---
generated_at: 2026-01-08 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：65-テーブルインポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. N/A（全主張に根拠あり）
  2. N/A
  3. N/A

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-generator/src/main/resources/templates/tool/gen/importTable.html`
- E-02: `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java`
- E-03: `ruoyi-generator/src/main/java/com/ruoyi/generator/service/impl/GenTableServiceImpl.java`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面タイトルは「導入表結構」 | E-01 L4 `th:include="include :: header('导入表结构')"` | ○ |
| C-02 | tool:gen:list権限が必要 | E-02 L81, L109, L128 `@RequiresPermissions("tool:gen:list")` | ○ |
| C-03 | POST /tool/gen/db/listでDB一覧取得 | E-02 L82-89 `@PostMapping("/db/list")` | ○ |
| C-04 | GET /tool/gen/importTableで画面表示 | E-02 L110-114 `@GetMapping("/importTable")` | ○ |
| C-05 | POST /tool/gen/importTableでインポート実行 | E-02 L130-140 `@PostMapping("/importTable")` | ○ |
| C-06 | テーブル名で検索可能 | E-01 L14 `表名称：<input type="text" name="tableName"/>` | ○ |
| C-07 | テーブル説明で検索可能 | E-01 L17 `表描述：<input type="text" name="tableComment"/>` | ○ |
| C-08 | clickToSelect: trueで行クリック選択 | E-01 L44 `clickToSelect: true` | ○ |
| C-09 | rememberSelected: trueで選択保持 | E-01 L45 `rememberSelected: true` | ○ |
| C-10 | uniqueIdはtableName | E-01 L46 `uniqueId: "tableName"` | ○ |
| C-11 | 序号列がある | E-01 L51-56 `title: "序号"` | ○ |
| C-12 | tableName列がある | E-01 L57-63 `field: 'tableName', title: '表名称'` | ○ |
| C-13 | tableComment列がある | E-01 L64-70 `field: 'tableComment', title: '表描述'` | ○ |
| C-14 | createTime列がある | E-01 L71-74 `field: 'createTime', title: '创建时间'` | ○ |
| C-15 | updateTime列がある | E-01 L75-78 `field: 'updateTime', title: '更新时间'` | ○ |
| C-16 | submitHandler関数がある | E-01 L84-92 `function submitHandler()` | ○ |
| C-17 | 未選択時に警告メッセージ表示 | E-01 L87 `$.modal.alertWarning("请至少选择一条记录")` | ○ |
| C-18 | $.operate.saveでインポート実行 | E-01 L91 `$.operate.save(prefix + "/importTable", data)` | ○ |
| C-19 | 関連機能はコード生成(No.18) | E-04 L94 `"65","テーブルインポート","18","コード生成","主機能"` | ○ |
| C-20 | importGenTableでDB登録 | E-03 L166-199 `public void importGenTable()` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体として信頼度が非常に高い（100%）

## 6) レビュアーチェックリスト（最小）
- [ ] データベーステーブル一覧が正しく表示されるか確認
- [ ] 既にインポート済みのテーブルが除外されているか確認
- [ ] 複数テーブルの一括インポートが正常に動作するか確認
- [ ] インポート後にgen_table、gen_table_columnに正しく登録されるか確認
- [ ] GenUtilsによる自動設定が適切に行われるか確認
