---
generated_at: 2026-01-08 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：66-テーブル作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. N/A（全主張に根拠あり）
  2. N/A
  3. N/A

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-generator/src/main/resources/templates/tool/gen/createTable.html`
- E-02: `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面タイトルは「創建表結構」 | E-01 L4 `th:include="include :: header('创建表结构')"` | ○ |
| C-02 | adminロールが必要 | E-02 L195 `@RequiresRoles("admin")` | ○ |
| C-03 | GET /tool/gen/createTableで画面表示 | E-02 L119-123 `@GetMapping("/createTable")` | ○ |
| C-04 | POST /tool/gen/createTableで作成実行 | E-02 L197-228 `@PostMapping("/createTable")` | ○ |
| C-05 | テキストエリアが12行 | E-01 L10 `rows="12"` | ○ |
| C-06 | テキストエリアがcol-sm-11幅 | E-01 L9 `class="col-sm-11 col"` | ○ |
| C-07 | ラベルに「支持多個建表語句」記載 | E-01 L8 `创建表语句(支持多个建表语句)` | ○ |
| C-08 | submitHandler関数がある | E-01 L19-27 `function submitHandler()` | ○ |
| C-09 | 空入力時に警告メッセージ表示 | E-01 L22 `$.modal.alertWarning("请输入建表语句")` | ○ |
| C-10 | $.operate.saveで作成実行 | E-01 L26 `$.operate.save(prefix + "/createTable", data)` | ○ |
| C-11 | SqlUtil.filterKeywordでセキュリティチェック | E-02 L203 `SqlUtil.filterKeyword(sql)` | ○ |
| C-12 | DruidのSQLUtils.parseStatementsでSQL解析 | E-02 L204 `SQLUtils.parseStatements(sql, DbType.mysql)` | ○ |
| C-13 | MySqlCreateTableStatementのみ処理 | E-02 L208 `if (sqlStatement instanceof MySqlCreateTableStatement)` | ○ |
| C-14 | createTableでDDL実行 | E-02 L211 `genTableService.createTable(createTableStatement.toString())` | ○ |
| C-15 | 作成後にインポート処理実行 | E-02 L218-220 `selectDbTableListByNames`, `importGenTable` | ○ |
| C-16 | エラー時「創建表結構異常」メッセージ | E-02 L226 `AjaxResult.error("创建表结构异常")` | ○ |
| C-17 | 関連機能はコード生成(No.18) | E-03 L95 `"66","テーブル作成","18","コード生成","主機能"` | ○ |
| C-18 | テキストエリアidはtext_create | E-01 L10 `id="text_create"` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - DDLを直接実行するため、セキュリティテストを入念に行う必要がある
- SqlUtil.filterKeyword()による禁止キーワードチェックが正しく動作するか確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] adminロール以外でアクセスできないことを確認
- [ ] 有効なCREATE TABLE文でテーブルが作成されるか確認
- [ ] 複数のCREATE TABLE文が正常に処理されるか確認
- [ ] 作成後にgen_table、gen_table_columnに正しく登録されるか確認
- [ ] SQLインジェクション対策が有効か確認（禁止キーワード等）
- [ ] 無効なSQL入力時のエラー処理を確認
