---
generated_at: 2026-01-08 11:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：67-コード生成編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  1. N/A（全主張に根拠あり）
  2. N/A
  3. N/A

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-generator/src/main/resources/templates/tool/gen/edit.html`
- E-02: `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java`
- E-03: `ruoyi-generator/src/main/java/com/ruoyi/generator/service/impl/GenTableServiceImpl.java`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面タイトルは「修改生成信息」 | E-01 L4 `th:include="include :: header('修改生成信息')"` | ○ |
| C-02 | tool:gen:edit権限が必要 | E-02 L145 `@RequiresPermissions("tool:gen:edit")` | ○ |
| C-03 | 3タブ構成 | E-01 L17-23 `tab-basic`, `tab-field`, `tab-gen` | ○ |
| C-04 | 字段信息タブがデフォルトアクティブ | E-01 L19 `class="active"` | ○ |
| C-05 | tableIdがhidden項目 | E-01 L26 `<input name="tableId" type="hidden"` | ○ |
| C-06 | tableNameが必須 | E-01 L35 `required` | ○ |
| C-07 | tableCommentが必須 | E-01 L43 `required` | ○ |
| C-08 | classNameが必須 | E-01 L53 `required` | ○ |
| C-09 | functionAuthorが必須 | E-01 L61 `required` | ○ |
| C-10 | Bootstrap Tableでカラム一覧表示 | E-01 L81 `id="bootstrap-table"` | ○ |
| C-11 | reorder-rowsプラグイン使用 | E-01 L272, L81 `data-reorderable-rows="true"` | ○ |
| C-12 | tplCategoryセレクト（crud/tree/sub） | E-01 L93-96 `value="crud"`, `value="tree"`, `value="sub"` | ○ |
| C-13 | formColNumセレクト（1/2/3列） | E-01 L140-144 `value="1"`, `value="2"`, `value="3"` | ○ |
| C-14 | genTypeラジオ（ZIP/自定義パス） | E-01 L154-155 `value="0"`, `value="1"` | ○ |
| C-15 | ツリー設定項目群がある | E-01 L215-253 `#otherInfo` | ○ |
| C-16 | 主子テーブル設定項目群がある | E-01 L190-213 `#subInfo` | ○ |
| C-17 | 辞書タイプ選択ポップアップ | E-01 L530-541 `function selectDictTree()` | ○ |
| C-18 | メニューツリー選択ポップアップ | E-01 L544-555 `function selectMenuTree()` | ○ |
| C-19 | submitHandler関数で保存 | E-01 L294-298 `function submitHandler()` | ○ |
| C-20 | $.operate.saveTabで保存実行 | E-01 L296 `$.operate.saveTab(prefix + "/edit"` | ○ |
| C-21 | onReorderRowでsort更新 | E-01 L474-478 `function onReorderRow(data)` | ○ |
| C-22 | tplCategoryVisibleで表示切替 | E-01 L492-514 `function tplCategoryVisible()` | ○ |
| C-23 | pathInfoVisibleで表示切替 | E-01 L521-528 `function pathInfoVisible()` | ○ |
| C-24 | validateEditでバリデーション | E-03 L410-442 `public void validateEdit()` | ○ |
| C-25 | ツリー設定不備でエラー | E-03 L418-429 `throw new ServiceException("树编码字段不能为空")` 等 | ○ |
| C-26 | 主子設定不備でエラー | E-03 L433-440 `throw new ServiceException("关联子表的表名不能为空")` 等 | ○ |
| C-27 | updateGenTableで更新 | E-03 L124-138 `public void updateGenTable()` | ○ |
| C-28 | 関連機能はコード生成(No.18) | E-04 L96 `"67","コード生成編集","18","コード生成","主機能"` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体として信頼度が非常に高い（100%）

## 6) レビュアーチェックリスト（最小）
- [ ] 3タブがすべて正常に表示されるか確認
- [ ] 基本情報タブの各項目が編集可能か確認
- [ ] 字段信息タブでドラッグ並び替えが動作するか確認
- [ ] テンプレート種別に応じてツリー/主子設定が表示切替されるか確認
- [ ] 生成方式に応じてパス入力欄が表示切替されるか確認
- [ ] 辞書タイプ選択ポップアップが動作するか確認
- [ ] メニューツリー選択ポップアップが動作するか確認
- [ ] 保存後にgen_table、gen_table_columnが正しく更新されるか確認
