---
generated_at: 2026-01-08 11:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：69-500エラー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. N/A（全主張に根拠あり）
  2. N/A
  3. N/A

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/error/500.html`
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面タイトルは「RuoYi - 500」 | E-01 L6 `<title>RuoYi - 500</title>` | ○ |
| C-02 | h1要素で500を表示 | E-01 L13 `<h1>500</h1>` | ○ |
| C-03 | h3要素で「内部服务器错误！」を表示 | E-01 L14 `<h3 class="font-bold">内部服务器错误！</h3>` | ○ |
| C-04 | エラー説明文を表示 | E-01 L17 `服务器遇到意外事件，不允许完成请求。我们抱歉。您可以返回主页面。` | ○ |
| C-05 | 「主页」ボタンがある | E-01 L18 `<a href="javascript:index()" class="btn btn-primary m-t">主页</a>` | ○ |
| C-06 | index関数でリダイレクト | E-01 L23-25 `function index()` | ○ |
| C-07 | window.top.locationを使用 | E-01 L24 `window.top.location = ctx + "index"` | ○ |
| C-08 | bootstrap.min.cssをインクルード | E-01 L7 `th:href="@{/css/bootstrap.min.css}"` | ○ |
| C-09 | animate.min.cssをインクルード | E-01 L8 `th:href="@{/css/animate.min.css}"` | ○ |
| C-10 | style.min.cssをインクルード | E-01 L9 `th:href="@{/css/style.min.css}"` | ○ |
| C-11 | fadeInDownアニメーション適用 | E-01 L12 `class="middle-box text-center animated fadeInDown"` | ○ |
| C-12 | テンプレートパスはerror/500.html | E-02 L70 | ○ |
| C-13 | th:inline="javascript"でコンテキストパス取得 | E-01 L21 `<script th:inline="javascript">` | ○ |
| C-14 | ctxにコンテキストパスを格納 | E-01 L22 `var ctx = [[@{/}]];` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルな静的エラー画面

## 6) レビュアーチェックリスト（最小）
- [ ] サーバー例外発生時に500画面が表示されるか確認
- [ ] 「主页」ボタンクリックで首頁に遷移するか確認
- [ ] iframe内でも正しく動作するか確認（window.top使用）
- [ ] アニメーションが適用されているか確認
- [ ] 404画面と一貫したレイアウトになっているか確認
