---
generated_at: 2026-01-08 11:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-メインコンテンツ（v1）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/main_v1.html` - v1ダッシュボードテンプレート
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 収入パネル（40,886,200）表示 | E-01 (25行目 40 886,200) | ○ |
| C-02 | 注文パネル（275,800）表示 | E-01 (39行目 275,800) | ○ |
| C-03 | 訪問者パネル（106,120）表示 | E-01 (53行目 106,120) | ○ |
| C-04 | 活跃用户パネル（80,600）表示 | E-01 (67行目 80,600) | ○ |
| C-05 | Flot.jsチャート使用 | E-01 (217行目 jquery.flot.js) | ○ |
| C-06 | 期間切替ボタン（天/月/年） | E-01 (83-85行目 btn-xs btn-white) | ○ |
| C-07 | ユーザープロジェクトリスト表示 | E-01 (147-208行目 table table-hover) | ○ |
| C-08 | sparkline使用可能 | E-01 (219行目 sparkline-js) | ○ |
| C-09 | 棒グラフデータ（data3）定義 | E-01 (233-242行目 data3) | ○ |
| C-10 | 折れ線グラフデータ（data2）定義 | E-01 (222-231行目 data2) | ○ |
| C-11 | 中国語人名のサンプルデータ | E-01 (163-206行目 青衣5858, 徐子崴等) | ○ |
| C-12 | 機能No.19「ログイン」が補助機能 | E-02 (11行目) | ○ |
| C-13 | メインカテゴリは「メイン」 | E-03 (8行目) | ○ |
| C-14 | テンプレートファイルパスはmain_v1.html | E-03 (8行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードから直接確認済み
- **1: 中リスク** - この画面が実運用で使用されているかは不明（互換性維持用の可能性）

## 6) レビュアーチェックリスト（最小）
- [ ] 本画面が実際に使用されているか確認
- [ ] Flot.jsチャートの表示動作確認
