---
generated_at: 2026-01-08 11:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-サービスエラー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. N/A（全主張に根拠あり）
  2. N/A
  3. N/A

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/error/service.html`
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面タイトルは「RuoYi - 500」 | E-01 L6 `<title>RuoYi - 500</title>` | ○ |
| C-02 | h3要素で「操作异常！」を表示 | E-01 L13 `<h3 class="font-bold">操作异常！</h3>` | ○ |
| C-03 | errorMessageを動的に表示 | E-01 L16 `[[${errorMessage}]]` | ○ |
| C-04 | bootstrap.min.cssをインクルード | E-01 L7 `th:href="@{/css/bootstrap.min.css}"` | ○ |
| C-05 | animate.min.cssをインクルード | E-01 L8 `th:href="@{/css/animate.min.css}"` | ○ |
| C-06 | style.min.cssをインクルード | E-01 L9 `th:href="@{/css/style.min.css}"` | ○ |
| C-07 | fadeInDownアニメーション適用 | E-01 L12 `class="middle-box text-center animated fadeInDown"` | ○ |
| C-08 | テンプレートパスはerror/service.html | E-02 L71 | ○ |
| C-09 | gray-bgクラスをbodyに適用 | E-01 L11 `<body class="gray-bg">` | ○ |
| C-10 | middle-boxクラスで中央配置 | E-01 L12 `class="middle-box text-center..."` | ○ |
| C-11 | 主页ボタンがない | E-01（ボタン要素なし） | ○ |
| C-12 | JavaScriptがない | E-01（scriptタグなし） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 1: 低〜中リスク - 主页ボタンがないためユーザーの離脱導線が不明確
- 他のエラー画面（404/500）との一貫性について検討推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ServiceException発生時にservice画面が表示されるか確認
- [ ] errorMessageが正しく表示されるか確認
- [ ] アニメーションが適用されているか確認
- [ ] 主页ボタンがないことが意図的かどうか確認
- [ ] ブラウザの戻るボタンで元の画面に戻れるか確認
