---
generated_at: 2026-01-08 14:15:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：71-権限エラー画面.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ考慮事項（ログ記録）**：ログ出力の実際の動作確認が必要
  2. **メッセージ翻訳**：日本語訳の妥当性確認が必要
  3. **画面遷移元**：すべての遷移元を網羅しているか確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/templates/error/unauth.html`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysLoginController.java`
- E-03: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/exception/GlobalExceptionHandler.java`
- E-04: `ruoyi-framework/src/main/java/com/ruoyi/framework/config/ShiroConfig.java`
- E-05: `ruoyi-admin/src/main/resources/application.yml`
- E-06: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/realm/UserRealm.java`
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-09: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面Noは71である | E-07 | ○ |
| C-02 | 画面名は「権限エラー画面」である | E-07 | ○ |
| C-03 | テンプレートパスは `error/unauth.html` | E-01, E-02 | ○ |
| C-04 | HTTPステータス403を表示 | E-01 (13行目: `<h1>403</h1>`) | ○ |
| C-05 | エラーメッセージ「您没有访问权限！」を表示 | E-01 (14行目) | ○ |
| C-06 | 「返回主页」ボタンが存在する | E-01 (18行目) | ○ |
| C-07 | URLは `/unauth` | E-02 (77行目: `@GetMapping("/unauth")`) | ○ |
| C-08 | コントローラは `SysLoginController` | E-02 | ○ |
| C-09 | unauthorizedUrlの設定値は `/unauth` | E-05 (97行目: `unauthorizedUrl: /unauth`) | ○ |
| C-10 | ShiroConfigでunauthorizedUrlを設定 | E-04 (127-128行目, 301-302行目) | ○ |
| C-11 | GlobalExceptionHandlerでAuthorizationExceptionをハンドル | E-03 (36-48行目) | ○ |
| C-12 | 非Ajaxリクエスト時にerror/unauthへ遷移 | E-03 (47行目: `return new ModelAndView("error/unauth")`) | ○ |
| C-13 | Ajaxリクエスト時はJSONエラーを返却 | E-03 (43行目: `return AjaxResult.error(...)`) | ○ |
| C-14 | index()関数でwindow.top.locationを変更 | E-01 (23-25行目) | ○ |
| C-15 | Thymeleafでコンテキストパスを取得 | E-01 (22行目: `var ctx = [[@{/}]]`) | ○ |
| C-16 | bootstrap.min.cssを使用 | E-01 (7行目) | ○ |
| C-17 | animate.min.cssを使用 | E-01 (8行目) | ○ |
| C-18 | style.min.cssを使用 | E-01 (9行目) | ○ |
| C-19 | UserRealmでdoGetAuthorizationInfoメソッドが権限を取得 | E-06 (56-81行目) | ○ |
| C-20 | 管理者は全権限`*:*:*`を持つ | E-06 (69行目: `info.addStringPermission("*:*:*")`) | ○ |
| C-21 | 関連機能Noは19（ログイン）である | E-08 | ○ |
| C-22 | 関連種別は「遷移先機能」である | E-08 | ○ |
| C-23 | カテゴリは「エラー」である | E-07 | ○ |
| C-24 | 画面遷移図にエラー画面フローが存在 | E-09 (299-313行目) | ○ |
| C-25 | 不正アクセスの試行はログに記録される | E-03 (40行目: `log.error(...)`) | △ |

## 4) 不足情報（Unknown / Missing）
- C-25（ログ記録）について：コード上は`log.error()`が存在するが、実行環境でのログ出力設定や実際の動作確認は未検証
  - 候補：実環境テスト / ログ設定ファイル確認 / 統合テスト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 本画面は静的なエラー表示画面であり、データベースアクセスやユーザー入力処理がないため、セキュリティリスクは低い
- **0: 低リスク** - 画面構造がシンプルで、他のエラー画面（404, 500）と同様のパターンで実装されている
- **1: 中リスク** - 権限チェックの実装が正しく動作するかは、Shiro設定全体との整合性に依存する

## 6) レビュアーチェックリスト（最小）
- [ ] URLパス `/unauth` が本番環境で正しく機能するか確認
- [ ] 「返回主页」ボタン押下時の遷移が正常に動作するか確認
- [ ] iframe構造内での`window.top.location`の動作確認
- [ ] 権限エラー発生時のログ出力が適切に行われるか確認
- [ ] 中国語メッセージの内容が業務要件に合致しているか確認
- [ ] 他のエラー画面（404, 500, service）との整合性確認
