---
generated_at: 2026-01-08 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-テーマ切替

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/skin.html` - テーマ切替テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysIndexController.java` - インデックスコントローラー
- E-03: `ruoyi-admin/src/main/resources/templates/index.html` - システム首頁（テーマ呼び出し元）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーマ切替のURLは `/system/switchSkin` | E-02 (119行目 @GetMapping("/system/switchSkin")) | ○ |
| C-02 | skin.htmlを返す | E-02 (122行目 return "skin") | ○ |
| C-03 | 12種類のテーマが選択可能 | E-01 (22-140行目 li要素12個) | ○ |
| C-04 | data-skin属性でスキン情報を保持 | E-01 (23行目 data-skin="skin-blue\|theme-dark") | ○ |
| C-05 | parent.$("body")で親ウィンドウ操作 | E-01 (155-161行目 parent.$("body")) | ○ |
| C-06 | storage.set('skin')でローカル保存 | E-01 (162行目 storage.set) | ○ |
| C-07 | スキンカラー5種類（blue,green,purple,red,yellow） | E-01 (146行目 skins配列) | ○ |
| C-08 | テーマスタイル3種類（dark,light,blue） | E-01 (149行目 themes配列) | ○ |
| C-09 | 既存スキンクラスを削除してから適用 | E-01 (154-159行目 removeClass, addClass) | ○ |
| C-10 | 即座に外観が変更される | E-01 (160-161行目 addClass即時実行) | ○ |
| C-11 | モーダルサイズは530x386px | E-03 (311行目 area : ["530px", "386px"]) | ○ |
| C-12 | layer.openで表示 | E-03 (307-313行目 layer.open) | ○ |
| C-13 | システム首頁起動時にテーマ復元 | E-03 (291-297行目 storage.get("skin")) | ○ |
| C-14 | メインカテゴリは「メイン」 | E-04 (9行目) | ○ |
| C-15 | テンプレートファイルパスはskin.html | E-04 (9行目) | ○ |
| C-16 | common.jsのstorageユーティリティ使用 | E-01 (143行目 common.js) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 各テーマの表示動作確認
- [ ] ローカルストレージへの保存・復元動作確認
