---
generated_at: 2026-01-08 11:10:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-ユーザー管理一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `ruoyi-admin/src/main/resources/templates/system/user/user.html` - ユーザー管理一覧テンプレート
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java` - ユーザーコントローラー
- E-03: `ruoyi-system/src/main/resources/mapper/system/SysUserMapper.xml` - ユーザーMyBatisマッパー
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GET /system/user で一覧画面を表示 | E-02 (64-69行目 @GetMapping) | ○ |
| C-02 | POST /system/user/list で一覧データ取得 | E-02 (71-79行目 @PostMapping("/list")) | ○ |
| C-03 | 2ペインレイアウト（部門ツリー+テーブル） | E-01 (38-48行目 container-div, left, right) | ○ |
| C-04 | zTree.jsで部門ツリー実装 | E-01 (214行目 $.tree.init) | ○ |
| C-05 | Bootstrap Tableで一覧テーブル実装 | E-01 (120行目 $.table.init) | ○ |
| C-06 | loginNameで部分一致検索 | E-01 (56行目 name="loginName") | ○ |
| C-07 | phonenumberで部分一致検索 | E-01 (61行目 name="phonenumber") | ○ |
| C-08 | statusで絞り込み検索 | E-01 (66行目 name="status") | ○ |
| C-09 | 作成日時範囲検索 | E-01 (71-72行目 params[beginTime], params[endTime]) | ○ |
| C-10 | system:user:view権限が必要 | E-02 (65行目 @RequiresPermissions("system:user:view")) | ○ |
| C-11 | system:user:add権限で追加ボタン表示 | E-01 (77行目 shiro:hasPermission="system:user:add") | ○ |
| C-12 | system:user:edit権限で編集ボタン表示 | E-01 (80行目 shiro:hasPermission="system:user:edit") | ○ |
| C-13 | system:user:remove権限で削除ボタン表示 | E-01 (83行目 shiro:hasPermission="system:user:remove") | ○ |
| C-14 | system:user:import権限でインポートボタン表示 | E-01 (86行目 shiro:hasPermission="system:user:import") | ○ |
| C-15 | system:user:export権限でエクスポートボタン表示 | E-01 (89行目 shiro:hasPermission="system:user:export") | ○ |
| C-16 | POST /system/user/remove で削除 | E-02 (276-287行目 @PostMapping("/remove")) | ○ |
| C-17 | POST /system/user/changeStatus で状態変更 | E-02 (319-331行目 @PostMapping("/changeStatus")) | ○ |
| C-18 | 論理削除（del_flag更新） | E-02 (284行目 userService.deleteUserByIds) | ○ |
| C-19 | 状態切替はトグルスイッチ表示 | E-01 (157-161行目 statusSwitch) | ○ |
| C-20 | 自分自身の削除は禁止 | E-02 (280-283行目 contains(userId)) | ○ |
| C-21 | 機能No.1「ユーザー管理」が主機能 | E-05 (15行目) | ○ |
| C-22 | 機能No.4「部門管理」が補助機能 | E-05 (15行目) | ○ |
| C-23 | メインカテゴリは「システム管理」 | E-04 (10行目) | ○ |
| C-24 | テンプレートファイルパスはsystem/user/user.html | E-04 (10行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 部門ツリーの表示・フィルタリング動作確認
- [ ] ユーザー検索機能の動作確認
- [ ] 権限に応じたボタン表示制御の動作確認
- [ ] ユーザー状態切替の動作確認
- [ ] インポート/エクスポート機能の動作確認
