---
generated_at: 2026-01-08 10:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 48
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：48 / 50、根拠なし：2
- 優先レビュー（高）
  1. **IT-037 プロファイル情報更新**：SysProfileControllerのソースコード未確認
  2. **IT-038 アバター画像更新**：SysProfileControllerのソースコード未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysLoginController.java`
- E-02: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysLoginService.java`
- E-03: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java`
- E-04: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysUserServiceImpl.java`
- E-05: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRoleController.java`
- E-06: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysMenuController.java`
- E-07: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDeptController.java`
- E-08: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysPostController.java`
- E-09: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysDictTypeController.java`
- E-10: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysConfigController.java`
- E-11: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java`
- E-12: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobController.java`
- E-13: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/controller/SysJobLogController.java`
- E-14: `ruoyi-generator/src/main/java/com/ruoyi/generator/controller/GenController.java`
- E-15: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysUserOnlineController.java`
- E-16: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/monitor/SysOperlogController.java`
- E-17: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/common/CommonController.java`
- E-18: `ruoyi-framework/src/main/java/com/ruoyi/framework/aspectj/DataScopeAspect.java`
- E-19: `ruoyi-framework/src/main/java/com/ruoyi/framework/aspectj/LogAspect.java`
- E-20: `ruoyi-framework/src/main/java/com/ruoyi/framework/interceptor/RepeatSubmitInterceptor.java`
- E-21: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/filter/sync/SyncOnlineSessionFilter.java`
- E-22: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/filter/kickout/KickoutSessionFilter.java`
- E-23: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/filter/captcha/CaptchaValidateFilter.java`
- E-24: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/exception/GlobalExceptionHandler.java`
- E-25: `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysUserMapper.java`
- E-26: `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysRoleMapper.java`
- E-27: `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysMenuMapper.java`
- E-28: `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysDeptMapper.java`
- E-29: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/ScheduleUtils.java`
- E-30: `ruoyi-generator/src/main/java/com/ruoyi/generator/util/VelocityUtils.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: ログイン認証からセッション管理までの一連フロー | E-01, E-02 | ○ |
| C-02 | IT-002: ログイン失敗時のエラーハンドリング | E-02, E-19 | ○ |
| C-03 | IT-003: ユーザー新規登録からDB保存までの一連フロー | E-03, E-04, E-25 | ○ |
| C-04 | IT-004: ユーザー更新時のトランザクション整合性 | E-04 | ○ |
| C-05 | IT-005: ユーザー削除時の関連データ削除 | E-04 | ○ |
| C-06 | IT-006: ユーザーインポート機能 | E-03, E-04 | ○ |
| C-07 | IT-007: ユーザーエクスポート機能 | E-03 | ○ |
| C-08 | IT-008: ロール新規登録からメニュー権限割り当てまで | E-05, E-26 | ○ |
| C-09 | IT-009: ロールへのユーザー一括割り当て | E-05 | ○ |
| C-10 | IT-010: ロール削除時のユーザー割り当て確認 | E-05 | ○ |
| C-11 | IT-011: メニュー登録から権限キャッシュ更新まで | E-06, E-27 | ○ |
| C-12 | IT-012: メニュー削除時の子メニュー・ロール割り当てチェック | E-06 | ○ |
| C-13 | IT-013: 部門新規登録から階層構造更新まで | E-07, E-28 | ○ |
| C-14 | IT-014: 部門削除時の子部門・ユーザー存在チェック | E-07 | ○ |
| C-15 | IT-015: 岗位新規登録から重複チェックまで | E-08 | ○ |
| C-16 | IT-016: 辞書タイプ登録からキャッシュ更新まで | E-09 | ○ |
| C-17 | IT-017: 辞書キャッシュ手動更新 | E-09 | ○ |
| C-18 | IT-018: パラメータ登録からキャッシュ更新まで | E-10 | ○ |
| C-19 | IT-019: パラメータキャッシュ手動更新 | E-10 | ○ |
| C-20 | IT-020: 通知公告CRUD操作 | E-11 | ○ |
| C-21 | IT-021: 定時タスク登録からQuartzスケジューラ連携まで | E-12, E-29 | ○ |
| C-22 | IT-022: 定時タスク即時実行 | E-12 | ○ |
| C-23 | IT-023: 定時タスク状態変更からスケジューラ連携まで | E-12, E-29 | ○ |
| C-24 | IT-024: タスク実行ログの記録と検索 | E-13 | ○ |
| C-25 | IT-025: テーブルインポートからコード生成まで | E-14, E-30 | ○ |
| C-26 | IT-026: テーブル同期機能 | E-14 | ○ |
| C-27 | IT-027: テーブル作成からコード生成までの一連フロー | E-14 | ○ |
| C-28 | IT-028: オンラインユーザー一覧取得とセッション管理 | E-15 | ○ |
| C-29 | IT-029: 操作ログの自動記録と検索 | E-16, E-19 | ○ |
| C-30 | IT-030: 操作ログ一括削除 | E-16 | ○ |
| C-31 | IT-031: ログイン履歴の自動記録と検索 | E-02 | ○ |
| C-32 | IT-032: 単一ファイルアップロード | E-17 | ○ |
| C-33 | IT-033: 複数ファイル一括アップロード | E-17 | ○ |
| C-34 | IT-034: ファイルダウンロード機能 | E-17 | ○ |
| C-35 | IT-035: データスコープによるアクセス制御 | E-18 | ○ |
| C-36 | IT-036: 権限注釈によるアクセス制御 | E-03, E-05 | ○ |
| C-37 | IT-037: プロファイル情報更新 | **根拠なし** | △ |
| C-38 | IT-038: アバター画像更新 | **根拠なし** | △ |
| C-39 | IT-039: パスワードリセット機能 | E-03 | ○ |
| C-40 | IT-040: ユーザー状態変更 | E-03, E-04 | ○ |
| C-41 | IT-041: 重複送信防止フィルター | E-20 | ○ |
| C-42 | IT-042: セッション同期フィルター | E-21 | ○ |
| C-43 | IT-043: キックアウトセッションフィルター | E-22 | ○ |
| C-44 | IT-044: ロールデータスコープ設定 | E-05 | ○ |
| C-45 | IT-045: キャプチャ検証からログインまで | E-23, E-02 | ○ |
| C-46 | IT-046: IPブラックリスト検証 | E-02 | ○ |
| C-47 | IT-047: ユーザーデータ権限チェック | E-04 | ○ |
| C-48 | IT-048: ロールデータ権限チェック | E-05 | ○ |
| C-49 | IT-049: 部門データ権限チェック | E-07 | ○ |
| C-50 | IT-050: グローバル例外ハンドリング | E-24 | ○ |

## 4) 不足情報（Unknown / Missing）
- IT-037/IT-038のSysProfileControllerのソースコードを直接確認していないため、プロファイル更新とアバター画像更新機能の実装詳細が不明
  - 候補：ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysProfileController.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほとんどのテストケースはソースコードから直接確認した根拠に基づいている
- 1: 中リスク - SysProfileController関連（IT-037, IT-038）は追加確認が必要
- 0: 低リスク - トランザクション整合性やデータスコープ制御はアノテーション(@Transactional, @DataScope)で明確に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] IT-001〜IT-002: ログイン認証フローがSysLoginService.login()の実装と一致しているか確認
- [ ] IT-003〜IT-005: ユーザーCRUD時のトランザクション境界が@Transactionalで適切に定義されているか確認
- [ ] IT-008〜IT-010: ロール-メニュー関連の整合性チェックが実装されているか確認
- [ ] IT-021〜IT-023: Quartzスケジューラとの連携がScheduleUtilsで適切に処理されているか確認
- [ ] IT-035, IT-047〜IT-049: データスコープ制御がDataScopeAspectで正しく実装されているか確認
- [ ] IT-037, IT-038: SysProfileControllerのソースコードを確認し、テストケース内容が正確か検証
- [ ] 全体: 権限アノテーション(@RequiresPermissions)が各コントローラーに適切に付与されているか確認
