---
generated_at: 2026-01-08 13:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が存在するため、優先的にレビューが必要な項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysNotice.java`
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java`
- E-03: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/filter/kickout/KickoutSessionFilter.java`
- E-04: `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/factory/AsyncFactory.java`
- E-05: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysLoginService.java`
- E-06: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java`
- E-07: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/filter/LogoutFilter.java`
- E-08: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysRegisterService.java`
- E-09: `ruoyi-framework/src/main/java/com/ruoyi/framework/aspectj/LogAspect.java`
- E-10: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/AbstractQuartzJob.java`
- E-11: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/exception/GlobalExceptionHandler.java`
- E-12: `ruoyi-common/src/main/java/com/ruoyi/common/utils/MessageUtils.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 公告通知機能の存在（noticeType=1通知、2公告） | E-01, E-02 | ○ |
| C-02 | セッションキックアウト通知機能（maxSession超過時） | E-03 | ○ |
| C-03 | ログイン成功時のログ記録機能 | E-04, E-05 | ○ |
| C-04 | ログイン失敗時のログ記録機能 | E-05, E-06 | ○ |
| C-05 | パスワードリトライ制限超過通知 | E-06 | ○ |
| C-06 | ログアウト時のログ記録機能 | E-07 | ○ |
| C-07 | ユーザー登録成功時のログ記録機能 | E-08 | ○ |
| C-08 | @Logアノテーションによる操作ログ記録 | E-09, E-04 | ○ |
| C-09 | Quartzジョブ実行結果のログ記録機能 | E-10 | ○ |
| C-10 | 権限エラー通知（AuthorizationException） | E-11 | ○ |
| C-11 | 業務例外通知（ServiceException） | E-11 | ○ |
| C-12 | システム例外通知（RuntimeException/Exception） | E-11 | ○ |
| C-13 | デモモード通知（DemoModeException） | E-11 | ○ |
| C-14 | 国際化メッセージ通知機能 | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠が不足している項目はありません
- 備考：本プロジェクトにはメール送信機能、SMS送信機能、プッシュ通知機能、WebSocket通知機能は実装されていません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての通知機能に対してソースコードによる根拠が確認できています
- 注意点：
  - 外部通知機能（メール、SMS、プッシュ通知等）は本プロジェクトには含まれていません
  - 通知機能の多くはログ記録・エラーハンドリングとして実装されており、ユーザーへの直接的なプッシュ型通知は限定的です

## 6) レビュアーチェックリスト（最小）
- [ ] SysNoticeの通知種別（noticeType）の値が正しく記載されているか確認
- [ ] KickoutSessionFilterのmaxSession設定値とデフォルト動作を確認
- [ ] AsyncFactory経由のログ記録が非同期で実行されることを確認
- [ ] GlobalExceptionHandlerの各例外ハンドラの動作確認
- [ ] 外部通知機能（メール/SMS/プッシュ）が必要な場合は追加実装が必要であることを認識
