# 通知設計書 1-公告通知

## 概要

本ドキュメントは、RuoYiシステムにおける公告通知機能の設計仕様を記述したものである。管理者がシステム内で作成した公告・通知を、ユーザーに対してシステム内通知として表示する機能について定義する。

### 本通知の処理概要

本通知は、管理者が作成した公告（公告）および通知（通知）をシステム内で管理・表示する機能を提供する。noticeType=1は「通知」、noticeType=2は「公告」として分類され、それぞれ異なる目的で使用される。

**業務上の目的・背景**：組織内での重要な情報共有を効率的に行うため、管理者から全ユーザーまたは特定ユーザーへの一斉連絡手段として本通知機能が必要である。システム障害のお知らせ、メンテナンス通知、業務連絡など、即時性と確実性が求められる情報伝達に使用される。

**通知の送信タイミング**：管理者が公告管理画面（/system/notice）から新規公告・通知を登録した時点で、システム内に公開される。ステータスが「正常」（status=0）の場合のみ表示対象となる。

**通知の受信者**：システムにログインしている全ユーザーが受信対象となる。公告一覧画面またはダッシュボード等から参照可能。権限「system:notice:view」を持つユーザーのみが閲覧可能。

**通知内容の概要**：公告タイトル（noticeTitle）、公告種別（通知/公告）、公告内容（noticeContent）、作成者、作成日時などの情報が含まれる。

**期待されるアクション**：ユーザーは通知内容を確認し、必要に応じて業務対応や情報の周知を行う。重要な公告については、関係者への転送や対応期限の確認などが期待される。

## 通知種別

システム内通知（アプリ内通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（データベース登録即時反映） |
| 優先度 | 中 |
| リトライ | 無（データベース登録のため不要） |

### 送信先決定ロジック

- 公告の場合：全ユーザーが参照可能
- 権限「system:notice:view」を持つユーザーのみがアクセス可能
- ステータスが「正常」（status=0）の公告のみ表示

## 通知テンプレート

### システム内通知の場合

| 項目 | 内容 |
|-----|------|
| 表示場所 | 公告管理画面（/system/notice） |
| 表示形式 | 一覧表示 + 詳細表示 |

### 本文テンプレート

```
【{noticeType}】{noticeTitle}

{noticeContent}

作成者：{createBy}
作成日時：{createTime}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| - | - | - | 添付ファイル機能なし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| noticeId | 公告ID | sys_notice.notice_id | Yes |
| noticeTitle | 公告タイトル | sys_notice.notice_title | Yes |
| noticeType | 公告種別（1=通知、2=公告） | sys_notice.notice_type | Yes |
| noticeContent | 公告内容 | sys_notice.notice_content | No |
| status | 公告状態（0=正常、1=停止） | sys_notice.status | Yes |
| createBy | 作成者 | sys_notice.create_by | No |
| createTime | 作成日時 | sys_notice.create_time | No |
| updateBy | 更新者 | sys_notice.update_by | No |
| updateTime | 更新日時 | sys_notice.update_time | No |
| remark | 備考 | sys_notice.remark | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 公告新規登録 | status=0（正常） | 管理者が公告管理画面から新規登録 |
| 画面操作 | 公告更新 | status=0（正常） | 既存公告の内容更新 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| status=1 | ステータスが「停止」の場合は表示されない |
| 削除済み | 論理削除された公告は表示されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[管理者：公告登録画面アクセス] --> B[公告情報入力]
    B --> C[バリデーション]
    C -->|OK| D[データベース登録]
    C -->|NG| E[エラーメッセージ表示]
    D --> F[操作ログ記録]
    F --> G[登録完了]
    E --> B
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| sys_notice | 公告情報の取得 | 主テーブル |

### テーブル別参照項目詳細

#### sys_notice

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| notice_id | 公告ID | 主キー |
| notice_title | 公告タイトル | - |
| notice_type | 公告種別 | 1=通知、2=公告 |
| notice_content | 公告内容 | - |
| status | 公告状態 | 0=正常のみ表示 |
| create_by | 作成者 | - |
| create_time | 作成日時 | - |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sys_notice | INSERT | 新規公告登録 |
| sys_notice | UPDATE | 公告内容更新 |
| sys_notice | DELETE | 公告削除（論理削除） |
| sys_oper_log | INSERT | 操作ログ記録 |

#### sys_notice テーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | notice_id | 自動採番 | シーケンス |
| INSERT | notice_title | 入力値 | 必須、最大50文字 |
| INSERT | notice_type | 入力値 | 1または2 |
| INSERT | notice_content | 入力値 | HTML形式可 |
| INSERT | status | 入力値 | デフォルト0 |
| INSERT | create_by | ログインユーザー名 | - |
| INSERT | create_time | 現在日時 | - |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| バリデーションエラー | タイトル未入力 | エラーメッセージ表示 |
| バリデーションエラー | タイトル50文字超過 | エラーメッセージ表示 |
| XSSエラー | タイトルにスクリプト文字含む | エラーメッセージ表示 |
| 権限エラー | 必要な権限なし | 403エラー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（データベース操作のため不要） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

配信時間帯の制限なし。24時間いつでも登録・参照可能。

## セキュリティ考慮事項

- XSS対策：公告タイトルに対して`@Xss`アノテーションによるスクリプト文字のチェックを実施
- 権限制御：Shiro認可アノテーション`@RequiresPermissions`による画面アクセス制御
- 入力バリデーション：`@NotBlank`、`@Size`アノテーションによる入力値検証
- 操作ログ：`@Log`アノテーションによる全操作の監査証跡記録

## 備考

- 本通知はプッシュ型ではなく、プル型（ユーザーが画面を開いて確認する）の通知である
- noticeType=1（通知）は業務連絡向け、noticeType=2（公告）は重要なお知らせ向けに使い分けることを推奨
- HTMLコンテンツが格納可能なため、リッチテキスト形式での通知内容作成が可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、公告データの構造を定義するエンティティクラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysNotice.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysNotice.java` | 公告エンティティの構造、フィールド定義、バリデーションアノテーション |

**読解のコツ**: `@NotBlank`、`@Size`、`@Xss`などのバリデーションアノテーションに注目。noticeType（1=通知、2=公告）とstatus（0=正常、1=停止）の意味を理解する。

#### Step 2: エントリーポイントを理解する

処理の起点となるControllerクラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysNoticeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java` | REST APIエンドポイント、権限制御、操作ログ記録 |

**主要処理フロー**:
1. **36-41行目**: 公告一覧画面表示（`@RequiresPermissions("system:notice:view")`）
2. **46-54行目**: 公告一覧データ取得（`list()`メソッド）
3. **68-77行目**: 公告新規登録（`addSave()`メソッド、`@Log`アノテーション付き）
4. **93-101行目**: 公告更新（`editSave()`メソッド）
5. **117-124行目**: 公告削除（`remove()`メソッド）

#### Step 3: サービス層を理解する

ビジネスロジックを実装するServiceクラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ISysNoticeService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysNoticeService.java` | サービスインターフェース定義 |
| 3-2 | SysNoticeServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysNoticeServiceImpl.java` | サービス実装、CRUD操作 |

**主要処理フロー**:
- **30-33行目**: ID指定での公告取得
- **42-45行目**: 条件指定での公告一覧取得
- **54-57行目**: 公告新規登録
- **66-69行目**: 公告更新
- **78-81行目**: 公告削除（複数ID指定可）

#### Step 4: データアクセス層を理解する

データベースアクセスを担当するMapperを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SysNoticeMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysNoticeMapper.java` | Mapperインターフェース定義 |

### プログラム呼び出し階層図

```
SysNoticeController (Webレイヤー)
    │
    ├─ ISysNoticeService (サービスインターフェース)
    │      └─ SysNoticeServiceImpl (サービス実装)
    │              └─ SysNoticeMapper (データアクセス)
    │                      └─ sys_notice (テーブル)
    │
    └─ @Log (操作ログAOP)
           └─ LogAspect
                  └─ AsyncFactory.recordOper()
                         └─ SysOperLog (操作ログテーブル)
```

### データフロー図

```
[入力]               [処理]                    [出力]

公告情報入力 ───▶ SysNoticeController ───▶ 画面レスポンス
    │                    │
    │                    ▼
    │              SysNoticeServiceImpl
    │                    │
    │                    ▼
    │              SysNoticeMapper
    │                    │
    │                    ▼
    └─────────────▶ sys_notice テーブル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysNotice.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysNotice.java` | ソース | 公告エンティティ定義 |
| SysNoticeController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java` | ソース | REST APIコントローラー |
| ISysNoticeService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysNoticeService.java` | ソース | サービスインターフェース |
| SysNoticeServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysNoticeServiceImpl.java` | ソース | サービス実装 |
| SysNoticeMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysNoticeMapper.java` | ソース | Mapperインターフェース |
| SysNoticeMapper.xml | `ruoyi-system/src/main/resources/mapper/system/SysNoticeMapper.xml` | 設定 | MyBatis SQLマッピング |
| LogAspect.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/aspectj/LogAspect.java` | ソース | 操作ログAOP |
