# 通知設計書 10-権限エラー通知

## 概要

本ドキュメントは、RuoYiシステムにおける権限エラー通知機能の設計仕様を記述したものである。認可エラー（AuthorizationException）発生時にAjaxリクエストにはJSONエラーを返却し、通常リクエストにはエラーページを表示する機能について定義する。

### 本通知の処理概要

本通知は、ユーザーが権限のない操作を試みた際に、適切なエラーレスポンスを返却する機能を提供する。Apache Shiroの認可機能と連携し、@RequiresPermissionsや@RequiresRolesアノテーションで制御された操作へのアクセス拒否時に、リクエスト種別に応じた形式でエラーを通知する。

**業務上の目的・背景**：セキュリティ制御の一環として、権限のないユーザーによる操作試行を検知し、適切にブロックする必要がある。不正アクセスの防止、ユーザーへの適切なフィードバック、セキュリティ監査ログの提供などの業務要件を満たすために本機能が実装されている。

**通知の送信タイミング**：ユーザーが権限のない操作（メニュー、ボタン、API等）にアクセスした際、Shiroの認可チェックでAuthorizationExceptionが発生した時点でエラー通知が返却される。GlobalExceptionHandlerでトリガーされる。

**通知の受信者**：操作を試みたユーザー自身。エラーメッセージまたはエラーページが直接表示される。

**通知内容の概要**：権限エラーの場合は「没有XX权限，请联系管理员授权」（XX権限がありません、管理者に認可を依頼してください）形式のメッセージが表示される。

**期待されるアクション**：ユーザーは管理者に対して必要な権限の付与を依頼する。管理者は権限リクエストを確認し、適切なロール・権限を割り当てる。不正アクセスの場合は調査対象となる。

## 通知種別

HTTPエラーレスポンス（JSON / HTMLページ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（HTTPレスポンス即時返却） |
| 優先度 | 高（セキュリティ関連） |
| リトライ | 無 |

### 送信先決定ロジック

- 操作を試みたユーザーに対して直接エラーを返却
- リクエスト種別（Ajax/通常）に応じてレスポンス形式を変更

## 通知テンプレート

### Ajaxリクエストの場合

| 項目 | 内容 |
|-----|------|
| レスポンス形式 | JSON |
| HTTPステータス | 200（ボディにエラー情報） |

### 本文テンプレート（Ajax）

```json
{
  "code": 500,
  "msg": "没有{permission}权限，请联系管理员授权"
}
```

### 通常リクエストの場合

| 項目 | 内容 |
|-----|------|
| レスポンス形式 | HTMLページ |
| 遷移先 | error/unauth |

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| - | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| permission | 不足している権限 | 例外メッセージから抽出 | No |
| msg | エラーメッセージ | PermissionUtils.getMsg() | Yes |
| requestURI | リクエストURI | request.getRequestURI() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 例外ハンドラー | AuthorizationException | 常時 | Shiro認可失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 全ての認可エラーが通知対象 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーリクエスト] --> B{@RequiresPermissions等}
    B -->|権限あり| C[正常処理]
    B -->|権限なし| D[AuthorizationException]
    D --> E[GlobalExceptionHandler]
    E --> F[handleAuthorizationException]
    F --> G[ログ出力]
    G --> H{Ajaxリクエスト?}
    H -->|Yes| I[AjaxResult.error返却]
    H -->|No| J[ModelAndView返却]
    I --> K[JSONレスポンス]
    J --> L[error/unauth表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| - | - | データベースは参照しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| - | - | データベースは更新しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| UnauthorizedException | 権限不足 | エラーメッセージ返却 |
| UnauthenticatedException | 未認証 | ログイン画面へリダイレクト |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。リクエストに応じて常時返却。

## セキュリティ考慮事項

- **ログ出力**：権限エラーはログに記録され、不正アクセス検知に活用
- **詳細メッセージ抑制**：内部エラー詳細は非公開、一般的なメッセージのみ返却
- **Shiro連携**：Apache Shiroの認可機能と連携し、確実な権限チェック

## 備考

- PermissionUtils.getMsg()で例外メッセージから権限名を抽出し、ユーザーフレンドリーなメッセージに変換
- error/unauthページはThymeleafテンプレートで定義
- 複数の権限が不足している場合も対応

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

レスポンス構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AjaxResult.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/AjaxResult.java` | Ajaxレスポンス構造 |

**読解のコツ**: codeフィールド（0=成功、その他=エラー）とmsgフィールドの構造を理解する。

#### Step 2: エントリーポイントを理解する

グローバル例外ハンドラーを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GlobalExceptionHandler.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/exception/GlobalExceptionHandler.java` | 例外ハンドラー全体 |

**主要処理フロー**:
1. **28行目**: @RestControllerAdviceアノテーション
2. **36-49行目**: handleAuthorizationException() - 認可例外ハンドラー
3. **39行目**: リクエストURIログ出力
4. **40行目**: エラーログ出力
5. **41-44行目**: Ajaxリクエスト判定とJSONレスポンス返却
6. **46-48行目**: 通常リクエストでのModelAndView返却（error/unauth）

#### Step 3: 権限メッセージ生成を理解する

権限ユーティリティを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PermissionUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/security/PermissionUtils.java` | 権限メッセージ生成 |

**主要処理フロー**:
- getMsg() - 例外メッセージから権限名を抽出し、ユーザーフレンドリーなメッセージに変換

### プログラム呼び出し階層図

```
Controllerメソッド (@RequiresPermissions付与)
    │
    └─ Shiro認可チェック
           │
           └─ AuthorizationException発生
                  │
                  └─ GlobalExceptionHandler.handleAuthorizationException()
                         │
                         ├─ log.error() (ログ出力)
                         │
                         ├─ ServletUtils.isAjaxRequest() (リクエスト種別判定)
                         │
                         ├─ Ajax: AjaxResult.error(PermissionUtils.getMsg())
                         │      │
                         │      └─ JSONレスポンス
                         │
                         └─ 通常: ModelAndView("error/unauth")
                                │
                                └─ エラーページ表示
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト ───▶ Controller ───▶ Shiro認可チェック
    │                    │              │
    │                    │              ▼
    │                    │         AuthorizationException
    │                    │              │
    │                    │              ▼
    │                    │         GlobalExceptionHandler
    │                    │              │
    │                    │              ├─ Ajax ───▶ JSONエラー
    │                    │              │
    │                    │              └─ 通常 ───▶ エラーページ
    │                    │
    │                    └─ 権限あり ───▶ 正常レスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GlobalExceptionHandler.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/web/exception/GlobalExceptionHandler.java` | ソース | グローバル例外ハンドラー |
| PermissionUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/security/PermissionUtils.java` | ソース | 権限ユーティリティ |
| AjaxResult.java | `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/AjaxResult.java` | ソース | Ajaxレスポンス構造 |
| ServletUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/ServletUtils.java` | ソース | サーブレットユーティリティ |
| unauth.html | `ruoyi-admin/src/main/resources/templates/error/unauth.html` | テンプレート | 権限エラーページ |
