# 通知設計書 3-ログイン成功通知

## 概要

本ドキュメントは、RuoYiシステムにおけるログイン成功通知（ログ記録）機能の設計仕様を記述したものである。ユーザーがログインに成功した際に、ログイン情報をデータベースに記録する機能について定義する。

### 本通知の処理概要

本通知は、ユーザーがシステムへのログインに成功した際に、ログイン情報を監査ログとして非同期でデータベースに記録する機能を提供する。ユーザー名、IPアドレス、ブラウザ情報、OS情報、ログイン地点などを記録し、セキュリティ監査やアクセス履歴管理に活用される。

**業務上の目的・背景**：セキュリティ監査およびコンプライアンス対応のため、全ユーザーのログイン履歴を記録する必要がある。不正アクセスの検知、ユーザー行動分析、アクセス統計の取得などの業務要件を満たすために本機能が実装されている。

**通知の送信タイミング**：ユーザーがログイン処理を完了し、認証に成功した直後に非同期タスクとしてログ記録が実行される。SysLoginService.login()メソッドの正常終了時にトリガーされる。

**通知の受信者**：システム管理者（ログ閲覧権限を持つユーザー）。記録されたログは監視画面（/monitor/logininfor）から参照可能。

**通知内容の概要**：ログイン成功時のユーザー名、ログインIPアドレス、ログイン地点（IPから逆引き）、使用ブラウザ、OS情報、成功メッセージ、ログイン日時が記録される。

**期待されるアクション**：管理者は定期的にログイン履歴を確認し、不審なアクセスパターン（異常なIPアドレス、通常と異なる時間帯のアクセス等）がないか監視する。セキュリティインシデント発生時の調査資料として活用する。

## 通知種別

ログ記録（データベース監査ログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（AsyncManager経由） |
| 優先度 | 中 |
| リトライ | 無（非同期タスクのため） |

### 送信先決定ロジック

- ログは一律でsys_logininforテーブルに記録
- 特定の送信先は存在しない（データベースへの記録）

## 通知テンプレート

### ログ記録の場合

| 項目 | 内容 |
|-----|------|
| 記録先 | sys_logininforテーブル |
| 記録形式 | データベースレコード |

### 本文テンプレート

```
ログインユーザー: {loginName}
IPアドレス: {ipaddr}
ログイン地点: {loginLocation}
ブラウザ: {browser}
OS: {os}
ステータス: 成功
メッセージ: {msg}
ログイン日時: {loginTime}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| - | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| loginName | ログインユーザー名 | 引数（username） | Yes |
| ipaddr | ログインIPアドレス | ShiroUtils.getIp() | Yes |
| loginLocation | ログイン地点 | AddressUtils.getRealAddressByIP() | No |
| browser | ブラウザ情報 | UserAgentUtils.getBrowser() | No |
| os | OS情報 | UserAgentUtils.getOperatingSystem() | No |
| status | ログインステータス | Constants.SUCCESS (0) | Yes |
| msg | メッセージ | MessageUtils.message("user.login.success") | Yes |
| loginTime | ログイン日時 | 現在日時（自動） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サービス処理 | ログイン成功 | 認証成功後 | SysLoginService.login()の正常終了 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 認証失敗 | 認証失敗時は別の通知（No.4）で記録 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ログインリクエスト] --> B[SysLoginService.login]
    B --> C{認証成功?}
    C -->|Yes| D[AsyncManager.me.execute]
    C -->|No| E[失敗ログ記録へ]
    D --> F[AsyncFactory.recordLogininfor]
    F --> G[TimerTask生成]
    G --> H[非同期実行]
    H --> I[IPから地点取得]
    I --> J[ブラウザ/OS情報取得]
    J --> K[SysLogininfor生成]
    K --> L[sys_logininforにINSERT]
    L --> M[ログ記録完了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| sys_user | ユーザー情報の取得 | ログイン認証時に使用 |
| sys_config | IP黒リスト等の設定取得 | ログイン検証時に使用 |

### テーブル別参照項目詳細

#### sys_user

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| login_name | ログインユーザー名 | WHERE login_name = ? |
| password | パスワード検証 | - |
| salt | パスワードソルト | - |
| status | ユーザー状態 | 有効チェック |
| del_flag | 削除フラグ | 論理削除チェック |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sys_logininfor | INSERT | ログイン情報記録 |
| sys_user | UPDATE | 最終ログイン情報更新 |

#### sys_logininfor テーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | info_id | 自動採番 | 主キー |
| INSERT | login_name | ユーザー名 | - |
| INSERT | ipaddr | IPアドレス | ShiroUtils.getIp() |
| INSERT | login_location | ログイン地点 | IP逆引き |
| INSERT | browser | ブラウザ | User-Agentから解析 |
| INSERT | os | OS | User-Agentから解析 |
| INSERT | status | 0 | 成功 |
| INSERT | msg | 成功メッセージ | i18n対応 |
| INSERT | login_time | 現在日時 | - |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| DB接続エラー | データベース接続不可 | ログ出力のみ、メイン処理に影響なし |
| IP逆引き失敗 | 外部サービスエラー | "内网IP"として記録 |
| User-Agent解析失敗 | 不正なUser-Agent | 空文字として記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（非同期タスクのため） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。24時間ログイン可能な環境では常時記録。

## セキュリティ考慮事項

- **IPアドレス記録**：クライアントIPアドレスを記録し、不正アクセス追跡に活用
- **地理情報取得**：IPから地理情報を取得し、異常なアクセス地点の検知に活用
- **非同期処理**：ログ記録をメイン処理から分離し、パフォーマンスへの影響を最小化
- **パスワード非記録**：セキュリティ上、パスワードはログに記録しない

## 備考

- 非同期処理はAsyncManagerとScheduledExecutorServiceを使用
- IP逆引きはAddressUtilsを通じて外部サービス（ip.taobao.com等）を使用
- メッセージは国際化対応（MessageUtils.message()）
- ログイン成功時にはユーザーテーブルの最終ログイン情報も更新される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ログ記録に使用されるエンティティクラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysLogininfor.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysLogininfor.java` | ログイン情報エンティティの構造、各フィールドの意味 |

**読解のコツ**: `@Excel`アノテーションでExcelエクスポート時のカラム名を確認。statusフィールド（0=成功、1=失敗）に注目。

#### Step 2: エントリーポイントを理解する

ログイン処理のサービスクラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysLoginService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysLoginService.java` | ログイン処理フロー、成功時のログ記録呼び出し |

**主要処理フロー**:
1. **54-131行目**: login()メソッド - ログイン処理全体
2. **57-61行目**: キャプチャ検証
3. **63-82行目**: 入力値バリデーション
4. **84-90行目**: IP黒リストチェック
5. **93-123行目**: ユーザー存在確認・状態チェック
6. **125行目**: パスワード検証（SysPasswordService.validate）
7. **127行目**: **ログイン成功ログ記録** - `AsyncManager.me().execute(AsyncFactory.recordLogininfor(username, Constants.LOGIN_SUCCESS, MessageUtils.message("user.login.success")))`

#### Step 3: 非同期ログ記録処理を理解する

ログ記録の非同期処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AsyncFactory.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/factory/AsyncFactory.java` | 非同期タスク生成、ログ記録処理 |

**主要処理フロー**:
- **92-135行目**: recordLogininfor()メソッド
- **94行目**: User-Agentヘッダー取得
- **95行目**: IPアドレス取得
- **101行目**: IP逆引きで地点取得
- **111-113行目**: ブラウザ・OS情報取得
- **115-121行目**: SysLogininforオブジェクト構築
- **123-129行目**: ステータス判定（SUCCESS/LOGOUT/REGISTER/LOGIN_FAIL）
- **132行目**: データベースINSERT

#### Step 4: データアクセス層を理解する

データベース登録処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SysLogininforServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysLogininforServiceImpl.java` | サービス実装 |
| 4-2 | SysLogininforMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysLogininforMapper.java` | Mapperインターフェース |

### プログラム呼び出し階層図

```
SysLoginService.login() (ログイン処理)
    │
    ├─ 各種バリデーション
    │
    ├─ SysPasswordService.validate() (パスワード検証)
    │
    └─ AsyncManager.me().execute() (非同期実行)
           │
           └─ AsyncFactory.recordLogininfor() (タスク生成)
                  │
                  ├─ ShiroUtils.getIp() (IP取得)
                  │
                  ├─ AddressUtils.getRealAddressByIP() (地点取得)
                  │
                  ├─ UserAgentUtils.getBrowser() (ブラウザ取得)
                  │
                  ├─ UserAgentUtils.getOperatingSystem() (OS取得)
                  │
                  └─ SysLogininforServiceImpl.insertLogininfor()
                         │
                         └─ SysLogininforMapper.insertLogininfor()
                                │
                                └─ sys_logininfor テーブル
```

### データフロー図

```
[入力]               [処理]                    [出力]

ログイン情報 ───▶ SysLoginService ───▶ 認証結果
    │                    │
    │                    ▼
    │              AsyncManager (非同期)
    │                    │
    │                    ▼
    │              AsyncFactory.recordLogininfor
    │                    │
    │                    ├─▶ IP逆引きAPI
    │                    │
    │                    ▼
    └─────────────▶ sys_logininfor テーブル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysLogininfor.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysLogininfor.java` | ソース | ログイン情報エンティティ |
| SysLoginService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysLoginService.java` | ソース | ログインサービス |
| AsyncFactory.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/factory/AsyncFactory.java` | ソース | 非同期タスクファクトリ |
| AsyncManager.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/AsyncManager.java` | ソース | 非同期タスク管理 |
| SysLogininforServiceImpl.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysLogininforServiceImpl.java` | ソース | ログイン情報サービス |
| SysLogininforMapper.java | `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysLogininforMapper.java` | ソース | Mapperインターフェース |
| AddressUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/AddressUtils.java` | ソース | IP逆引きユーティリティ |
| UserAgentUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/http/UserAgentUtils.java` | ソース | User-Agent解析 |
| Constants.java | `ruoyi-common/src/main/java/com/ruoyi/common/constant/Constants.java` | ソース | 定数定義（LOGIN_SUCCESS等） |
