# 通知設計書 4-ログイン失敗通知

## 概要

本ドキュメントは、RuoYiシステムにおけるログイン失敗通知（ログ記録）機能の設計仕様を記述したものである。ユーザーがログインに失敗した際（パスワード誤り、キャプチャエラー、ユーザー不存在、アカウント無効等）に、失敗情報をデータベースに記録する機能について定義する。

### 本通知の処理概要

本通知は、ユーザーがシステムへのログインに失敗した際に、失敗情報を監査ログとして非同期でデータベースに記録する機能を提供する。失敗の種類（キャプチャエラー、パスワード不一致、ユーザー不存在、アカウント停止等）に応じたメッセージとともに、IPアドレス、ブラウザ情報、OS情報等を記録し、セキュリティ監視に活用される。

**業務上の目的・背景**：セキュリティ監視およびブルートフォース攻撃検知のため、全てのログイン失敗を記録する必要がある。不正アクセス試行の検知、アカウント乗っ取り試行の監視、パスワードリスト攻撃の検出などの業務要件を満たすために本機能が実装されている。

**通知の送信タイミング**：ユーザーがログイン処理を行い、認証に失敗した時点で非同期タスクとしてログ記録が実行される。SysLoginService.login()メソッドの各種バリデーション失敗時、またはSysPasswordService.validate()でのパスワード不一致時にトリガーされる。

**通知の受信者**：システム管理者（ログ閲覧権限を持つユーザー）。記録されたログは監視画面（/monitor/logininfor）から参照可能。

**通知内容の概要**：ログイン失敗時の試行ユーザー名、IPアドレス、ログイン地点、使用ブラウザ、OS情報、失敗理由メッセージ、試行日時が記録される。

**期待されるアクション**：管理者は失敗ログを監視し、同一IPからの連続失敗、同一アカウントへの多数の失敗試行などの不審なパターンを検知する。必要に応じてIPブロック、アカウントロック、ユーザーへの通知などの対応を行う。

## 通知種別

ログ記録（データベース監査ログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（AsyncManager経由） |
| 優先度 | 高（セキュリティ関連） |
| リトライ | 無（非同期タスクのため） |

### 送信先決定ロジック

- ログは一律でsys_logininforテーブルに記録
- 特定の送信先は存在しない（データベースへの記録）

## 通知テンプレート

### ログ記録の場合

| 項目 | 内容 |
|-----|------|
| 記録先 | sys_logininforテーブル |
| 記録形式 | データベースレコード |

### 本文テンプレート

```
ログインユーザー: {loginName}
IPアドレス: {ipaddr}
ログイン地点: {loginLocation}
ブラウザ: {browser}
OS: {os}
ステータス: 失敗
メッセージ: {msg}
ログイン日時: {loginTime}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| - | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| loginName | ログイン試行ユーザー名 | 引数（username） | Yes |
| ipaddr | ログイン試行IPアドレス | ShiroUtils.getIp() | Yes |
| loginLocation | ログイン試行地点 | AddressUtils.getRealAddressByIP() | No |
| browser | ブラウザ情報 | UserAgentUtils.getBrowser() | No |
| os | OS情報 | UserAgentUtils.getOperatingSystem() | No |
| status | ログインステータス | Constants.FAIL (1) | Yes |
| msg | 失敗理由メッセージ | MessageUtils.message() | Yes |
| loginTime | ログイン試行日時 | 現在日時（自動） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サービス処理 | キャプチャエラー | CAPTCHA_ERROR | 画像認証コード誤り |
| サービス処理 | 入力値空 | username/passwordが空 | ユーザー名またはパスワード未入力 |
| サービス処理 | パスワード長エラー | 5-20文字範囲外 | パスワード長が規定外 |
| サービス処理 | ユーザー名長エラー | 2-20文字範囲外 | ユーザー名長が規定外 |
| サービス処理 | IPブラックリスト | IP黒リストに該当 | 禁止IPからのアクセス |
| サービス処理 | ユーザー不存在 | ユーザーが見つからない | 存在しないユーザー名 |
| サービス処理 | ユーザー削除済み | del_flag=2 | 論理削除されたユーザー |
| サービス処理 | アカウント停止 | status=1 | 無効化されたアカウント |
| サービス処理 | パスワード不一致 | パスワード検証失敗 | 入力パスワードが一致しない |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 認証成功 | 認証成功時は別の通知（No.3）で記録 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ログインリクエスト] --> B[SysLoginService.login]
    B --> C{キャプチャ検証}
    C -->|NG| D1[キャプチャエラーログ記録]
    C -->|OK| E{入力値バリデーション}
    E -->|NG| D2[バリデーションエラーログ記録]
    E -->|OK| F{IPブラックリスト}
    F -->|該当| D3[ブラックリストエラーログ記録]
    F -->|OK| G{ユーザー存在確認}
    G -->|不存在| D4[ユーザー不存在ログ記録]
    G -->|存在| H{ユーザー状態確認}
    H -->|削除済み| D5[削除済みエラーログ記録]
    H -->|停止中| D6[停止中エラーログ記録]
    H -->|有効| I{パスワード検証}
    I -->|NG| D7[パスワード不一致ログ記録]
    I -->|OK| J[ログイン成功処理へ]
    D1 --> K[AsyncManager.execute]
    D2 --> K
    D3 --> K
    D4 --> K
    D5 --> K
    D6 --> K
    D7 --> K
    K --> L[AsyncFactory.recordLogininfor]
    L --> M[sys_logininforにINSERT]
    M --> N[例外スロー]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| sys_user | ユーザー情報の取得 | ログイン認証時に使用 |
| sys_config | IP黒リスト設定取得 | sys.login.blackIPListキー |

### テーブル別参照項目詳細

#### sys_config

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| config_value | IP黒リスト | config_key = 'sys.login.blackIPList' |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sys_logininfor | INSERT | ログイン失敗情報記録 |

#### sys_logininfor テーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | info_id | 自動採番 | 主キー |
| INSERT | login_name | ユーザー名 | 入力値 |
| INSERT | ipaddr | IPアドレス | ShiroUtils.getIp() |
| INSERT | login_location | ログイン地点 | IP逆引き |
| INSERT | browser | ブラウザ | User-Agentから解析 |
| INSERT | os | OS | User-Agentから解析 |
| INSERT | status | 1 | 失敗 |
| INSERT | msg | 失敗理由 | i18n対応メッセージ |
| INSERT | login_time | 現在日時 | - |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| DB接続エラー | データベース接続不可 | ログ出力のみ、例外はスロー |
| IP逆引き失敗 | 外部サービスエラー | "内网IP"として記録 |
| User-Agent解析失敗 | 不正なUser-Agent | 空文字として記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（非同期タスクのため） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。ログイン試行に応じて常時記録。

## セキュリティ考慮事項

- **IPアドレス記録**：攻撃元IPの特定・ブロックに活用
- **失敗理由の記録**：攻撃パターン分析に活用（パスワード総当たり、辞書攻撃等）
- **パスワード非記録**：セキュリティ上、試行されたパスワードはログに記録しない
- **ユーザー名記録**：存在しないユーザー名への試行も記録し、アカウント推測攻撃を検知

## 備考

- 失敗ログ記録後に各種例外（CaptchaException, UserNotExistsException等）がスローされる
- ログ記録は例外スロー前に非同期で実行されるため、確実に記録される
- パスワードリトライ制限超過は別の通知（No.5）で扱う
- 失敗理由メッセージは国際化対応（MessageUtils.message()）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ログ記録に使用されるエンティティクラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysLogininfor.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysLogininfor.java` | ログイン情報エンティティの構造、statusフィールド（1=失敗） |

**読解のコツ**: statusフィールドの値（0=成功、1=失敗）に注目。msgフィールドに失敗理由が格納される。

#### Step 2: エントリーポイントを理解する

ログイン処理のサービスクラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysLoginService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysLoginService.java` | ログイン処理フロー、各種失敗時のログ記録呼び出し |

**主要処理フロー**:
1. **57-61行目**: キャプチャ検証失敗 - `AsyncFactory.recordLogininfor(username, Constants.LOGIN_FAIL, MessageUtils.message("user.jcaptcha.error"))`
2. **63-67行目**: 入力値空チェック失敗 - `MessageUtils.message("not.null")`
3. **69-74行目**: パスワード長チェック失敗 - `MessageUtils.message("user.password.not.match")`
4. **77-82行目**: ユーザー名長チェック失敗 - `MessageUtils.message("user.password.not.match")`
5. **85-90行目**: IPブラックリスト該当 - `MessageUtils.message("login.blocked")`
6. **107-111行目**: ユーザー不存在 - `MessageUtils.message("user.not.exists")`
7. **113-117行目**: ユーザー削除済み - `MessageUtils.message("user.password.delete")`
8. **119-123行目**: アカウント停止 - `MessageUtils.message("user.blocked")`

#### Step 3: パスワード検証処理を理解する

パスワード検証サービスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SysPasswordService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java` | パスワード検証、リトライカウント管理 |

**主要処理フロー**:
- **59-64行目**: パスワード不一致時 - `AsyncFactory.recordLogininfor(loginName, Constants.LOGIN_FAIL, MessageUtils.message("user.password.retry.limit.count", retryCount))`

#### Step 4: 非同期ログ記録処理を理解する

ログ記録の非同期処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | AsyncFactory.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/factory/AsyncFactory.java` | 非同期タスク生成、ログ記録処理 |

**主要処理フロー**:
- **127-129行目**: LOGIN_FAIL時のステータス設定 - `else if (Constants.LOGIN_FAIL.equals(status)) { logininfor.setStatus(Constants.FAIL) }`

### プログラム呼び出し階層図

```
SysLoginService.login() (ログイン処理)
    │
    ├─ キャプチャ検証失敗
    │      └─ AsyncManager.execute(recordLogininfor) ─▶ sys_logininfor
    │
    ├─ 入力値バリデーション失敗
    │      └─ AsyncManager.execute(recordLogininfor) ─▶ sys_logininfor
    │
    ├─ IPブラックリスト該当
    │      └─ AsyncManager.execute(recordLogininfor) ─▶ sys_logininfor
    │
    ├─ ユーザー不存在
    │      └─ AsyncManager.execute(recordLogininfor) ─▶ sys_logininfor
    │
    ├─ ユーザー状態異常（削除/停止）
    │      └─ AsyncManager.execute(recordLogininfor) ─▶ sys_logininfor
    │
    └─ SysPasswordService.validate()
           │
           └─ パスワード不一致
                  └─ AsyncManager.execute(recordLogininfor) ─▶ sys_logininfor
```

### データフロー図

```
[入力]               [処理]                    [出力]

ログイン情報 ───▶ SysLoginService ───▶ 認証失敗例外
    │                    │
    │                    ▼
    │              バリデーション失敗検出
    │                    │
    │                    ▼
    │              AsyncManager (非同期)
    │                    │
    │                    ▼
    └─────────────▶ sys_logininfor テーブル
                         │
                         └─▶ status = 1 (失敗)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysLogininfor.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysLogininfor.java` | ソース | ログイン情報エンティティ |
| SysLoginService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysLoginService.java` | ソース | ログインサービス |
| SysPasswordService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java` | ソース | パスワード検証サービス |
| AsyncFactory.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/factory/AsyncFactory.java` | ソース | 非同期タスクファクトリ |
| CaptchaException.java | `ruoyi-common/src/main/java/com/ruoyi/common/exception/user/CaptchaException.java` | ソース | キャプチャ例外 |
| UserNotExistsException.java | `ruoyi-common/src/main/java/com/ruoyi/common/exception/user/UserNotExistsException.java` | ソース | ユーザー不存在例外 |
| UserBlockedException.java | `ruoyi-common/src/main/java/com/ruoyi/common/exception/user/UserBlockedException.java` | ソース | アカウント停止例外 |
| BlackListException.java | `ruoyi-common/src/main/java/com/ruoyi/common/exception/user/BlackListException.java` | ソース | ブラックリスト例外 |
| UserPasswordNotMatchException.java | `ruoyi-common/src/main/java/com/ruoyi/common/exception/user/UserPasswordNotMatchException.java` | ソース | パスワード不一致例外 |
| Constants.java | `ruoyi-common/src/main/java/com/ruoyi/common/constant/Constants.java` | ソース | 定数定義（LOGIN_FAIL, FAIL等） |
