# 通知設計書 6-ログアウト通知

## 概要

本ドキュメントは、RuoYiシステムにおけるログアウト通知（ログ記録）機能の設計仕様を記述したものである。ユーザーがシステムからログアウトした際にログアウト情報をデータベースに記録する機能について定義する。

### 本通知の処理概要

本通知は、ユーザーがシステムからログアウトした際に、ログアウト情報を監査ログとして非同期でデータベースに記録する機能を提供する。ユーザー名、IPアドレス、ログアウト日時などを記録し、セッション管理とセキュリティ監査に活用される。

**業務上の目的・背景**：セキュリティ監査およびセッション管理のため、全ユーザーのログアウト履歴を記録する必要がある。不正アクセス後のログアウト検知、ユーザー行動分析、セッションライフサイクル管理などの業務要件を満たすために本機能が実装されている。

**通知の送信タイミング**：ユーザーがログアウト操作を行った時点（ログアウトボタン押下、セッションタイムアウト等）で非同期タスクとしてログ記録が実行される。LogoutFilter.preHandle()メソッドでトリガーされる。

**通知の受信者**：システム管理者（ログ閲覧権限を持つユーザー）。記録されたログは監視画面（/monitor/logininfor）から参照可能。

**通知内容の概要**：ログアウト時のユーザー名、IPアドレス、ログイン地点、使用ブラウザ、OS情報、ログアウト成功メッセージ、ログアウト日時が記録される。

**期待されるアクション**：管理者はログアウト履歴を監視し、異常なログアウトパターン（短時間での繰り返しログイン・ログアウト等）を検知する。セキュリティインシデント発生時の調査資料として活用する。

## 通知種別

ログ記録（データベース監査ログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（AsyncManager経由） |
| 優先度 | 中 |
| リトライ | 無（非同期タスクのため） |

### 送信先決定ロジック

- ログは一律でsys_logininforテーブルに記録
- 特定の送信先は存在しない（データベースへの記録）

## 通知テンプレート

### ログ記録の場合

| 項目 | 内容 |
|-----|------|
| 記録先 | sys_logininforテーブル |
| 記録形式 | データベースレコード |

### 本文テンプレート

```
ログインユーザー: {loginName}
IPアドレス: {ipaddr}
ログイン地点: {loginLocation}
ブラウザ: {browser}
OS: {os}
ステータス: 成功（ログアウト）
メッセージ: {msg}
ログアウト日時: {loginTime}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| - | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| loginName | ログアウトユーザー名 | ShiroUtils.getSysUser().getLoginName() | Yes |
| ipaddr | IPアドレス | ShiroUtils.getIp() | Yes |
| loginLocation | 地点 | AddressUtils.getRealAddressByIP() | No |
| browser | ブラウザ情報 | UserAgentUtils.getBrowser() | No |
| os | OS情報 | UserAgentUtils.getOperatingSystem() | No |
| status | ステータス | Constants.SUCCESS (0) | Yes |
| msg | メッセージ | MessageUtils.message("user.logout.success") | Yes |
| loginTime | ログアウト日時 | 現在日時（自動） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| フィルター処理 | ログアウトリクエスト | ユーザーがログイン中 | LogoutFilter.preHandle() |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ユーザー情報なし | ShiroUtils.getSysUser()がnullの場合はログ記録なし |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ログアウトリクエスト] --> B[LogoutFilter.preHandle]
    B --> C[Subject取得]
    C --> D[リダイレクトURL取得]
    D --> E{SysUser取得}
    E -->|null| F[ログ記録スキップ]
    E -->|存在| G[AsyncManager.execute]
    G --> H[AsyncFactory.recordLogininfor]
    H --> I[ログ記録]
    I --> J[キャッシュクリア]
    J --> K[subject.logout]
    K --> L[リダイレクト]
    F --> K
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| - | - | ユーザー情報はセッションから取得 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sys_logininfor | INSERT | ログアウト情報記録 |
| sys_user_online | DELETE | オンラインユーザー情報削除 |

#### sys_logininfor テーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | info_id | 自動採番 | 主キー |
| INSERT | login_name | ユーザー名 | - |
| INSERT | ipaddr | IPアドレス | ShiroUtils.getIp() |
| INSERT | login_location | 地点 | IP逆引き |
| INSERT | browser | ブラウザ | User-Agentから解析 |
| INSERT | os | OS | User-Agentから解析 |
| INSERT | status | 0 | 成功 |
| INSERT | msg | ログアウト成功メッセージ | i18n対応 |
| INSERT | login_time | 現在日時 | - |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| SessionException | セッションが無効 | エラーログ出力、処理続行 |
| DB接続エラー | データベース接続不可 | エラーログ出力のみ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（非同期タスクのため） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。ログアウト操作に応じて常時記録。

## セキュリティ考慮事項

- **セッション無効化**：ログアウト時に確実にセッションを無効化
- **キャッシュクリア**：ユーザーキャッシュをクリアし、セキュリティリスクを低減
- **例外処理**：SessionException発生時もログアウト処理を続行し、確実にセッションを終了

## 備考

- ログアウト後はloginUrl（設定値）へリダイレクト
- オンラインユーザーキャッシュ（ISysUserOnlineService）もクリアされる
- Constants.LOGOUTステータスでログ記録されるため、ログイン成功（SUCCESS）と区別可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ログ記録に使用されるエンティティクラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysLogininfor.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysLogininfor.java` | ログイン/ログアウト情報エンティティ |

**読解のコツ**: ログアウトもログイン情報と同じテーブル・エンティティを使用。statusとmsgで区別される。

#### Step 2: エントリーポイントを理解する

ログアウトフィルターを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LogoutFilter.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/filter/LogoutFilter.java` | ログアウト処理全体 |

**主要処理フロー**:
1. **44-75行目**: preHandle()メソッド - ログアウト処理全体
2. **48行目**: Subject取得
3. **49行目**: リダイレクトURL取得
4. **52-53行目**: SysUser取得
5. **55行目**: ログイン名取得
6. **57行目**: **ログアウトログ記録** - `AsyncManager.me().execute(AsyncFactory.recordLogininfor(loginName, Constants.LOGOUT, MessageUtils.message("user.logout.success")))`
7. **59行目**: キャッシュクリア - `removeUserCache(loginName, ShiroUtils.getSessionId())`
8. **62行目**: セッション終了 - `subject.logout()`
9. **68行目**: リダイレクト

#### Step 3: 非同期ログ記録処理を理解する

ログ記録の非同期処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AsyncFactory.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/factory/AsyncFactory.java` | 非同期タスク生成、LOGOUT時のステータス設定 |

**主要処理フロー**:
- **123行目**: LOGOUTステータス判定 - `if (StringUtils.equalsAny(status, Constants.LOGIN_SUCCESS, Constants.LOGOUT, Constants.REGISTER))`
- **125行目**: ステータス設定 - `logininfor.setStatus(Constants.SUCCESS)`

### プログラム呼び出し階層図

```
LogoutFilter.preHandle() (ログアウトフィルター)
    │
    ├─ getSubject() (Subject取得)
    │
    ├─ getRedirectUrl() (リダイレクトURL取得)
    │
    ├─ ShiroUtils.getSysUser() (ユーザー情報取得)
    │
    ├─ AsyncManager.me().execute() (非同期実行)
    │      │
    │      └─ AsyncFactory.recordLogininfor(LOGOUT) ─▶ sys_logininfor
    │
    ├─ ISysUserOnlineService.removeUserCache() (キャッシュクリア)
    │
    ├─ subject.logout() (セッション終了)
    │
    └─ issueRedirect() (リダイレクト)
```

### データフロー図

```
[入力]               [処理]                    [出力]

ログアウト要求 ───▶ LogoutFilter ───▶ リダイレクト
    │                    │
    │                    ▼
    │              AsyncManager (非同期)
    │                    │
    │                    ▼
    │              AsyncFactory.recordLogininfor
    │                    │
    │                    ▼
    └─────────────▶ sys_logininfor テーブル
                         │
                         └─▶ status = 0, msg = "logout success"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LogoutFilter.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/filter/LogoutFilter.java` | ソース | ログアウトフィルター |
| AsyncFactory.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/factory/AsyncFactory.java` | ソース | 非同期タスクファクトリ |
| SysLogininfor.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysLogininfor.java` | ソース | ログイン情報エンティティ |
| ISysUserOnlineService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserOnlineService.java` | ソース | オンラインユーザーサービス |
| Constants.java | `ruoyi-common/src/main/java/com/ruoyi/common/constant/Constants.java` | ソース | 定数定義（LOGOUT） |
| ShiroUtils.java | `ruoyi-common/src/main/java/com/ruoyi/common/utils/ShiroUtils.java` | ソース | Shiroユーティリティ |
