# 通知設計書 7-ユーザー登録成功通知

## 概要

本ドキュメントは、RuoYiシステムにおけるユーザー登録成功通知（ログ記録）機能の設計仕様を記述したものである。新規ユーザーが自己登録に成功した際にログを記録する機能について定義する。

### 本通知の処理概要

本通知は、新規ユーザーがシステムへの自己登録に成功した際に、登録情報を監査ログとして非同期でデータベースに記録する機能を提供する。登録ユーザー名、IPアドレス、登録日時などを記録し、ユーザー管理とセキュリティ監査に活用される。

**業務上の目的・背景**：ユーザー管理および不正登録検知のため、全ての新規登録を記録する必要がある。アカウント作成履歴の管理、大量登録攻撃の検知、登録統計の取得などの業務要件を満たすために本機能が実装されている。

**通知の送信タイミング**：新規ユーザーが登録フォームから情報を送信し、バリデーション通過後にデータベースへのユーザー登録が成功した時点で非同期タスクとしてログ記録が実行される。SysRegisterService.register()メソッドでトリガーされる。

**通知の受信者**：システム管理者（ログ閲覧権限を持つユーザー）。記録されたログは監視画面（/monitor/logininfor）から参照可能。

**通知内容の概要**：登録成功時のユーザー名、IPアドレス、登録地点、使用ブラウザ、OS情報、登録成功メッセージ、登録日時が記録される。

**期待されるアクション**：管理者は登録履歴を監視し、異常な登録パターン（短時間での大量登録、不審なIP等）を検知する。新規ユーザーの承認プロセスや、ウェルカムメール送信などの後続処理のトリガーとしても活用できる。

## 通知種別

ログ記録（データベース監査ログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（AsyncManager経由） |
| 優先度 | 中 |
| リトライ | 無（非同期タスクのため） |

### 送信先決定ロジック

- ログは一律でsys_logininforテーブルに記録
- 特定の送信先は存在しない（データベースへの記録）

## 通知テンプレート

### ログ記録の場合

| 項目 | 内容 |
|-----|------|
| 記録先 | sys_logininforテーブル |
| 記録形式 | データベースレコード |

### 本文テンプレート

```
登録ユーザー: {loginName}
IPアドレス: {ipaddr}
登録地点: {loginLocation}
ブラウザ: {browser}
OS: {os}
ステータス: 成功（登録）
メッセージ: {msg}
登録日時: {loginTime}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| - | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| loginName | 登録ユーザー名 | user.getLoginName() | Yes |
| ipaddr | IPアドレス | ShiroUtils.getIp() | Yes |
| loginLocation | 登録地点 | AddressUtils.getRealAddressByIP() | No |
| browser | ブラウザ情報 | UserAgentUtils.getBrowser() | No |
| os | OS情報 | UserAgentUtils.getOperatingSystem() | No |
| status | ステータス | Constants.SUCCESS (0) | Yes |
| msg | メッセージ | MessageUtils.message("user.register.success") | Yes |
| loginTime | 登録日時 | 現在日時（自動） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サービス処理 | ユーザー登録成功 | regFlag == true | SysRegisterService.register()の正常終了 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| バリデーションエラー | 各種入力チェック失敗時は記録しない |
| DB登録失敗 | registerUser()がfalseを返した場合は記録しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[登録リクエスト] --> B[SysRegisterService.register]
    B --> C{キャプチャ検証}
    C -->|NG| D1[エラーメッセージ返却]
    C -->|OK| E{入力バリデーション}
    E -->|NG| D2[エラーメッセージ返却]
    E -->|OK| F{ユーザー名重複チェック}
    F -->|重複| D3[エラーメッセージ返却]
    F -->|OK| G[パスワード暗号化]
    G --> H[userService.registerUser]
    H --> I{登録成功?}
    I -->|No| D4[エラーメッセージ返却]
    I -->|Yes| J[AsyncManager.execute]
    J --> K[AsyncFactory.recordLogininfor]
    K --> L[sys_logininforにINSERT]
    L --> M[空文字返却（成功）]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| sys_user | ユーザー名重複チェック | checkLoginNameUnique() |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| sys_user | INSERT | 新規ユーザー登録 |
| sys_logininfor | INSERT | 登録成功ログ記録 |

#### sys_logininfor テーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | info_id | 自動採番 | 主キー |
| INSERT | login_name | ユーザー名 | - |
| INSERT | ipaddr | IPアドレス | ShiroUtils.getIp() |
| INSERT | login_location | 登録地点 | IP逆引き |
| INSERT | browser | ブラウザ | User-Agentから解析 |
| INSERT | os | OS | User-Agentから解析 |
| INSERT | status | 0 | 成功 |
| INSERT | msg | 登録成功メッセージ | i18n対応 |
| INSERT | login_time | 現在日時 | - |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キャプチャエラー | 画像認証コード誤り | エラーメッセージ返却 |
| 入力値空 | ユーザー名/パスワード未入力 | エラーメッセージ返却 |
| パスワード長エラー | 5-20文字範囲外 | エラーメッセージ返却 |
| ユーザー名長エラー | 2-20文字範囲外 | エラーメッセージ返却 |
| ユーザー名重複 | 既存ユーザーと重複 | エラーメッセージ返却 |
| DB登録失敗 | データベースエラー | エラーメッセージ返却 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（非同期タスクのため） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（アプリレベルでの制限は別途検討） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。登録操作に応じて常時記録。

## セキュリティ考慮事項

- **キャプチャ検証**：自動登録攻撃を防止するためキャプチャ必須
- **パスワード暗号化**：登録時にパスワードをMD5+ソルトで暗号化して保存
- **ユーザー名重複チェック**：既存ユーザーとの重複を防止
- **パスワード非記録**：セキュリティ上、パスワードはログに記録しない

## 備考

- 登録成功時は空文字が返却される（エラー時はエラーメッセージ）
- 登録ユーザーにはデフォルトでログインユーザー名がユーザー名（userName）として設定される
- パスワード更新日（pwdUpdateDate）が現在日時で設定される
- Constants.REGISTERステータスでログ記録されるため、ログインと区別可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ログ記録に使用されるエンティティクラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SysLogininfor.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysLogininfor.java` | ログイン/登録情報エンティティ |

**読解のコツ**: 登録もログイン情報と同じテーブル・エンティティを使用。statusとmsgで区別される。

#### Step 2: エントリーポイントを理解する

登録サービスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SysRegisterService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysRegisterService.java` | 登録処理全体 |

**主要処理フロー**:
1. **35-82行目**: register()メソッド - 登録処理全体
2. **39-42行目**: キャプチャ検証
3. **43-60行目**: 入力バリデーション
4. **61-64行目**: ユーザー名重複チェック
5. **67-70行目**: パスワード暗号化・ユーザー情報設定
6. **71行目**: ユーザー登録実行 - `userService.registerUser(user)`
7. **72-79行目**: 登録結果判定とログ記録
8. **78行目**: **登録成功ログ記録** - `AsyncManager.me().execute(AsyncFactory.recordLogininfor(loginName, Constants.REGISTER, MessageUtils.message("user.register.success")))`

#### Step 3: 非同期ログ記録処理を理解する

ログ記録の非同期処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AsyncFactory.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/factory/AsyncFactory.java` | 非同期タスク生成、REGISTER時のステータス設定 |

**主要処理フロー**:
- **123行目**: REGISTERステータス判定 - `if (StringUtils.equalsAny(status, Constants.LOGIN_SUCCESS, Constants.LOGOUT, Constants.REGISTER))`
- **125行目**: ステータス設定 - `logininfor.setStatus(Constants.SUCCESS)`

### プログラム呼び出し階層図

```
SysRegisterController.ajaxRegister() (コントローラー)
    │
    └─ SysRegisterService.register() (登録サービス)
           │
           ├─ キャプチャ検証
           │
           ├─ 入力バリデーション
           │
           ├─ userService.checkLoginNameUnique() (重複チェック)
           │
           ├─ passwordService.encryptPassword() (パスワード暗号化)
           │
           ├─ userService.registerUser() (ユーザー登録)
           │      │
           │      └─ sys_user INSERT
           │
           └─ AsyncManager.me().execute() (非同期実行)
                  │
                  └─ AsyncFactory.recordLogininfor(REGISTER) ─▶ sys_logininfor
```

### データフロー図

```
[入力]               [処理]                    [出力]

登録フォーム ───▶ SysRegisterService ───▶ 結果メッセージ
    │                    │
    │                    ▼
    │              バリデーション
    │                    │
    │                    ▼
    │              ユーザー登録
    │                    │
    │                    ▼
    │              AsyncManager (非同期)
    │                    │
    │                    ▼
    └─────────────▶ sys_logininfor テーブル
                         │
                         └─▶ status = 0, msg = "register success"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SysRegisterService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysRegisterService.java` | ソース | 登録サービス |
| SysRegisterController.java | `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysRegisterController.java` | ソース | 登録コントローラー |
| AsyncFactory.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/factory/AsyncFactory.java` | ソース | 非同期タスクファクトリ |
| SysPasswordService.java | `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java` | ソース | パスワード暗号化 |
| ISysUserService.java | `ruoyi-system/src/main/java/com/ruoyi/system/service/ISysUserService.java` | ソース | ユーザーサービス |
| SysLogininfor.java | `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysLogininfor.java` | ソース | ログイン情報エンティティ |
| Constants.java | `ruoyi-common/src/main/java/com/ruoyi/common/constant/Constants.java` | ソース | 定数定義（REGISTER） |
