---
generated_at: 2026-01-08 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-公告通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **公告の配信先決定ロジック詳細**：実装コードから全ユーザー配信と推測したが、明示的な配信先テーブルなし
  2. **操作ログ連携**：LogAspectとの連携は確認したが、非同期処理の詳細フローは要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysNotice.java` (行1-102)
- E-02: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java` (行1-126)
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysNoticeServiceImpl.java` (行1-83)
- E-04: `ruoyi-system/src/main/java/com/ruoyi/system/mapper/SysNoticeMapper.java` (行1-52)
- E-05: `ruoyi-framework/src/main/java/com/ruoyi/framework/aspectj/LogAspect.java` (行1-265)
- E-06: `ruoyi-common/src/main/java/com/ruoyi/common/annotation/Log.java` (行1-51)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | noticeType=1は通知、noticeType=2は公告として分類 | E-01 (行25-26: コメント「公告类型（1通知 2公告）」) | ○ |
| C-02 | status=0は正常、status=1は停止 | E-01 (行32: コメント「公告状态（0正常 1关闭）」) | ○ |
| C-03 | 公告タイトルは最大50文字 | E-01 (行51: `@Size(min = 0, max = 50)`) | ○ |
| C-04 | 公告タイトルにXSS対策あり | E-01 (行49: `@Xss`アノテーション) | ○ |
| C-05 | 公告タイトルは必須項目 | E-01 (行50: `@NotBlank`) | ○ |
| C-06 | system:notice:view権限で一覧画面アクセス可能 | E-02 (行36: `@RequiresPermissions("system:notice:view")`) | ○ |
| C-07 | system:notice:list権限で一覧データ取得可能 | E-02 (行46: `@RequiresPermissions("system:notice:list")`) | ○ |
| C-08 | system:notice:add権限で新規登録可能 | E-02 (行59,69: `@RequiresPermissions("system:notice:add")`) | ○ |
| C-09 | system:notice:edit権限で編集可能 | E-02 (行82,93: `@RequiresPermissions("system:notice:edit")`) | ○ |
| C-10 | system:notice:remove権限で削除可能 | E-02 (行117: `@RequiresPermissions("system:notice:remove")`) | ○ |
| C-11 | 新規登録時に操作ログ記録 | E-02 (行70: `@Log(title = "通知公告", businessType = BusinessType.INSERT)`) | ○ |
| C-12 | 更新時に操作ログ記録 | E-02 (行94: `@Log(title = "通知公告", businessType = BusinessType.UPDATE)`) | ○ |
| C-13 | 削除時に操作ログ記録 | E-02 (行118: `@Log(title = "通知公告", businessType = BusinessType.DELETE)`) | ○ |
| C-14 | 新規登録時にcreateByにログインユーザー名設定 | E-02 (行75: `notice.setCreateBy(getLoginName())`) | ○ |
| C-15 | 更新時にupdateByにログインユーザー名設定 | E-02 (行99: `notice.setUpdateBy(getLoginName())`) | ○ |
| C-16 | ServiceはMapperを通じてDBアクセス | E-03 (行20-21: `@Autowired private SysNoticeMapper noticeMapper`) | ○ |
| C-17 | 複数ID指定での一括削除が可能 | E-03 (行79-80: `deleteNoticeByIds`, Convert.toStrArray使用), E-04 (行51) | ○ |
| C-18 | @Logアノテーションで操作ログがAOP記録される | E-05, E-06 | ○ |
| C-19 | 操作ログは非同期で記録される | E-05 (行125: `AsyncManager.me().execute(AsyncFactory.recordOper(operLog))`) | ○ |
| C-20 | エンドポイントは/system/notice | E-02 (行28: `@RequestMapping("/system/notice")`) | ○ |
| C-21 | 一覧取得はPOST /list | E-02 (行47: `@PostMapping("/list")`) | ○ |
| C-22 | 新規登録はPOST /add | E-02 (行71: `@PostMapping("/add")`) | ○ |
| C-23 | 削除はPOST /remove | E-02 (行119: `@PostMapping("/remove")`) | ○ |
| C-24 | 全ユーザーが公告を参照可能 | **根拠なし** | △ |
| C-25 | HTMLコンテンツが格納可能 | **根拠なし**（noticeContentの型はStringだが、HTML可否の明示的制御なし） | △ |

## 4) 不足情報（Unknown / Missing）
- **C-24について**：コードから公告の配信先を特定ユーザーに絞り込む機能が見当たらないため、全ユーザー参照可能と推測したが、明示的な根拠なし
  - 候補：sys_notice_user（配信先管理テーブル）/ 設定ファイル / フロントエンド実装
- **C-25について**：noticeContentフィールドはString型でXSS対策アノテーションがないため、HTML格納可能と推測したが要確認
  - 候補：フロントエンドのエディタ設定 / 入力バリデーション設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造、CRUD操作、権限制御は明確に実装されている
- 1: 中リスク - 配信先ロジックの詳細確認が必要（運用上の問題になりうる）

## 6) レビュアーチェックリスト（最小）
- [ ] sys_noticeテーブルの実際のDDLを確認し、カラム定義が設計書と一致するか検証
- [ ] フロントエンド（Thymeleaf/HTML）で公告の表示ロジックを確認
- [ ] MyBatis XMLマッピングファイル（SysNoticeMapper.xml）のSQL定義を確認
- [ ] 公告の表示条件（status=0のみ表示）がフロントエンドでも適用されているか確認
