---
generated_at: 2026-01-08 11:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-権限エラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/exception/GlobalExceptionHandler.java` (行1-150)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @RestControllerAdviceで例外ハンドラー定義 | E-01 (行28: `@RestControllerAdvice`) | ○ |
| C-02 | @ExceptionHandler(AuthorizationException.class)で認可例外ハンドリング | E-01 (行36: `@ExceptionHandler(AuthorizationException.class)`) | ○ |
| C-03 | handleAuthorizationException()で処理 | E-01 (行37: `public Object handleAuthorizationException(AuthorizationException e, HttpServletRequest request)`) | ○ |
| C-04 | リクエストURIをログ出力 | E-01 (行39-40: `String requestURI = request.getRequestURI(); log.error("请求地址'{}',权限校验失败'{}'", requestURI, e.getMessage())`) | ○ |
| C-05 | ServletUtils.isAjaxRequest()でリクエスト種別判定 | E-01 (行41: `if (ServletUtils.isAjaxRequest(request))`) | ○ |
| C-06 | Ajaxリクエスト時はAjaxResult.error()返却 | E-01 (行43: `return AjaxResult.error(PermissionUtils.getMsg(e.getMessage()))`) | ○ |
| C-07 | PermissionUtils.getMsg()でメッセージ生成 | E-01 (行43: `PermissionUtils.getMsg(e.getMessage())`) | ○ |
| C-08 | 通常リクエスト時はModelAndView返却 | E-01 (行47: `return new ModelAndView("error/unauth")`) | ○ |
| C-09 | エラーページはerror/unauth | E-01 (行47: `"error/unauth"`) | ○ |
| C-10 | メソッド戻り値はObject型 | E-01 (行37: `public Object handleAuthorizationException`) | ○ |
| C-11 | RuntimeExceptionもハンドリング | E-01 (行66-72: `@ExceptionHandler(RuntimeException.class)`) | ○ |
| C-12 | Exceptionもハンドリング | E-01 (行77-83: `@ExceptionHandler(Exception.class)`) | ○ |
| C-13 | ServiceExceptionもハンドリング | E-01 (行88-100: `@ExceptionHandler(ServiceException.class)`) | ○ |
| C-14 | DemoModeExceptionもハンドリング | E-01 (行144-148: `@ExceptionHandler(DemoModeException.class)`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認できた
- 0: 低リスク - 例外ハンドリングは標準的なSpringパターン

## 6) レビュアーチェックリスト（最小）
- [ ] PermissionUtils.getMsg()の実装を確認
- [ ] error/unauth.htmlテンプレートの内容を確認
- [ ] ServletUtils.isAjaxRequest()の判定ロジックを確認
- [ ] 他の例外ハンドラー（ServiceException, DemoModeException等）との整合性を確認
