---
generated_at: 2026-01-08 15:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：11-業務例外通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-common/src/main/java/com/ruoyi/common/exception/ServiceException.java` - 業務例外クラス定義
- E-02: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/exception/GlobalExceptionHandler.java` - 全体例外ハンドラー
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/AjaxResult.java` - Ajaxレスポンス構造体
- E-04: `ruoyi-admin/src/main/resources/templates/error/service.html` - エラー表示ページ
- E-05: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysUserServiceImpl.java` - ユーザーサービス
- E-06: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDictTypeServiceImpl.java` - 辞書タイプサービス
- E-07: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysRoleServiceImpl.java` - ロールサービス
- E-08: `ruoyi-system/src/main/java/com/ruoyi/system/service/impl/SysDeptServiceImpl.java` - 部門サービス
- E-09: `ruoyi-generator/src/main/java/com/ruoyi/generator/service/impl/GenTableServiceImpl.java` - コード生成サービス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ServiceExceptionはRuntimeExceptionを継承 | E-01 L8 `public final class ServiceException extends RuntimeException` | ○ |
| C-02 | messageとdetailMessageフィールドを持つ | E-01 L15,L22 | ○ |
| C-03 | GlobalExceptionHandlerでServiceExceptionをハンドリング | E-02 L88 `@ExceptionHandler(ServiceException.class)` | ○ |
| C-04 | Ajaxリクエスト判定によりレスポンス形式を切り替え | E-02 L92 `if (ServletUtils.isAjaxRequest(request))` | ○ |
| C-05 | Ajax時はAjaxResult.error()でJSONレスポンス | E-02 L94 `return AjaxResult.error(e.getMessage())` | ○ |
| C-06 | 通常リクエスト時はerror/serviceへ遷移 | E-02 L98 `return new ModelAndView("error/service", "errorMessage", e.getMessage())` | ○ |
| C-07 | AjaxResult.Type.ERRORは500 | E-03 L35 `ERROR(500)` | ○ |
| C-08 | service.htmlでerrorMessage変数を表示 | E-04 L16 `[[${errorMessage}]]` | ○ |
| C-09 | ユーザー削除時に超級管理者チェックで例外発生 | E-05 L446 `throw new ServiceException("不允许操作超级管理员用户")` | ○ |
| C-10 | ユーザーデータ権限チェックで例外発生 | E-05 L465 `throw new ServiceException("没有权限访问用户数据！")` | ○ |
| C-11 | ユーザーインポート時に空データで例外発生 | E-05 L517 `throw new ServiceException("导入用户数据不能为空！")` | ○ |
| C-12 | 辞書タイプ削除時に使用中チェックで例外発生 | E-06 L131 `throw new ServiceException(String.format("%1$s已分配,不能删除", dictType.getDictName()))` | ○ |
| C-13 | ロール削除時にユーザー割当チェックで例外発生 | E-07 L165 | ○ |
| C-14 | ロール操作時に超級管理者ロールチェックで例外発生 | E-07 L319 `throw new ServiceException("不允许操作超级管理员角色")` | ○ |
| C-15 | 部門新規登録時に親部門停止チェックで例外発生 | E-08 L199 `throw new ServiceException("部门停用，不允许新增")` | ○ |
| C-16 | コード生成インポート失敗時に例外発生 | E-09 L197 `throw new ServiceException("导入失败：" + e.getMessage())` | ○ |
| C-17 | コード生成プレビュー失敗時に例外発生 | E-09 L286 `throw new ServiceException("渲染模板失败，表名：" + table.getTableName())` | ○ |
| C-18 | コード生成同期時に原テーブル不存在で例外発生 | E-09 L308 `throw new ServiceException("同步数据失败，原表结构不存在")` | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠が不足している項目はありません
- すべての主張がソースコードにより確認されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 例外処理機構は標準的なSpring Boot実装に従っている
- 0: 低リスク - エラーメッセージはハードコードされているが、ビジネスロジックとして適切

## 6) レビュアーチェックリスト（最小）
- [ ] ServiceExceptionのdetailMessageがログに出力されるか確認
- [ ] error/service.htmlのスタイリングが他のエラーページと一貫しているか確認
- [ ] 中国語エラーメッセージの国際化対応が必要か検討
