---
generated_at: 2026-01-08 15:32:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-システム例外通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/exception/GlobalExceptionHandler.java` - 全体例外ハンドラー（全149行）
- E-02: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/AjaxResult.java` - Ajaxレスポンス構造体
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/core/text/Convert.java` - 型変換ユーティリティ
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/utils/html/EscapeUtil.java` - HTMLエスケープユーティリティ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RuntimeExceptionハンドラーが存在 | E-01 L66 `@ExceptionHandler(RuntimeException.class)` | ○ |
| C-02 | Exceptionハンドラーが存在 | E-01 L77 `@ExceptionHandler(Exception.class)` | ○ |
| C-03 | RuntimeException時に「発生未知异常」をログ出力 | E-01 L70 `log.error("请求地址'{}',发生未知异常.", requestURI, e)` | ○ |
| C-04 | Exception時に「発生系统异常」をログ出力 | E-01 L81 `log.error("请求地址'{}',发生系统异常.", requestURI, e)` | ○ |
| C-05 | スタックトレースがログに記録される | E-01 L70,L81 log.errorの第3引数に例外オブジェクト | ○ |
| C-06 | HTTPメソッド不サポートハンドラーが存在 | E-01 L54 `@ExceptionHandler(HttpRequestMethodNotSupportedException.class)` | ○ |
| C-07 | パス変数不足ハンドラーが存在 | E-01 L105 `@ExceptionHandler(MissingPathVariableException.class)` | ○ |
| C-08 | パラメータ型不一致ハンドラーが存在 | E-01 L116 `@ExceptionHandler(MethodArgumentTypeMismatchException.class)` | ○ |
| C-09 | バインドエラーハンドラーが存在 | E-01 L133 `@ExceptionHandler(BindException.class)` | ○ |
| C-10 | AjaxResult.error()でエラーレスポンス生成 | E-01 L71,L82 `return AjaxResult.error(e.getMessage())` | ○ |
| C-11 | AjaxResult.Type.ERRORは500 | E-02 L35 `ERROR(500)` | ○ |
| C-12 | パス変数不足時に変数名を含むメッセージ | E-01 L110 `String.format("请求路径中缺少必需的路径变量[%s]", e.getVariableName())` | ○ |
| C-13 | パラメータ型不一致時に期待型と入力値を含むメッセージ | E-01 L127 `String.format("请求参数类型不匹配，参数[%s]要求类型为：'%s'，但输入值为：'%s'"...)` | ○ |
| C-14 | パラメータ値をEscapeUtil.clean()でサニタイズ | E-01 L124 `value = EscapeUtil.clean(value)` | ○ |
| C-15 | @RestControllerAdviceによる全コントローラ適用 | E-01 L28 `@RestControllerAdvice` | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠が不足している項目はありません
- すべての主張がソースコードにより確認されています

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Exception.getMessage()がそのままクライアントに返却されるため、データベースエラー等でセンシティブ情報が漏洩する可能性あり
- 0: 低リスク - XSS対策としてEscapeUtil.clean()が実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] プロダクション環境でException.getMessage()の内容を汎用メッセージに置換するか検討
- [ ] データベース接続エラー等でSQL文やテーブル名が漏洩しないか確認
- [ ] ログ出力レベルとローテーション設定が適切か確認
- [ ] 例外ハンドラーの優先順位が意図通りか確認（具体的→一般的）
