---
generated_at: 2026-01-08 15:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：13-デモモード通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **DemoModeExceptionのスロー箇所**：コード内でDemoModeExceptionをスローする具体的な実装箇所が確認できない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-common/src/main/java/com/ruoyi/common/exception/DemoModeException.java` - デモモード例外クラス定義（15行）
- E-02: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/exception/GlobalExceptionHandler.java` - 全体例外ハンドラー
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/config/RuoYiConfig.java` - グローバル設定クラス
- E-04: `ruoyi-admin/src/main/resources/application.yml` - アプリケーション設定
- E-05: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysIndexController.java` - インデックスコントローラ
- E-06: `ruoyi-admin/src/main/resources/templates/index.html` - サイドナビ型インデックスページ
- E-07: `ruoyi-admin/src/main/resources/templates/index-topnav.html` - トップナビ型インデックスページ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DemoModeExceptionはRuntimeExceptionを継承 | E-01 L8 `public class DemoModeException extends RuntimeException` | ○ |
| C-02 | DemoModeExceptionは空のコンストラクタのみ持つ | E-01 L12-14 `public DemoModeException() {}` | ○ |
| C-03 | GlobalExceptionHandlerでDemoModeExceptionをハンドリング | E-02 L144 `@ExceptionHandler(DemoModeException.class)` | ○ |
| C-04 | 固定メッセージ「演示模式，不允许操作」を返却 | E-02 L147 `return AjaxResult.error("演示模式，不允许操作")` | ○ |
| C-05 | RuoYiConfigにdemoEnabledフィールドが存在 | E-03 L25 `private static boolean demoEnabled` | ○ |
| C-06 | isDemoEnabled()メソッドで設定値を取得 | E-03 L63-66 `public static boolean isDemoEnabled()` | ○ |
| C-07 | application.ymlでruoyi.demoEnabled設定が可能 | E-04 L10 `demoEnabled: true` | ○ |
| C-08 | SysIndexControllerでdemoEnabled値をテンプレートに渡す | E-05 L65 `mmap.put("demoEnabled", RuoYiConfig.isDemoEnabled())` | ○ |
| C-09 | index.htmlでdemoEnabled時に「実例演示」メニュー表示 | E-06 L74 `<li th:if="${demoEnabled}">` | ○ |
| C-10 | index-topnav.htmlでdemoEnabled時にメニュー表示 | E-07 L93,L243 `th:if="${demoEnabled}"` | ○ |
| C-11 | demoEnabled=trueがデフォルト設定 | E-04 L10 `demoEnabled: true` | ○ |
| C-12 | DemoModeExceptionにカスタムメッセージ設定機能なし | E-01 全体 - コンストラクタはパラメータを受け取らない | ○ |
| C-13 | @ConfigurationPropertiesでapplication.ymlから読み込み | E-03 L12 `@ConfigurationProperties(prefix = "ruoyi")` | ○ |
| C-14 | データ変更操作時にDemoModeExceptionがスローされる | **根拠なし** - コード内でthrow new DemoModeException()の実装箇所が確認できない | △ |

## 4) 不足情報（Unknown / Missing）
- DemoModeExceptionをスローする具体的な実装箇所がソースコード内で確認できない
  - 候補：AOPによるインターセプト / フィルターでの実装 / カスタム実装が必要
  - 備考：DemoModeExceptionクラスとハンドラーは存在するが、現状のコードベースでは例外をスローする箇所が未実装の可能性がある。または別の方法（フロントエンド制御等）でデモモード制限を行っている可能性がある。

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - DemoModeExceptionのスロー実装が確認できないため、デモモード制限が期待通りに機能するか確認が必要
- 0: 低リスク - 例外ハンドラー自体は正しく実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] DemoModeExceptionをスローする実装が存在するか確認
- [ ] AOPやフィルターによるデモモード制限が実装されているか確認
- [ ] demoEnabled=true時にデータ変更操作が実際に制限されるかテスト
- [ ] フロントエンドでの制御と併用されているか確認
