---
generated_at: 2026-01-08 15:38:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-国際化メッセージ通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-common/src/main/java/com/ruoyi/common/utils/MessageUtils.java` - 国際化メッセージ取得ユーティリティ（26行）
- E-02: `ruoyi-framework/src/main/java/com/ruoyi/framework/config/I18nConfig.java` - i18n設定クラス（43行）
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/utils/spring/SpringUtils.java` - Spring Bean取得ユーティリティ
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/exception/base/BaseException.java` - 国際化対応基底例外クラス（97行）
- E-05: `ruoyi-common/src/main/java/com/ruoyi/common/constant/Constants.java` - 定数定義（DEFAULT_LOCALE）
- E-06: `ruoyi-admin/src/main/resources/static/i18n/messages.properties` - 国際化メッセージ定義（38行）
- E-07: `ruoyi-admin/src/main/resources/application.yml` - spring.messages.basename設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MessageUtils.message()メソッドが存在 | E-01 L21 `public static String message(String code, Object... args)` | ○ |
| C-02 | SpringUtils.getBean()でMessageSourceを取得 | E-01 L23 `MessageSource messageSource = SpringUtils.getBean(MessageSource.class)` | ○ |
| C-03 | LocaleContextHolder.getLocale()でロケール取得 | E-01 L24 `LocaleContextHolder.getLocale()` | ○ |
| C-04 | messageSource.getMessage()で国際化メッセージ取得 | E-01 L24 `messageSource.getMessage(code, args, LocaleContextHolder.getLocale())` | ○ |
| C-05 | I18nConfigでSessionLocaleResolverを使用 | E-02 L23 `SessionLocaleResolver slr = new SessionLocaleResolver()` | ○ |
| C-06 | デフォルトロケールはConstants.DEFAULT_LOCALE | E-02 L25 `slr.setDefaultLocale(Constants.DEFAULT_LOCALE)` | ○ |
| C-07 | ロケール変更パラメータは「lang」 | E-02 L34 `lci.setParamName("lang")` | ○ |
| C-08 | LocaleChangeInterceptorがインターセプターに登録 | E-02 L41 `registry.addInterceptor(localeChangeInterceptor())` | ○ |
| C-09 | DEFAULT_LOCALEはLocale.SIMPLIFIED_CHINESE | E-05 L25 `public static final Locale DEFAULT_LOCALE = Locale.SIMPLIFIED_CHINESE` | ○ |
| C-10 | BaseException.getMessage()でMessageUtils.message()を呼び出し | E-04 L69 `message = MessageUtils.message(code, args)` | ○ |
| C-11 | コードが空の場合はdefaultMessageを使用 | E-04 L71-74 `if (message == null) { message = defaultMessage; }` | ○ |
| C-12 | messages.propertiesにuser.jcaptcha.error定義 | E-06 L3 `user.jcaptcha.error=验证码错误` | ○ |
| C-13 | messages.propertiesにuser.password.retry.limit.count定義 | E-06 L6 `user.password.retry.limit.count=密码输入错误{0}次` | ○ |
| C-14 | messages.propertiesにno.permission定義 | E-06 L32 `no.permission=您没有数据的权限，请联系管理员添加权限 [{0}]` | ○ |
| C-15 | messages.propertiesにupload.exceed.maxSize定義 | E-06 L28 `upload.exceed.maxSize=上传的文件大小超出限制的文件大小！...{0}MB` | ○ |
| C-16 | spring.messages.basenameで設定ファイルパス指定 | E-07 L57 `basename: static/i18n/messages` | ○ |
| C-17 | プレースホルダー記法{0}、{1}等が使用可能 | E-06 L6,L7,L28,L32-37 複数のメッセージで{0}使用 | ○ |
| C-18 | SpringUtilsでBeanFactoryからBean取得 | E-03 L49 `return (T) beanFactory.getBean(name)` L62 `return (T) beanFactory.getBean(clz)` | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠が不足している項目はありません
- すべての主張がソースコードおよび設定ファイルにより確認されています
- 備考：追加の言語ファイル（messages_en.properties等）は確認されていないが、Springの国際化機構により追加可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 標準的なSpring i18n実装に従っている
- 0: 低リスク - デフォルトロケールが明確に定義されている
- 1: 中リスク - 現状は中国語のみのメッセージ定義であり、多言語対応は追加作業が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 追加言語対応が必要な場合、messages_en.properties等を作成
- [ ] プレースホルダーに挿入される値がサニタイズされているか確認
- [ ] ロケール切り替え機能（langパラメータ）がセキュリティ的に問題ないか確認
- [ ] messages.propertiesの文字エンコーディングがUTF-8であるか確認
