---
generated_at: 2026-01-08 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：2-セッションキックアウト通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **maxSession/kickoutUrl/kickoutAfterの設定箇所**：設定クラスでの初期化方法を要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/filter/kickout/KickoutSessionFilter.java` (行1-176)
- E-02: `ruoyi-common/src/main/java/com/ruoyi/common/constant/ShiroConstants.java` (SYS_USERCACHE定義)
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/core/domain/AjaxResult.java` (エラーレスポンス構造)
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/utils/ServletUtils.java` (Ajaxリクエスト判定)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | maxSessionでセッション最大数を制御 | E-01 (行38: `private int maxSession = -1`) | ○ |
| C-02 | maxSession=-1で制限なし | E-01 (行64-68: `if (!subject.isAuthenticated() ... || maxSession == -1)`) | ○ |
| C-03 | kickoutAfterでキックアウト対象を制御 | E-01 (行42-43: `private Boolean kickoutAfter = false`) | ○ |
| C-04 | kickoutAfter=falseで古いセッションをキックアウト | E-01 (行98: `kickoutAfter ? deque.removeFirst() : deque.removeLast()`) | ○ |
| C-05 | セッションIDはDeque構造でキャッシュ管理 | E-01 (行51: `Cache<String, Deque<Serializable>> cache`, 行82) | ○ |
| C-06 | キャッシュ名はsys-usercache | E-01 (行174: `cacheManager.getCache(ShiroConstants.SYS_USERCACHE)`) | ○ |
| C-07 | kickout属性をセッションに設定 | E-01 (行109: `kickoutSession.setAttribute("kickout", true)`) | ○ |
| C-08 | kickout=trueでログアウト実行 | E-01 (行119-122: `if (session.getAttribute("kickout") ... subject.logout()`) | ○ |
| C-09 | Ajaxリクエスト時はJSONエラー返却 | E-01 (行138-141: `if (ServletUtils.isAjaxRequest(req))`) | ○ |
| C-10 | エラーメッセージは「您已在别处登录，请您修改密码或重新登录」 | E-01 (行140: `AjaxResult.error("您已在别处登录，请您修改密码或重新登录")`) | ○ |
| C-11 | 通常リクエストはkickoutUrlへリダイレクト | E-01 (行145: `WebUtils.issueRedirect(request, response, kickoutUrl)`) | ○ |
| C-12 | isAccessAllowedは常にfalseを返す | E-01 (行54-57: `return false`) | ○ |
| C-13 | onAccessDeniedでメイン処理実行 | E-01 (行61-132: `protected boolean onAccessDenied`) | ○ |
| C-14 | 認証されていないユーザーは処理スキップ | E-01 (行64: `if (!subject.isAuthenticated() && !subject.isRemembered()`) | ○ |
| C-15 | ログイン名でキャッシュキーを管理 | E-01 (行74: `String loginName = user.getLoginName()`) | ○ |
| C-16 | 既存セッションがDequeになければ追加 | E-01 (行86-92: `if (!deque.contains(sessionId) ...`) | ○ |
| C-17 | セッション数がmaxSession超過でキックアウト開始 | E-01 (行95: `while (deque.size() > maxSession)`) | ○ |
| C-18 | AccessControlFilterを継承 | E-01 (行31: `extends AccessControlFilter`) | ○ |
| C-19 | ObjectMapperでJSON変換 | E-01 (行33: `ObjectMapper objectMapper`, 行141) | ○ |
| C-20 | セッション取得例外は無視 | E-01 (行112-115: `catch (Exception e) { }`) | ○ |
| C-21 | saveRequestでリクエスト保存 | E-01 (行123: `saveRequest(request)`) | ○ |
| C-22 | ShiroConfig.javaでフィルター設定 | **根拠なし**（設定クラスの詳細未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- **C-22について**：KickoutSessionFilterのBean登録とフィルターチェーン設定の詳細を確認する必要がある
  - 候補：ShiroConfig.java / application.yml / shiro設定ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - キックアウトロジックは明確に実装されている
- 0: 低リスク - エラーメッセージも固定文字列で確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ShiroConfig.javaでKickoutSessionFilterのBean定義とフィルターチェーン設定を確認
- [ ] ehcache-shiro.xmlでsys-usercacheの設定（TTL、最大サイズ等）を確認
- [ ] kickoutUrlの設定値がログイン画面を指しているか確認
- [ ] maxSessionのデフォルト値が運用要件に合致しているか確認
