---
generated_at: 2026-01-08 10:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-ログイン成功通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysLoginService.java` (行1-185)
- E-02: `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/factory/AsyncFactory.java` (行1-137)
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysLogininfor.java` (行1-159)
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/constant/Constants.java` (行1-122)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ログイン成功時にAsyncManager経由で非同期ログ記録 | E-01 (行127: `AsyncManager.me().execute(AsyncFactory.recordLogininfor(username, Constants.LOGIN_SUCCESS, ...))`) | ○ |
| C-02 | Constants.LOGIN_SUCCESSは"Success" | E-04 (行50: `public static final String LOGIN_SUCCESS = "Success"`) | ○ |
| C-03 | メッセージはuser.login.successキーで取得 | E-01 (行127: `MessageUtils.message("user.login.success")`) | ○ |
| C-04 | recordLogininforでTimerTaskを生成 | E-02 (行92-135: `public static TimerTask recordLogininfor`) | ○ |
| C-05 | User-Agentヘッダーからブラウザ情報取得 | E-02 (行94: `ServletUtils.getRequest().getHeader("User-Agent")`, 行113) | ○ |
| C-06 | ShiroUtils.getIp()でIPアドレス取得 | E-02 (行95: `final String ip = ShiroUtils.getIp()`) | ○ |
| C-07 | AddressUtils.getRealAddressByIPで地点取得 | E-02 (行101: `AddressUtils.getRealAddressByIP(ip)`) | ○ |
| C-08 | UserAgentUtils.getOperatingSystemでOS取得 | E-02 (行111: `UserAgentUtils.getOperatingSystem(userAgent)`) | ○ |
| C-09 | UserAgentUtils.getBrowserでブラウザ取得 | E-02 (行113: `UserAgentUtils.getBrowser(userAgent)`) | ○ |
| C-10 | SysLogininforオブジェクトを生成 | E-02 (行115: `SysLogininfor logininfor = new SysLogininfor()`) | ○ |
| C-11 | loginNameをセット | E-02 (行116: `logininfor.setLoginName(username)`) | ○ |
| C-12 | ipaddrをセット | E-02 (行117: `logininfor.setIpaddr(ip)`) | ○ |
| C-13 | loginLocationをセット | E-02 (行118: `logininfor.setLoginLocation(address)`) | ○ |
| C-14 | browserをセット | E-02 (行119: `logininfor.setBrowser(browser)`) | ○ |
| C-15 | osをセット | E-02 (行120: `logininfor.setOs(os)`) | ○ |
| C-16 | msgをセット | E-02 (行121: `logininfor.setMsg(message)`) | ○ |
| C-17 | LOGIN_SUCCESS時はstatus=SUCCESS(0)をセット | E-02 (行123-125: `if (StringUtils.equalsAny(status, Constants.LOGIN_SUCCESS, ...) { logininfor.setStatus(Constants.SUCCESS) }`) | ○ |
| C-18 | Constants.SUCCESSは"0" | E-04 (行40: `public static final String SUCCESS = "0"`) | ○ |
| C-19 | SysLogininforServiceImplでDB登録 | E-02 (行132: `SpringUtils.getBean(SysLogininforServiceImpl.class).insertLogininfor(logininfor)`) | ○ |
| C-20 | SysLogininforにinfoIdフィールドあり | E-03 (行21-22: `private Long infoId`) | ○ |
| C-21 | SysLogininforにloginNameフィールドあり | E-03 (行25: `private String loginName`) | ○ |
| C-22 | SysLogininforにstatusフィールドあり（0成功、1失敗） | E-03 (行28-29: `@Excel(name = "登录状态", readConverterExp = "0=成功,1=失败")`) | ○ |
| C-23 | SysLogininforにloginTimeフィールドあり | E-03 (行52-53: `private Date loginTime`) | ○ |
| C-24 | ログファイルにも出力される | E-02 (行109: `sys_user_logger.info(s.toString(), args)`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認できた
- 0: 低リスク - ログ記録処理は標準的な実装

## 6) レビュアーチェックリスト（最小）
- [ ] sys_logininforテーブルのDDLを確認し、カラム定義が設計書と一致するか検証
- [ ] MyBatis XMLマッピングファイル（SysLogininforMapper.xml）のINSERT文を確認
- [ ] AsyncManagerのスレッドプール設定を確認（同時実行数、キューサイズ等）
- [ ] IP逆引きサービス（AddressUtils）の外部依存先を確認
