---
generated_at: 2026-01-08 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-ログイン失敗通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysLoginService.java` (行1-185)
- E-02: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java` (行1-86)
- E-03: `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/factory/AsyncFactory.java` (行1-137)
- E-04: `ruoyi-common/src/main/java/com/ruoyi/common/constant/Constants.java` (行1-122)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | キャプチャエラー時にログ記録 | E-01 (行59: `AsyncFactory.recordLogininfor(username, Constants.LOGIN_FAIL, MessageUtils.message("user.jcaptcha.error"))`) | ○ |
| C-02 | ユーザー名/パスワード空時にログ記録 | E-01 (行65: `AsyncFactory.recordLogininfor(username, Constants.LOGIN_FAIL, MessageUtils.message("not.null"))`) | ○ |
| C-03 | パスワード長エラー時にログ記録 | E-01 (行72: `AsyncFactory.recordLogininfor(username, Constants.LOGIN_FAIL, MessageUtils.message("user.password.not.match"))`) | ○ |
| C-04 | パスワード長は5-20文字 | E-01 (行69-70: `password.length() < UserConstants.PASSWORD_MIN_LENGTH || password.length() > UserConstants.PASSWORD_MAX_LENGTH`) | ○ |
| C-05 | ユーザー名長エラー時にログ記録 | E-01 (行80: `AsyncFactory.recordLogininfor(username, Constants.LOGIN_FAIL, MessageUtils.message("user.password.not.match"))`) | ○ |
| C-06 | ユーザー名長は2-20文字 | E-01 (行77-78: `username.length() < UserConstants.USERNAME_MIN_LENGTH || username.length() > UserConstants.USERNAME_MAX_LENGTH`) | ○ |
| C-07 | IPブラックリスト該当時にログ記録 | E-01 (行88: `AsyncFactory.recordLogininfor(username, Constants.LOGIN_FAIL, MessageUtils.message("login.blocked"))`) | ○ |
| C-08 | IPブラックリストはsys.login.blackIPListで設定 | E-01 (行85: `configService.selectConfigByKey("sys.login.blackIPList")`) | ○ |
| C-09 | ユーザー不存在時にログ記録 | E-01 (行109: `AsyncFactory.recordLogininfor(username, Constants.LOGIN_FAIL, MessageUtils.message("user.not.exists"))`) | ○ |
| C-10 | ユーザー削除済み時にログ記録 | E-01 (行115: `AsyncFactory.recordLogininfor(username, Constants.LOGIN_FAIL, MessageUtils.message("user.password.delete"))`) | ○ |
| C-11 | アカウント停止時にログ記録 | E-01 (行121: `AsyncFactory.recordLogininfor(username, Constants.LOGIN_FAIL, MessageUtils.message("user.blocked"))`) | ○ |
| C-12 | パスワード不一致時にログ記録 | E-02 (行61: `AsyncFactory.recordLogininfor(loginName, Constants.LOGIN_FAIL, MessageUtils.message("user.password.retry.limit.count", retryCount))`) | ○ |
| C-13 | Constants.LOGIN_FAILは"Error" | E-04 (行65: `public static final String LOGIN_FAIL = "Error"`) | ○ |
| C-14 | Constants.FAILは"1" | E-04 (行45: `public static final String FAIL = "1"`) | ○ |
| C-15 | LOGIN_FAIL時はstatus=FAILをセット | E-03 (行127-129: `else if (Constants.LOGIN_FAIL.equals(status)) { logininfor.setStatus(Constants.FAIL) }`) | ○ |
| C-16 | CaptchaException例外をスロー | E-01 (行60: `throw new CaptchaException()`) | ○ |
| C-17 | UserNotExistsException例外をスロー | E-01 (行66, 110: `throw new UserNotExistsException()`) | ○ |
| C-18 | UserPasswordNotMatchException例外をスロー | E-01 (行73, 81: `throw new UserPasswordNotMatchException()`) | ○ |
| C-19 | BlackListException例外をスロー | E-01 (行89: `throw new BlackListException()`) | ○ |
| C-20 | UserDeleteException例外をスロー | E-01 (行116: `throw new UserDeleteException()`) | ○ |
| C-21 | UserBlockedException例外をスロー | E-01 (行122: `throw new UserBlockedException()`) | ○ |
| C-22 | パスワード検証はSysPasswordService.validateで実行 | E-01 (行125: `passwordService.validate(user, password)`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認できた
- 0: 低リスク - 各種失敗パターンの記録処理は網羅的に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 各失敗メッセージキー（user.jcaptcha.error等）がi18nプロパティファイルに存在するか確認
- [ ] UserConstants.PASSWORD_MIN_LENGTH/MAX_LENGTHの値を確認（5-20であるか）
- [ ] UserConstants.USERNAME_MIN_LENGTH/MAX_LENGTHの値を確認（2-20であるか）
- [ ] 失敗ログの監視・アラート設定が運用要件を満たしているか確認
