---
generated_at: 2026-01-08 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-パスワードリトライ制限超過通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java` (行1-86)
- E-02: `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/factory/AsyncFactory.java` (行1-137)
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/exception/user/UserPasswordRetryLimitExceedException.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | maxRetryCountはapplication.ymlから読み込み | E-01 (行33-34: `@Value("${user.password.maxRetryCount}") private String maxRetryCount`) | ○ |
| C-02 | キャッシュ名はLOGIN_RECORD_CACHE | E-01 (行39: `cacheManager.getCache(ShiroConstants.LOGIN_RECORD_CACHE)`) | ○ |
| C-03 | キャッシュの型はCache<String, AtomicInteger> | E-01 (行31: `private Cache<String, AtomicInteger> loginRecordCache`) | ○ |
| C-04 | validate()でリトライカウントを取得 | E-01 (行46: `AtomicInteger retryCount = loginRecordCache.get(loginName)`) | ○ |
| C-05 | retryCountがnullの場合は0で初期化 | E-01 (行48-52: `if (retryCount == null) { retryCount = new AtomicInteger(0); loginRecordCache.put(loginName, retryCount) }`) | ○ |
| C-06 | incrementAndGet()でカウントインクリメント | E-01 (行53: `retryCount.incrementAndGet()`) | ○ |
| C-07 | maxRetryCount超過でログ記録 | E-01 (行53-55: `if (retryCount.incrementAndGet() > Integer.valueOf(maxRetryCount).intValue()) { AsyncManager.me().execute(AsyncFactory.recordLogininfor(...)) }`) | ○ |
| C-08 | メッセージキーはuser.password.retry.limit.exceed | E-01 (行55: `MessageUtils.message("user.password.retry.limit.exceed", maxRetryCount)`) | ○ |
| C-09 | UserPasswordRetryLimitExceedExceptionをスロー | E-01 (行56: `throw new UserPasswordRetryLimitExceedException(Integer.valueOf(maxRetryCount).intValue())`) | ○ |
| C-10 | パスワード不一致時はカウントを更新 | E-01 (行62: `loginRecordCache.put(loginName, retryCount)`) | ○ |
| C-11 | パスワード不一致時はUserPasswordNotMatchExceptionをスロー | E-01 (行63: `throw new UserPasswordNotMatchException()`) | ○ |
| C-12 | パスワード一致時はカウントをクリア | E-01 (行67: `clearLoginRecordCache(loginName)`) | ○ |
| C-13 | clearLoginRecordCacheでキャッシュから削除 | E-01 (行76-79: `public void clearLoginRecordCache(String loginName) { loginRecordCache.remove(loginName) }`) | ○ |
| C-14 | matches()でパスワード照合 | E-01 (行59, 71-74: `if (!matches(user, password))`) | ○ |
| C-15 | encryptPassword()でMD5ハッシュ化 | E-01 (行81-84: `return new Md5Hash(loginName + password + salt).toHex()`) | ○ |
| C-16 | パスワード不一致時もログ記録 | E-01 (行61: `AsyncFactory.recordLogininfor(loginName, Constants.LOGIN_FAIL, MessageUtils.message("user.password.retry.limit.count", retryCount))`) | ○ |
| C-17 | @PostConstructでキャッシュ初期化 | E-01 (行36-40: `@PostConstruct public void init()`) | ○ |
| C-18 | CacheManagerをDI | E-01 (行28-29: `@Autowired private CacheManager cacheManager`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認できた
- 0: 低リスク - リトライ制限ロジックは明確に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] application.ymlでuser.password.maxRetryCountの設定値を確認
- [ ] ehcache-shiro.xmlでloginRecordCacheのTTL設定を確認（ロック時間に相当）
- [ ] メッセージキーuser.password.retry.limit.exceedがi18nプロパティに存在するか確認
- [ ] UserPasswordRetryLimitExceedExceptionの例外ハンドリングを確認
