---
generated_at: 2026-01-08 10:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-ログアウト通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/filter/LogoutFilter.java` (行1-91)
- E-02: `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/factory/AsyncFactory.java` (行1-137)
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/constant/Constants.java` (行1-122)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LogoutFilterはShiroのLogoutFilterを継承 | E-01 (行24: `extends org.apache.shiro.web.filter.authc.LogoutFilter`) | ○ |
| C-02 | preHandle()でログアウト処理を実行 | E-01 (行44: `protected boolean preHandle(ServletRequest request, ServletResponse response)`) | ○ |
| C-03 | ShiroUtils.getSysUser()でユーザー情報取得 | E-01 (行52: `SysUser user = ShiroUtils.getSysUser()`) | ○ |
| C-04 | ユーザーがnullでない場合のみログ記録 | E-01 (行53: `if (StringUtils.isNotNull(user))`) | ○ |
| C-05 | ログアウトログ記録にAsyncManager使用 | E-01 (行57: `AsyncManager.me().execute(AsyncFactory.recordLogininfor(loginName, Constants.LOGOUT, MessageUtils.message("user.logout.success")))`) | ○ |
| C-06 | Constants.LOGOUTステータスで記録 | E-01 (行57: `Constants.LOGOUT`), E-03 (行55: `public static final String LOGOUT = "Logout"`) | ○ |
| C-07 | メッセージキーはuser.logout.success | E-01 (行57: `MessageUtils.message("user.logout.success")`) | ○ |
| C-08 | キャッシュクリアにremoveUserCache使用 | E-01 (行59: `SpringUtils.getBean(ISysUserOnlineService.class).removeUserCache(loginName, ShiroUtils.getSessionId())`) | ○ |
| C-09 | subject.logout()でセッション終了 | E-01 (行62: `subject.logout()`) | ○ |
| C-10 | SessionException発生時はエラーログ出力 | E-01 (行64-67: `catch (SessionException ise) { log.error("logout fail.", ise) }`) | ○ |
| C-11 | issueRedirect()でリダイレクト | E-01 (行68: `issueRedirect(request, response, redirectUrl)`) | ○ |
| C-12 | loginUrlでリダイレクト先を設定可能 | E-01 (行31-41: `private String loginUrl`, `getLoginUrl()`, `setLoginUrl()`) | ○ |
| C-13 | getRedirectUrl()でリダイレクト先決定 | E-01 (行81-89: `protected String getRedirectUrl()`) | ○ |
| C-14 | LOGOUTはstatus=SUCCESSとして記録 | E-02 (行123-125: `if (StringUtils.equalsAny(status, Constants.LOGIN_SUCCESS, Constants.LOGOUT, Constants.REGISTER)) { logininfor.setStatus(Constants.SUCCESS) }`) | ○ |
| C-15 | preHandle()は常にfalseを返す | E-01 (行74: `return false`) | ○ |
| C-16 | 例外発生時も処理続行 | E-01 (行69-73: `catch (Exception e) { log.error(...) }`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認できた
- 0: 低リスク - ログアウト処理は標準的なShiroパターンに従っている

## 6) レビュアーチェックリスト（最小）
- [ ] loginUrlの設定値がShiroConfig.javaで正しく設定されているか確認
- [ ] メッセージキーuser.logout.successがi18nプロパティファイルに存在するか確認
- [ ] ISysUserOnlineService.removeUserCache()の実装を確認
- [ ] ログアウト後のセッション無効化が確実に行われているか確認
