---
generated_at: 2026-01-08 11:05:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-操作ログ記録通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-framework/src/main/java/com/ruoyi/framework/aspectj/LogAspect.java` (行1-265)
- E-02: `ruoyi-common/src/main/java/com/ruoyi/common/annotation/Log.java` (行1-51)
- E-03: `ruoyi-system/src/main/java/com/ruoyi/system/domain/SysOperLog.java` (行1-293)
- E-04: `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/factory/AsyncFactory.java` (行1-137)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @Aspectアノテーションでアスペクト定義 | E-01 (行38: `@Aspect`) | ○ |
| C-02 | パスワード関連フィールドは除外 | E-01 (行45: `EXCLUDE_PROPERTIES = { "password", "oldPassword", "newPassword", "confirmPassword" }`) | ○ |
| C-03 | ThreadLocalで開始時刻を保持 | E-01 (行48: `private static final ThreadLocal<Long> TIME_THREADLOCAL`) | ○ |
| C-04 | パラメータ最大長は2000文字 | E-01 (行51: `private static final int PARAM_MAX_LENGTH = 2000`) | ○ |
| C-05 | @Beforeで開始時刻記録 | E-01 (行56-60: `@Before ... TIME_THREADLOCAL.set(System.currentTimeMillis())`) | ○ |
| C-06 | @AfterReturningで正常終了時処理 | E-01 (行67-71: `@AfterReturning`) | ○ |
| C-07 | @AfterThrowingで例外発生時処理 | E-01 (行79-83: `@AfterThrowing`) | ○ |
| C-08 | handleLog()でログ記録メイン処理 | E-01 (行85-137: `protected void handleLog`) | ○ |
| C-09 | SysOperLog生成 | E-01 (行93: `SysOperLog operLog = new SysOperLog()`) | ○ |
| C-10 | 初期ステータスはSUCCESS | E-01 (行94: `operLog.setStatus(BusinessStatus.SUCCESS.ordinal())`) | ○ |
| C-11 | ShiroUtils.getIp()でIP取得 | E-01 (行96: `String ip = ShiroUtils.getIp()`) | ○ |
| C-12 | operUrlは最大255文字 | E-01 (行98: `StringUtils.substring(ServletUtils.getRequest().getRequestURI(), 0, 255)`) | ○ |
| C-13 | 操作者名はgetLoginName()から取得 | E-01 (行101: `operLog.setOperName(currentUser.getLoginName())`) | ○ |
| C-14 | 部門名はgetDept().getDeptName()から取得 | E-01 (行105: `operLog.setDeptName(currentUser.getDept().getDeptName())`) | ○ |
| C-15 | 例外発生時はステータスFAIL | E-01 (行111: `operLog.setStatus(BusinessStatus.FAIL.ordinal())`) | ○ |
| C-16 | エラーメッセージは最大2000文字 | E-01 (行112: `StringUtils.substring(..., 0, 2000)`) | ○ |
| C-17 | メソッド名はクラス名.メソッド名()形式 | E-01 (行117: `operLog.setMethod(className + "." + methodName + "()")`) | ○ |
| C-18 | リクエスト方式を設定 | E-01 (行119: `operLog.setRequestMethod(ServletUtils.getRequest().getMethod())`) | ○ |
| C-19 | 実行時間を計算 | E-01 (行123: `operLog.setCostTime(System.currentTimeMillis() - TIME_THREADLOCAL.get())`) | ○ |
| C-20 | AsyncManager.execute()で非同期記録 | E-01 (行125: `AsyncManager.me().execute(AsyncFactory.recordOper(operLog))`) | ○ |
| C-21 | finallyでThreadLocalクリア | E-01 (行135: `TIME_THREADLOCAL.remove()`) | ○ |
| C-22 | @Log.title()でモジュール名取得 | E-02 (行24: `public String title() default ""`) | ○ |
| C-23 | @Log.businessType()で業務タイプ取得 | E-02 (行29: `public BusinessType businessType() default BusinessType.OTHER`) | ○ |
| C-24 | @Log.operatorType()で操作者種別取得 | E-02 (行34: `public OperatorType operatorType() default OperatorType.MANAGE`) | ○ |
| C-25 | isSaveRequestDataでパラメータ記録制御 | E-02 (行39: `public boolean isSaveRequestData() default true`) | ○ |
| C-26 | isSaveResponseDataでレスポンス記録制御 | E-02 (行44: `public boolean isSaveResponseData() default true`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認できた
- 0: 低リスク - AOPベースのログ記録は標準的なパターン

## 6) レビュアーチェックリスト（最小）
- [ ] BusinessType列挙型の値と意味の対応を確認
- [ ] OperatorType列挙型の値と意味の対応を確認
- [ ] sys_oper_logテーブルのDDLを確認
- [ ] @Logアノテーションが付与されているControllerメソッドを確認
