---
generated_at: 2026-01-08 11:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-スケジュールジョブ実行結果通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/AbstractQuartzJob.java` (行1-107)
- E-02: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/domain/SysJobLog.java` (行1-156)
- E-03: `ruoyi-common/src/main/java/com/ruoyi/common/constant/Constants.java` (行1-122)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AbstractQuartzJobはJobインターフェースを実装 | E-01 (行23: `implements Job`) | ○ |
| C-02 | ThreadLocalで開始時刻を保持 | E-01 (行30: `private static ThreadLocal<Date> threadLocal`) | ○ |
| C-03 | execute()でテンプレートメソッド実行 | E-01 (行33: `public void execute(JobExecutionContext context)`) | ○ |
| C-04 | JobDataMapからジョブ情報取得 | E-01 (行36: `context.getMergedJobDataMap().get(ScheduleConstants.TASK_PROPERTIES)`) | ○ |
| C-05 | before()で開始時刻記録 | E-01 (行61: `threadLocal.set(new Date())`) | ○ |
| C-06 | doExecute()はサブクラスで実装 | E-01 (行105: `protected abstract void doExecute`) | ○ |
| C-07 | 正常終了時にafter()呼び出し | E-01 (行44: `after(context, sysJob, null)`) | ○ |
| C-08 | 例外発生時にafter()呼び出し | E-01 (行49: `after(context, sysJob, e)`) | ○ |
| C-09 | after()でSysJobLog構築 | E-01 (行75: `final SysJobLog sysJobLog = new SysJobLog()`) | ○ |
| C-10 | ジョブ名を設定 | E-01 (行76: `sysJobLog.setJobName(sysJob.getJobName())`) | ○ |
| C-11 | ジョブグループを設定 | E-01 (行77: `sysJobLog.setJobGroup(sysJob.getJobGroup())`) | ○ |
| C-12 | 呼び出し対象を設定 | E-01 (行78: `sysJobLog.setInvokeTarget(sysJob.getInvokeTarget())`) | ○ |
| C-13 | 開始時刻をThreadLocalから取得 | E-01 (行72, 79: `Date startTime = threadLocal.get(); sysJobLog.setStartTime(startTime)`) | ○ |
| C-14 | 終了時刻を現在日時で設定 | E-01 (行80: `sysJobLog.setEndTime(new Date())`) | ○ |
| C-15 | 実行時間をミリ秒で計算 | E-01 (行81: `long runMs = sysJobLog.getEndTime().getTime() - sysJobLog.getStartTime().getTime()`) | ○ |
| C-16 | ログ情報にジョブ名と実行時間を設定 | E-01 (行82: `sysJobLog.setJobMessage(sysJobLog.getJobName() + " 总共耗时：" + runMs + "毫秒")`) | ○ |
| C-17 | 例外発生時はstatus=FAILを設定 | E-01 (行85: `sysJobLog.setStatus(Constants.FAIL)`) | ○ |
| C-18 | 例外情報は最大2000文字に切り詰め | E-01 (行86: `StringUtils.substring(ExceptionUtil.getExceptionMessage(e), 0, 2000)`) | ○ |
| C-19 | 正常終了時はstatus=SUCCESSを設定 | E-01 (行91: `sysJobLog.setStatus(Constants.SUCCESS)`) | ○ |
| C-20 | ISysJobLogService.addJobLog()でDB登録 | E-01 (行95: `SpringUtils.getBean(ISysJobLogService.class).addJobLog(sysJobLog)`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認できた
- 0: 低リスク - ジョブログ記録はテンプレートメソッドパターンで確実に実行

## 6) レビュアーチェックリスト（最小）
- [ ] sys_job_logテーブルのDDLを確認
- [ ] QuartzJobExecutionとQuartzDisallowConcurrentExecutionの使い分けを確認
- [ ] ScheduleConstants.TASK_PROPERTIESの値を確認
- [ ] ThreadLocalのメモリリーク対策（remove()）を確認
