---
generated_at: 2026-01-08 10:30:00
metrics:
  claims_total: 42
  claims_with_evidence: 38
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：運用マニュアル.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：38 / 42、根拠なし：4
- 優先レビュー（高）
  1. **対応ブラウザの具体的なバージョン情報**：根拠なし（一般的な推奨に基づく）
  2. **パスワードリトライ上限の具体的な回数**：根拠不足（設定値による）
  3. **セッションタイムアウト時間の具体的な値**：根拠不足（設定値による）
  4. **サポート連絡方法の具体的な手順**：根拠なし（組織依存）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-02: `docs/code-to-docs/画面一覧/画面遷移図.md`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面設計書/1-ログイン画面.md`
- E-06: `docs/code-to-docs/画面設計書/4-システム首頁.md`
- E-07: `docs/code-to-docs/画面設計書/47-通知公告管理一覧.md`
- E-08: `docs/code-to-docs/画面設計書/11-ユーザー編集.md`
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv`
- E-10: `docs/code-to-docs/データベース設計書/データベース設計書.md`
- E-11: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysLoginController.java`
- E-12: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysUserController.java`
- E-13: `ruoyi-admin/src/main/java/com/ruoyi/web/controller/system/SysNoticeController.java`
- E-14: `ruoyi-admin/src/main/resources/templates/login.html`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | システム概要：SpringBoot, MyBatis, Shiro, Thymeleaf, Bootstrap ベース | E-05 | ○ |
| C-02 | ログイン画面の入力項目（ユーザー名、パスワード、認証コード、記住我） | E-05 | ○ |
| C-03 | ログイン成功後にシステム首頁へ遷移 | E-02, E-05 | ○ |
| C-04 | 認証コード画像クリックで更新可能 | E-05 | ○ |
| C-05 | Remember Me機能の存在 | E-05 | ○ |
| C-06 | 画面ロック機能（lockscreen） | E-01, E-06 | ○ |
| C-07 | システム首頁の3エリア構成（ヘッダー、サイドバー、コンテンツ） | E-06 | ○ |
| C-08 | タブ形式の複数画面表示機能 | E-06 | ○ |
| C-09 | タブの右クリックコンテキストメニュー | E-06 | ○ |
| C-10 | テーマ切替機能の存在 | E-01, E-06 | ○ |
| C-11 | ユーザー管理機能（登録、編集、削除、パスワードリセット） | E-03, E-04 | ○ |
| C-12 | ユーザー管理一覧の項目（用户名称、登录账号、部门、手机号码、状态、创建时间） | E-08 | ○ |
| C-13 | ユーザー編集画面の入力項目 | E-08 | ○ |
| C-14 | ユーザーロール割当機能 | E-04, E-08 | ○ |
| C-15 | ユーザーデータのExcelインポート/エクスポート機能 | E-03, E-04 | ○ |
| C-16 | 通知公告管理機能（新規、編集、削除、詳細表示） | E-03, E-07 | ○ |
| C-17 | 通知公告の検索条件（公告標題、操作人員、公告類型） | E-07 | ○ |
| C-18 | 通知公告の公告類型（通知、公告） | E-07, E-09 | ○ |
| C-19 | ロール管理機能 | E-03 | ○ |
| C-20 | データ権限設定機能（全部、自定、本部门、本部门及以下、仅本人） | E-04 | ○ |
| C-21 | メニュー管理機能 | E-01, E-03 | ○ |
| C-22 | 部門管理機能（ツリー形式） | E-01, E-02, E-03 | ○ |
| C-23 | 役職（岗位）管理機能 | E-01, E-03 | ○ |
| C-24 | オンラインユーザー監視機能 | E-01, E-03 | ○ |
| C-25 | 強制ログアウト機能 | E-03 | ○ |
| C-26 | 操作ログ機能 | E-01, E-03 | ○ |
| C-27 | ログインログ機能 | E-01, E-03 | ○ |
| C-28 | アカウントロック解除機能 | E-03 | ○ |
| C-29 | サーバー監視機能（CPU、メモリ、JVM、ディスク） | E-01, E-03 | ○ |
| C-30 | キャッシュ監視機能 | E-01, E-03 | ○ |
| C-31 | 辞書タイプ管理機能 | E-01, E-03 | ○ |
| C-32 | 辞書データ管理機能 | E-01, E-03 | ○ |
| C-33 | パラメータ設定機能 | E-01, E-03 | ○ |
| C-34 | 定期タスク管理機能 | E-01, E-03 | ○ |
| C-35 | Cron式生成器機能 | E-01 | ○ |
| C-36 | タスク実行ログ機能 | E-01, E-03 | ○ |
| C-37 | プロフィール管理機能 | E-01, E-03 | ○ |
| C-38 | アバター変更機能 | E-01, E-03 | ○ |
| C-39 | 対応ブラウザ（Chrome、Edge、Safari、Firefox最新版） | **根拠なし** | △ |
| C-40 | パスワード入力失敗でアカウントロック | E-09 | ○ |
| C-41 | セッションタイムアウト動作 | E-05, E-06 | ○ |
| C-42 | サポート連絡方法の記載内容 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **対応ブラウザのバージョン情報**
  - 理由：プロジェクト固有の設定ドキュメントが不在
  - 候補：package.json / browserslistrc / プロジェクトREADME
- **パスワードリトライ上限の具体的回数**
  - 理由：application.yml等の設定ファイル未参照
  - 候補：application.yml / shiro設定 / SysPasswordService.java
- **セッションタイムアウト時間の具体値**
  - 理由：設定ファイル未参照
  - 候補：application.yml / shiro設定
- **サポート連絡方法**
  - 理由：組織固有の情報であり、コードからは取得不可
  - 候補：運用規定書 / 組織内ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: システム機能に関する記載（C-01〜C-38）
  - 画面設計書・機能一覧・画面機能マッピングに基づいており、高い信頼性
- **1（中リスク）**: 対応ブラウザ情報（C-39）
  - 一般的な推奨値を記載しているが、プロジェクト固有の検証結果ではない
- **1（中リスク）**: パスワード・セッション関連の具体的な数値
  - 設定値に依存するため、実環境での確認が必要
- **0（低リスク）**: トラブルシューティング情報
  - エラーメッセージは画面設計書の記載に基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] 対応ブラウザ情報が実際の動作確認結果と一致するか確認
- [ ] パスワードリトライ上限回数が実環境の設定と一致するか確認
- [ ] セッションタイムアウト時間が実環境の設定と一致するか確認
- [ ] サポート連絡方法を組織に合わせて更新
- [ ] 画面キャプチャの追加が必要か検討
- [ ] ユーザー種別の定義が実際の運用と一致するか確認
- [ ] エラーメッセージの日本語訳が適切か確認（原文は中国語）
