# RuoYi後台管理システム 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [ログイン・ログアウト手順](#2-ログインログアウト手順)
3. [トップページ（TOP画面）](#3-トップページtop画面)

**【業務フローに沿った機能】**
4. [【STEP1】通知公告機能（通知の配信・受信）](#4-step1通知公告機能通知の配信受信)
5. [【STEP2-3】ユーザー管理機能（申請の入力・処理）](#5-step2-3ユーザー管理機能申請の入力処理)
6. [【STEP3-4】権限・ロール管理機能（アクセス制御）](#6-step3-4権限ロール管理機能アクセス制御)
7. [【STEP4-5】システム監視・ログ管理機能（監視・完了確認）](#7-step4-5システム監視ログ管理機能監視完了確認)

**【サポート機能】**
8. [辞書・パラメータ管理機能](#8-辞書パラメータ管理機能)
9. [定期タスク管理機能](#9-定期タスク管理機能)
10. [マイページ機能（プロフィール管理）](#10-マイページ機能プロフィール管理)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 RuoYi後台管理システムとは

RuoYi後台管理システムは、企業向けの総合管理プラットフォームです。ユーザー管理、権限管理、組織管理、システム監視などの機能を統合し、効率的な業務運用を支援します。

本システムはSpringBoot、MyBatis、Apache Shiro、Thymeleaf、Bootstrapをベースに構築されており、高いセキュリティと使いやすいインターフェースを提供します。

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **ユーザー管理** | ユーザーの登録・編集・削除、パスワード管理、ロール割当 |
| **権限管理** | ロール設定、メニュー権限管理、データ権限設定 |
| **組織管理** | 部門管理、役職管理、組織階層の設定 |
| **システム設定** | 辞書管理、パラメータ設定、通知公告の管理 |
| **システム監視** | オンラインユーザー監視、操作ログ確認、サーバー監視 |
| **定期タスク** | スケジュールタスクの登録・管理・実行状況の確認 |

### 1.3 業務フロー概要

本システムにおける業務は、以下の流れで進行します：

```
┌─────────────────────────────────────────────────────────────────┐
│                        業務フロー                                │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  【STEP 1】管理者が通知公告を作成・配信                          │
│      ↓                                                          │
│  【STEP 2】管理者がユーザー情報を登録・更新                      │
│      ↓                                                          │
│  【STEP 3】管理者がロール・権限を設定                            │
│      ↓                                                          │
│  【STEP 4】ユーザーがシステムにログインして業務を実行            │
│      ↓                                                          │
│  【STEP 5】管理者が操作ログ・システム状態を監視                  │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **システム管理者** | 通知公告の作成・配信、ユーザー管理、ロール・権限設定、システム監視、定期タスク管理 |
| **一般ユーザー** | 通知の確認、自身のプロフィール管理、割り当てられた機能の利用 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| 通知公告 | 組織内への通知・公告の作成と配信 | STEP 1 |
| ユーザー管理 | ユーザーの登録・編集・削除・パスワード管理 | STEP 2 |
| ロール管理 | ロールの作成・権限設定・ユーザー割当 | STEP 3 |
| メニュー管理 | システムメニュー構造の管理 | STEP 3 |
| 部門管理 | 組織の部門階層の管理 | STEP 2-3 |
| 役職管理 | 役職の登録と管理 | STEP 2-3 |
| 操作ログ | ユーザー操作履歴の確認 | STEP 5 |
| ログインログ | ログイン履歴の確認 | STEP 5 |
| オンラインユーザー | 現在接続中のユーザー監視 | STEP 5 |
| サーバー監視 | サーバーリソースの監視 | STEP 5 |
| 定期タスク | スケジュールタスクの管理 | 随時利用 |
| プロフィール | 個人情報・パスワードの変更 | 随時利用 |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| システム管理者（admin） | すべての機能にアクセス可能。システム全体の管理を担当 |
| 一般管理者 | 特定の管理権限を付与されたユーザー。部門管理やユーザー管理などを担当 |
| 一般ユーザー | 業務遂行に必要な権限のみ付与されたユーザー |

### 1.6 対応ブラウザ

推奨ブラウザ：
- Google Chrome（最新版）
- Microsoft Edge（最新版）
- Safari（最新版）
- Firefox（最新版）

---

## 2. ログイン・ログアウト手順

### 2.1 ログイン方法

1. ブラウザでRuoYi後台管理システムのログインページにアクセスします
2. ログイン画面が表示されます

**入力項目：**

| 項目 | 入力内容 |
|------|---------|
| ユーザー名（用户名） | システムに登録されたログインアカウント名を入力 |
| パスワード（密码） | 登録されたパスワードを入力 |
| 認証コード（验证码） | 画面に表示される4桁の認証コードを入力（設定により表示されない場合あり） |
| 記住我（Remember Me） | チェックを入れると次回ログイン時に情報が保持されます |

3. 「登 录」ボタンをクリックします
4. 認証に成功すると、システム首頁（TOP画面）が表示されます

**注意事項：**
- 認証コード画像が見づらい場合は、画像をクリックすると新しい認証コードが表示されます
- パスワードを複数回間違えるとアカウントがロックされる場合があります
- 初期パスワードは変更することを推奨します

### 2.2 ログアウト方法

1. 画面右上のユーザー名（またはアバター画像）をクリックします
2. 表示されるドロップダウンメニューから「退出登录」を選択します
3. 確認ダイアログが表示された場合は「確定」をクリックします
4. ログイン画面に戻ります

### 2.3 パスワードを忘れた場合

パスワードを忘れた場合は、システム管理者に連絡してパスワードリセットを依頼してください。

**管理者によるパスワードリセット手順：**
1. 「システム管理」→「ユーザー管理」を開く
2. 対象ユーザーの行で「更多操作」→「重置密码」を選択
3. 新しいパスワードを入力して「確定」をクリック

### 2.4 画面ロック

作業を一時中断する場合、画面ロック機能を使用できます。

1. 画面右上のロックアイコン（锁屏）をクリック
2. 画面がロックされ、パスワード入力画面が表示されます
3. パスワードを入力して「解 锁」をクリックすると作業を再開できます

---

## 3. トップページ（TOP画面）

### 3.1 画面構成

ログイン後に表示されるシステム首頁は、以下の3つのエリアで構成されています。

**1. ヘッダーエリア（上部）**
- システムロゴ「RuoYi」
- ユーザーアバターとユーザー名
- 各種アイコン（ドキュメント、画面ロック、全画面表示）
- ログアウトメニュー

**2. サイドバーエリア（左側）**
- ナビゲーションメニュー
- 権限に応じたメニュー項目が表示されます

**3. コンテンツエリア（右側）**
- 選択した機能の画面が表示されます
- タブ形式で複数の画面を同時に開くことができます

### 3.2 メニュー操作

**メニューの展開/折りたたみ：**
- メニュー項目の左側にある矢印をクリックすると、サブメニューが展開/折りたたみされます
- 左上のハンバーガーアイコンをクリックすると、サイドバー全体を折りたたむことができます

**メニュー項目のクリック：**
- メニュー項目をクリックすると、該当する機能画面がコンテンツエリアにタブとして表示されます
- 既に開いているタブをクリックすると、その画面に切り替わります

### 3.3 タブ操作

**タブの切り替え：**
- タブをクリックして画面を切り替えます

**タブの閉じ方：**
- タブの「×」ボタンをクリックして閉じます
- タブを右クリックするとコンテキストメニューが表示され、以下の操作が可能です：
  - 「刷新」：現在のタブを再読み込み
  - 「关闭当前」：現在のタブを閉じる
  - 「关闭其他」：他のタブをすべて閉じる
  - 「关闭全部」：すべてのタブを閉じる

### 3.4 テーマ切替

1. 画面右上のユーザー名をクリック
2. ドロップダウンメニューから「切换主题」を選択
3. テーマ選択画面で好みのテーマをクリック
4. 選択したテーマがすぐに適用されます

---

## 4. 【STEP1】通知公告機能（通知の配信・受信）

> **業務フローでの位置**: 管理者がユーザーに対して通知や公告を配信し、ユーザーがそれを確認するステップです。

### 4.1 通知公告一覧を表示する

1. サイドメニューから「システム管理」→「通知公告」を選択します
2. 通知公告管理一覧画面が表示されます

**一覧画面の項目：**
| 項目 | 説明 |
|------|------|
| 序号 | 通知・公告のID番号 |
| 公告標題 | 通知・公告のタイトル（クリックで詳細表示） |
| 公告類型 | 「通知」または「公告」 |
| 状態 | 「正常」または「関閉」 |
| 創建者 | 作成者名 |
| 創建時間 | 作成日時 |

### 4.2 通知公告を検索する

1. 画面上部の検索フォームに条件を入力します
   - 「公告標題」：タイトルの一部を入力（部分一致検索）
   - 「操作人員」：作成者名を入力
   - 「公告類型」：通知/公告を選択
2. 「搜索」ボタンをクリックします
3. 条件に一致するデータが一覧に表示されます
4. 「重置」ボタンをクリックすると検索条件がクリアされます

### 4.3 通知公告の詳細を表示する

1. 一覧画面で確認したい通知・公告の「公告標題」をクリックします
2. 詳細表示画面がモーダルで開きます
3. 内容を確認後、「閉じる」ボタンで戻ります

### 4.4 通知公告を新規作成する（管理者向け）

1. 一覧画面で「新増」ボタンをクリックします
2. 新規登録画面がフルスクリーンモーダルで開きます
3. 以下の項目を入力します：
   - **公告標題**（必須）：通知・公告のタイトル
   - **公告類型**（必須）：「通知」または「公告」を選択
   - **状態**：「正常」または「関閉」を選択
   - **公告内容**：リッチテキストエディタで内容を入力
4. 「確定」ボタンをクリックして保存します

### 4.5 通知公告を編集する（管理者向け）

1. 一覧画面で編集したい項目のチェックボックスをチェックします
2. 「修改」ボタンをクリック、または行内の「編集」ボタンをクリックします
3. 編集画面で内容を修正します
4. 「確定」ボタンをクリックして保存します

### 4.6 通知公告を削除する（管理者向け）

1. 一覧画面で削除したい項目のチェックボックスをチェックします
2. 「削除」ボタンをクリック、または行内の「削除」ボタンをクリックします
3. 確認ダイアログで「確定」をクリックします

---

## 5. 【STEP2-3】ユーザー管理機能（申請の入力・処理）

> **業務フローでの位置**: 管理者がユーザーの登録・編集を行い、システム利用者の情報を管理するステップです。

### 5.1 ユーザー一覧を表示する

1. サイドメニューから「システム管理」→「ユーザー管理」を選択します
2. ユーザー管理一覧画面が表示されます
3. 左側に部門ツリー、右側にユーザー一覧が表示されます

**一覧画面の項目：**
| 項目 | 説明 |
|------|------|
| 用户名称 | ユーザーの表示名 |
| 登录账号 | ログインに使用するアカウント名 |
| 部门 | 所属部門 |
| 手机号码 | 電話番号 |
| 状态 | 「正常」または「停用」 |
| 创建时间 | アカウント作成日時 |

### 5.2 ユーザーを検索する

1. 画面上部の検索フォームに条件を入力します
   - 「登录账号」：ログイン名を入力
   - 「手机号码」：電話番号を入力
   - 「状态」：正常/停用を選択
   - 「创建时间」：期間を指定
2. 「搜索」ボタンをクリックします
3. 左側の部門ツリーで部門を選択すると、その部門のユーザーのみが表示されます

### 5.3 ユーザーを新規登録する（管理者向け）

1. 一覧画面で「新増」ボタンをクリックします
2. 新規登録画面がモーダルで開きます
3. 以下の項目を入力します：

**基本情報：**
| 項目 | 必須 | 説明 |
|------|------|------|
| 用户名称 | ○ | ユーザーの表示名（30文字以内） |
| 归属部门 | - | 「選択」ボタンで部門を選択 |
| 手机号码 | - | 電話番号（11桁） |
| 邮箱 | - | メールアドレス |
| 登录账号 | ○ | ログイン用のアカウント名 |
| 登录密码 | ○ | 初期パスワード |
| 用户性别 | - | 男/女/未知 |
| 岗位 | - | 役職を選択 |
| 角色 | - | ロールを選択（複数可） |
| 备注 | - | 備考 |

4. 「確定」ボタンをクリックして登録します

### 5.4 ユーザー情報を編集する（管理者向け）

1. 一覧画面で編集したいユーザーの「修改」ボタンをクリックします
2. 編集画面がモーダルで開きます
3. 必要な項目を修正します（ログイン名は変更不可）
4. 「確定」ボタンをクリックして保存します

### 5.5 ユーザーパスワードをリセットする（管理者向け）

1. 一覧画面で対象ユーザーの行を選択します
2. 「更多操作」→「重置密码」を選択します
3. 新しいパスワードを入力します
4. 「確定」ボタンをクリックします

### 5.6 ユーザーにロールを割り当てる（管理者向け）

1. 一覧画面で対象ユーザーの行を選択します
2. 「更多操作」→「分配角色」を選択します
3. ロール割当画面で、割り当てたいロールにチェックを入れます
4. 「確定」ボタンをクリックします

### 5.7 ユーザーデータをインポート/エクスポートする

**インポート：**
1. 「导入」ボタンをクリックします
2. 「下载模板」でテンプレートをダウンロードします
3. テンプレートにデータを入力し、保存します
4. 「点击上传」でファイルを選択します
5. 「確定」ボタンをクリックしてインポートします

**エクスポート：**
1. 必要に応じて検索条件でデータを絞り込みます
2. 「导出」ボタンをクリックします
3. Excelファイルがダウンロードされます

---

## 6. 【STEP3-4】権限・ロール管理機能（アクセス制御）

> **業務フローでの位置**: 管理者がロールと権限を設定し、ユーザーのアクセス制御を行うステップです。

### 6.1 ロール一覧を表示する

1. サイドメニューから「システム管理」→「ロール管理」を選択します
2. ロール管理一覧画面が表示されます

**一覧画面の項目：**
| 項目 | 説明 |
|------|------|
| 角色名称 | ロールの表示名 |
| 权限字符 | ロールの識別キー |
| 显示顺序 | 表示順序 |
| 状态 | 「正常」または「停用」 |
| 创建时间 | 作成日時 |

### 6.2 ロールを新規作成する（管理者向け）

1. 一覧画面で「新増」ボタンをクリックします
2. 新規登録画面がモーダルで開きます
3. 以下の項目を入力します：
   - **角色名称**（必須）：ロールの表示名
   - **权限字符**（必須）：ロールの識別キー（例：admin、common）
   - **角色顺序**（必須）：表示順序
   - **状态**：正常/停用
   - **菜单权限**：アクセス可能なメニューにチェック
   - **备注**：備考
4. 「確定」ボタンをクリックして登録します

### 6.3 データ権限を設定する（管理者向け）

1. ロール一覧画面で対象ロールの「更多操作」→「数据权限」を選択します
2. データ権限設定画面が開きます
3. 「权限范囲」を選択します：
   - 「全部数据权限」：すべてのデータにアクセス可能
   - 「自定数据权限」：指定した部門のデータにアクセス可能
   - 「本部门数据权限」：自部門のデータのみ
   - 「本部门及以下数据权限」：自部門と配下部門のデータ
   - 「仅本人数据权限」：自分のデータのみ
4. 「確定」ボタンをクリックして保存します

### 6.4 ロールにユーザーを割り当てる（管理者向け）

1. ロール一覧画面で対象ロールの「更多操作」→「分配用户」を選択します
2. ロールユーザー割当画面が開きます
3. 「添加用户」ボタンでユーザー選択ダイアログを開きます
4. 割り当てたいユーザーにチェックを入れ、「確定」をクリックします

### 6.5 メニュー管理を行う（管理者向け）

1. サイドメニューから「システム管理」→「メニュー管理」を選択します
2. メニュー管理画面が表示されます（ツリー形式）

**メニューの新規追加：**
1. 「新増」ボタンをクリックします
2. 以下の項目を入力します：
   - **上级菜单**：親メニューを選択
   - **菜单类型**：目录/菜单/按钮
   - **菜单名称**：メニューの表示名
   - **显示排序**：表示順序
   - **请求地址**：メニューのURL
   - **权限标识**：権限識別子
3. 「確定」ボタンをクリックして登録します

### 6.6 部門管理を行う（管理者向け）

1. サイドメニューから「システム管理」→「部門管理」を選択します
2. 部門管理画面が表示されます（ツリー形式）

**部門の新規追加：**
1. 「新増」ボタンをクリックします
2. 以下の項目を入力します：
   - **上级部门**：親部門を選択
   - **部门名称**：部門の表示名
   - **显示排序**：表示順序
   - **负责人**：責任者名
   - **联系电话**：連絡先電話番号
   - **邮箱**：メールアドレス
   - **状态**：正常/停用
3. 「確定」ボタンをクリックして登録します

---

## 7. 【STEP4-5】システム監視・ログ管理機能（監視・完了確認）

> **業務フローでの位置**: 管理者がシステムの状態を監視し、ユーザーの操作履歴を確認するステップです。

### 7.1 オンラインユーザーを監視する

1. サイドメニューから「システム監視」→「オンラインユーザー」を選択します
2. 現在ログイン中のユーザー一覧が表示されます

**一覧画面の項目：**
| 項目 | 説明 |
|------|------|
| 会话编号 | セッションID |
| 登录名称 | ログインアカウント名 |
| 部门名称 | 所属部門 |
| 主机 | 接続元IPアドレス |
| 浏览器 | 使用ブラウザ |
| 操作系统 | OS情報 |
| 登录时间 | ログイン日時 |

**強制ログアウト：**
1. 対象ユーザーの行で「强退」ボタンをクリックします
2. 確認ダイアログで「確定」をクリックします
3. 対象ユーザーがシステムから強制ログアウトされます

### 7.2 操作ログを確認する

1. サイドメニューから「システム監視」→「操作ログ」を選択します
2. 操作ログ一覧画面が表示されます

**一覧画面の項目：**
| 項目 | 説明 |
|------|------|
| 操作模块 | 操作対象のモジュール名 |
| 业务类型 | 操作種別（新増/修改/删除等） |
| 请求方式 | HTTPメソッド |
| 操作人员 | 操作を行ったユーザー |
| 主机 | 操作元IPアドレス |
| 操作状态 | 成功/失敗 |
| 操作时间 | 操作日時 |

**詳細表示：**
- 行内の「詳細」ボタンをクリックすると、操作の詳細情報が表示されます

### 7.3 ログインログを確認する

1. サイドメニューから「システム監視」→「ログインログ」を選択します
2. ログイン履歴一覧が表示されます

**一覧画面の項目：**
| 項目 | 説明 |
|------|------|
| 访问编号 | ログID |
| 用户名称 | ログインアカウント名 |
| 登录地址 | 接続元IPアドレス |
| 登录地点 | IPから推定した地域 |
| 浏览器 | 使用ブラウザ |
| 操作系统 | OS情報 |
| 登录状态 | 成功/失敗 |
| 操作信息 | 結果メッセージ |
| 登录时间 | ログイン日時 |

**アカウントロック解除：**
1. ロックされたユーザーを検索します
2. 「解锁」ボタンをクリックします
3. アカウントのロックが解除されます

### 7.4 サーバー監視を確認する

1. サイドメニューから「システム監視」→「サーバー監視」を選択します
2. サーバー情報が表示されます

**表示される情報：**
- **CPU情報**：使用率、コア数
- **メモリ情報**：使用量、空き容量
- **JVM情報**：Java仮想マシンの状態
- **ディスク情報**：各ディスクの使用状況

### 7.5 キャッシュ監視を確認する

1. サイドメニューから「システム監視」→「キャッシュ監視」を選択します
2. キャッシュ情報が表示されます

**操作：**
- 「削除」ボタンで個別のキャッシュを削除
- 「清空」ボタンで特定種類のキャッシュをすべて削除

---

## 8. 辞書・パラメータ管理機能

### 8.1 辞書タイプを管理する

1. サイドメニューから「システム管理」→「字典管理」を選択します
2. 辞書タイプ一覧画面が表示されます

**辞書タイプの新規追加：**
1. 「新増」ボタンをクリックします
2. 以下の項目を入力します：
   - **字典名称**：辞書の表示名
   - **字典类型**：辞書の識別キー
   - **状态**：正常/停用
   - **备注**：備考
3. 「確定」ボタンをクリックして登録します

### 8.2 辞書データを管理する

1. 辞書タイプ一覧で対象行の「数据」列をクリックします
2. 辞書データ一覧画面が表示されます

**辞書データの新規追加：**
1. 「新増」ボタンをクリックします
2. 以下の項目を入力します：
   - **字典标签**：表示用ラベル
   - **字典键值**：システム内部で使用する値
   - **字典排序**：表示順序
   - **状态**：正常/停用
3. 「確定」ボタンをクリックして登録します

### 8.3 パラメータを管理する

1. サイドメニューから「システム管理」→「参数設定」を選択します
2. パラメータ一覧画面が表示されます

**パラメータの新規追加：**
1. 「新増」ボタンをクリックします
2. 以下の項目を入力します：
   - **参数名称**：パラメータの表示名
   - **参数键名**：パラメータのキー
   - **参数键值**：パラメータの値
   - **系统内置**：システム組み込みかどうか
   - **备注**：備考
3. 「確定」ボタンをクリックして登録します

---

## 9. 定期タスク管理機能

### 9.1 定期タスク一覧を表示する

1. サイドメニューから「システム監視」→「定期タスク」を選択します
2. 定期タスク一覧画面が表示されます

**一覧画面の項目：**
| 項目 | 説明 |
|------|------|
| 任务名称 | タスクの表示名 |
| 任务组名 | タスクグループ |
| 调用目标字符串 | 実行対象のBean名とメソッド |
| cron执行表达式 | 実行スケジュール（Cron形式） |
| 状态 | 正常/暂停 |

### 9.2 定期タスクを新規作成する（管理者向け）

1. 一覧画面で「新増」ボタンをクリックします
2. 新規登録画面が開きます
3. 以下の項目を入力します：
   - **任务名称**（必須）：タスクの表示名
   - **任务组名**（必須）：タスクグループを選択
   - **调用目标字符串**（必須）：実行するBean名とメソッド
   - **cron表达式**（必須）：実行スケジュール
   - **执行策略**：立即执行/放弃执行/执行一次
   - **是否并发**：允许/禁止
   - **状态**：正常/暂停
4. 「確定」ボタンをクリックして登録します

**Cron式の入力補助：**
- 「cron表达式」フィールド右側のボタンをクリックすると、Cron式生成器が開きます
- GUI画面でスケジュールを設定すると、自動的にCron式が生成されます

### 9.3 タスクを即時実行する

1. 一覧画面で対象タスクの「更多操作」→「执行一次」を選択します
2. 確認ダイアログで「確定」をクリックします
3. タスクが即時実行されます

### 9.4 タスク実行ログを確認する

1. 一覧画面で対象タスクの「更多操作」→「任务详情」を選択します
2. タスクログ画面で実行履歴を確認できます

---

## 10. マイページ機能（プロフィール管理）

### 10.1 プロフィールにアクセスする

1. 画面右上のユーザー名をクリックします
2. ドロップダウンメニューから「个人中心」を選択します
3. プロフィール画面が表示されます

### 10.2 基本情報を確認する

プロフィール画面の「基本資料」タブで以下の情報を確認できます：
- 用户名称（ユーザー名）
- 手机号码（電話番号）
- 邮箱（メールアドレス）
- 所属部门（所属部門）
- 所属角色（ロール）
- 创建日期（登録日）

### 10.3 基本情報を編集する

1. 「基本資料」タブの入力フィールドで情報を編集します
2. 「保存」ボタンをクリックして変更を保存します

### 10.4 パスワードを変更する

1. 画面右上のユーザー名をクリックします
2. ドロップダウンメニューから「修改密码」を選択します
3. 以下の項目を入力します：
   - **旧密码**：現在のパスワード
   - **新密码**：新しいパスワード
   - **确认密码**：新しいパスワード（確認用）
4. 「確定」ボタンをクリックして変更を保存します

### 10.5 アバター画像を変更する

1. プロフィール画面で「修改头像」タブを選択します
2. 「選择」ボタンをクリックして画像ファイルを選択します
3. 画像のトリミング範囲を調整します
4. 「保存」ボタンをクリックして変更を適用します

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
【STEP 1】管理者が通知公告を作成・配信 → 4章参照
    ↓
【STEP 2】管理者がユーザー情報を登録・更新 → 5章参照
    ↓
【STEP 3】管理者がロール・権限を設定 → 6章参照
    ↓
【STEP 4】ユーザーがシステムにログインして業務を実行 → 2章、3章参照
    ↓
【STEP 5】管理者が操作ログ・システム状態を監視 → 7章参照
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

### 11.1 【管理者】STEP1: 通知公告の作成

新しいお知らせや公告を作成する場合の手順です。

1. システムにログインします（2.1参照）
2. 「システム管理」→「通知公告」を選択します
3. 「新增」ボタンをクリックします
4. 公告標題、公告類型、内容を入力します
5. 「確定」をクリックして保存します

### 11.2 【管理者】STEP2: ユーザー登録

新しいユーザーを登録する場合の手順です。

1. 「システム管理」→「ユーザー管理」を選択します
2. 「新增」ボタンをクリックします
3. ユーザー情報（ユーザー名、ログイン名、パスワード等）を入力します
4. 必要に応じて部門、役職、ロールを選択します
5. 「確定」をクリックして登録します
6. 登録したユーザーに初期パスワードを通知します

### 11.3 【管理者】STEP3: ロール・権限設定

ユーザーの権限を設定する場合の手順です。

1. 「システム管理」→「ロール管理」を選択します
2. 適切なロールを選択または新規作成します
3. ロールにメニュー権限を設定します
4. 必要に応じてデータ権限を設定します
5. 「システム管理」→「ユーザー管理」でユーザーにロールを割り当てます

### 11.4 【一般ユーザー】STEP4: 日常業務の実行

一般ユーザーが日常業務を行う手順です。

1. システムにログインします（2.1参照）
2. 通知公告を確認します（ホーム画面または通知一覧）
3. サイドメニューから必要な機能を選択します
4. 業務を実行します
5. 業務終了後、ログアウトします（2.2参照）

### 11.5 【管理者】STEP5: システム監視

システムの状態を監視する手順です。

1. 「システム監視」→「オンラインユーザー」で接続状況を確認します
2. 「システム監視」→「操作ログ」で操作履歴を確認します
3. 「システム監視」→「ログインログ」でログイン履歴を確認します
4. 「システム監視」→「サーバー監視」でサーバーリソースを確認します
5. 問題があれば対処します（13章トラブルシューティング参照）

---

## 12. よくある質問と対処法

### 12.1 ログインに関するQ&A

**Q: ログインできません**

A: 以下を確認してください：
- ユーザー名（ログイン名）が正しいか確認してください
- パスワードが正しいか確認してください（大文字・小文字に注意）
- 認証コードが正しく入力されているか確認してください
- アカウントがロックされていないか管理者に確認してください

**Q: パスワードを忘れました**

A: システム管理者に連絡して、パスワードリセットを依頼してください。

**Q: 認証コードが見えません**

A: 認証コード画像をクリックすると、新しい認証コードが表示されます。

### 12.2 ユーザー管理に関するQ&A

**Q: ユーザーを削除できません**

A: 以下を確認してください：
- 削除権限があるか確認してください
- システム管理者（admin）は削除できません
- 該当ユーザーに関連するデータがある場合、先にデータを削除する必要があるかもしれません

**Q: ロールが選択できません**

A: ロールが「停用」状態になっている可能性があります。ロール管理でステータスを確認してください。

### 12.3 権限に関するQ&A

**Q: メニューが表示されません**

A: 以下を確認してください：
- 必要なロールが割り当てられているか確認してください
- ロールに該当メニューの権限が設定されているか確認してください
- 一度ログアウトして再ログインしてみてください

**Q: 「権限不足」エラーが表示されます**

A: 操作に必要な権限がありません。管理者に権限の付与を依頼してください。

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| 用户或密码错误 | ユーザー名またはパスワードが間違っている | 正しいユーザー名とパスワードを入力してください |
| 验证码已过期 | 認証コードの有効期限が切れた | 認証コード画像をクリックして更新し、再入力してください |
| 账户已锁定 | パスワード入力失敗回数が上限を超えた | 管理者にロック解除を依頼してください |
| Email已经存在 | 入力したメールアドレスが既に使用されている | 別のメールアドレスを使用してください |
| 手机号码已经存在 | 入力した電話番号が既に使用されている | 別の電話番号を使用してください |
| 无权限访问 | 操作に必要な権限がない | 管理者に権限の付与を依頼してください |

### 13.2 よくあるトラブルと解決方法

**トラブル: 画面が真っ白になる**

解決方法：
1. ブラウザの更新ボタンをクリックしてページを再読み込みします
2. ブラウザのキャッシュをクリアします
3. 別のブラウザで試してみます
4. 問題が続く場合はシステム管理者に連絡します

**トラブル: セッションが切れてしまう**

解決方法：
1. 長時間操作しない場合、セッションがタイムアウトします
2. 再度ログインしてください
3. 頻繁に発生する場合は管理者にセッションタイムアウト設定の確認を依頼します

**トラブル: データが保存されない**

解決方法：
1. 必須項目がすべて入力されているか確認します
2. 入力値のフォーマットが正しいか確認します（メール形式、電話番号形式など）
3. ネットワーク接続を確認します
4. ブラウザの開発者ツールでエラーを確認します

**トラブル: Excelエクスポートが動作しない**

解決方法：
1. ブラウザのポップアップブロックを確認し、許可します
2. ダウンロードフォルダを確認します
3. 別のブラウザで試してみます

### 13.3 サポートへの連絡方法

上記の方法で解決しない場合は、システム管理者に以下の情報を添えて連絡してください：

1. 発生日時
2. ログインユーザー名
3. 操作内容（何をしようとしていたか）
4. エラーメッセージ（表示されていれば）
5. 画面のスクリーンショット（可能であれば）

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-01-08 | 初版作成 |

---

*本マニュアルは、RuoYi後台管理システムのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
