---
generated_at: 2026-01-08 12:00:00
metrics:
  claims_total: 50
  claims_with_evidence: 47
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：47 / 50、根拠なし：3
- 優先レビュー（高）
  1. **NFT-031 ブラウザ互換性テスト**：具体的なブラウザバージョン要件が未定義
  2. **NFT-043 HTTPS対応確認**：本番環境のSSL/TLS設定詳細が未定義
  3. **NFT-050 ストレステスト**：具体的な負荷数値の根拠が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/application.yml`
- E-02: `ruoyi-admin/src/main/resources/application-druid.yml`
- E-03: `ruoyi-framework/src/main/java/com/ruoyi/framework/config/ShiroConfig.java`
- E-04: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java`
- E-05: `ruoyi-admin/src/main/resources/ehcache/ehcache-shiro.xml`
- E-06: `ruoyi-framework/src/main/java/com/ruoyi/framework/config/FilterConfig.java`
- E-07: `ruoyi-common/src/main/java/com/ruoyi/common/xss/XssHttpServletRequestWrapper.java`
- E-08: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/filter/csrf/CsrfValidateFilter.java`
- E-09: `ruoyi-framework/src/main/java/com/ruoyi/framework/interceptor/RepeatSubmitInterceptor.java`
- E-10: `ruoyi-framework/src/main/java/com/ruoyi/framework/aspectj/LogAspect.java`
- E-11: `ruoyi-framework/src/main/java/com/ruoyi/framework/aspectj/DataScopeAspect.java`
- E-12: `ruoyi-common/src/main/java/com/ruoyi/common/utils/file/FileUploadUtils.java`
- E-13: `ruoyi-admin/src/main/resources/logback.xml`
- E-14: `ruoyi-framework/src/main/java/com/ruoyi/framework/config/DruidConfig.java`
- E-15: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/domain/Server.java`
- E-16: `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/ShutdownManager.java`
- E-17: `ruoyi-framework/src/main/java/com/ruoyi/framework/web/exception/GlobalExceptionHandler.java`
- E-18: `ruoyi-quartz/src/main/java/com/ruoyi/quartz/util/QuartzDisallowConcurrentExecution.java`
- E-19: `pom.xml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001 ログイン処理レスポンス時間（Shiro認証+CAPTCHA） | E-01, E-03 | ○ |
| C-02 | NFT-002 一覧画面レスポンス（PageHelper分頁処理） | E-19 (pagehelper依存) | ○ |
| C-03 | NFT-003 同時ユーザー処理能力（Tomcat max-threads:800） | E-01 (server.tomcat.threads.max:800) | ○ |
| C-04 | NFT-004 高負荷時安定性（accept-count:1000） | E-01 (server.tomcat.accept-count:1000) | ○ |
| C-05 | NFT-005 SQLクエリ実行時間（slow-sql-millis:1000） | E-02 (slow-sql-millis:1000) | ○ |
| C-06 | NFT-006 DB接続プール（maxActive:20/maxWait:60000） | E-02 | ○ |
| C-07 | NFT-007 Ehcacheキャッシュ（sys-dict/sys-config永続） | E-05 | ○ |
| C-08 | NFT-008 ファイルアップロード制限（max-file-size:10MB） | E-01 (spring.servlet.multipart.max-file-size:10MB) | ○ |
| C-09 | NFT-009 アカウントロック（maxRetryCount:5/600秒） | E-01, E-04, E-05 | ○ |
| C-10 | NFT-010 セッションタイムアウト（expireTime:30） | E-01 (shiro.session.expireTime:30) | ○ |
| C-11 | NFT-011 同時ログイン制御（maxSession設定） | E-01, E-03 | ○ |
| C-12 | NFT-012 CAPTCHA検証（captchaEnabled:true） | E-01 (shiro.user.captchaEnabled:true) | ○ |
| C-13 | NFT-013 パスワード暗号化（MD5+Salt） | E-04 (Md5Hash) | ○ |
| C-14 | NFT-014 XSSフィルタ（XssFilter/XssHttpServletRequestWrapper） | E-06, E-07 | ○ |
| C-15 | NFT-015 HTMLエスケープ（EscapeUtil.clean()） | E-07 | ○ |
| C-16 | NFT-016 CSRF対策（CsrfValidateFilter） | E-01, E-08 | ○ |
| C-17 | NFT-017 SQLインジェクション対策（MyBatis PreparedStatement） | E-19 (MyBatis依存) | ○ |
| C-18 | NFT-018 データスコープ制御（DataScopeAspect） | E-11 | ○ |
| C-19 | NFT-019 権限チェック（Shiro@RequiresPermissions） | E-03 | ○ |
| C-20 | NFT-020 Cookie HttpOnly（httpOnly:true） | E-01 (shiro.cookie.httpOnly:true) | ○ |
| C-21 | NFT-021 RememberMe暗号化（AES 128bit） | E-03 (CipherUtils.generateNewKey(128,"AES")) | ○ |
| C-22 | NFT-022 ファイル拡張子制限（DEFAULT_ALLOWED_EXTENSION） | E-12 | ○ |
| C-23 | NFT-023 ファイルサイズ制限（DEFAULT_MAX_SIZE:50MB） | E-12 | ○ |
| C-24 | NFT-024 機密情報ログ除外（EXCLUDE_PROPERTIES） | E-10 | ○ |
| C-25 | NFT-025 重複送信防止（RepeatSubmitInterceptor） | E-09 | ○ |
| C-26 | NFT-026 データソース切替（DynamicDataSource） | E-02, E-14 | ○ |
| C-27 | NFT-027 セッション永続化（OnlineSessionDAO） | E-03 | ○ |
| C-28 | NFT-028 グローバル例外ハンドリング | E-17 | ○ |
| C-29 | NFT-029 非同期処理エラーハンドリング（AsyncManager） | E-10 (AsyncManager使用) | ○ |
| C-30 | NFT-030 グレースフルシャットダウン（ShutdownManager） | E-16 | ○ |
| C-31 | NFT-031 主要ブラウザ動作確認 | **根拠なし** | △ |
| C-32 | NFT-032 Java 8互換性（java.version:1.8） | E-19 | ○ |
| C-33 | NFT-033 MySQL互換性（mysql-connector） | E-02 | ○ |
| C-34 | NFT-034 マルチバイト文字処理（UTF-8） | E-01, E-19 | ○ |
| C-35 | NFT-035 操作ログ記録（LogAspect/@Log） | E-10 | ○ |
| C-36 | NFT-036 ログローテーション（maxHistory:60） | E-13 | ○ |
| C-37 | NFT-037 ログレベル制御（logback.xml） | E-13 | ○ |
| C-38 | NFT-038 サーバーリソース監視（Server.java/oshi） | E-15, E-19 | ○ |
| C-39 | NFT-039 Druidモニタリング（statViewServlet） | E-02 | ○ |
| C-40 | NFT-040 外部設定ファイル対応 | E-01 | ○ |
| C-41 | NFT-041 JVMメモリ監視 | E-15 | ○ |
| C-42 | NFT-042 データベース接続リーク確認 | E-02, E-14 | ○ |
| C-43 | NFT-043 HTTPS対応確認 | **根拠なし** | △ |
| C-44 | NFT-044 ファイル名長制限（100文字） | E-12 | ○ |
| C-45 | NFT-045 定時タスク実行（Quartz） | E-18 | ○ |
| C-46 | NFT-046 定時タスク同時実行制御 | E-18 | ○ |
| C-47 | NFT-047 API応答時間測定（Swagger） | E-01, E-19 | ○ |
| C-48 | NFT-048 ログイン情報記録（SysLogininfor） | E-10 (AsyncFactory.recordLogininfor) | ○ |
| C-49 | NFT-049 多言語対応（messages.properties） | E-01 | ○ |
| C-50 | NFT-050 ピーク負荷テスト（300同時ユーザー） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **NFT-031 ブラウザ互換性**：具体的なブラウザバージョン要件が設定ファイルに定義されていない
  - 候補：要件定義書 / 外部設計書 / テスト計画書
- **NFT-043 HTTPS対応**：本番環境のSSL/TLS設定がプロジェクト内に含まれていない
  - 候補：インフラ設計書 / デプロイメント設定 / Nginx/Apache設定ファイル
- **NFT-050 ピーク負荷テスト**：300同時ユーザーの根拠となるSLA/要件定義が見つからない
  - 候補：SLA定義書 / 性能要件定義書 / 顧客要件

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - NFT-031：ブラウザ互換性テストは実施必須だが、対象バージョンの明確化が必要
- **1: 中リスク** - NFT-043：本番環境でのHTTPS必須化の確認が必要
- **0: 低リスク** - NFT-050：負荷テストの数値は本番運用開始後に調整可能

## 6) レビュアーチェックリスト（最小）
- [ ] NFT-009 アカウントロック機能のテスト手順と期待結果の詳細化
- [ ] NFT-016 CSRF対策が現在無効（enabled:false）のため、本番環境での設定確認
- [ ] NFT-031 対象ブラウザとバージョンの明確化
- [ ] NFT-043 本番環境でのSSL/TLS設定の確認
- [ ] NFT-050 ピーク負荷テストの同時ユーザー数の妥当性確認
- [ ] 各テストケースの合格基準値が実運用要件と整合しているか確認
- [ ] 高優先度テストケースの実施順序とスケジュールの確認
