---
generated_at: 2026-01-08 10:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 40
  claims_without_evidence: 5
confidence_derived: 0.89
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：40 / 45、根拠なし：5
- 優先レビュー（高）
  1. **稼働率99.9%以上**：コード内に明示的な設定なし（推奨値として記載）
  2. **RTO/RPO目標値**：コード内に明示的な設定なし（推奨値として記載）
  3. **計画停止時間**：コード内に明示的な設定なし（推奨値として記載）
  4. **画面表示3秒以内**：コード内に明示的な設定なし（推奨値として記載）
  5. **API応答1秒以内**：慢SQLしきい値から推定（直接的な設定なし）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ruoyi-admin/src/main/resources/application.yml`
- E-02: `ruoyi-admin/src/main/resources/application-druid.yml`
- E-03: `ruoyi-admin/src/main/resources/logback.xml`
- E-04: `ruoyi-admin/src/main/resources/ehcache/ehcache-shiro.xml`
- E-05: `pom.xml`
- E-06: `ruoyi-framework/src/main/java/com/ruoyi/framework/config/ShiroConfig.java`
- E-07: `ruoyi-common/src/main/java/com/ruoyi/common/xss/XssFilter.java`
- E-08: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/web/filter/csrf/CsrfValidateFilter.java`
- E-09: `ruoyi-framework/src/main/java/com/ruoyi/framework/shiro/service/SysPasswordService.java`
- E-10: `ruoyi-framework/src/main/java/com/ruoyi/framework/aspectj/LogAspect.java`
- E-11: `ruoyi-framework/src/main/java/com/ruoyi/framework/aspectj/DataScopeAspect.java`
- E-12: `ruoyi-common/src/main/java/com/ruoyi/common/config/thread/ThreadPoolConfig.java`
- E-13: `ruoyi-framework/src/main/java/com/ruoyi/framework/manager/AsyncManager.java`
- E-14: `ruoyi-framework/src/main/java/com/ruoyi/framework/config/FilterConfig.java`
- E-15: `ruoyi-admin/src/main/resources/mybatis/mybatis-config.xml`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Tomcat最大スレッド数800 | E-01 (`server.tomcat.threads.max: 800`) | ○ |
| C-02 | Tomcat最小スレッド数100 | E-01 (`server.tomcat.threads.min-spare: 100`) | ○ |
| C-03 | 接続キュー1000 | E-01 (`server.tomcat.accept-count: 1000`) | ○ |
| C-04 | 慢SQLしきい値1000ms | E-02 (`slow-sql-millis: 1000`) | ○ |
| C-05 | データベース最大接続数20 | E-02 (`maxActive: 20`) | ○ |
| C-06 | 初期接続数5 | E-02 (`initialSize: 5`) | ○ |
| C-07 | 最小アイドル接続数10 | E-02 (`minIdle: 10`) | ○ |
| C-08 | 接続取得待ちタイムアウト60秒 | E-02 (`maxWait: 60000`) | ○ |
| C-09 | セッションタイムアウト30分 | E-01 (`shiro.session.expireTime: 30`) | ○ |
| C-10 | セッション検証間隔10分 | E-01 (`shiro.session.validationInterval: 10`) | ○ |
| C-11 | Apache Shiro 1.13.0使用 | E-05 (`shiro.version: 1.13.0`) | ○ |
| C-12 | MD5ハッシュによるパスワード暗号化 | E-09 (`Md5Hash`使用) | ○ |
| C-13 | ログイン試行5回制限 | E-01 (`user.password.maxRetryCount: 5`) | ○ |
| C-14 | ログイン失敗時10分ロック | E-04 (`loginRecordCache` TTL 600秒) | ○ |
| C-15 | CAPTCHA認証有効 | E-01 (`shiro.user.captchaEnabled: true`) | ○ |
| C-16 | Remember Me機能（AES 128bit） | E-06 (`CipherUtils.generateNewKey(128, "AES")`) | ○ |
| C-17 | Cookie有効期限30日 | E-01 (`shiro.cookie.maxAge: 30`) | ○ |
| C-18 | データスコープ5段階制御 | E-11 (5種類のDATA_SCOPE定数) | ○ |
| C-19 | XSS対策フィルタ実装 | E-07, E-14 (`XssFilter.java`) | ○ |
| C-20 | CSRF対策フィルタ実装（デフォルト無効） | E-01, E-08 (`csrf.enabled: false`) | ○ |
| C-21 | SQLインジェクション対策（Druid Wall） | E-02 (`wall.config`) | ○ |
| C-22 | Cookie HttpOnly属性有効 | E-01 (`shiro.cookie.httpOnly: true`) | ○ |
| C-23 | ファイルアップロード上限10MB | E-01 (`max-file-size: 10MB`) | ○ |
| C-24 | リクエスト総サイズ上限20MB | E-01 (`max-request-size: 20MB`) | ○ |
| C-25 | マルチモジュール構成（6モジュール） | E-05 (`modules`セクション) | ○ |
| C-26 | マスター/スレーブDB構成対応 | E-02 (`slave`設定セクション) | ○ |
| C-27 | スレッドプールコアサイズ50 | E-12 (`corePoolSize = 50`) | ○ |
| C-28 | スレッドプール最大サイズ200 | E-12 (`maxPoolSize = 200`) | ○ |
| C-29 | キュー容量1000 | E-12 (`queueCapacity = 1000`) | ○ |
| C-30 | EhCacheによるキャッシュ管理 | E-04, E-06 | ○ |
| C-31 | ログ保存場所 /home/ruoyi/logs | E-03 (`log.path`) | ○ |
| C-32 | ログ保持期間60日 | E-03 (`maxHistory: 60`) | ○ |
| C-33 | AOPによる操作ログ記録 | E-10 (`@Log`アノテーション処理) | ○ |
| C-34 | 敏感情報自動除外 | E-10 (`EXCLUDE_PROPERTIES`) | ○ |
| C-35 | 非同期ログ記録（10ms遅延） | E-13 (`OPERATE_DELAY_TIME = 10`) | ○ |
| C-36 | Druid監視コンソール有効 | E-02 (`statViewServlet.enabled: true`) | ○ |
| C-37 | Quartz定時タスク | E-05 (`ruoyi-quartz`モジュール) | ○ |
| C-38 | Swagger 3.0 API文書 | E-01 (`swagger.enabled: true`), E-05 | ○ |
| C-39 | Java 1.8以上 | E-05 (`java.version: 1.8`) | ○ |
| C-40 | Spring Boot 2.5.15 | E-05 (`spring-boot.version: 2.5.15`) | ○ |
| C-41 | 稼働率99.9%以上 | **根拠なし** | △ |
| C-42 | RTO 4時間以内 | **根拠なし** | △ |
| C-43 | RPO 1時間以内 | **根拠なし** | △ |
| C-44 | 画面表示3秒以内 | **根拠なし** | △ |
| C-45 | 計画停止時間月1回/4時間以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **可用性要件（稼働率、RTO、RPO）**：コード内に明示的な設定・定義が存在しないため、一般的な推奨値として記載
  - 候補：SLA定義書 / 運用設計書 / インフラ設計書
- **レスポンスタイム目標値**：アプリケーション層での明示的な目標値設定がないため、慢SQLしきい値等から推定
  - 候補：性能要件定義書 / 負荷テスト計画書
- **計画停止時間**：メンテナンスウィンドウの定義がコード内に存在しない
  - 候補：運用計画書 / 保守契約書

## 5) リスクフラグ（レビュー観点）
- **[1] 中リスク**: CSRF対策がデフォルト無効（`csrf.enabled: false`）。本番環境では有効化を推奨
- **[1] 中リスク**: データベースマスター/スレーブ構成がデフォルト無効。高可用性要件がある場合は検討が必要
- **[0] 低リスク**: パスワード暗号化にMD5を使用。より強力なアルゴリズム（bcrypt等）への移行を検討可能
- **[0] 低リスク**: Remember Me機能のCipherKeyが動的生成される場合、サーバー再起動でCookieが無効化される

## 6) レビュアーチェックリスト（最小）
- [ ] 可用性要件（稼働率、RTO、RPO）がビジネス要件と整合しているか確認
- [ ] レスポンスタイム目標値がユーザー体験要件を満たしているか確認
- [ ] CSRF対策の有効化が本番環境で必要か検討
- [ ] データベース冗長構成の要否を確認
- [ ] パスワード暗号化アルゴリズムのセキュリティレベルを評価
- [ ] ログ保持期間（60日）が監査要件を満たしているか確認
- [ ] ファイルアップロードサイズ上限（10MB/20MB）がビジネス要件を満たしているか確認
