# 非機能要件定義書

## 概要

本ドキュメントは、RuoYi管理システム（バージョン4.8.2）の非機能要件を定義するものです。本システムはSpring Boot 2.5.15をベースとしたJava Webアプリケーションであり、Apache Shiroによる認証・認可、Druidデータベースコネクションプール、MyBatisによるデータアクセスを主要コンポーネントとして構成されています。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| 画面表示 | 3秒以内 | 静的リソースはキャッシュ対象外（`anon`アクセス） |
| API応答 | 1秒以内 | 慢SQLのしきい値は1000ms（`slow-sql-millis: 1000`） |
| データベースクエリ | 1秒以内 | Druid設定に基づく監視対象 |
| セッション検証 | 10分間隔 | `shiro.session.validationInterval: 10` |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 同時接続数 | 最大800 | Tomcat最大スレッド数（`server.tomcat.threads.max: 800`） |
| 最小スレッド数 | 100 | Tomcat初期スレッド数（`server.tomcat.threads.min-spare: 100`） |
| 接続キュー | 1000 | `server.tomcat.accept-count: 1000` |
| データベース接続プール | 最大20接続 | Druid設定（`maxActive: 20`） |
| スレッドプール（非同期処理） | コア50/最大200 | `ThreadPoolConfig`による設定 |

### データベース接続設定

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| 初期接続数 | 5 | `initialSize: 5` |
| 最小アイドル接続数 | 10 | `minIdle: 10` |
| 最大接続数 | 20 | `maxActive: 20` |
| 接続取得待ちタイムアウト | 60秒 | `maxWait: 60000` |
| 接続タイムアウト | 30秒 | `connectTimeout: 30000` |
| ソケットタイムアウト | 60秒 | `socketTimeout: 60000` |
| 接続検証間隔 | 60秒 | `timeBetweenEvictionRunsMillis: 60000` |
| 最小生存時間 | 5分 | `minEvictableIdleTimeMillis: 300000` |
| 最大生存時間 | 15分 | `maxEvictableIdleTimeMillis: 900000` |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | 99.9%以上 | コード内に明示的な設定なし（推奨値） |
| 計画停止時間 | 月1回/4時間以内 | メンテナンスウィンドウ（推奨値） |
| 障害復旧時間（RTO） | 4時間以内 | コード内に明示的な設定なし（推奨値） |
| 目標復旧時点（RPO） | 1時間以内 | コード内に明示的な設定なし（推奨値） |

### セッション管理

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| セッションタイムアウト | 30分 | `shiro.session.expireTime: 30` |
| セッション同期周期 | 1分 | `shiro.session.dbSyncPeriod: 1` |
| セッション検証間隔 | 10分 | `shiro.session.validationInterval: 10` |
| 同一ユーザー最大セッション数 | 無制限 | `shiro.session.maxSession: -1` |

## セキュリティ要件

### 認証・認可

| 項目 | 実装内容 | 根拠 |
| --- | --- | --- |
| 認証フレームワーク | Apache Shiro 1.13.0 | `ShiroConfig.java`、`pom.xml` |
| パスワード暗号化 | MD5ハッシュ（ソルト付き） | `SysPasswordService.encryptPassword()` |
| ログイン試行制限 | 5回失敗で10分間ロック | `user.password.maxRetryCount: 5`、`ehcache-shiro.xml` |
| CAPTCHA認証 | 数学計算式/文字認証 | `shiro.user.captchaEnabled: true`、`captchaType: math` |
| Remember Me機能 | AES 128bit暗号化Cookie | `CustomCookieRememberMeManager`、有効期限30日 |
| セッション管理 | EhCacheによるキャッシュ | `ehcache-shiro.xml` |

### 権限制御

| 項目 | 実装内容 | 根拠 |
| --- | --- | --- |
| ロールベースアクセス制御（RBAC） | `@RequiresPermissions`、`@RequiresRoles`アノテーション | 各Controllerクラス |
| データスコープ制御 | 5段階（全部/カスタム/部門/部門配下/本人のみ） | `DataScopeAspect.java` |
| 権限キャッシュ | EhCache（`sys-authCache`） | `ehcache-shiro.xml` |

### 攻撃対策

| 項目 | 実装内容 | 根拠 |
| --- | --- | --- |
| XSS対策 | XssFilter、HTMLエスケープ処理 | `XssFilter.java`、`FilterConfig.java` |
| CSRF対策 | トークン検証（デフォルト無効） | `CsrfValidateFilter.java`、`csrf.enabled: false` |
| SQLインジェクション対策 | Druid Wall Filter | `application-druid.yml`（`wall.config`） |
| Cookie保護 | HttpOnly属性有効 | `shiro.cookie.httpOnly: true` |

### ファイルアップロード制限

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| 単一ファイルサイズ上限 | 10MB | `spring.servlet.multipart.max-file-size` |
| リクエスト総サイズ上限 | 20MB | `spring.servlet.multipart.max-request-size` |

## 拡張性要件

### アーキテクチャ

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| モジュール構成 | マルチモジュール構成（6モジュール） | `ruoyi-admin`、`ruoyi-framework`、`ruoyi-system`、`ruoyi-quartz`、`ruoyi-generator`、`ruoyi-common` |
| データベース構成 | マスター/スレーブ構成対応 | `application-druid.yml`（slave設定） |
| キャッシュ機構 | EhCache | `ehcache-shiro.xml` |

### スレッドプール設定

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| コアプールサイズ | 50 | `ThreadPoolConfig.corePoolSize` |
| 最大プールサイズ | 200 | `ThreadPoolConfig.maxPoolSize` |
| キュー容量 | 1000 | `ThreadPoolConfig.queueCapacity` |
| キープアライブ時間 | 300秒 | `ThreadPoolConfig.keepAliveSeconds` |
| リジェクションポリシー | CallerRunsPolicy | 呼び出し元スレッドで実行 |

### キャッシュ設定

| キャッシュ名 | 最大エントリ数 | TTL | 用途 |
| --- | --- | --- | --- |
| defaultCache | 1000 | 3600秒 | デフォルトキャッシュ |
| loginRecordCache | 2000 | 600秒 | ログイン試行記録 |
| sys-userCache | 10000 | 無制限 | アクティブユーザー |
| sys-authCache | 10000 | 無制限 | 権限キャッシュ |
| sys-cache | 1000 | 永続 | システムキャッシュ |
| sys-config | 1000 | 永続 | システム設定 |
| sys-dict | 1000 | 永続 | 辞書データ |
| shiro-activeSessionCache | 10000 | 無制限 | アクティブセッション |

## 保守性要件

### ログ管理

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| ログフレームワーク | Logback 1.2.13 | `logback.xml` |
| ログ保存場所 | `/home/ruoyi/logs` | `logback.xml`（`log.path`） |
| ログファイル分類 | INFO/ERROR/ユーザー操作 | `sys-info.log`、`sys-error.log`、`sys-user.log` |
| ログ保持期間 | 60日 | `maxHistory: 60` |
| ログフォーマット | 時刻/スレッド/レベル/クラス/メソッド/行番号/メッセージ | `%d{HH:mm:ss.SSS} [%thread] %-5level %logger{20} - [%method,%line] - %msg%n` |

### 監査ログ

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| 操作ログ記録 | AOPによる自動記録 | `LogAspect.java`、`@Log`アノテーション |
| 記録項目 | ユーザー/IP/URL/パラメータ/実行時間/結果 | `SysOperLog`エンティティ |
| 敏感情報除外 | password、oldPassword等を自動除外 | `LogAspect.EXCLUDE_PROPERTIES` |
| 非同期記録 | 10ms遅延で非同期実行 | `AsyncManager.OPERATE_DELAY_TIME` |
| ログインログ | ログイン成功/失敗の記録 | `SysLogininfor`テーブル |

### コード生成

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| コード生成機能 | Velocityテンプレートエンジン | `ruoyi-generator`モジュール |
| 対応テーブル | 単一テーブル/主従テーブル/ツリーテーブル | `generator.yml` |

## 運用・監視要件

### 監視機能

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| データベース監視 | Druid監視コンソール | `/druid/*`、`statViewServlet.enabled: true` |
| 慢SQL検知 | 1秒以上のクエリをログ出力 | `slow-sql-millis: 1000` |
| サーバー監視 | OSHI（OS/ハードウェア情報取得） | `ServerController`、`oshi-core 6.9.1` |
| オンラインユーザー監視 | リアルタイムセッション管理 | `SysUserOnlineController` |
| キャッシュ監視 | キャッシュ状態表示 | `CacheController` |

### 定時タスク

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| タスクスケジューラ | Quartz | `ruoyi-quartz`モジュール |
| 実行ログ | タスク実行履歴の記録 | `SysJobLog`テーブル |

### API文書

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| API文書生成 | Swagger 3.0（Springfox） | `swagger.enabled: true` |

## 互換性要件

### 動作環境

| 項目 | 要件 | 備考 |
| --- | --- | --- |
| Java バージョン | 1.8以上 | `pom.xml`（`java.version: 1.8`） |
| Spring Boot | 2.5.15 | `pom.xml` |
| データベース | MySQL | `application-druid.yml` |
| 文字エンコーディング | UTF-8 | `project.build.sourceEncoding: UTF-8` |
| タイムゾーン | GMT+8 | `spring.jackson.time-zone: GMT+8` |

### ブラウザ対応

| 項目 | 実装内容 | 備考 |
| --- | --- | --- |
| テンプレートエンジン | Thymeleaf | `spring.thymeleaf.mode: HTML` |
| 国際化 | messages.properties | `spring.messages.basename: static/i18n/messages` |

### URI設定

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| コンテキストパス | `/` | `server.servlet.context-path` |
| HTTPポート | 80 | `server.port: 80` |
| URIエンコーディング | UTF-8 | `server.tomcat.uri-encoding: UTF-8` |

## 備考

- 本ドキュメントはRuoYi管理システム バージョン4.8.2のソースコードを解析して作成されました
- 推奨値として記載された項目は、コード内に明示的な設定がないため、一般的なベストプラクティスに基づく値です
- CSRF対策はデフォルトで無効化されているため、本番環境では有効化を推奨します
- データベースのマスター/スレーブ構成はデフォルトで無効化されています
