---
generated_at: 2026-01-19 21:50:00
metrics:
  claims_total: 32
  claims_with_evidence: 28
  claims_without_evidence: 4
confidence_derived: 0.88
---

# 根拠レポート：インフラ設計意図書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：28 / 32、根拠なし：4
- 優先レビュー（高）
  1. **RTO/RPO目標値**：具体的な数値根拠が設定ファイルにない
  2. **業務要件ID（BR-001〜BR-005）**：推定された要件であり、実際の要件定義書との照合が必要
  3. **コスト試算値**：具体的な予算制約の根拠がコードにない
  4. **同時接続数の規模別閾値**：推定値であり、負荷テスト結果等との照合が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/インフラ設計書/インフラ設計書.md`
- E-02: `.env.example`
- E-03: `composer.json`
- E-04: `config/database.php`
- E-05: `config/cache.php`
- E-06: `config/queue.php`
- E-07: `config/session.php`
- E-08: `config/logging.php`
- E-09: `config/mail.php`
- E-10: `config/filesystems.php`
- E-11: `config/app.php`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Laravel 11.xベースのERPシステムである | E-01, E-03 | ○ |
| C-02 | PHP 8.2以上が必須である | E-03 | ○ |
| C-03 | FilamentPHP 4.xを使用している | E-03 | ○ |
| C-04 | SQLiteがデフォルトのデータベースである | E-02, E-04 | ○ |
| C-05 | MySQL/PostgreSQL/MariaDB/SQL Serverに対応している | E-04 | ○ |
| C-06 | セッションはdatabaseがデフォルトである | E-02, E-07 | ○ |
| C-07 | キャッシュはdatabaseがデフォルトである | E-02, E-05 | ○ |
| C-08 | キューはdatabaseがデフォルトである | E-02, E-06 | ○ |
| C-09 | Redisに対応している | E-04, E-05, E-06 | ○ |
| C-10 | Memcachedに対応している | E-05, E-07 | ○ |
| C-11 | AWS S3に対応している | E-10 | ○ |
| C-12 | AWS SQSに対応している | E-06 | ○ |
| C-13 | AWS DynamoDBに対応している | E-05 | ○ |
| C-14 | ログはstack/single/dailyに対応している | E-08 | ○ |
| C-15 | Slack Webhook連携に対応している | E-08 | ○ |
| C-16 | Papertrail連携に対応している | E-08 | ○ |
| C-17 | メールはlog/smtp/ses/postmark/resendに対応している | E-09 | ○ |
| C-18 | メールのfailover機能がある | E-09 | ○ |
| C-19 | PHP CLI Workers=4がデフォルトである | E-02 | ○ |
| C-20 | BCRYPT rounds=12である | E-02, E-11 | ○ |
| C-21 | AES-256-CBC暗号化を使用している | E-11 | ○ |
| C-22 | セッションはHttpOnly、SameSite=Laxである | E-07 | ○ |
| C-23 | ログローテーションは14日がデフォルトである | E-08 | ○ |
| C-24 | Laravel Sail（Docker）に対応している | E-03 | ○ |
| C-25 | メンテナンスモードはfile/cacheドライバーに対応している | E-02, E-11 | ○ |
| C-26 | 失敗ジョブはfailed_jobsテーブルに記録される | E-06 | ○ |
| C-27 | セッションライフタイムは120分がデフォルトである | E-02, E-07 | ○ |
| C-28 | プラグインベースの拡張アーキテクチャである | E-03 | ○ |
| C-29 | RTO目標は数時間〜1時間以内である | **根拠なし** | △ |
| C-30 | RPO目標は24時間以内である | **根拠なし** | △ |
| C-31 | 業務要件ID（BR-001〜BR-005）が存在する | **根拠なし** | △ |
| C-32 | 同時接続数の規模別閾値（100/1,000人等）が適切である | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **RTO/RPO目標値**: 設定ファイルやドキュメントに具体的なSLA目標の記載がない。実際の運用要件は顧客ごとに異なると推測されるため、インフラ設計書に記載された一般的な推奨値を基に設計意図を推定した
  - 候補：運用マニュアル / SLA定義書 / 顧客要件定義書
- **業務要件ID**: 正式な業務要件定義書が確認できなかった。ERPシステムの一般的な要件とコードベースの機能から推定した要件IDを付与した
  - 候補：業務要件定義書 / ユーザーストーリー / 製品仕様書
- **コスト試算値**: 具体的な月額予算やコスト目標の記載がない。オープンソースERPとしての一般的な価格帯を想定して記載した
  - 候補：価格表 / 見積書 / コスト計算シート
- **同時接続数の閾値**: 負荷テスト結果や性能要件の記載がない。インフラ設計書の推奨構成を基に規模別の閾値を推定した
  - 候補：負荷テスト結果 / 性能要件定義書 / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - クラウドプラットフォーム選定（非依存設計）：設定ファイルの環境変数ベース設計から明確に確認可能
- **0: 低リスク** - データストア選定：config/database.php、config/cache.php等から全ドライバー対応が確認可能
- **0: 低リスク** - 監視・ログ設計：config/logging.phpから対応チャンネルが明確に確認可能
- **1: 中リスク** - スケーリング戦略：設計意図は推定可能だが、具体的なスケーリング設定・閾値はコードに含まれない
- **1: 中リスク** - 可用性・冗長性設計：failover等の機能は確認可能だが、具体的なSLA目標は推定値
- **2: 高リスク** - RTO/RPO目標：根拠となる文書がなく、業務要件との整合性は要確認
- **2: 高リスク** - 業務要件との対応：推定された要件IDであり、実際の業務要件との照合が必要

## 6) レビュアーチェックリスト（最小）
- [ ] RTO/RPO目標値が実際の顧客要件と整合しているか確認する
- [ ] 業務要件ID（BR-001〜BR-005）が正式な要件定義と一致しているか確認する
- [ ] コスト試算値（月額予算等）が実際の価格帯と整合しているか確認する
- [ ] 同時接続数の閾値が負荷テスト結果と整合しているか確認する
- [ ] 「推測される」「可能性が高い」と記載された箇所が適切か確認する
- [ ] 代替案として記載された選択肢が網羅的か確認する
- [ ] 各設計判断の「不採用理由」が妥当か確認する
