---
generated_at: 2026-01-19 22:00:00
metrics:
  claims_total: 45
  claims_with_evidence: 41
  claims_without_evidence: 4
confidence_derived: 0.91
---

# 根拠レポート：セキュリティ設計意図書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：41 / 45、根拠なし：4
- 優先レビュー（高）
  1. **業務要件ID（BR-001〜BR-005）の具体的定義**：明示的な要件定義書がなく推測に基づく
  2. **将来のセキュリティ強化計画**：計画文書がなく推測に基づく
  3. **法令対応の具体的実装状況**：法令チェックリスト等の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `docs/code-to-docs/セキュリティ設計書/セキュリティ設計書.md`
- E-02: `config/auth.php`
- E-03: `config/session.php`
- E-04: `config/app.php`
- E-05: `config/filament-shield.php`
- E-06: `config/logging.php`
- E-07: `app/Providers/Filament/AdminPanelProvider.php`
- E-08: `plugins/webkul/security/src/Models/User.php`
- E-09: `plugins/webkul/security/src/Policies/UserPolicy.php`
- E-10: `plugins/webkul/website/src/Filament/Customer/Auth/Register.php`
- E-11: `app/Models/User.php`
- E-12: `composer.json`
- E-13: `plugins/webkul/*/src/Policies/*.php`（80以上のPolicyファイル）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | セッションベースパスワード認証を採用 | E-01, E-02, E-07 | ○ |
| C-02 | 認証ガードはweb（管理者用）とcustomer（顧客用）の2種類 | E-02 | ○ |
| C-03 | パスワードはbcryptでハッシュ化 | E-01, E-11 | ○ |
| C-04 | パスワードリセットトークン有効期限60分 | E-02 | ○ |
| C-05 | パスワード確認タイムアウト10800秒（3時間） | E-02 | ○ |
| C-06 | ユーザー登録時のRate Limitingは2回/試行 | E-10 | ○ |
| C-07 | メール検証機能が有効（AdminPanel） | E-07 | ○ |
| C-08 | session()->regenerate()でセッション固定化対策 | E-10 | ○ |
| C-09 | RBAC（Spatie Permission + Filament Shield）を採用 | E-05, E-07, E-08 | ○ |
| C-10 | super_adminは無効化されている | E-05 | ○ |
| C-11 | パネルユーザーのデフォルトロールはAdmin | E-05 | ○ |
| C-12 | 80以上のリソースに個別権限設定 | E-05, E-13 | ○ |
| C-13 | 権限は11種類（view_any, view, create等） | E-05 | ○ |
| C-14 | 権限名はlower_snake形式 | E-05 | ○ |
| C-15 | セッションドライバーはdatabase | E-03 | ○ |
| C-16 | セッション有効期限は120分 | E-03 | ○ |
| C-17 | HTTPOnly Cookieはtrue | E-03 | ○ |
| C-18 | Same-Site属性はlax | E-03 | ○ |
| C-19 | セッション暗号化はfalse（デフォルト） | E-03 | ○ |
| C-20 | AES-256-CBC暗号化を採用 | E-04 | ○ |
| C-21 | APP_KEYは環境変数で管理 | E-04 | ○ |
| C-22 | APP_PREVIOUS_KEYSでキーローテーション対応 | E-04 | ○ |
| C-23 | EncryptCookiesミドルウェアでCookie暗号化 | E-07 | ○ |
| C-24 | VerifyCsrfTokenミドルウェアでCSRF対策 | E-07 | ○ |
| C-25 | Eloquent ORMでSQLインジェクション対策 | E-01, E-08 | ○ |
| C-26 | $fillable属性でMass Assignment対策 | E-08, E-11 | ○ |
| C-27 | $hidden属性でpassword, remember_tokenを隠蔽 | E-11 | ○ |
| C-28 | ログはdailyドライバーで14日保持 | E-06 | ○ |
| C-29 | Slackチャネルはcriticalレベルで通知 | E-06 | ○ |
| C-30 | 非推奨警告はnullで無効化 | E-06 | ○ |
| C-31 | bezhansalleh/filament-shield ^4.0を使用 | E-12 | ○ |
| C-32 | filament/filament ^4.1を使用 | E-12 | ○ |
| C-33 | laravel/framework ^11.9を使用 | E-12 | ○ |
| C-34 | PHP 8.2以上が必要 | E-12 | ○ |
| C-35 | Userモデルはユーザープロバイダーとしてwebkul\Security\Models\User | E-02, E-05 | ○ |
| C-36 | CustomerモデルはWebkul\Website\Models\Partner | E-02 | ○ |
| C-37 | Policy定義はFilament Shieldで自動生成可能 | E-05 | ○ |
| C-38 | 認証ミドルウェアスタックは9つのミドルウェアを含む | E-07 | ○ |
| C-39 | Password::default()でパスワードバリデーション | E-10 | ○ |
| C-40 | Hash::make()でパスワードをハッシュ化 | E-10 | ○ |
| C-41 | FilamentShieldPluginがAdminPanelに登録 | E-07 | ○ |
| C-42 | 業務要件ID（BR-001〜BR-005）の定義 | **根拠なし** | △ |
| C-43 | 将来のセキュリティ強化計画（MFA、OAuth等） | **根拠なし** | △ |
| C-44 | 法令対応（個人情報保護法、不正アクセス禁止法）の具体的実装 | **根拠なし** | △ |
| C-45 | ROI・コスト比較の具体的数値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **業務要件定義書の不在**: 業務要件ID（BR-001〜BR-005）は実際のコードや設計書からの推測であり、明示的な要件定義書が確認できませんでした
  - 候補：requirements.md / 業務要件定義書 / ヒアリング記録

- **将来計画の文書不在**: MFA追加、OAuth対応等の将来計画は推測に基づいており、ロードマップ等の根拠文書がありません
  - 候補：ROADMAP.md / セキュリティ強化計画書 / バックログ

- **法令対応チェックリスト不在**: 個人情報保護法等への対応は機能から推測しており、明示的なコンプライアンスチェックリストが確認できませんでした
  - 候補：コンプライアンスチェックシート / 法令対応マトリクス

- **コスト・ROI根拠不在**: セキュリティ対策のコスト比較や投資対効果は一般論に基づいており、具体的な数値根拠がありません
  - 候補：見積書 / ROI分析書 / コスト比較表

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 認証・認可の実装詳細（C-01〜C-41）：ソースコードで確認可能
- **1: 中リスク** - 業務要件との紐付け（C-42）：推測に基づくが、実装内容は確認可能
- **1: 中リスク** - 法令対応（C-44）：機能は存在するが、網羅性の確認が必要
- **2: 高リスク** - 将来計画（C-43）：根拠なく、計画変更の可能性あり
- **0: 低リスク** - コスト比較（C-45）：定性的な記述で問題なし

## 6) レビュアーチェックリスト（最小）

- [ ] 認証設定（config/auth.php）の内容が設計意図書と一致しているか確認
- [ ] セッション設定（config/session.php）の内容が設計意図書と一致しているか確認
- [ ] Filament Shield設定（config/filament-shield.php）のsuper_admin無効化を確認
- [ ] AdminPanelProviderのミドルウェアスタックがセキュリティ要件を満たしているか確認
- [ ] 80以上のPolicyファイルが存在し、適切な権限チェックが実装されているか確認
- [ ] Rate Limiting（2回/試行）が適切か、業務要件との整合性を確認
- [ ] ログ保持期間（14日）が法令・業務要件を満たしているか確認
- [ ] 業務要件ID（BR-001〜BR-005）の妥当性をステークホルダーと確認
- [ ] 将来のセキュリティ強化計画がプロジェクト計画と整合しているか確認
- [ ] 法令対応の網羅性を法務・コンプライアンス部門と確認
