---
generated_at: 2026-01-19 22:15:00
metrics:
  claims_total: 42
  claims_with_evidence: 38
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：データベース設計意図書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：38 / 42、根拠なし：4
- 優先レビュー（高）
  1. **業務要件ID（BR-xxx）との対応**: 類推による命名であり、実際の要件定義書が存在しない
  2. **パフォーマンス影響の定量評価**: 実測値なし、設計時の推測に基づく
  3. **ROI（投資対効果）の具体値**: 定量的な評価データなし
  4. **将来のスケーラビリティ要件**: 具体的なデータ量・トラフィック予測なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/データベース設計書/データベース設計書.md`
- E-02: `database/migrations/0001_01_01_000000_create_users_table.php`
- E-03: `plugins/webkul/products/database/migrations/2025_01_05_100751_create_products_products_table.php`
- E-04: `plugins/webkul/sales/database/migrations/2025_02_05_053212_create_sales_orders_table.php`
- E-05: `plugins/webkul/purchases/database/migrations/2025_02_11_101110_create_purchases_orders_table.php`
- E-06: `plugins/webkul/partners/database/migrations/2024_12_11_101220_create_partners_partners_table.php`
- E-07: `plugins/webkul/inventories/database/migrations/2025_01_14_133260_create_inventories_moves_table.php`
- E-08: `plugins/webkul/accounts/database/migrations/2025_02_11_055303_create_accounts_account_moves_table.php`
- E-09: `plugins/webkul/employees/database/migrations/2024_12_12_063353_create_employees_employees_table.php`
- E-10: `plugins/webkul/products/src/Models/Product.php`
- E-11: `app/Models/User.php`
- E-12: Laravelフレームワーク標準（公知の情報）
- E-13: spatie/laravel-permission パッケージ（公知の情報）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 主キー戦略としてAUTO_INCREMENT（bigint unsigned）を採用 | E-02, E-03, E-04, E-05, E-06 | ○ |
| C-02 | 全テーブルで`$table->id()`を使用 | E-02〜E-09 | ○ |
| C-03 | 論理削除を主要エンティティに採用（softDeletes） | E-02, E-03, E-06, E-09 | ○ |
| C-04 | purchases_ordersは物理削除なし（timestampsのみ） | E-05 | ○ |
| C-05 | inventories_movesは物理削除なし | E-07 | ○ |
| C-06 | 金額型としてdecimal(15,4)を採用 | E-03, E-04, E-05, E-08 | ○ |
| C-07 | 為替レートはdecimal(15,6)で精度確保 | E-05 | ○ |
| C-08 | partners_partnersにname, tax_id, phone等のインデックス設定 | E-06 | ○ |
| C-09 | purchases_ordersにname, state, priority, 日付等のインデックス設定 | E-05 | ○ |
| C-10 | 外部キー制約でRESTRICTを重要関係に適用 | E-03, E-04, E-05, E-07 | ○ |
| C-11 | 外部キー制約でSET NULLを担当者・作成者に適用 | E-04, E-05, E-06 | ○ |
| C-12 | 外部キー制約でCASCADEを親子関係に適用 | E-03 | ○ |
| C-13 | creator_idによる作成者追跡を全主要テーブルに設置 | E-02〜E-09 | ○ |
| C-14 | created_at/updated_atによる監査証跡 | E-02〜E-09 | ○ |
| C-15 | HasLogActivityトレイトによる変更履歴追跡 | E-10 | ○ |
| C-16 | HasChatterトレイトによる活動履歴 | E-10 | ○ |
| C-17 | sales_ordersにamount_untaxed, amount_tax, amount_totalを非正規化保持 | E-04 | ○ |
| C-18 | purchases_ordersにuntaxed_amount, tax_amount, total_amountを非正規化保持 | E-05 | ○ |
| C-19 | products_categoriesにfull_name, parent_pathを保持 | E-01 | ○ |
| C-20 | products_productsにparent_idで自己参照（バリエーション管理） | E-03 | ○ |
| C-21 | employees_employeesにparent_id（上司）で自己参照 | E-09 | ○ |
| C-22 | partners_partnersにaccount_type, sub_typeで顧客・仕入先区分管理 | E-06 | ○ |
| C-23 | company_idによるマルチテナント対応 | E-03, E-04, E-05, E-06, E-07, E-08, E-09 | ○ |
| C-24 | JSON型をimages, sending_data等に使用 | E-03, E-08 | ○ |
| C-25 | stateカラムでステータス管理（varchar） | E-04, E-05, E-07, E-08 | ○ |
| C-26 | inventories_movesにsource_location_id/destination_location_idで移動元・先管理 | E-07 | ○ |
| C-27 | accounts_account_movesにinalterable_hashで改ざん検知 | E-08 | ○ |
| C-28 | Laravelの$table->id()がbigint unsigned AUTO_INCREMENTを生成 | E-12 | ○ |
| C-29 | spatie/laravel-permissionによる権限管理 | E-01, E-13 | ○ |
| C-30 | 命名規則「モジュール名_テーブル名」の一貫適用 | E-02〜E-09 | ○ |
| C-31 | ピボットテーブルで多対多関係を管理 | E-01 | ○ |
| C-32 | users.emailにユニーク制約 | E-02 | ○ |
| C-33 | sessions.last_activityにインデックス | E-02 | ○ |
| C-34 | employees_employeesとusersをuser_idで連携 | E-09 | ○ |
| C-35 | 退職者管理にdeparture_reason_id, departure_dateを使用 | E-09 | ○ |
| C-36 | sales_ordersとpurchases_ordersの構造的類似性 | E-04, E-05 | ○ |
| C-37 | 受発注から会計仕訳への連携テーブルが存在 | E-01 | ○ |
| C-38 | Filament管理画面との親和性を考慮した設計 | E-10 | ○ |
| C-39 | 業務要件ID（BR-xxx）は類推による命名 | **根拠なし** | △ |
| C-40 | Excel管理継続との比較における定量的ROI | **根拠なし** | △ |
| C-41 | パフォーマンス影響の実測値 | **根拠なし** | △ |
| C-42 | 将来のデータ量・トラフィック予測 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **業務要件定義書が不在**
  - 業務要件ID（BR-xxx）は設計意図書作成時に類推で命名したもの
  - 候補：要件定義書 / ユーザーストーリー / ヒアリング記録
- **パフォーマンス計測データが不在**
  - インデックス戦略や非正規化の効果は推測に基づく
  - 候補：ベンチマーク結果 / APMデータ / クエリ実行計画
- **投資対効果（ROI）の定量データが不在**
  - Excel管理継続との比較は定性的な記述のみ
  - 候補：導入前後の工数比較 / エラー率比較 / コスト試算
- **将来予測の根拠が不在**
  - スケーラビリティ考慮は一般論に基づく
  - 候補：事業計画 / 成長予測 / データ量見積もり

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 主キー戦略、削除方式、データ型選択 - マイグレーションファイルから明確に確認可能
- **0（低リスク）**: インデックス設定 - マイグレーションファイルから明確に確認可能
- **0（低リスク）**: 外部キー制約 - マイグレーションファイルから明確に確認可能
- **1（中リスク）**: 履歴管理方式 - トレイト使用は確認できるが、実際の動作確認は未実施
- **1（中リスク）**: 非正規化の選択理由 - 設計意図は推測であり、開発者の意図確認が望ましい
- **2（高リスク）**: 業務要件との対応 - 要件定義書が不在のため、類推に基づく記述
- **2（高リスク）**: ROI・効果の定量評価 - データに基づかない記述

## 6) レビュアーチェックリスト（最小）
- [ ] 主キー戦略（AUTO_INCREMENT）がプロジェクトの要件に適合しているか確認
- [ ] 論理削除対象テーブルの選定が監査要件を満たしているか確認
- [ ] インデックス設定が実際の検索パターンに適合しているか確認
- [ ] 外部キー制約のON DELETE戦略が業務フローに適合しているか確認
- [ ] 非正規化された金額サマリーの更新タイミングと整合性確保方法を確認
- [ ] 業務要件ID（BR-xxx）の命名を正式な要件定義と照合・修正
- [ ] 将来のスケーラビリティ要件について、実際の事業計画と照合
- [ ] Excel管理継続との比較について、ステークホルダーと定性評価を確認
