---
generated_at: 2026-01-19 00:00:00
metrics:
  claims_total: 156
  claims_with_evidence: 134
  claims_without_evidence: 22
confidence_derived: 0.86
---

# 根拠レポート：機能設計意図書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：134 / 156、根拠なし：22
- 優先レビュー（高）
  1. **業務工数の推定値**：実際の業務量データがないため、推定に依存
  2. **月間件数の想定**：企業規模・業種により大きく異なる可能性
  3. **工数削減効果**：導入前後の実測値ではなく推定値

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/機能設計書/1-プラグイン管理.md`
- E-02: `docs/code-to-docs/機能設計書/2-ユーザー管理.md`
- E-03: `docs/code-to-docs/機能設計書/3-ロール管理.md`
- E-04: `docs/code-to-docs/機能設計書/4-会社管理.md`
- E-05: `docs/code-to-docs/機能設計書/5-チーム管理.md`
- E-06: `docs/code-to-docs/機能設計書/6-カスタムフィールド管理.md`
- E-07: `docs/code-to-docs/機能設計書/7-テーブルビュー管理.md`
- E-08: `docs/code-to-docs/機能設計書/8-アナリティクス.md`
- E-09: `docs/code-to-docs/機能設計書/9-チャッター.md`
- E-10: `docs/code-to-docs/機能設計書/10-フルカレンダー.md`
- E-11: `docs/code-to-docs/機能設計書/11-サポート.md`
- E-12: `docs/code-to-docs/機能設計書/12-見積書管理.md`
- E-13: `docs/code-to-docs/機能設計書/13-受注管理.md`
- E-14: `docs/code-to-docs/機能設計書/14-顧客管理.md`
- E-15: `docs/code-to-docs/機能設計書/15-商品管理_販売.md`
- E-16: `docs/code-to-docs/機能設計書/16-請求対象管理.md`
- E-17: `docs/code-to-docs/機能設計書/17-販売チーム管理.md`
- E-18: `docs/code-to-docs/機能設計書/18-見積テンプレート管理.md`
- E-19: `docs/code-to-docs/機能設計書/19-商品カテゴリ管理_販売.md`
- E-20: `docs/code-to-docs/機能設計書/20-商品属性管理_販売.md`
- E-21: `docs/code-to-docs/機能設計書/21-パッケージング管理(販売).md`
- E-22: `docs/code-to-docs/機能設計書/22-タグ管理(販売).md`
- E-23: `docs/code-to-docs/機能設計書/23-活動タイプ管理(販売).md`
- E-24: `docs/code-to-docs/機能設計書/24-活動プラン管理(販売).md`
- E-25: `docs/code-to-docs/機能設計書/25-発注書管理.md`
- E-26: `docs/code-to-docs/機能設計書/26-見積依頼(RFQ)管理.md`
- E-27: `docs/code-to-docs/機能設計書/27-仕入先管理.md`
- E-28: `docs/code-to-docs/機能設計書/28-商品管理(購買).md`
- E-29: `docs/code-to-docs/機能設計書/29-購買依頼管理.md`
- E-30: `docs/code-to-docs/機能設計書/30-商品カテゴリ管理(購買).md`
- E-31: `docs/code-to-docs/機能設計書/31-仕入先価格管理.md`
- E-32: `docs/code-to-docs/機能設計書/32-商品属性管理_購買.md`
- E-33: `docs/code-to-docs/機能設計書/33-パッケージング管理_購買.md`
- E-34: `docs/code-to-docs/機能設計書/34-倉庫管理.md`
- E-35: `docs/code-to-docs/機能設計書/35-ロケーション管理.md`
- E-36: `docs/code-to-docs/機能設計書/36-在庫移動管理.md`
- E-37: `docs/code-to-docs/機能設計書/37-在庫調整.md`
- E-38: `docs/code-to-docs/機能設計書/38-ルート管理.md`
- E-39: `docs/code-to-docs/機能設計書/39-ストレージカテゴリ管理.md`
- E-40: `docs/code-to-docs/機能設計書/40-パッケージタイプ管理.md`
- E-41: `docs/code-to-docs/機能設計書/F041-商品カテゴリ管理(在庫).md`
- E-42: `docs/code-to-docs/機能設計書/51-顧客請求書管理.md`
- E-43: `docs/code-to-docs/機能設計書/52-返金管理_仕入.md`
- E-44: `docs/code-to-docs/機能設計書/53-支払管理.md`
- E-45: `docs/code-to-docs/機能設計書/54-ベンダー管理.md`
- E-46: `docs/code-to-docs/機能設計書/55-商品管理_請求.md`
- E-47: `docs/code-to-docs/機能設計書/56-インコターム管理.md`
- E-48: `docs/code-to-docs/機能設計書/57-決済処理.md`
- E-49: `docs/code-to-docs/機能設計書/58-決済トランザクション管理.md`
- E-50: `docs/code-to-docs/機能設計書/59-商品マスタ管理.md`
- E-51: `docs/code-to-docs/機能設計書/60-商品カテゴリ管理.md`
- E-52: `docs/code-to-docs/機能設計書/61-商品属性管理.md`
- E-53: `docs/code-to-docs/機能設計書/62-価格リスト管理.md`
- E-54: `docs/code-to-docs/機能設計書/63-パッケージング管理.md`
- E-55: `docs/code-to-docs/機能設計書/64-パートナー管理.md`
- E-56: `docs/code-to-docs/機能設計書/65-住所管理.md`
- E-57: `docs/code-to-docs/機能設計書/66-連絡先管理.md`
- E-58: `docs/code-to-docs/機能設計書/67-パートナー関係管理.md`
- E-59: `docs/code-to-docs/機能設計書/68-従業員管理.md`
- E-60: `docs/code-to-docs/機能設計書/69-部門管理.md`
- E-61: `docs/code-to-docs/機能設計書/70-職位管理.md`
- E-62: `docs/code-to-docs/機能設計書/71-スキルタイプ管理.md`
- E-63: `docs/code-to-docs/機能設計書/72-勤務カレンダー管理.md`
- E-64: `docs/code-to-docs/機能設計書/73-従業員カテゴリ管理.md`
- E-65: `docs/code-to-docs/機能設計書/74-勤務地管理.md`
- E-66: `docs/code-to-docs/機能設計書/75-雇用形態管理.md`
- E-67: `docs/code-to-docs/機能設計書/76-退職理由管理.md`
- E-68: `docs/code-to-docs/機能設計書/77-活動プラン管理(人事).md`
- E-69: `docs/code-to-docs/機能設計書/78-従業員スキルレポート.md`
- E-70: `docs/code-to-docs/機能設計書/79-応募者管理.md`
- E-71: `docs/code-to-docs/機能設計書/80-求人管理.md`
- E-72: `docs/code-to-docs/機能設計書/81-候補者管理.md`
- E-73: `docs/code-to-docs/機能設計書/82-採用ステージ管理.md`
- E-74: `docs/code-to-docs/機能設計書/83-学歴管理.md`
- E-75: `docs/code-to-docs/機能設計書/84-不採用理由管理.md`
- E-76: `docs/code-to-docs/機能設計書/85-応募者カテゴリ管理.md`
- E-77: `docs/code-to-docs/機能設計書/86-雇用形態管理（採用）.md`
- E-78: `docs/code-to-docs/機能設計書/87-スキルタイプ管理（採用）.md`
- E-79: `docs/code-to-docs/機能設計書/88-UTMソース管理.md`
- E-80: `docs/code-to-docs/機能設計書/89-UTMメディア管理.md`
- E-81: `docs/code-to-docs/機能設計書/90-活動タイプ管理（採用）.md`
- E-82: `docs/code-to-docs/機能設計書/91-活動プラン管理（採用）.md`
- E-83: `docs/code-to-docs/機能設計書/92-部門管理（採用）.md`
- E-84: `docs/code-to-docs/機能設計書/93-休暇申請管理.md`
- E-85: `docs/code-to-docs/機能設計書/94-自分の休暇管理.md`
- E-86: `docs/code-to-docs/機能設計書/95-休暇割当管理.md`
- E-87: `docs/code-to-docs/機能設計書/96-自分の休暇割当管理.md`
- E-88: `docs/code-to-docs/機能設計書/97-休暇タイプ管理.md`
- E-89: `docs/code-to-docs/機能設計書/98-休暇発生プラン管理.md`
- E-90: `docs/code-to-docs/機能設計書/99-祝日管理.md`
- E-91: `docs/code-to-docs/機能設計書/100-必須休暇日管理.md`
- E-92: `docs/code-to-docs/機能設計書/101-活動タイプ管理(休暇).md`
- E-93: `docs/code-to-docs/機能設計書/102-タイムシート管理.md`
- E-94: `docs/code-to-docs/機能設計書/103-プロジェクト管理.md`
- E-95: `docs/code-to-docs/機能設計書/104-タスク管理.md`
- E-96: `docs/code-to-docs/機能設計書/105-マイルストーン管理.md`
- E-97: `docs/code-to-docs/機能設計書/106-タスクステージ管理.md`
- E-98: `docs/code-to-docs/機能設計書/107-サブタスク管理.md`
- E-99: `docs/code-to-docs/機能設計書/108-タスク工数管理.md`
- E-100: `docs/code-to-docs/機能設計書/109-ブログ記事管理.md`
- E-101: `docs/code-to-docs/機能設計書/110-ブログカテゴリ管理.md`
- E-102: `docs/code-to-docs/機能設計書/111-ブログタグ管理.md`
- E-103: `docs/code-to-docs/機能設計書/112-ページ管理.md`
- E-104: `docs/code-to-docs/機能設計書/113-ウェブサイトパートナー管理.md`
- E-105: `docs/code-to-docs/機能設計書/114-連絡先設定管理.md`
- E-106: `docs/code-to-docs/機能設計書/F042-請求書管理.md`
- E-107: `docs/code-to-docs/機能設計書/F043-返金管理.md`
- E-108: `docs/code-to-docs/機能設計書/F044-仕訳帳管理.md`
- E-109: `docs/code-to-docs/機能設計書/F045-税グループ管理.md`
- E-110: `docs/code-to-docs/機能設計書/F046-税管理.md`
- E-111: `docs/code-to-docs/機能設計書/F047-財政ポジション管理.md`
- E-112: `docs/code-to-docs/機能設計書/F048-銀行口座管理.md`
- E-113: `docs/code-to-docs/機能設計書/F049-支払条件管理.md`
- E-114: `docs/code-to-docs/機能設計書/F050-請求書管理(仕入).md`
- E-115: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

### ドメイン概要に関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AureusERPは統合業務管理（ERP）システムである | E-01〜E-114（機能設計書全体） | ○ |
| C-02 | 製造業、卸売・小売業、サービス業、一般企業で利用可能 | E-12, E-25, E-59, E-93（各業務機能の存在） | ○ |
| C-03 | 主なステークホルダーとして営業、購買、倉庫、経理、人事、PM、管理者が存在 | E-12, E-25, E-34, E-42, E-59, E-93, E-01（各機能の利用者記載） | ○ |
| C-04 | システムは基幹業務を統合管理するハブシステムとして位置づけられる | E-01〜E-114（販売・購買・在庫・会計・人事・プロジェクトの各機能群） | ○ |

### ドメイン共通課題に関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | 業務データの分断（サイロ化）が一般的な課題である | **根拠なし** | △ |
| C-06 | 見積もり・発注業務の属人化が一般的な課題である | E-12, E-25（見積・発注機能の業務背景記載） | ○ |
| C-07 | 在庫管理の不正確さが一般的な課題である | E-34, E-36（在庫管理機能の業務背景記載） | ○ |
| C-08 | 人事情報管理の煩雑さが一般的な課題である | E-59, E-84（人事・休暇管理の業務背景記載） | ○ |
| C-09 | プロジェクト工数管理の困難さが一般的な課題である | E-93, E-94（タイムシート・プロジェクト管理の業務背景記載） | ○ |

### 業務プロセスに関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | 販売プロセスは見積もり→受注→出荷→請求の流れ | E-12, E-13, E-42, E-115（業務要件一覧） | ○ |
| C-11 | 購買プロセスは見積依頼→発注→入庫→支払の流れ | E-25, E-26, E-44, E-115 | ○ |
| C-12 | 在庫管理プロセスは入庫→保管→出庫→棚卸の流れ | E-34, E-35, E-36, E-37 | ○ |
| C-13 | 会計プロセスは請求→入金/支払→仕訳の流れ | E-42, E-44, E-108 | ○ |
| C-14 | 人事管理プロセスは入社→勤務→退職の流れ | E-59, E-60, E-67 | ○ |
| C-15 | 採用プロセスは募集→選考→採用決定の流れ | E-70, E-71, E-73 | ○ |
| C-16 | 休暇管理プロセスは申請→承認→取得の流れ | E-84, E-85, E-86 | ○ |
| C-17 | プロジェクト管理プロセスはプロジェクト→タスク→工数の流れ | E-93, E-94, E-95 | ○ |

### 業務工数に関する主張（推定値）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | 見積書手動作成に月500件×15分=月125時間かかる | **根拠なし（推定）** | △ |
| C-19 | 受注入力に月500件×10分=月83時間かかる | **根拠なし（推定）** | △ |
| C-20 | 請求書作成に月500件×10分=月83時間かかる | **根拠なし（推定）** | △ |
| C-21 | 見積依頼作成に月300件×15分=月75時間かかる | **根拠なし（推定）** | △ |
| C-22 | 発注書作成に月300件×15分=月75時間かかる | **根拠なし（推定）** | △ |
| C-23 | 入出庫記録に月2000件×5分=月167時間かかる | **根拠なし（推定）** | △ |
| C-24 | 休暇申請処理に月100件×10分=月17時間かかる | **根拠なし（推定）** | △ |
| C-25 | 工数集計に月1000件×2分=月33時間かかる | **根拠なし（推定）** | △ |

### 機能の存在に関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | プラグイン管理機能が存在する | E-01 | ○ |
| C-27 | ユーザー管理機能が存在する | E-02 | ○ |
| C-28 | ロール管理機能が存在する | E-03 | ○ |
| C-29 | 会社管理機能が存在する | E-04 | ○ |
| C-30 | チーム管理機能が存在する | E-05 | ○ |
| C-31 | カスタムフィールド管理機能が存在する | E-06 | ○ |
| C-32 | テーブルビュー管理機能が存在する | E-07 | ○ |
| C-33 | アナリティクス機能が存在する | E-08 | ○ |
| C-34 | チャッター機能が存在する | E-09 | ○ |
| C-35 | フルカレンダー機能が存在する | E-10 | ○ |
| C-36 | サポート機能が存在する | E-11 | ○ |
| C-37 | 見積書管理機能が存在する | E-12 | ○ |
| C-38 | 受注管理機能が存在する | E-13 | ○ |
| C-39 | 顧客管理機能が存在する | E-14 | ○ |
| C-40 | 商品管理（販売）機能が存在する | E-15 | ○ |
| C-41 | 請求対象管理機能が存在する | E-16 | ○ |
| C-42 | 販売チーム管理機能が存在する | E-17 | ○ |
| C-43 | 見積テンプレート管理機能が存在する | E-18 | ○ |
| C-44 | 商品カテゴリ管理（販売）機能が存在する | E-19 | ○ |
| C-45 | 商品属性管理（販売）機能が存在する | E-20 | ○ |
| C-46 | パッケージング管理（販売）機能が存在する | E-21 | ○ |
| C-47 | タグ管理（販売）機能が存在する | E-22 | ○ |
| C-48 | 活動タイプ管理（販売）機能が存在する | E-23 | ○ |
| C-49 | 活動プラン管理（販売）機能が存在する | E-24 | ○ |
| C-50 | 発注書管理機能が存在する | E-25 | ○ |
| C-51 | 見積依頼（RFQ）管理機能が存在する | E-26 | ○ |
| C-52 | 仕入先管理機能が存在する | E-27 | ○ |
| C-53 | 商品管理（購買）機能が存在する | E-28 | ○ |
| C-54 | 購買依頼管理機能が存在する | E-29 | ○ |
| C-55 | 商品カテゴリ管理（購買）機能が存在する | E-30 | ○ |
| C-56 | 仕入先価格管理機能が存在する | E-31 | ○ |
| C-57 | 商品属性管理（購買）機能が存在する | E-32 | ○ |
| C-58 | パッケージング管理（購買）機能が存在する | E-33 | ○ |
| C-59 | 倉庫管理機能が存在する | E-34 | ○ |
| C-60 | ロケーション管理機能が存在する | E-35 | ○ |
| C-61 | 在庫移動管理機能が存在する | E-36 | ○ |
| C-62 | 在庫調整機能が存在する | E-37 | ○ |
| C-63 | ルート管理機能が存在する | E-38 | ○ |
| C-64 | ストレージカテゴリ管理機能が存在する | E-39 | ○ |
| C-65 | パッケージタイプ管理機能が存在する | E-40 | ○ |
| C-66 | 商品カテゴリ管理（在庫）機能が存在する | E-41 | ○ |
| C-67 | 顧客請求書管理機能が存在する | E-42 | ○ |
| C-68 | 返金管理（仕入）機能が存在する | E-43 | ○ |
| C-69 | 支払管理機能が存在する | E-44 | ○ |
| C-70 | ベンダー管理機能が存在する | E-45 | ○ |
| C-71 | 商品管理（請求）機能が存在する | E-46 | ○ |
| C-72 | インコターム管理機能が存在する | E-47 | ○ |
| C-73 | 決済処理機能が存在する | E-48 | ○ |
| C-74 | 決済トランザクション管理機能が存在する | E-49 | ○ |
| C-75 | 商品マスタ管理機能が存在する | E-50 | ○ |
| C-76 | 商品カテゴリ管理機能が存在する | E-51 | ○ |
| C-77 | 商品属性管理機能が存在する | E-52 | ○ |
| C-78 | 価格リスト管理機能が存在する | E-53 | ○ |
| C-79 | パッケージング管理機能が存在する | E-54 | ○ |
| C-80 | パートナー管理機能が存在する | E-55 | ○ |
| C-81 | 住所管理機能が存在する | E-56 | ○ |
| C-82 | 連絡先管理機能が存在する | E-57 | ○ |
| C-83 | パートナー関係管理機能が存在する | E-58 | ○ |
| C-84 | 従業員管理機能が存在する | E-59 | ○ |
| C-85 | 部門管理機能が存在する | E-60 | ○ |
| C-86 | 職位管理機能が存在する | E-61 | ○ |
| C-87 | スキルタイプ管理機能が存在する | E-62 | ○ |
| C-88 | 勤務カレンダー管理機能が存在する | E-63 | ○ |
| C-89 | 従業員カテゴリ管理機能が存在する | E-64 | ○ |
| C-90 | 勤務地管理機能が存在する | E-65 | ○ |
| C-91 | 雇用形態管理機能が存在する | E-66 | ○ |
| C-92 | 退職理由管理機能が存在する | E-67 | ○ |
| C-93 | 活動プラン管理（人事）機能が存在する | E-68 | ○ |
| C-94 | 従業員スキルレポート機能が存在する | E-69 | ○ |
| C-95 | 応募者管理機能が存在する | E-70 | ○ |
| C-96 | 求人管理機能が存在する | E-71 | ○ |
| C-97 | 候補者管理機能が存在する | E-72 | ○ |
| C-98 | 採用ステージ管理機能が存在する | E-73 | ○ |
| C-99 | 学歴管理機能が存在する | E-74 | ○ |
| C-100 | 不採用理由管理機能が存在する | E-75 | ○ |
| C-101 | 応募者カテゴリ管理機能が存在する | E-76 | ○ |
| C-102 | 雇用形態管理（採用）機能が存在する | E-77 | ○ |
| C-103 | スキルタイプ管理（採用）機能が存在する | E-78 | ○ |
| C-104 | UTMソース管理機能が存在する | E-79 | ○ |
| C-105 | UTMメディア管理機能が存在する | E-80 | ○ |
| C-106 | 活動タイプ管理（採用）機能が存在する | E-81 | ○ |
| C-107 | 活動プラン管理（採用）機能が存在する | E-82 | ○ |
| C-108 | 部門管理（採用）機能が存在する | E-83 | ○ |
| C-109 | 休暇申請管理機能が存在する | E-84 | ○ |
| C-110 | 自分の休暇管理機能が存在する | E-85 | ○ |
| C-111 | 休暇割当管理機能が存在する | E-86 | ○ |
| C-112 | 自分の休暇割当管理機能が存在する | E-87 | ○ |
| C-113 | 休暇タイプ管理機能が存在する | E-88 | ○ |
| C-114 | 休暇発生プラン管理機能が存在する | E-89 | ○ |
| C-115 | 祝日管理機能が存在する | E-90 | ○ |
| C-116 | 必須休暇日管理機能が存在する | E-91 | ○ |
| C-117 | 活動タイプ管理（休暇）機能が存在する | E-92 | ○ |
| C-118 | タイムシート管理機能が存在する | E-93 | ○ |
| C-119 | プロジェクト管理機能が存在する | E-94 | ○ |
| C-120 | タスク管理機能が存在する | E-95 | ○ |
| C-121 | マイルストーン管理機能が存在する | E-96 | ○ |
| C-122 | タスクステージ管理機能が存在する | E-97 | ○ |
| C-123 | サブタスク管理機能が存在する | E-98 | ○ |
| C-124 | タスク工数管理機能が存在する | E-99 | ○ |
| C-125 | ブログ記事管理機能が存在する | E-100 | ○ |
| C-126 | ブログカテゴリ管理機能が存在する | E-101 | ○ |
| C-127 | ブログタグ管理機能が存在する | E-102 | ○ |
| C-128 | ページ管理機能が存在する | E-103 | ○ |
| C-129 | ウェブサイトパートナー管理機能が存在する | E-104 | ○ |
| C-130 | 連絡先設定管理機能が存在する | E-105 | ○ |
| C-131 | 請求書管理機能が存在する | E-106 | ○ |
| C-132 | 返金管理機能が存在する | E-107 | ○ |
| C-133 | 仕訳帳管理機能が存在する | E-108 | ○ |
| C-134 | 税グループ管理機能が存在する | E-109 | ○ |
| C-135 | 税管理機能が存在する | E-110 | ○ |
| C-136 | 財政ポジション管理機能が存在する | E-111 | ○ |
| C-137 | 銀行口座管理機能が存在する | E-112 | ○ |
| C-138 | 支払条件管理機能が存在する | E-113 | ○ |
| C-139 | 請求書管理（仕入）機能が存在する | E-114 | ○ |

### 技術設計判断に関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-140 | トランザクション境界はユースケース単位 | E-12, E-25（トランザクション仕様記載） | ○ |
| C-141 | バリデーションは入力層＋ドメイン層の2層 | E-12, E-59（バリデーション仕様記載） | ○ |
| C-142 | 共通処理はトレイトで実装 | E-59, E-70（HasChatter, HasLogActivity等の記載） | ○ |
| C-143 | 状態管理はEnumを使用 | E-12, E-25, E-70（State Enum記載） | ○ |
| C-144 | 論理削除はSoftDeletesを使用 | E-02, E-59, E-70（SoftDeletes記載） | ○ |
| C-145 | 権限管理はFilament Shield + Spatie Permission | E-01, E-02, E-70（権限管理記載） | ○ |
| C-146 | UI基盤はFilament v3 | E-01〜E-114（全機能でFilament使用） | ○ |

### 工数削減効果に関する主張（推定値）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-147 | 見積書作成で83時間削減 | **根拠なし（推定）** | △ |
| C-148 | 受注入力で66時間削減 | **根拠なし（推定）** | △ |
| C-149 | 請求書作成で66時間削減 | **根拠なし（推定）** | △ |
| C-150 | 発注書作成で60時間削減 | **根拠なし（推定）** | △ |
| C-151 | 入出庫記録で100時間削減 | **根拠なし（推定）** | △ |
| C-152 | 休暇申請処理で14時間削減 | **根拠なし（推定）** | △ |
| C-153 | 工数集計で28時間削減 | **根拠なし（推定）** | △ |

### その他の主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-154 | 114件の機能設計書が存在する | E-01〜E-114（ファイル一覧） | ○ |
| C-155 | 83件の業務要件が存在する | E-115（業務要件一覧.csv） | ○ |
| C-156 | 二重入力により月20〜40時間の工数増加 | **根拠なし（一般論）** | △ |

## 4) 不足情報（Unknown / Missing）

- **実際の業務量データ**: 月間の見積件数、発注件数、入出庫件数などの実測値がないため、工数は一般的なERP導入企業を想定した推定値
  - 候補: 導入企業へのヒアリング / 業界標準データ / 過去のERP導入事例
- **導入前後の比較データ**: 手動運用時の工数と、システム導入後の工数の実測値がない
  - 候補: PoC実施時の計測 / パイロット導入時の計測
- **業界別の課題の根拠**: 「業務データの分断」などのドメイン共通課題は、ERP業界の一般論であり、特定の調査レポート等の引用はない
  - 候補: ERP導入効果に関する調査レポート / コンサルティングファームの白書

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 対象 | 内容 |
|---|---|---|
| 1（中リスク） | 工数推定値 | 実測値ではなく推定のため、顧客説明時には「想定値」であることを明示する必要あり |
| 1（中リスク） | 月間件数 | 企業規模・業種により大きく異なるため、幅を持った説明が必要 |
| 0（低リスク） | 機能の存在 | 114件の機能設計書に基づいており、根拠は十分 |
| 0（低リスク） | 技術設計判断 | 機能設計書に明記されており、根拠は十分 |

## 6) レビュアーチェックリスト（最小）

- [ ] 工数推定値が「推定値」であることが明示されているか確認
- [ ] 月間件数の想定が顧客企業の実態と乖離していないか確認
- [ ] 業務プロセスの流れが顧客の実業務と合致しているか確認
- [ ] 機能の存在の主張が機能設計書と整合しているか確認
- [ ] 技術設計判断の記載がアーキテクチャ設計意図書と重複・矛盾していないか確認
- [ ] ドメイン共通課題の記載が顧客業界の実態と合致しているか確認
