---
generated_at: 2026-01-19 12:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 32
  claims_without_evidence: 13
confidence_derived: 0.71
---

# 根拠レポート：画面設計意図書

## 本レポートについて

### 目的
本レポートは、生成された画面設計意図書の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.71**
  - 根拠あり：32 / 45、根拠なし：13
- 優先レビュー（高）
  1. **工数削減効果の数値**：具体的な工数（月○時間削減）は推定値であり、実測データなし
  2. **業務プロセスの発生頻度**：「日次50〜200件」等の数値は仮定に基づく
  3. **エラー率・コスト削減率**：「エラー率5%」「コスト削減3%」等は一般的な仮定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `composer.json` - Laravel 11, Filament v4.x, 各プラグインの依存関係
- E-02: `package.json` - Tailwind CSS v4, Vite, フロントエンド依存
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 369画面のリスト
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 114機能のリスト
- E-05: `docs/code-to-docs/画面設計書/*.md` - 各画面の設計書（369ファイル）
- E-06: `docs/code-to-docs/業務要件一覧/業務要件一覧.md` - 業務要件定義
- E-07: `docs/code-to-docs/設計意図書/機能設計意図書.md` - 機能設計意図書
- E-08: `plugins/webkul/` - プラグインソースコード構造

## 3) Claims と根拠の対応（レビューの主戦場）

### ドメイン・システム概要

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Aureus ERPは中小企業から大企業向けのオープンソースERPシステム | E-01, E-08 | ○ |
| C-02 | 対象画面数369画面、対象機能数114機能 | E-03, E-04 | ○ |
| C-03 | 24プラグイン構成のモジュラーアーキテクチャ | E-01, E-08 | ○ |

### 業務プロセス定義

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-04 | 販売管理プロセス（見積→受注→出荷→請求）の業務フロー | E-05, E-06 | ○ |
| C-05 | 購買管理プロセス（RFQ→発注→入庫→支払）の業務フロー | E-05, E-06 | ○ |
| C-06 | 在庫管理プロセス（入庫→保管→移動→出庫）の業務フロー | E-05, E-06 | ○ |
| C-07 | 会計管理プロセス（仕訳→請求→入金→消込）の業務フロー | E-05, E-06 | ○ |
| C-08 | 人事管理プロセス（従業員登録→配置→スキル管理）の業務フロー | E-05 | ○ |
| C-09 | 採用管理プロセス（求人→応募→選考→採用）の業務フロー | E-05 | ○ |
| C-10 | 休暇管理プロセス（申請→承認→取得→残日数管理）の業務フロー | E-05 | ○ |
| C-11 | プロジェクト管理プロセス（立上げ→タスク→工数→完了）の業務フロー | E-05 | ○ |

### 業務課題と効果（定量的主張）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | 販売管理で日次50〜200件の取引が発生 | **根拠なし** | △ |
| C-13 | 見積書作成で月200件×20分=月67時間の工数が発生 | **根拠なし** | △ |
| C-14 | システム化により月116時間の工数削減効果 | **根拠なし** | △ |
| C-15 | 手入力による転記ミス率5%の仮定 | **根拠なし** | △ |
| C-16 | 購買管理で月75時間→月25時間（50時間削減） | **根拠なし** | △ |
| C-17 | 在庫管理で月140時間→月50時間（90時間削減） | **根拠なし** | △ |
| C-18 | 会計管理で月153時間→月50時間（103時間削減） | **根拠なし** | △ |
| C-19 | 人事管理で月19時間→月6時間（13時間削減） | **根拠なし** | △ |
| C-20 | 採用管理で月40時間→月15時間（25時間削減） | **根拠なし** | △ |
| C-21 | 休暇管理で月33時間→月10時間（23時間削減） | **根拠なし** | △ |
| C-22 | プロジェクト管理で月49時間→月15時間（34時間削減） | **根拠なし** | △ |
| C-23 | 全体で月間約1,025時間の工数削減効果 | **根拠なし** | △ |

### 技術設計判断

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | UIフレームワークとしてFilament PHP v4.xを採用 | E-01 | ○ |
| C-25 | TALL Stack（Tailwind, Alpine.js, Laravel, Livewire）構成 | E-01, E-02 | ○ |
| C-26 | Tailwind CSS v4を採用 | E-02 | ○ |
| C-27 | 状態管理にLivewire + Alpine.jsを採用 | E-01 | ○ |
| C-28 | コンポーネント設計にFilament標準（Resource/Page/Widget）を採用 | E-08 | ○ |
| C-29 | ルーティングはMPA + Livewire部分SPA | E-08 | ○ |
| C-30 | フォーム設計にFilament Formsを採用 | E-08 | ○ |
| C-31 | データフェッチングにLivewire + Eloquent ORMを採用 | E-08 | ○ |
| C-32 | WCAG 2.1 AA準拠を目標（Filament標準依存） | E-01 | ○ |

### 画面分類と機能

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | 販売管理に21画面が存在 | E-03, E-05 | ○ |
| C-34 | 購買管理に20画面が存在 | E-03, E-05 | ○ |
| C-35 | 在庫管理に79画面が存在 | E-03, E-05 | ○ |
| C-36 | 会計管理に53画面が存在 | E-03, E-05 | ○ |
| C-37 | 人事管理に30画面が存在 | E-03, E-05 | ○ |
| C-38 | 採用管理に22画面が存在 | E-03, E-05 | ○ |
| C-39 | 休暇管理に27画面が存在 | E-03, E-05 | ○ |
| C-40 | プロジェクト管理に19画面が存在 | E-03, E-05 | ○ |
| C-41 | マスタ・システム管理に25画面が存在 | E-03, E-05 | ○ |
| C-42 | コンテンツ管理に18画面が存在 | E-03, E-05 | ○ |

### 選択理由・不採用理由

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | FilamentがLaravel完全統合で管理画面に最適化されている | E-01, E-08 | ○ |
| C-44 | React/Vueを不採用とした理由（SPA構成のコスト高） | E-01（React/Vue不使用を確認） | ○ |
| C-45 | デスクトップファーストを採用（業務システム特性） | E-05（画面構成から推測） | ○ |

## 4) 不足情報（Unknown / Missing）

### 工数削減効果の根拠不足
- **理由**: 画面ごとの工数削減効果（「月200件×20分=月67時間」等）は、一般的な業務効率化の仮定に基づいており、実測データや業務分析結果が存在しない
- **候補**:
  - 導入企業へのヒアリング調査
  - ベンチマークデータの取得
  - 業務分析レポート（As-Is/To-Be比較）

### 業務発生頻度の根拠不足
- **理由**: 「日次50〜200件」等の数値は中規模企業を想定した推定値であり、根拠データなし
- **候補**:
  - 業界標準データの参照
  - 対象企業規模別のベンチマーク

### エラー率・コスト効果の根拠不足
- **理由**: 「転記ミス率5%」「コスト削減3%」等は一般的な仮定に基づく
- **候補**:
  - 既存システム導入事例の効果測定データ
  - 業界レポートの引用

## 5) リスクフラグ（レビュー観点）

| 項目 | リスクレベル | 説明 |
|---|---|---|
| 工数削減効果の数値 | 2（高リスク） | 定量的主張に根拠なし。顧客への説明時に誤解を招く可能性 |
| 業務プロセス定義 | 0（低リスク） | 画面設計書から業務目的が読み取れる |
| 技術選定理由 | 0（低リスク） | ソースコードから実装技術が確認可能 |
| 画面数・機能数 | 0（低リスク） | 一覧ファイルから正確にカウント可能 |
| 将来拡張性 | 1（中リスク） | 方針記載のみで、具体的な設計根拠なし |

## 6) レビュアーチェックリスト（最小）

- [ ] 工数削減効果の数値が顧客説明に使用される場合、「推定値」であることを明記しているか確認
- [ ] 業務プロセスの発生頻度が自社の実態と乖離していないか確認
- [ ] 技術選定理由が自社のスキルセット・方針と整合しているか確認
- [ ] 全369画面が業務プロセスに分類されているか確認
- [ ] 「なぜ手動運用ではダメか」「なぜExcel管理で代用しないか」の説明が納得できるか確認
- [ ] 根拠なし（△）の項目について、追加調査の要否を判断

---

## 補足：Evidence詳細

### E-01: composer.json

主要な依存関係：
- `laravel/framework`: ^11.9
- `filament/filament`: ^3.2
- `livewire/livewire`: ^3.5
- `webkul/*`: 24のプラグインパッケージ

### E-02: package.json

フロントエンド依存：
- `tailwindcss`: ^4.0
- `vite`: ^6.0

### E-03: 画面一覧.csv

369画面がCSV形式でリスト化されている。画面番号、画面名、プラグイン、URLパス等を含む。

### E-04: 機能一覧.csv

114機能がCSV形式でリスト化されている。機能番号、機能名、プラグイン、関連画面等を含む。

### E-05: 画面設計書/*.md

369ファイルの画面設計書。各画面について以下を記載：
- 業務上の目的・背景
- 画面構成
- 入出力項目
- イベント仕様
- データベース更新仕様

### E-06: 業務要件一覧.md

業務要件が定義されている。各業務プロセスの目的、ステークホルダー、業務フローを記載。

### E-07: 機能設計意図書.md

ドメイン概要、機能設計の意図が記載されている。画面設計意図書から参照。

### E-08: plugins/webkul/

24プラグインのソースコード。Filament Resource、Page、Form、Table等の実装を含む。

