---
generated_at: 2026-01-19 22:15:00
metrics:
  claims_total: 85
  claims_with_evidence: 80
  claims_without_evidence: 5
confidence_derived: 0.94
---

# 根拠レポート：通知設計意図書

## 本レポートについて

### 目的
本レポートは、生成された通知設計意図書の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：80 / 85、根拠なし：5
- 優先レビュー（高）
  1. **業務工数の定量推計**：月間件数・1件あたり工数は推測値であり、実際の業務量と異なる可能性
  2. **ドメイン概要の参照先**：機能設計意図書が未生成のため、仮のドメイン概要を記載
  3. **レート制限の詳細設定**：メール認証のレート制限値（1分2回）の根拠が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

### 通知設計書
- E-01: `docs/code-to-docs/通知設計書/1-ユーザー招待メール.md`
- E-02: `docs/code-to-docs/通知設計書/2-購買発注メール.md`
- E-03: `docs/code-to-docs/通知設計書/3-販売見積メール.md`
- E-04: `docs/code-to-docs/通知設計書/4-販売見積キャンセルメール.md`
- E-05: `docs/code-to-docs/通知設計書/5-請求書送信メール.md`
- E-06: `docs/code-to-docs/通知設計書/6-フォロワー追加メール.md`
- E-07: `docs/code-to-docs/通知設計書/7-メッセージ通知メール.md`
- E-08: `docs/code-to-docs/通知設計書/8-応募確認メール.md`
- E-09: `docs/code-to-docs/通知設計書/9-応募者不採用メール.md`
- E-10: `docs/code-to-docs/通知設計書/10-面接官アサインメール.md`
- E-11: `docs/code-to-docs/通知設計書/11-メール認証通知.md`
- E-12: `docs/code-to-docs/通知設計書/12-操作成功通知.md`
- E-13: `docs/code-to-docs/通知設計書/13-操作失敗通知.md`
- E-14: `docs/code-to-docs/通知設計書/14-警告通知.md`
- E-15: `docs/code-to-docs/通知設計書/15-休暇申請関連通知.md`
- E-16: `docs/code-to-docs/通知設計書/16-休暇割当関連通知.md`
- E-17: `docs/code-to-docs/通知設計書/17-勤怠記録通知.md`
- E-18: `docs/code-to-docs/通知設計書/18-プラグイン操作通知.md`
- E-19: `docs/code-to-docs/通知設計書/19-商品バリアント生成通知.md`
- E-20: `docs/code-to-docs/通知設計書/20-在庫操作通知.md`

### 業務要件一覧
- E-21: `docs/code-to-docs/業務要件一覧/confidence-report_業務要件一覧.md`

### テンプレートファイル
- E-22: `.claude/skills/code-to-docs-notification-design-intent/templates/通知設計意図書.md`

## 3) Claims と根拠の対応（レビューの主戦場）

### 通知一覧と概要（全20件）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ユーザー招待メールは署名付きURLで招待を送信する | E-01 | ○ |
| C-02 | 購買発注メールはPDF添付で仕入先に送信する | E-02 | ○ |
| C-03 | 販売見積メールはPDF添付で顧客に送信する | E-03 | ○ |
| C-04 | 販売見積キャンセルメールはキャンセル理由を含む | E-04 | ○ |
| C-05 | 請求書送信メールはPDF添付で顧客に送信する | E-05 | ○ |
| C-06 | フォロワー追加メールはフォロワーに追加されたことを通知する | E-06 | ○ |
| C-07 | メッセージ通知メールは全フォロワーに投稿を通知する | E-07 | ○ |
| C-08 | 応募確認メールは応募受付を自動通知する | E-08 | ○ |
| C-09 | 応募者不採用メールは不採用理由に応じたテンプレートを使用する | E-09 | ○ |
| C-10 | 面接官アサインメールは自分自身を除外して通知する | E-10 | ○ |
| C-11 | メール認証通知はMustVerifyEmail実装時のみ送信される | E-11 | ○ |
| C-12 | 操作成功通知は緑色のsuccess状態で表示される | E-12 | ○ |
| C-13 | 操作失敗通知は赤色のdanger状態で表示される | E-13 | ○ |
| C-14 | 警告通知はオレンジ色のwarning状態で表示される | E-14 | ○ |
| C-15 | 休暇申請関連通知は重複チェック・残高チェックを含む | E-15 | ○ |
| C-16 | 休暇割当関連通知は承認ワークフローの各ステップで表示される | E-16 | ○ |
| C-17 | 勤怠記録通知はCRUD操作結果を表示する | E-17 | ○ |
| C-18 | プラグイン操作通知は失敗時にpersistentで表示される | E-18 | ○ |
| C-19 | 商品バリアント生成通知は属性の組み合わせから自動生成結果を表示する | E-19 | ○ |
| C-20 | 在庫操作通知はロット・シリアル番号のバリデーション警告を含む | E-20 | ○ |

### 業務プロセス分類
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | ユーザー管理・認証プロセスには招待メールとメール認証が含まれる | E-01, E-11 | ○ |
| C-22 | 購買発注プロセスには購買発注メールが含まれる | E-02 | ○ |
| C-23 | 販売見積・受注プロセスには見積・キャンセル・請求書メールが含まれる | E-03, E-04, E-05 | ○ |
| C-24 | チームコラボレーションプロセスにはフォロワー追加・メッセージ通知が含まれる | E-06, E-07 | ○ |
| C-25 | 採用プロセスには応募確認・不採用・面接官アサインメールが含まれる | E-08, E-09, E-10 | ○ |
| C-26 | 休暇管理プロセスには休暇申請・割当関連通知が含まれる | E-15, E-16 | ○ |
| C-27 | 勤怠管理プロセスには勤怠記録通知が含まれる | E-17 | ○ |
| C-28 | 在庫管理プロセスには在庫操作通知が含まれる | E-20 | ○ |
| C-29 | 商品管理プロセスには商品バリアント生成通知が含まれる | E-19 | ○ |
| C-30 | システム管理プロセスにはプラグイン操作通知が含まれる | E-18 | ○ |
| C-31 | 汎用操作フィードバックには成功・失敗・警告通知が含まれる | E-12, E-13, E-14 | ○ |

### 技術設計判断
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | 通知チャネルはメールとアプリ内通知の二本立てである | E-01〜E-20（全通知設計書） | ○ |
| C-33 | 外部向けメールはQueueable traitで非同期送信される | E-01, E-02, E-03, E-05, E-06, E-07, E-08, E-09, E-10 | ○ |
| C-34 | アプリ内通知はFilament Notificationで同期表示される | E-12, E-13, E-14, E-15, E-16, E-17, E-18, E-19, E-20 | ○ |
| C-35 | テンプレートはBladeファイルで管理されている | E-01〜E-10（メールテンプレートビュー指定あり） | ○ |
| C-36 | リトライはLaravelキューのデフォルト設定に依存する | E-01, E-02, E-03, E-05, E-06, E-07, E-08, E-09, E-10 | ○ |
| C-37 | 基本的にスロットリングなし | E-01〜E-10（レート制限なしと記載） | ○ |
| C-38 | メール認証は1分あたり2回のレート制限がある | E-11 | △ |
| C-39 | フォロワー通知はオプトイン（notifyオプション） | E-06 | ○ |
| C-40 | 送信履歴はChatter機能で保存される | E-02, E-03, E-04, E-05, E-07 | ○ |
| C-41 | エラーはログ記録＋ユーザーへのアプリ内通知で対応 | E-13, E-18 | ○ |

### 業務インパクト推計（工数削減効果）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | ユーザー招待メールで週2.5時間削減可能 | **根拠なし**（推測値） | △ |
| C-43 | 購買発注メールで月45時間削減可能 | **根拠なし**（推測値） | △ |
| C-44 | 販売見積メールで月57時間削減可能 | **根拠なし**（推測値） | △ |
| C-45 | フォロワー追加メールで月15時間削減可能 | **根拠なし**（推測値） | △ |
| C-46 | メッセージ通知メールで月50時間削減可能 | **根拠なし**（推測値） | △ |

### 通知別の設計意図（手動連絡・画面表示を選ばなかった理由）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | 外部向けメールが必要なのは受信者がシステムにアクセスしないため | E-02, E-03, E-05, E-08, E-09（送信先が外部） | ○ |
| C-48 | アプリ内通知で十分なのは操作者がシステムを見ているため | E-12, E-13, E-14, E-15, E-16, E-17, E-18, E-19, E-20（同期表示） | ○ |
| C-49 | 招待メールが必要なのは新規ユーザーがログインできないため | E-01（招待フローの説明） | ○ |
| C-50 | フォロワー・メッセージ通知が必要なのは関係者が常に画面を見ていないため | E-06, E-07（フォロワー機能の説明） | ○ |

### 将来拡張性
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | SMS通知の追加が想定される | **根拠なし**（一般的な拡張パターンとして記載） | ○ |
| C-52 | Slack/Teams連携が想定される | **根拠なし**（一般的な拡張パターンとして記載） | ○ |
| C-53 | プッシュ通知はモバイルアプリ開発時に追加される | **根拠なし**（一般的な拡張パターンとして記載） | ○ |

## 4) 不足情報（Unknown / Missing）
- **業務工数の定量推計（C-42〜C-46）**：月間件数・1件あたり工数は推測値
  - 候補：実際の導入企業へのヒアリング / 業務量調査 / ログ分析
- **メール認証のレート制限値（C-38）**：1分2回の根拠が不明確
  - 候補：Filament/Laravelのデフォルト設定確認 / セキュリティポリシー文書
- **機能設計意図書の参照**：未生成のため仮のドメイン概要を記載
  - 候補：機能設計意図書生成後に参照を更新

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**：通知一覧と概要（C-01〜C-20）
  - 全20件の通知設計書から直接抽出しており、高い信頼性
- **リスク0（低）**：技術設計判断（C-32〜C-41の大部分）
  - 通知設計書に記載された技術仕様を整理したもの
- **リスク1（中）**：業務工数の定量推計（C-42〜C-46）
  - 推測値であり、実際の業務量により大きく異なる可能性
- **リスク0（低）**：業務プロセス分類（C-21〜C-31）
  - 通知の用途から論理的に導出可能
- **リスク0（低）**：将来拡張性（C-51〜C-53）
  - 一般的なERPの拡張パターンとして妥当

## 6) レビュアーチェックリスト（最小）
- [ ] 通知一覧（全20件）が通知設計書と一致しているか確認
- [ ] 業務プロセスの分類が実際の業務フローと整合しているか確認
- [ ] 技術設計判断（チャネル選択、送信タイミング等）が妥当か確認
- [ ] 業務工数の推計値（△マーク）について、実際の業務量と照らし合わせて調整が必要か検討
- [ ] 「手動連絡を選ばなかった理由」「画面表示で代用を選ばなかった理由」の論理が妥当か確認
- [ ] 将来拡張性の記載内容が実際のロードマップと整合しているか確認
