# インフラ設計意図書

## 概要

本ドキュメントは、AureusERP（Laravel 11.xベースのエンタープライズ向けERPシステム）におけるインフラストラクチャ設計の意図・背景・選定理由を記載する。既存の「インフラ設計書.md」を基に、なぜこのような構成を採用したのか、どのような業務課題を解決しようとしているのかを明確にすることを目的とする。

---

## 業務要件との関連（なぜこのインフラ構成が必要か）

### 対応する業務要件
| 業務要件ID | 業務要件名 | インフラに求められる要件 |
| --- | --- | --- |
| BR-001 | ERP基盤の提供 | 中小企業から大規模企業まで対応可能なスケーラブルな基盤 |
| BR-002 | 多様な導入形態への対応 | オンプレミス、クラウド、コンテナ環境など多様な環境での稼働 |
| BR-003 | 低コストでの導入・運用 | 初期投資を抑えつつ、事業成長に応じた拡張が可能な構成 |
| BR-004 | システムの継続的な可用性 | 業務停止による機会損失を最小化する冗長構成 |
| BR-005 | セキュアなデータ管理 | 顧客・取引情報の保護、暗号化、アクセス制御 |

### 業務観点でのインフラ要件

#### 可用性・信頼性への業務要求
中小企業から大規模企業までをターゲットとするERPシステムとして、業務停止は直接的な売上機会損失や業務遅延に繋がる。特に受発注、在庫管理、会計処理などの基幹業務を担うため、システムの安定稼働が強く求められる。

| 項目 | 業務要求 | 根拠 |
| --- | --- | --- |
| 許容ダウンタイム | 小規模: 年間数時間 / 大規模: 月間数分以内 | 受発注業務の停止は売上機会損失に直結するため |
| 稼働時間帯 | 導入企業の業務時間に依存（24時間365日の可能性あり） | グローバル展開企業やEC連携企業では常時稼働が必要 |
| 災害時の業務継続 | 大規模導入では必須、小規模では任意 | BCP対応として、重要データの保護と迅速な復旧が必要 |

#### 性能・処理能力への業務要求
ERPシステムとして、日常的な業務処理から月末締め処理、年次決算処理まで多様な負荷パターンに対応する必要がある。

| 項目 | 業務要求 | 根拠 |
| --- | --- | --- |
| 応答時間 | 画面操作: 3秒以内、レポート生成: 30秒以内 | 業務担当者がストレスなく操作できる応答速度が必要 |
| 同時利用者数 | 小規模: 10-50人 / 中規模: 100-500人 / 大規模: 1,000人以上 | 企業規模に応じた同時接続に対応が必要 |
| ピーク時処理量 | 月末締め処理で通常の3-5倍の負荷 | 締め処理、決算処理時のバッチ実行に対応が必要 |

#### コスト・予算への業務制約
オープンソースERPとして、特に中小企業が導入しやすいコスト構造を実現する必要がある。

| 項目 | 制約 | 根拠 |
| --- | --- | --- |
| 月額インフラ予算 | 小規模: 数万円以内 / 中規模: 数十万円以内 | 中小企業のIT予算に合わせた構成が必要 |
| 初期投資上限 | 最小構成ではゼロ（SQLite使用）から可能 | オープンソースの利点を活かし、段階的投資を可能に |
| コスト最適化の優先度 | 高（小規模）/ 中（大規模） | 事業規模に応じて可用性とコストのバランスを調整 |

### 検討した構成案（業務観点）

| 案 | 概要 | メリット | デメリット | 業務適合性 |
| --- | --- | --- | --- | --- |
| A | シングルサーバー + SQLite | 最低コスト、簡易構成 | スケール困難、可用性低 | 小規模向け: 高 |
| B | 単一クラウドVM + MySQL | 低コスト、運用負荷小 | 冗長性なし、拡張に限界 | 中規模向け: 中 |
| C（採用） | 柔軟なDB/キャッシュ選択 + スケーラブル構成 | 段階的拡張可能、多様な環境対応 | 構成の複雑さが増す可能性 | 全規模対応: 高 |
| D | フルマネージド（Laravel Vapor等） | 運用負荷最小、自動スケール | コスト高め、ベンダー依存 | 大規模向け: 中 |

### 選択理由（業務観点）

本システムでは、**多様なDB・キャッシュドライバーに対応した柔軟なインフラ構成（案C）**を採用した。

1. **業務要件との適合性**: オープンソースERPとして、小規模企業から大規模企業まで幅広い顧客層に対応する必要がある。SQLiteからMySQL/PostgreSQL、ファイルキャッシュからRedisまで、企業の規模・予算に応じて最適な構成を選択できる柔軟性が業務要件を満たす。

2. **業務継続性の観点**: セッションとキャッシュをデータベースまたはRedisで管理することで、アプリケーションサーバーの冗長化が可能となり、障害時の業務影響を最小化できる。また、メール送信のfailover機能により、通知障害時も代替手段での業務継続が可能。

3. **将来の業務拡大への対応**: モノリシックアーキテクチャながらプラグインベースの拡張性を持ち、業務拡大に伴う機能追加にも対応可能。インフラ面では、ロードバランサー配下での水平スケーリングにより、利用者増加にも対応できる設計となっている。

4. **費用対効果（ROI）**: 初期導入時は最小構成（SQLite + ファイルキャッシュ）で開始し、事業成長に伴い段階的にインフラを強化できる。これにより、初期投資を抑えつつ、必要に応じた投資で最大の効果を得られる。

---

## 設計意図サマリー

| 設計論点 | 想定される選択肢 | 採用した方針 | 主な選択理由 |
| --- | --- | --- | --- |
| クラウド選定 | AWS / GCP / Azure / オンプレミス | クラウド非依存（マルチクラウド対応） | 顧客の既存環境に合わせた柔軟な導入を可能にするため |
| コンピューティング | コンテナ / サーバーレス / VM | VM/コンテナ両対応（Laravel Sail対応） | 開発環境のコンテナ化と本番環境の柔軟性を両立 |
| スケーリング | 水平 / 垂直 / オートスケール | 水平スケーリング対応（ステートレス設計） | セッションの外部化により複数インスタンスでの運用を可能に |
| 可用性設計 | シングルAZ / マルチAZ / マルチリージョン | 構成依存（シングル〜マルチAZまで対応） | 顧客の可用性要件に応じて選択可能な設計 |

---

## 設計判断と根拠

### 1. クラウドプラットフォーム選定

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| AWS | Amazon Web Services | 最大シェア、サービス豊富、S3/SES等との親和性 | コスト高め、学習曲線 |
| GCP | Google Cloud Platform | データ分析強い、K8s親和性 | シェア小さい |
| Azure | Microsoft Azure | エンタープライズ強い、MS連携 | 学習コスト |
| オンプレミス | 自社データセンター | 完全制御、コンプライアンス対応 | 初期投資大、運用負荷高 |
| クラウド非依存 | 特定クラウドに依存しない設計 | 移植性高い、顧客選択の自由 | 各クラウド固有機能の活用が制限 |

#### 採用した方針
**クラウド非依存（マルチクラウド対応）設計**を採用。特定のクラウドベンダーに依存せず、AWS S3/SES/SQS/DynamoDB、および標準的なRDB（MySQL/PostgreSQL/MariaDB/SQL Server）に対応した構成。

#### 選択理由

1. **背景にあると推察する業務課題**:
   - ERPシステムの導入を検討する企業は、既に自社でITインフラを保有していることが多い
   - 特定クラウドへのロックインは、既存投資の無駄や移行コストの発生に繋がる
   - 中小企業ではオンプレミスやレンタルサーバーでの運用も多い

2. **業務課題に対するアプローチ方針**:
   - 環境変数ベースの設定切り替えにより、同一コードベースで多様な環境に対応
   - AWS S3、SES、SQS等への対応を「オプション」として提供し、必要な企業のみが利用
   - 標準的なLaravel機能を活用することで、特殊な設定なしでの動作を保証

3. **期待される業務改善効果**:
   - 顧客の既存IT資産を活用した導入が可能になり、導入コスト・期間を削減
   - ベンダーロックインを回避し、将来のクラウド移行やマルチクラウド戦略に対応可能
   - 各企業のセキュリティポリシー・コンプライアンス要件に柔軟に対応

#### 不採用とした選択肢の理由
- **AWS専用設計**: 市場シェアは大きいが、オンプレミス運用や他クラウド利用企業への対応が困難になる
- **オンプレミス専用設計**: クラウドの柔軟性・スケーラビリティを活かせず、現代のインフラ要件を満たさない

---

### 2. コンピューティングリソース

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| コンテナ（Docker/K8s） | コンテナオーケストレーション | ポータブル、リソース効率、環境再現性 | 学習コスト、運用複雑化の可能性 |
| サーバーレス（Lambda/Vapor） | イベント駆動、従量課金 | 運用不要、コスト最適 | コールドスタート、実行時間制限 |
| VM（EC2/Compute Engine） | 仮想マシン | 自由度高い、既存ノウハウ活用 | リソース効率やや低い |
| PaaS（App Engine等） | マネージドアプリ基盤 | 運用負荷小 | 柔軟性制限、ベンダーロックイン |

#### 採用した方針
**VM/コンテナ両対応**を採用。開発環境ではLaravel Sail（Docker）によるコンテナ化、本番環境では従来のVM/物理サーバーでの運用を標準としつつ、Docker/Kubernetes運用も可能な構成。

#### リソース構成
| コンポーネント | 実行環境 | スペック | 選択理由 |
| --- | --- | --- | --- |
| Webサーバー | Nginx（推奨）/ Apache | 任意（負荷に応じて調整） | Nginxの高パフォーマンスと静的ファイル配信効率 |
| APサーバー | PHP-FPM / PHP 8.2以上 | PHP CLI Workers: 4（デフォルト） | Laravel 11.xの要件、FilamentPHP 4.xの要件 |
| DBサーバー | SQLite / MySQL 8.0+ / PostgreSQL / MariaDB | 負荷に応じて選択 | 小規模はSQLite、中〜大規模はMySQL/PostgreSQL |
| キャッシュサーバー | Redis 6.x以上（オプション） | 任意 | 高負荷環境でのパフォーマンス向上 |

#### 選択理由

1. **背景にあると推察する業務課題**:
   - 開発チームのスキルセット・運用体制は企業により大きく異なる
   - コンテナ運用の経験がない企業も多く、導入障壁となる可能性がある
   - 一方、モダンな開発プラクティスとしてコンテナ化のニーズも高い

2. **業務課題に対するアプローチ方針**:
   - Laravel Sailにより、開発環境のセットアップを簡素化（Docker未経験者でも利用可能）
   - 本番環境は顧客の運用体制に合わせて選択可能（VM、コンテナ、PaaS）
   - PHP CLI Workers設定により、単一サーバーでも並列処理が可能

3. **期待される業務改善効果**:
   - 開発環境の構築時間短縮（数時間→数分）
   - 環境差異による本番障害の削減
   - 運用チームの既存スキルを活かした本番環境構築

#### 不採用とした選択肢の理由
- **サーバーレス専用設計（Lambda/Vapor）**: ERPシステムの長時間バッチ処理やステートフルな操作に制約がある。また、コールドスタートによる応答遅延がユーザー体験を損なう可能性がある
- **Kubernetes必須設計**: 運用複雑化と学習コストが高く、小規模企業での導入障壁となる

---

### 3. スケーリング戦略

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| 垂直スケール | インスタンスサイズ増加 | シンプル、設定変更のみ | 上限あり、ダウンタイム発生 |
| 水平スケール | インスタンス数増加 | 上限なし、高可用性 | 状態管理必要、ロードバランサー必要 |
| オートスケール | 負荷に応じて自動調整 | 効率的、コスト最適 | 設定複雑、予測困難な負荷に対応難 |
| 固定キャパシティ | 常に一定のリソース | 予測可能、シンプル | コスト非効率、ピーク対応困難 |

#### 採用した方針
**水平スケーリング対応（ステートレス設計）**を採用。セッションとキャッシュをデータベースまたはRedisに外部化し、複数インスタンスでの運用を可能にする設計。

#### スケーリング設定
| コンポーネント | 方式 | 閾値（推奨） | 上限/下限 | 選択理由 |
| --- | --- | --- | --- | --- |
| Webサーバー | 水平スケール | CPU 70%以上 | 1〜N台 | ステートレス化により容易に追加可能 |
| キューワーカー | 水平スケール | キュー滞留1,000件以上 | 1〜N台 | 独立プロセスとして並列実行可能 |
| データベース | 垂直スケール + レプリカ | コネクション使用率80%以上 | 構成依存 | 読み取り負荷はレプリカで分散 |

#### 選択理由

1. **背景にあると推察する業務課題**:
   - ERPシステムは月末締め処理や年次決算時に負荷が集中する傾向がある
   - 事業成長に伴い利用者数が増加しても、システム再構築なしで対応したい
   - 通常時と繁忙期で大きく負荷が異なり、固定リソースでは非効率

2. **業務課題に対するアプローチ方針**:
   - `SESSION_DRIVER=database`（デフォルト）または`redis`により、セッションを外部化
   - `CACHE_STORE=database`（デフォルト）または`redis`により、キャッシュを外部化
   - ロードバランサー配下での複数インスタンス運用を想定した設計

3. **期待される業務改善効果**:
   - 繁忙期の負荷増大にも、インスタンス追加のみで対応可能
   - 単一障害点の排除による可用性向上
   - 負荷に応じたリソース調整によるコスト最適化

#### 不採用とした選択肢の理由
- **垂直スケールのみ**: スケールアップ時のダウンタイムが業務に影響。また、上限があるため大規模利用に対応困難
- **固定キャパシティ**: 繁忙期に対応するために常時高スペックを維持するとコスト非効率

---

### 4. 可用性・冗長性設計

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| シングルインスタンス | 単一サーバー構成 | コスト最小、シンプル | 単一障害点、メンテナンス時停止 |
| マルチインスタンス | 複数サーバー + ロードバランサー | 障害耐性、ローリングデプロイ | コスト増、構成複雑化 |
| マルチAZ | 複数アベイラビリティゾーンに分散 | AZ障害に耐性 | コスト増、レイテンシ増の可能性 |
| マルチリージョン | 複数リージョンに分散 | 地域障害に耐性、DR対応 | コスト高い、データ同期複雑 |

#### 採用した方針
**構成依存の柔軟な可用性設計**を採用。小規模はシングルインスタンス、中規模以上はマルチインスタンス構成を推奨し、顧客の可用性要件に応じて選択可能。

#### 冗長化構成
| コンポーネント | 冗長化方式 | フェイルオーバー時間 | 選択理由 |
| --- | --- | --- | --- |
| アプリケーション層 | ロードバランサー + 複数インスタンス | 即時（ヘルスチェック間隔依存） | ステートレス設計により自動フェイルオーバー |
| データベース層 | マスター・スレーブレプリケーション | 数秒〜数分（構成依存） | クラウドマネージドDB使用時は自動フェイルオーバー |
| キャッシュ層 | Redis Sentinel / Cluster（大規模時） | 数秒 | キャッシュ消失時もDBフォールバックで業務継続 |
| メール送信 | failover機能（SMTP → log） | 即時 | 通知障害時も記録は継続し、後から再送可能 |

#### 選択理由

1. **背景にあると推察する業務課題**:
   - 小規模企業では可用性よりもコストが優先されることが多い
   - 大規模企業ではシステム停止が大きな機会損失に繋がるため、冗長化が必須
   - メンテナンス時のダウンタイムも業務に影響を与える

2. **業務課題に対するアプローチ方針**:
   - `APP_MAINTENANCE_DRIVER=file`または`cache`によるメンテナンスモード制御
   - セッション外部化による複数インスタンス運用対応
   - メール送信のfailover設定により、障害時もログ出力にフォールバック

3. **期待される業務改善効果**:
   - 企業規模に応じた最適な可用性レベルの実現
   - 計画メンテナンス時のダウンタイム削減（ローリングデプロイ対応）
   - 障害発生時の自動復旧による業務影響の最小化

#### 不採用とした選択肢の理由
- **マルチリージョン必須設計**: 全ての導入企業にとってオーバースペック。コストと複雑さが増大し、小規模企業の導入を阻害する
- **シングルインスタンス固定**: 中〜大規模企業の可用性要件を満たせない

---

### 5. ネットワーク設計

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| パブリックサブネットのみ | 全リソースにパブリックIP | シンプル、設定容易 | セキュリティリスク高 |
| パブリック+プライベート | 層に応じて分離 | セキュリティ向上、標準的構成 | NAT必要、コスト増 |
| プライベートのみ | 全リソースプライベート | 高セキュリティ | アクセス複雑、VPN必須 |

#### 採用した方針
**パブリック+プライベートサブネット構成（推奨）**を採用。Web層はパブリック、DB・キャッシュ層はプライベートに配置する標準的な3層構成。

#### ネットワーク構成
| 要素 | 設定 | 他の選択肢 | 選択理由 |
| --- | --- | --- | --- |
| Web層 | パブリックサブネット / HTTP:80, HTTPS:443 | プライベート+ALB | 直接アクセス可能、ALBも利用可能 |
| DB層 | プライベートサブネット / MySQL:3306, PostgreSQL:5432 | パブリックアクセス | セキュリティ確保、外部からの攻撃防止 |
| キャッシュ層 | プライベートサブネット / Redis:6379, Memcached:11211 | パブリックアクセス | 内部通信のみ許可 |

#### 選択理由

1. **背景にあると推察する業務課題**:
   - ERPシステムは機密性の高い業務データを扱うため、セキュリティが重要
   - 一方で、従業員がインターネット経由でアクセスする必要がある
   - データベースへの直接攻撃を防止する必要がある

2. **業務課題に対するアプローチ方針**:
   - 3層アーキテクチャ（Web/AP/DB）による責務分離
   - プライベートサブネットによるDB・キャッシュの保護
   - ポート構成の明確化による適切なファイアウォール設定

3. **期待される業務改善効果**:
   - 外部からのデータベース直接攻撃を防止
   - ネットワーク層でのセキュリティ確保により、アプリケーション層の負担軽減
   - 監査・コンプライアンス要件への対応が容易

---

### 6. データストア選定

#### 想定される選択肢（RDB）

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| SQLite | 組み込みRDB | 設定不要、ファイルベース | スケール困難、同時接続制限 |
| MySQL 8.0+ | 最も普及したRDB | 実績豊富、情報多い | 商用ライセンス注意 |
| PostgreSQL | 高機能RDB | JSON対応、拡張性 | 学習コストやや高 |
| MariaDB | MySQLフォーク | オープンソース、高互換 | 一部機能差異 |
| SQL Server | Microsoft RDB | Windowsとの親和性 | ライセンスコスト |

#### 想定される選択肢（キャッシュ/セッション）

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| ファイル | ファイルシステム | 設定不要、シンプル | スケール困難、I/O負荷 |
| データベース | RDBテーブル | 追加インフラ不要、永続化 | パフォーマンスやや劣る |
| Redis | インメモリKVS | 高速、多機能 | 追加インフラ必要 |
| Memcached | インメモリキャッシュ | シンプル、高速 | 永続化不可、機能限定 |
| DynamoDB | AWSマネージドKVS | サーバーレス、スケーラブル | AWSロックイン |

#### 採用した方針
**マルチドライバー対応**を採用。RDBはSQLite/MySQL/PostgreSQL/MariaDB/SQL Serverから選択可能、キャッシュ/セッションはデータベース（デフォルト）/Redis/Memcached/DynamoDBから選択可能。

#### データストア構成
| 用途 | サービス | 構成 | 他の選択肢 | 選択理由 |
| --- | --- | --- | --- | --- |
| 業務データ | SQLite（デフォルト）→ MySQL/PostgreSQL | 単一→レプリカ構成 | 各種RDB | 規模に応じた選択を可能に |
| セッション | database（デフォルト）→ redis | RDBテーブル/Redis | file/memcached | 外部化によるスケーラビリティ確保 |
| キャッシュ | database（デフォルト）→ redis | RDBテーブル/Redis | file/memcached | 追加インフラなしで開始可能 |
| キュー | database（デフォルト）→ redis/sqs | RDBテーブル/Redis/SQS | sync/beanstalkd | 非同期処理の信頼性確保 |

#### 選択理由

1. **背景にあると推察する業務課題**:
   - 導入企業のIT環境・スキルセットは多様
   - 初期導入時は最小構成で開始し、成長に伴い拡張したい
   - 既存のデータベース資産を活用したい企業も多い

2. **業務課題に対するアプローチ方針**:
   - 環境変数（`DB_CONNECTION`、`CACHE_STORE`、`SESSION_DRIVER`、`QUEUE_CONNECTION`）による設定切り替え
   - デフォルト設定（SQLite + database）で追加インフラなしに動作
   - 成長に伴うRedis導入や、AWS環境でのSQS/DynamoDB活用をサポート

3. **期待される業務改善効果**:
   - 導入初期のインフラコスト削減
   - 段階的なインフラ強化による投資最適化
   - 既存環境・スキルの活用による運用負荷軽減

---

### 7. 監視・ログ・アラート

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| CloudWatch/Cloud Monitoring | クラウドネイティブ監視 | 統合済み、設定容易 | ベンダーロックイン |
| Datadog | SaaS監視プラットフォーム | 多機能、統合ダッシュボード | コスト高い |
| Prometheus + Grafana | OSS監視スタック | 柔軟、コスト低い | 運用負荷 |
| New Relic | APM特化 | アプリ性能可視化 | コスト高い |
| アプリケーションログ | Laravelログ機能 | 追加コスト不要 | 分析機能限定 |

#### 採用した方針
**Laravelログ機能 + 外部連携オプション**を採用。基本はLaravelのログ機能（stack/single/daily）を使用し、必要に応じてSlack、Papertrail、Syslog等に連携可能。

#### 監視構成
| 対象 | ツール | メトリクス | アラート条件 | 選択理由 |
| --- | --- | --- | --- | --- |
| アプリエラー | storage/logs/laravel.log | ERRORレベル以上 | 発生時即時 | 標準機能で対応 |
| キュー滞留 | jobs テーブル監視 | 滞留件数 | 1,000件以上 | バッチ処理遅延の検知 |
| 失敗ジョブ | failed_jobs テーブル監視 | 失敗件数 | 1件以上 | 処理失敗の即時検知 |
| 重大エラー | Slack Webhook | CRITICALレベル | 発生時即時 | 即時通知による迅速対応 |

#### 選択理由

1. **背景にあると推察する業務課題**:
   - 小規模企業では高額な監視ツールの導入が困難
   - 一方で、業務に影響するエラーは即時に検知したい
   - ログの長期保存・分析も必要な場合がある

2. **業務課題に対するアプローチ方針**:
   - `LOG_CHANNEL=stack`でログチャンネルを柔軟に構成
   - `LOG_DAILY_DAYS=14`で14日分のログローテーションをデフォルト設定
   - Slack Webhook連携により、重大エラーの即時通知を実現
   - Papertrail/Syslog連携により、ログの外部保存・分析を可能に

3. **期待される業務改善効果**:
   - 追加コストなしでの基本的な監視・ログ管理
   - 重大エラーの即時検知による業務影響の最小化
   - 必要に応じた外部監視ツールとの連携

#### 不採用とした選択肢の理由
- **Datadog/New Relic必須**: コストが高く、小規模企業での導入障壁となる
- **監視なし**: 障害検知が遅れ、業務影響が拡大するリスクがある

---

### 8. バックアップ・DR

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| スナップショット | 定期的なスナップショット取得 | シンプル、復元容易 | RPO粗い |
| 継続的レプリケーション | リアルタイム複製 | RPO短い | コスト・複雑さ増 |
| クロスリージョンバックアップ | 別リージョンに保存 | 地域災害対策 | コスト高い |
| ローカルバックアップのみ | 同一サーバー/ストレージ | コスト最小 | 災害時データ損失リスク |

#### 採用した方針
**日次バックアップ + オフサイト保存（推奨）**を採用。データベース、アップロードファイル、設定ファイルを日次でバックアップし、AWS S3等への保存を推奨。

#### バックアップ設定
| 対象 | 頻度 | 保持期間 | 保存先 | 選択理由 |
| --- | --- | --- | --- | --- |
| データベース | 日次 | 30日 | ローカル/S3 | 業務データの保護 |
| storage/app/public | 日次 | 30日 | ローカル/S3 | アップロードファイルの保護 |
| .env ファイル | 変更時 | 無期限 | セキュア保管 | 設定・認証情報の保護 |
| storage/logs/ | 日次 | 14日 | ローカル | トラブルシューティング用 |

#### RTO/RPO目標
| 項目 | 目標値 | 他の選択肢 | 選択理由 |
| --- | --- | --- | --- |
| RTO | 数時間（小規模）〜1時間以内（大規模） | 分単位の復旧 | 規模に応じた適切な目標設定 |
| RPO | 24時間以内（日次バックアップ） | リアルタイム | コストと業務要件のバランス |

#### 選択理由

1. **背景にあると推察する業務課題**:
   - データ損失はビジネス継続に致命的な影響を与える
   - 一方で、リアルタイムレプリケーションはコストが高い
   - 災害時のデータ復旧手段が必要

2. **業務課題に対するアプローチ方針**:
   - mysqldump/pg_dump/SQLiteファイルコピーによる日次バックアップ
   - AWS S3へのオフサイトバックアップ（オプション）
   - failed_jobsテーブルによるキュー処理の再試行可能性確保

3. **期待される業務改善効果**:
   - データ損失リスクの大幅軽減（RPO: 24時間以内）
   - 障害発生時の迅速な復旧（RTO: 数時間以内）
   - オフサイトバックアップによる災害対策

---

### 9. コスト最適化

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| --- | --- | --- | --- |
| オンデマンド | 従量課金 | 柔軟、コミットメント不要 | 単価高め |
| リザーブド/Committed Use | 1-3年予約 | 大幅割引（30-70%） | コミットメント必要 |
| スポット/Preemptible | 余剰リソース利用 | 大幅割引（60-90%） | 中断リスク |
| SQLite利用 | 外部DB不要 | DB費用ゼロ | スケール制限 |

#### 採用した方針
**段階的投資モデル**を採用。初期はSQLite + データベースキャッシュで開始し、成長に伴いMySQL/Redis等を追加していく構成。

#### コスト最適化施策
| 施策 | 対象 | 削減効果 | 選択理由 |
| --- | --- | --- | --- |
| SQLiteデフォルト | データベース | DB費用ゼロ（初期） | 小規模導入のハードル低減 |
| データベースキャッシュ | キャッシュ層 | Redis費用削減 | 追加インフラ不要 |
| PHP CLI Workers | APサーバー | 並列処理による効率化 | 単一サーバーでの処理能力向上 |
| ログローテーション | ストレージ | ストレージ費用削減 | 14日保持で適切なバランス |

#### 選択理由

1. **背景にあると推察する業務課題**:
   - 中小企業はIT予算が限られている
   - 初期投資を抑えつつ、将来の拡張に対応したい
   - 過剰なインフラ投資は避けたい

2. **業務課題に対するアプローチ方針**:
   - 最小構成（SQLite + database）でゼロコストDB運用が可能
   - 成長フェーズに応じた段階的なインフラ投資
   - `PHP_CLI_SERVER_WORKERS=4`による単一サーバーでの効率的な処理

3. **期待される業務改善効果**:
   - 初期導入コストの大幅削減
   - 事業成長に合わせた適切な投資タイミング
   - 過剰投資の回避によるROI向上

---

## 将来の拡張性考慮

### 想定される変更
1. **利用者数の大幅増加**: ロードバランサー配下でのインスタンス追加、Redisクラスターへの移行、データベースリードレプリカの追加により対応可能
2. **グローバル展開**: マルチリージョン構成、CDN活用、地域別データセンター配置への拡張が可能な設計
3. **マイクロサービス化**: 現在のモノリシックアーキテクチャからの段階的な分離も、API設計により対応可能

### マルチリージョン対応
現時点ではシングルリージョン構成を基本とするが、以下の対応により将来のマルチリージョン展開が可能:
- セッション・キャッシュの外部化（Redis/ElastiCache）により、リージョン間でのステート共有が可能
- AWS S3等のオブジェクトストレージ利用により、ファイルのリージョン間共有が可能
- データベースのクロスリージョンレプリケーションにより、読み取り負荷の分散が可能

---

## 備考

### セキュリティ考慮事項
本インフラ設計において、以下のセキュリティ対策を前提としている:
- 暗号化: AES-256-CBC（`APP_KEY`による）
- パスワードハッシュ: BCRYPT（rounds: 12）
- セッションCookie: HttpOnly、SameSite=Lax
- CSRF保護: Laravel標準機能
- 本番環境での`APP_DEBUG=false`設定

### 推奨クラウド環境
本設計は以下の環境での運用を想定している:
- **AWS**: EC2, RDS, ElastiCache, S3, SES
- **Google Cloud**: Compute Engine, Cloud SQL, Cloud Storage
- **Azure**: Virtual Machines, Azure Database, Blob Storage
- **DigitalOcean**: Droplets, Managed Databases
- **Laravel Forge / Vapor**: Laravel専用マネージドサービス

### 設計時の制約・前提
- PHP 8.2以上の実行環境が必須
- Laravel 11.x、FilamentPHP 4.xの要件に準拠
- オープンソース（MIT License）としての配布を前提とした設計
