# 帳票設計意図書

## 概要

本書は、Aureus ERPシステムの各帳票が**なぜ実装されるに至ったか**を業務課題起点で記述する。
**各帳票が存在する業務上の理由**を明らかにすることを目的とし、併せて技術設計判断の根拠も記載する。

## 1. ドメイン概要

> ドメイン概要（業界・業種、主なステークホルダー、システムの位置づけ、ドメイン共通課題等）は **[機能設計意図書](./機能設計意図書.md)** を参照してください。

本システムはERP（Enterprise Resource Planning）システムであり、以下の業務領域をカバーする：
- 販売管理（見積書、受注、請求書）
- 購買管理（見積依頼、発注書、購買契約）
- 在庫管理（入庫、出庫、内部移動、ピッキング）
- 会計管理（請求書、クレジットノート）

帳票は、これらの業務プロセスにおいて、外部（顧客・仕入先）との正式な取引文書、または内部の作業指示・確認文書として機能する。

---

## 2. 業務プロセス別の帳票と想定価値

### 業務プロセス1: 出荷処理

#### プロセス概要

**業務フロー**

受注確定 → 出荷指示 → ピッキング → 検品 → 梱包 → 出荷 → 納品

**関係者**

倉庫担当者、ピッキング担当者、出荷検品担当者、配送担当者、顧客（検収担当）

**発生頻度**

日次（毎営業日）、1日約50〜200件（企業規模による）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| ピッキング指示の属人化 | 口頭指示や手書きメモでは作業ミスが発生しやすい |
| 納品内容の確認困難 | 納品時に顧客と内容確認ができず、後日クレーム発生 |
| 製品識別の非効率 | 目視による製品確認では時間がかかり、誤出荷リスクがある |
| パッケージ内容の確認不可 | 梱包済みパッケージの内容物を開封しないと確認できない |

#### 本業務をシステム化しない場合の想定リスク・コスト

1. **工数コスト**
   - 手書きピッキングリスト作成：1件あたり15分 × 100件/日 = 25時間/日
   - 手書き納品伝票作成：1件あたり10分 × 100件/日 = 約17時間/日
   - 製品ラベル手書き作成：1件あたり5分 × 300枚/日 = 25時間/日
2. **品質リスク**
   - 誤出荷率：手作業で約2〜5%（自動化で0.1%以下に削減可能）
   - 納品クレーム対応コスト：1件あたり30分〜2時間
3. **法的リスク**
   - 納品証跡がないことによる取引紛争リスク

#### 本業務をシステム化することの想定効果

1. **作業時間削減**：月間約300〜500時間の削減
2. **誤出荷率低減**：2%から0.1%以下へ
3. **顧客クレーム削減**：納品証跡の明確化による紛争防止
4. **トレーサビリティ確保**：ロット・シリアル管理による品質管理強化

#### 主な関連帳票と業務インパクト

| 帳票名 | 何をする帳票か | 帳票がない場合の運用工数 | 帳票があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 納品伝票 | 出荷時に顧客へ渡す納品情報を記載したPDF帳票 | 日100件×10分=月約33時間 | 日100件×1分=月約2時間（31時間削減） |
| ピッキング作業書 | 倉庫でのピッキング作業指示を記載したPDF帳票 | 日100件×15分=月約50時間 | 日100件×2分=月約3時間（47時間削減） |
| 製品ラベル | 製品識別用のバーコードラベルPDF | 日300枚×5分=月約250時間 | 日300枚×0.5分=月約25時間（225時間削減） |
| パッケージ伝票 | パッケージ内容物を記載したPDF帳票 | 日50件×10分=月約17時間 | 日50件×1分=月約2時間（15時間削減） |

---

### 業務プロセス2: 在庫管理・倉庫運用

#### プロセス概要

**業務フロー**

ロケーション設定 → 製品入庫 → 在庫配置 → 棚卸 → 在庫調整

**関係者**

倉庫管理者、棚卸担当者、品質管理担当者

**発生頻度**

- ロケーション管理：随時（新規棚設置時、レイアウト変更時）
- ロット管理：日次（入荷時）
- 棚卸：月次〜年次

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| ロケーション識別の困難 | 倉庫内で正確な保管場所を特定できず、探索時間が増大 |
| ロット追跡の非効率 | 品質問題発生時に該当ロットを特定できない |
| パッケージ識別の混乱 | 類似パッケージの取り違えが発生 |
| 製品識別の誤り | 目視確認では類似製品の判別が困難 |
| パッケージング単位の混同 | まとめ売り単位と個別製品の区別がつかない |

#### 本業務をシステム化しない場合の想定リスク・コスト

1. **工数コスト**
   - ロケーション特定時間：1回あたり5分（バーコードなしの場合）
   - 棚卸作業時間：目視確認で年間約200時間
2. **品質リスク**
   - リコール対応時のロット特定困難（最悪、全製品回収）
   - 有効期限切れ製品の出荷リスク
3. **法的・コンプライアンスリスク**
   - トレーサビリティ不備による法令違反（食品・医薬品等）

#### 本業務をシステム化することの想定効果

1. **棚卸時間削減**：バーコードスキャンにより年間約150時間削減
2. **ロケーション探索時間削減**：1回5分→30秒へ短縮
3. **リコール対応迅速化**：該当ロット即時特定（数日→数時間）
4. **コンプライアンス対応**：トレーサビリティ要件の充足

#### 主な関連帳票と業務インパクト

| 帳票名 | 何をする帳票か | 帳票がない場合の運用工数 | 帳票があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| ロケーションバーコード | 倉庫ロケーション識別用バーコードラベルPDF | 手書き/目視管理で月10時間 | 自動生成で月0.5時間（9.5時間削減） |
| ロットバーコード | 製品ロット/シリアル番号識別用バーコードラベルPDF | 手書きで月20時間 | 自動生成で月1時間（19時間削減） |
| パッケージバーコード（内容なし） | パッケージ識別用シンプルバーコードラベルPDF | 手書きで月5時間 | 自動生成で月0.3時間（4.7時間削減） |
| パッケージバーコード（内容あり） | パッケージ識別＋内容物情報を含むラベルPDF | 手書きで月10時間 | 自動生成で月0.5時間（9.5時間削減） |
| 製品バーコード | 製品識別用バーコードラベルPDF（価格表示対応） | 手書きで月30時間 | 自動生成で月1.5時間（28.5時間削減） |
| パッケージングバーコード | まとめ売り単位識別用バーコードラベルPDF | 手書きで月8時間 | 自動生成で月0.4時間（7.6時間削減） |

---

### 業務プロセス3: 購買処理

#### プロセス概要

**業務フロー**

見積依頼作成 → 仕入先送付 → 見積回答受領 → 発注確定 → 入庫 → 仕入先請求処理

**関係者**

購買担当者、調達マネージャー、仕入先

**発生頻度**

日次〜週次、月間約50〜200件

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 見積依頼書の手作業作成 | 手書きやExcelでの作成に時間がかかり、記載ミスも発生 |
| 発注書の正式性確保 | 非定型フォーマットでは取引証跡として不十分 |
| 契約内容の文書化不足 | 口頭合意のみでは後日紛争リスクがある |

#### 本業務をシステム化しない場合の想定リスク・コスト

1. **工数コスト**
   - 見積依頼書手作業作成：1件あたり20分 × 50件/月 = 約17時間/月
   - 発注書手作業作成：1件あたり15分 × 100件/月 = 約25時間/月
   - 契約書作成：1件あたり60分 × 10件/月 = 約10時間/月
2. **法的リスク**
   - 発注内容の不明確さによる取引紛争
   - 契約条件の曖昧さによる追加コスト発生

#### 本業務をシステム化することの想定効果

1. **発注処理時間削減**：月間約40時間の削減
2. **発注ミス削減**：システム制御による入力チェック
3. **取引証跡確保**：正式な発注書・契約書のPDF保存

#### 主な関連帳票と業務インパクト

| 帳票名 | 何をする帳票か | 帳票がない場合の運用工数 | 帳票があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 見積依頼書/発注書 | 仕入先への見積依頼・発注を正式文書化したPDF帳票 | 月100件×20分=月約33時間 | 月100件×3分=月約5時間（28時間削減） |
| 購買契約書 | サプライヤーとの購買契約を文書化したPDF帳票 | 月10件×60分=月約10時間 | 月10件×5分=月約1時間（9時間削減） |

---

### 業務プロセス4: 販売処理

#### プロセス概要

**業務フロー**

見積書作成 → 顧客送付 → 受注確定 → 出荷指示 → 納品 → 請求書発行 → 入金確認

**関係者**

営業担当者、販売マネージャー、顧客

**発生頻度**

日次〜週次、月間約100〜500件

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 見積書の手作業作成 | 手書きやExcelでの作成に時間がかかり、価格計算ミスも発生 |
| 見積書の非定型フォーマット | 会社のブランドイメージ低下、顧客への印象悪化 |
| 送付作業の非効率 | メール添付のためのPDF変換・添付作業が煩雑 |

#### 本業務をシステム化しない場合の想定リスク・コスト

1. **工数コスト**
   - 見積書手作業作成：1件あたり20分 × 200件/月 = 約67時間/月
   - メール送付準備：1件あたり5分 × 200件/月 = 約17時間/月
2. **営業リスク**
   - 見積回答遅延による機会損失
   - 価格計算ミスによる利益減少
3. **ブランドリスク**
   - 非専門的な見積書フォーマットによる信頼性低下

#### 本業務をシステム化することの想定効果

1. **見積作成時間削減**：月間約70時間の削減
2. **見積精度向上**：システム制御による価格自動計算
3. **プロフェッショナルな印象**：統一フォーマットによるブランド向上
4. **営業効率向上**：ワンクリックでのメール送信

#### 主な関連帳票と業務インパクト

| 帳票名 | 何をする帳票か | 帳票がない場合の運用工数 | 帳票があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 見積書 | 顧客への販売見積をPDF形式で生成しメール送信する帳票 | 月200件×25分=月約83時間 | 月200件×5分=月約17時間（66時間削減） |

---

### 業務プロセス5: 請求処理

#### プロセス概要

**業務フロー**

納品完了 → 請求書作成 → 請求書確認 → 顧客送付 → 入金確認 → 消込処理

**関係者**

経理担当者、会計マネージャー、顧客

**発生頻度**

月次（月末締め）、月間約200〜1000件

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 請求書作成の属人化 | 特定担当者でないと正確な請求書が作成できない |
| 手作業による計算ミス | 金額・税額の手計算で誤りが発生 |
| 請求書送付の遅延 | 月末処理集中により送付が遅れ、入金も遅延 |
| 請求内容の確認困難 | 発行前に内容を確認する手段がない |

#### 本業務をシステム化しない場合の想定リスク・コスト

1. **工数コスト**
   - 請求書手作業作成：1件あたり15分 × 500件/月 = 約125時間/月
   - 内容確認・修正：1件あたり5分 × 500件/月 = 約42時間/月
2. **財務リスク**
   - 請求漏れによる売上機会損失
   - 金額ミスによる過少/過大請求
3. **キャッシュフローリスク**
   - 請求書送付遅延による入金遅延

#### 本業務をシステム化することの想定効果

1. **請求処理時間削減**：月間約150時間の削減
2. **請求精度向上**：システム制御による自動計算
3. **入金サイクル短縮**：即時送付による早期入金
4. **監査対応強化**：請求書発行履歴の自動記録

#### 主な関連帳票と業務インパクト

| 帳票名 | 何をする帳票か | 帳票がない場合の運用工数 | 帳票があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 請求書 | 顧客への請求をPDF形式で生成しメール送信する帳票 | 月500件×15分=月約125時間 | 月500件×3分=月約25時間（100時間削減） |
| 請求書プレビュー | 請求書発行前の内容確認用画面表示機能 | 月500件×5分=月約42時間（確認・修正） | 月500件×1分=月約8時間（34時間削減） |

---

## 3. 各帳票想定意図サマリー

| 帳票名 | 背景にある業務課題 | 業務負荷（推察） | 主な解決アプローチ | 手動作成を選ばなかった理由 | 画面表示で代用を選ばなかった理由 |
| -------- | ------------------ | ---------------- | ------------------ | -------------------------- | ---------------------------------- |
| 1-納品伝票 | 出荷時の納品内容確認・顧客検収支援 | 中（月33時間） | 出荷データから自動生成 | 出荷ごとに作成が必要で手作業では間に合わないため | 商品に同梱する物理的な帳票が必要なため |
| 2-ピッキング作業書 | ピッキング作業の効率化・正確性向上 | 高（月50時間） | 出荷指示から作業書自動生成 | バーコード印刷が必要で手書きでは対応不可のため | 倉庫内で携帯・参照する紙の作業書が必要なため |
| 3-製品ラベル | 製品識別・バーコードスキャン対応 | 高（月250時間） | 複数フォーマット対応のラベル自動生成 | 大量印刷が必要で手書きは現実的でないため | バーコードラベルは物理的に製品に貼付する必要があるため |
| 4-パッケージ伝票 | パッケージ内容物の確認・検品支援 | 中（月17時間） | パッケージデータから明細自動生成 | 内容物リストの手書き作成は非効率のため | パッケージに同梱または貼付する物理帳票が必要なため |
| 5-ロケーションバーコード | 倉庫ロケーションの識別・作業効率化 | 低（月10時間） | ロケーションマスタから一括生成 | ロケーション数が多く手書きでは管理困難のため | 倉庫の棚に貼付する物理ラベルが必要なため |
| 6-ロットバーコード | 製品トレーサビリティ・品質管理 | 中（月20時間） | ロット情報から一括生成 | 品質管理上、正確なロット番号印刷が必須のため | 製品に貼付する物理ラベルが必要なため |
| 7-パッケージバーコード（内容なし） | パッケージ識別・追跡 | 低（月5時間） | パッケージマスタから一括生成 | パッケージ数が多く手書きは非効率のため | パッケージに貼付する物理ラベルが必要なため |
| 8-パッケージバーコード（内容あり） | パッケージ識別＋内容確認 | 中（月10時間） | パッケージ＋内容物データから自動生成 | 内容物リストを含むため手書きは困難のため | パッケージに貼付または同梱する物理帳票が必要なため |
| 9-製品バーコード | 製品識別・価格表示 | 高（月30時間） | 製品マスタから複数フォーマットで生成 | 大量のラベル印刷が必要で手書きは不可能のため | 製品に貼付する物理ラベルが必要なため |
| 10-パッケージングバーコード | まとめ売り単位の識別 | 低（月8時間） | パッケージング情報から自動生成 | まとめ売り単位は個別製品と区別する正確なラベルが必要なため | パッケージに貼付する物理ラベルが必要なため |
| 11-見積依頼書/発注書 | 購買プロセスの正式文書化 | 中（月33時間） | 購買注文データから自動生成 | 発行量が多く、正式な取引文書として体裁が必要なため | 仕入先への送付用として印刷・PDF送信が必要なため |
| 12-購買契約書 | サプライヤーとの契約文書化 | 低（月10時間） | 購買契約データから自動生成 | 法的文書として正式なフォーマットが必要なため | 契約書として印刷・署名が必要なため |
| 13-見積書 | 販売プロセスの正式文書化・顧客対応 | 高（月83時間） | 見積データから自動生成＋メール送信 | 発行量が多く、プロフェッショナルな体裁が必要なため | 顧客への送付用としてPDFメール送信が必要なため |
| 14-請求書 | 請求処理の正式文書化・会計処理 | 高（月125時間） | 請求データから自動生成＋メール送信 | 法的な請求書要件を満たす正式文書が必要なため | 顧客への送付用として印刷・PDF送信が必要なため |
| 15-請求書プレビュー | 請求書発行前の内容確認 | 中（月42時間） | 請求書と同一レイアウトで画面表示 | 発行前確認は画面表示で十分なため | プレビュー機能として画面表示が適切（PDFは不要） |

---

## 4. 技術設計判断と根拠

### 設計意図サマリー

| 設計論点 | 想定される選択肢 | 採用した方針 | 主な選択理由 |
| -------- | ---------------- | ------------ | ------------ |
| 出力形式 | PDF / Excel / CSV / HTML | PDF（主）、HTML（プレビュー） | 印刷・メール送付に最適、改ざん困難 |
| 生成方式 | 同期 / 非同期 / バッチ | 同期生成 | データ件数が限定的で即時性が重要 |
| テンプレート管理 | コード内 / ファイル / DB | Bladeテンプレートファイル | 開発効率とメンテナンス性のバランス |
| 保存・配信 | ダウンロード / メール / ストレージ | 直接ダウンロード＋メール送信 | 即時利用と顧客送付の両方に対応 |

---

### 4-1. 出力形式選択

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| PDF | 固定レイアウト | 印刷最適、改ざん困難、互換性高い | 編集不可 |
| Excel | スプレッドシート | 編集・加工可能 | レイアウト崩れ、印刷設定複雑 |
| CSV | カンマ区切りテキスト | 軽量、データ連携向き | 書式なし、帳票に不向き |
| HTML | Web表示 | ブラウザで表示可能 | 印刷レイアウト制御困難 |
| Word | 文書形式 | 編集可能、書式豊富 | テンプレート管理複雑 |

#### 採用した方針

PDF形式を主とし、プレビュー機能のみHTML表示

#### 形式用途

| 形式 | 用途 | 対象帳票 | 選択理由 |
| ---- | ---- | -------- | -------- |
| PDF | 印刷・メール送付 | 納品伝票、ピッキング作業書、各種ラベル、見積依頼書/発注書、購買契約書、見積書、請求書 | 固定レイアウトで印刷品質保証、改ざん困難 |
| HTML | 画面プレビュー | 請求書プレビュー | PDF生成不要で高速表示 |

#### 選択理由

1. **印刷品質保証**：PDFは紙媒体での出力品質が安定しており、レイアウト崩れがない
2. **改ざん防止**：正式な取引文書として改ざん困難な形式が適切
3. **互換性**：PDFは閲覧環境を選ばず、顧客・仕入先との文書交換に最適
4. **メール添付**：ファイルサイズが適切で、メール添付に適している

#### 不採用とした選択肢の理由

- **Excel**: 正式な帳票として体裁が整わず、印刷時のレイアウト制御が困難
- **CSV**: 書式情報がなく、帳票としての用途には不適切
- **Word**: テンプレート管理が複雑で、システム生成には向かない

---

### 4-2. 帳票生成ライブラリ/サービス

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| wkhtmltopdf | HTMLからPDF変換 | 無料、HTML/CSSの知識で対応可能 | サーバー環境依存、一部CSSに制限 |
| Puppeteer/Playwright | ブラウザでPDF生成 | 高品質、最新CSS対応 | リソース消費大、Node.js必要 |
| DomPDF | PHP純粋実装 | PHPエコシステム、サーバー環境非依存 | CSS対応に制限あり |
| TCPDF | PHP実装 | 高機能、日本語対応良好 | コード量多い |
| 商用帳票ツール | JasperReports等 | 高機能、サポート | ライセンスコスト |
| SaaSサービス | Docurain等 | 運用不要 | 従量課金、依存 |

#### 採用した方針

barryvdh/laravel-dompdf（DomPDF）

#### 採用ツール

| 形式 | ツール | 他の選択肢 | 選択理由 |
| ---- | ------ | ---------- | -------- |
| PDF | DomPDF | wkhtmltopdf, TCPDF | Laravel統合、サーバー環境非依存、十分なCSS対応 |
| バーコード | milon/barcode (DNS1D) | php-barcode, zxing | Laravel統合、Code128対応、軽量 |

#### 選択理由

1. **Laravel統合**：Laravelフレームワークとの親和性が高く、Bladeテンプレートをそのまま利用可能
2. **サーバー環境非依存**：外部バイナリ（wkhtmltopdf等）のインストールが不要
3. **十分なCSS対応**：帳票に必要なテーブル、フォント、レイアウト制御に対応
4. **メンテナンス性**：広く利用されているパッケージで、継続的なメンテナンスが期待できる

#### 不採用とした選択肢の理由

- **wkhtmltopdf**: サーバーへの外部バイナリインストールが必要で、環境構築が複雑
- **Puppeteer**: Node.js環境が必要で、PHPアプリケーションとの統合が複雑
- **商用ツール**: 本システムの帳票要件にはオーバースペック、コスト増

---

### 4-3. テンプレート管理

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| コード内埋め込み | ソースコードに定義 | シンプル、バージョン管理容易 | 変更にデプロイ必要、見通し悪い |
| テンプレートファイル | 別ファイルで管理 | 分離、見やすい、デザイナー協業可能 | デプロイ必要 |
| DB管理 | DBにテンプレート保存 | 動的変更可能、テナント別対応 | 管理画面必要、複雑性増加 |
| ノーコードツール | GUIで編集 | 非エンジニアが編集可 | ツール依存、コスト |

#### 採用した方針

Bladeテンプレートファイル（モジュール別管理）

#### テンプレート構成

| 帳票種別 | 管理場所 | 形式 | 選択理由 |
| -------- | -------- | ---- | -------- |
| 在庫系帳票 | plugins/webkul/inventories/resources/views/ | Blade | 在庫モジュール内で一元管理 |
| 購買系帳票 | plugins/webkul/purchases/resources/views/ | Blade | 購買モジュール内で一元管理 |
| 販売系帳票 | plugins/webkul/sales/resources/views/ | Blade | 販売モジュール内で一元管理 |
| 会計系帳票 | plugins/webkul/accounts/resources/views/ | Blade | 会計モジュール内で一元管理 |

#### 選択理由

1. **モジュール分離**：各業務モジュールが自身の帳票テンプレートを管理し、責任範囲が明確
2. **開発効率**：Bladeテンプレートの機能（継承、コンポーネント、ループ等）を活用可能
3. **バージョン管理**：Gitでのバージョン管理が容易
4. **共通スタイル**：CSSを共有して一貫したデザインを維持

#### 不採用とした選択肢の理由

- **コード内埋め込み**: HTMLが長くなり、可読性・メンテナンス性が低下
- **DB管理**: 動的変更の要件がなく、複雑性に見合うメリットがない
- **ノーコードツール**: エンジニア主導の開発体制で、追加コストに見合わない

---

### 4-4. パフォーマンス対策

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| ストリーミング生成 | 逐次出力 | メモリ効率良い | 実装複雑 |
| ページング生成 | ページ単位で処理 | バランス | 結合処理必要 |
| 一括生成 | 全データをメモリに | シンプル | メモリ消費大 |
| キャッシュ活用 | 生成結果をキャッシュ | 再利用時高速 | 鮮度管理必要 |

#### 採用した方針

一括生成（streamDownload）、明細件数制限による制御

#### 対策一覧

| 対策 | 対象 | 効果 | 選択理由 |
| ---- | ---- | ---- | -------- |
| streamDownload | 全帳票 | メモリ効率的なダウンロード | Laravelの標準機能で実装シンプル |
| 明細制限目安 | 全帳票 | 1帳票あたり100件程度 | 実運用で十分な件数、過度な制限不要 |
| 改ページ制御 | 複数レコード出力 | 帳票ごとにページ分割 | 可読性確保 |

#### 選択理由

1. **実運用件数での十分性**：1帳票あたり100件程度の明細であれば、一括生成で問題なく処理可能
2. **シンプルな実装**：ストリーミングの複雑な実装を避け、メンテナンス性を優先
3. **streamDownloadの活用**：Laravelの機能でメモリ効率的なダウンロードを実現

#### 不採用とした選択肢の理由

- **ストリーミング生成**: 明細件数が限定的で、複雑な実装に見合うメリットがない
- **キャッシュ活用**: 帳票データはリアルタイム性が重要で、キャッシュは不適切

---

### 4-5. 非同期生成

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| 同期生成 | リクエスト内で生成完了 | シンプル、即時取得 | 大量データでタイムアウト |
| 非同期生成 | バックグラウンドで生成 | タイムアウト回避 | 進捗表示・完了通知必要 |
| 事前生成 | スケジュールで事前生成 | 即時ダウンロード | 最新データでない |
| オンデマンド＋キャッシュ | 初回生成後キャッシュ | バランス | キャッシュ管理必要 |

#### 採用した方針

同期生成（リクエスト内でPDF生成・ダウンロード）

#### 生成パターン

| 帳票種別 | 生成方式 | 他の選択肢 | 選択理由 |
| -------- | -------- | ---------- | -------- |
| 全帳票 | 同期生成 | 非同期生成 | 即時性重要、データ件数が限定的 |
| 一括ラベル印刷 | 同期生成 | 非同期生成 | 100件上限で同期処理可能 |

#### 選択理由

1. **即時性の要件**：帳票は操作直後にダウンロードしたいユースケースが多い
2. **データ件数の限定性**：1回の出力で数十〜100件程度であり、同期処理で十分
3. **シンプルな実装**：非同期処理のキュー管理、進捗表示、完了通知の実装を回避
4. **目標出力時間**：3〜5秒以内の出力を想定し、同期処理で達成可能

#### 不採用とした選択肢の理由

- **非同期生成**: 数百〜数千件の大量出力要件がないため、複雑性に見合わない
- **事前生成**: 帳票データはリアルタイムの最新データが必要

---

### 4-6. 保存・配信方式

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| 直接ダウンロード | 生成後即ダウンロード | シンプル、即時取得 | 再ダウンロード不可 |
| ストレージ保存 | S3等に保存、URL共有 | 再ダウンロード可、履歴管理 | ストレージコスト |
| メール送信 | 生成後メールで送信 | 通知兼ねる、外部送付可 | サイズ制限 |
| 保存期限付き | 一定期間後に削除 | ストレージ節約 | 期限管理必要 |

#### 採用した方針

直接ダウンロード（基本）、メール送信（外部送付時）、一時ストレージ保存（メール添付用）

#### 保存設定

| 帳票種別 | 保存先 | 保持期間 | 選択理由 |
| -------- | ------ | -------- | -------- |
| 内部作業用帳票（ラベル類） | 直接ダウンロード（保存なし） | - | 一時的な利用、再印刷は再生成で対応 |
| 外部送付用帳票（見積書、請求書） | publicディスク一時保存 | メール送信完了まで | メール添付のため一時保存が必要 |

#### 選択理由

1. **シンプルな運用**：基本は直接ダウンロードで、ユーザーが必要に応じてローカル保存
2. **メール送信対応**：見積書・請求書は顧客へのメール送信が主用途のため、添付用に一時保存
3. **ストレージコスト抑制**：長期保存は行わず、必要時は再生成で対応

#### 不採用とした選択肢の理由

- **永続ストレージ保存**: 帳票の長期保存要件がなく、ストレージコスト増に見合わない
- **保存期限付き**: 一時保存で十分、期限管理の複雑性を回避

---

### 4-7. アクセス制御

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| 認証のみ | ログインユーザーは全帳票可 | シンプル | 機密性低い |
| ロールベース | ロールで帳票アクセス制御 | 管理容易、柔軟 | 権限設計必要 |
| 所有者ベース | 自分のデータのみ | きめ細かい | 実装複雑 |
| 署名付きURL | 一時的アクセス許可 | セキュア、外部共有可 | URL管理必要 |

#### 採用した方針

Filament Resourceのcan権限によるロールベースアクセス制御

#### 権限設定

| 帳票種別 | 閲覧権限 | ダウンロード権限 | 選択理由 |
| -------- | -------- | ---------------- | -------- |
| 在庫系帳票 | 在庫オペレーション閲覧権限 | 同上 | 倉庫担当者に限定 |
| 購買系帳票 | 購買注文閲覧権限 | 同上 | 購買担当者に限定 |
| 販売系帳票 | 販売注文閲覧権限 | 同上 | 営業担当者に限定 |
| 会計系帳票 | 請求書閲覧権限 | 同上 | 経理担当者に限定 |

#### 選択理由

1. **既存権限モデルの活用**：Filament Resourceの権限モデルをそのまま利用
2. **シンプルな権限設計**：元データへのアクセス権限＝帳票出力権限として一貫性確保
3. **柔軟性**：ロール管理画面で権限を柔軟に設定可能

#### 不採用とした選択肢の理由

- **認証のみ**: 機密性の高い情報（価格、顧客情報等）を含むため不適切
- **所有者ベース**: 部門内での情報共有が必要なケースがあり、制限が厳しすぎる
- **署名付きURL**: 社内利用が主で、外部共有URLの要件がない

---

### 4-8. 監査証跡

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| 生成ログのみ | 生成日時・ユーザーを記録 | シンプル | ダウンロード追跡不可 |
| 生成＋ダウンロード | 両方を記録 | 追跡可能 | ログ量増加 |
| 詳細監査 | パラメータ含めて記録 | 完全追跡 | ストレージ・プライバシー |

#### 採用した方針

最小限のログ（生成ログは未実装、状態変更ログは実装）

#### 記録項目

| 項目 | 内容 | 保持期間 | 選択理由 |
| ---- | ---- | -------- | -------- |
| 見積依頼書出力時 | 注文状態をSENTに変更 | 永続 | 購買ワークフローの進行状況を記録 |
| 見積書・請求書送信時 | メール送信履歴 | 永続 | 顧客への送付履歴として必要 |
| 帳票生成ログ | （未実装） | - | 現状は実装されていない |

#### 選択理由

1. **状態変更による追跡**：帳票出力が業務状態遷移を伴う場合は、状態変更として記録
2. **メール送信履歴**：外部送付の証跡として重要
3. **生成ログの優先度**：現状、詳細な生成ログの要件がない

#### 不採用とした選択肢の理由

- **詳細監査**: 監査要件が明確でないため、オーバーエンジニアリングを避ける
- **全操作ログ**: ログ量増加に見合う要件がない

---

### 4-9. 多言語・地域化対応

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| 単一言語 | 1言語のみ | シンプル | グローバル対応不可 |
| 言語別テンプレート | 言語ごとにテンプレート | きめ細かい | 管理コスト増 |
| 動的ローカライズ | 生成時に言語適用 | 柔軟、テンプレート共通化 | 実装複雑 |
| ユーザー設定連動 | ユーザー言語設定に従う | ユーザーフレンドリー | 設定管理必要 |

#### 採用した方針

英語固定（現状）、将来的にはLaravelのローカライズ機能を活用予定

#### 対応状況

| 言語 | 対応帳票 | 対応方法 | 選択理由 |
| ---- | -------- | -------- | -------- |
| 英語 | 全帳票 | テンプレート固定 | グローバルなERPシステムとして英語を基本 |
| 日本語等 | （未対応） | - | 将来的にローカライズ対応予定 |

#### 選択理由

1. **初期フェーズの優先度**：機能実装を優先し、多言語化は後続フェーズで対応
2. **英語の汎用性**：グローバルなERPシステムとして、英語表記が標準的
3. **将来拡張性**：Laravelのローカライズ機能により、後から多言語化が可能

#### 不採用とした選択肢の理由

- **言語別テンプレート**: テンプレート管理コストが大幅に増加
- **初期から多言語対応**: 開発コスト増に見合う要件がない

---

## 5. 将来の拡張性考慮

### 想定される変更

1. **多言語対応の追加**
   - 対応方針：Laravelの翻訳ファイル（lang/ja/pdf.php等）を追加し、テンプレート内のラベルを翻訳キーで置換
   - 影響範囲：全帳票テンプレートの修正が必要

2. **電子署名対応**
   - 対応方針：PDF生成後に電子署名を付与する処理を追加
   - 影響範囲：PDF生成処理の後処理として実装

3. **帳票履歴管理**
   - 対応方針：生成した帳票をストレージに保存し、帳票履歴画面を追加
   - 影響範囲：帳票生成処理にストレージ保存処理を追加、履歴管理リソースの新規作成

4. **カスタムテンプレート対応**
   - 対応方針：テナント/会社別のカスタムテンプレートをDB管理に移行
   - 影響範囲：テンプレート読み込み処理の変更、テンプレート管理画面の追加

5. **大量帳票の非同期生成**
   - 対応方針：一定件数以上の場合はLaravelキューで非同期処理
   - 影響範囲：帳票生成アクションに件数判定と非同期処理の分岐を追加

### 帳票追加時の指針

1. **モジュール配置**：帳票の業務ドメインに対応するモジュール内にテンプレートを配置
2. **テンプレート命名規則**：`{帳票名}.blade.php` の形式で命名
3. **共通スタイル利用**：既存帳票のCSSスタイルを参考に一貫性を保つ
4. **Actionクラス作成**：FilamentのActionまたはBulkActionとして実装
5. **権限設定**：元データのリソース権限に準拠

---

## 備考

- 本ドキュメントは、帳票設計書（15件）を基に業務観点から設計意図を類推したものである
- 業務インパクトの数値は、一般的なERP導入企業を想定した推定値であり、実際の効果は企業規模・業務量により異なる
- 技術設計判断は、現在のコードベース（barryvdh/laravel-dompdf、milon/barcode使用）を根拠としている
