# 機能設計意図書

## 概要

本書は、AureusERPシステムの各機能が**なぜ実装されるに至ったか**を業務課題起点で記述する。
**各機能が存在する業務上の理由**を明らかにすることを目的とし、技術的な設計判断は別途アーキテクチャ設計意図書で記載している。

## 1. ドメイン概要

### 対象ドメイン

#### 業界・業種
中小〜中堅企業向けの統合業務管理（ERP: Enterprise Resource Planning）システム。業種横断的に利用可能であり、特に以下の業種での利用が想定される：
- **製造業**: 購買・在庫・販売の一連のサプライチェーン管理
- **卸売・小売業**: 顧客管理、見積もり〜受注〜配送〜請求の商流管理
- **サービス業**: プロジェクト管理、工数管理、顧客請求管理
- **一般企業**: 人事管理、採用管理、休暇管理などの人事労務管理

#### 主なステークホルダー
| ステークホルダー | 主な利用機能 |
|-----------------|-------------|
| **営業担当者** | 見積書管理、受注管理、顧客管理 |
| **購買担当者** | 見積依頼（RFQ）管理、発注書管理、仕入先管理 |
| **倉庫担当者** | 在庫移動管理、入出庫処理、ロット管理 |
| **経理担当者** | 請求書管理、支払管理、仕訳帳管理、税管理 |
| **人事担当者** | 従業員管理、採用管理、休暇管理、勤務カレンダー管理 |
| **プロジェクトマネージャー** | プロジェクト管理、タスク管理、工数管理 |
| **システム管理者** | ユーザー管理、ロール管理、プラグイン管理、会社管理 |
| **従業員（一般）** | 休暇申請、タイムシート入力 |

#### システムの位置づけ
企業の基幹業務を統合管理するハブシステムとして位置づけられる。販売管理、購買管理、在庫管理、会計管理、人事管理、プロジェクト管理を一元化し、業務データの分断を防ぎ、リアルタイムな経営情報の可視化を実現する。

### このドメインにおける一般的な課題

#### 1. 業務データの分断（サイロ化）

**発生背景**

中小企業では、部門ごとに異なるシステム（Excel、個別業務システム）を使用していることが多く、データが散在している。販売部門のExcel、購買部門のExcel、経理部門の会計ソフトが連携しておらず、同じ情報を複数回入力する必要がある。

**業務への影響**

- 二重入力による工数増加（月20〜40時間程度と推測）
- 転記ミスによる在庫差異、請求漏れ
- リアルタイムな経営情報の把握が困難

#### 2. 見積もり・発注業務の属人化

**発生背景**

価格体系が複雑で、顧客別・数量別の価格設定、割引ルールなどがベテラン担当者の頭の中にのみ存在している。

**業務への影響**

- 新人教育に時間がかかる（3〜6ヶ月程度）
- 担当者不在時に正確な見積もりが出せない
- 価格設定ミスによる利益率低下

#### 3. 在庫管理の不正確さ

**発生背景**

手作業での在庫台帳管理、入出庫記録の遅延・漏れ、棚卸頻度の不足。

**業務への影響**

- 欠品による販売機会損失
- 過剰在庫によるキャッシュフロー悪化
- 棚卸差異の調査・是正に多大な工数

#### 4. 人事情報管理の煩雑さ

**発生背景**

従業員情報、スキル情報、休暇残高などが紙やExcelで管理されており、更新漏れや参照困難が発生。

**業務への影響**

- 休暇承認の遅延、残高把握ミス
- 適材適所の人員配置が困難
- 採用プロセスの進捗把握困難

#### 5. プロジェクト工数管理の困難さ

**発生背景**

プロジェクトごとの作業時間を把握する仕組みがなく、実績工数の可視化ができていない。

**業務への影響**

- プロジェクト採算管理が不正確
- 工数見積もり精度の向上が困難
- リソース配分の最適化ができない

## 2. 業務プロセス別の機能と想定価値

### 業務プロセス1: 販売プロセス（見積もり〜受注〜出荷〜請求）

#### プロセス概要

**業務フロー**

顧客からの問い合わせ → 見積書作成 → 見積書送付 → 顧客承認 → 受注確定 → 出荷指示 → 出荷 → 請求書発行 → 入金確認

**関係者**

営業担当者、営業事務、倉庫担当者、経理担当者

**発生頻度**

月間500〜2,000件程度（企業規模による）

#### 関連するドメイン課題

| ドメイン課題 | この業務プロセスでの具体的な影響 |
| ------------ | -------------------------------- |
| 見積もり・発注業務の属人化 | ベテラン担当者でないと正確な見積もりが作れない、価格設定ミス |
| 業務データの分断 | 見積→受注→出荷→請求の情報が分断され、転記ミスや漏れが発生 |

#### 本業務をシステム化しない場合の想定リスク・コスト

**工数コスト**
- 見積書作成: 月500件 x 15分 = 月125時間
- 受注入力: 月500件 x 10分 = 月83時間
- 請求書作成: 月500件 x 10分 = 月83時間
- データ照合・確認: 月500件 x 5分 = 月42時間
- **合計: 月333時間（約2名分の工数）**

**その他リスク**
- 転記ミスによるクレーム対応（月10件 x 2時間 = 月20時間）
- 価格設定ミスによる損失（年間売上の0.5〜1%程度）
- 請求漏れによる機会損失

#### 本業務をシステム化することの想定効果

**工数削減効果**
- 見積書作成: 月500件 x 5分 = 月42時間（83時間削減）
- 受注入力: 見積からの変換で月500件 x 2分 = 月17時間（66時間削減）
- 請求書作成: 受注からの自動生成で月500件 x 2分 = 月17時間（66時間削減）
- データ照合: 自動連携で0（42時間削減）
- **合計: 月257時間削減（月76時間に短縮）**

**その他効果**
- 転記ミス削減によるクレーム対応工数削減
- 価格マスタによる価格設定ミス防止
- 請求漏れ防止

#### 主な関連機能と業務インパクト

| 機能名 | 何をする機能か | 機能がない場合の運用工数 | 機能があることによるインパクト |
| ------ | ---------------------- | ------------------------ | ------------------------------ |
| 見積書管理 | 顧客・商品を選択すると見積書を自動生成、価格自動取得 | 月500件×15分=月125時間 | 月500件×5分=月42時間（83時間削減） |
| 受注管理 | 見積書から受注へワンクリック変換、出荷連携 | 月500件×10分=月83時間 | 月500件×2分=月17時間（66時間削減） |
| 顧客管理 | 顧客情報を一元管理、過去取引履歴参照 | 顧客情報検索に1件5分×月500件=月42時間 | 瞬時検索で月5時間程度（37時間削減） |
| 顧客請求書管理 | 受注から請求書自動生成、メール送信 | 月500件×10分=月83時間 | 月500件×2分=月17時間（66時間削減） |
| 価格リスト管理 | 顧客別・期間別の価格設定を一元管理 | 都度価格表確認に5分×500件=月42時間 | 自動適用で確認作業0（42時間削減） |
| 販売チーム管理 | 営業チーム単位での目標・実績管理 | Excel集計に月30時間 | ダッシュボード自動表示で月2時間（28時間削減） |
| 見積テンプレート管理 | 定型見積のテンプレート化 | テンプレート都度作成に月10時間 | テンプレート選択で月1時間（9時間削減） |
| タグ管理（販売） | 見積・受注のタグ分類 | 手動分類に月5時間 | タグ自動分類で月1時間（4時間削減） |
| 活動タイプ管理（販売） | 営業活動の種類を定義 | 活動記録の標準化なし | 活動の可視化・分析が可能に |
| 活動プラン管理（販売） | 営業活動の定型プラン化 | フォロー漏れリスク | 自動リマインダーで漏れ防止 |
| 商品管理（販売） | 販売商品マスタの管理 | 商品情報管理に月20時間 | 一元管理で月5時間（15時間削減） |
| 商品カテゴリ管理（販売） | 商品カテゴリの階層管理 | カテゴリ管理に月5時間 | 階層管理で月1時間（4時間削減） |
| 商品属性管理（販売） | 商品のバリエーション管理 | 属性管理に月10時間 | 体系的管理で月2時間（8時間削減） |
| パッケージング管理（販売） | 販売単位のパッケージ設定 | 梱包設定管理に月5時間 | 自動設定で月1時間（4時間削減） |
| 請求対象管理 | 請求対象となる受注の管理 | 請求漏れチェックに月10時間 | 自動抽出で月1時間（9時間削減） |

### 業務プロセス2: 購買プロセス（見積依頼〜発注〜入庫〜支払）

#### プロセス概要

**業務フロー**

購買依頼 → 仕入先選定 → 見積依頼（RFQ）送付 → 見積回答受領 → 発注書作成・送付 → 入庫確認 → 検収 → 請求書照合 → 支払処理

**関係者**

購買担当者、倉庫担当者、経理担当者

**発生頻度**

月間300〜1,000件程度

#### 関連するドメイン課題

| ドメイン課題 | この業務プロセスでの具体的な影響 |
| ------------ | -------------------------------- |
| 業務データの分断 | 発注→入庫→支払の情報が分断、照合に時間がかかる |
| 見積もり・発注業務の属人化 | 仕入先別の取引条件が担当者の頭の中にしかない |

#### 本業務をシステム化しない場合の想定リスク・コスト

**工数コスト**
- 見積依頼作成・送付: 月300件 x 15分 = 月75時間
- 発注書作成: 月300件 x 15分 = 月75時間
- 入庫確認・照合: 月300件 x 10分 = 月50時間
- 請求書照合: 月300件 x 10分 = 月50時間
- **合計: 月250時間**

**その他リスク**
- 発注漏れによる欠品リスク
- 重複発注によるコスト増
- 支払漏れ・重複支払リスク

#### 本業務をシステム化することの想定効果

**工数削減効果**
- 見積依頼作成: RFQからの自動生成で月300件 x 5分 = 月25時間（50時間削減）
- 発注書作成: RFQからの変換で月300件 x 3分 = 月15時間（60時間削減）
- 入庫確認: 発注連携で月300件 x 3分 = 月15時間（35時間削減）
- 請求書照合: 自動照合で月300件 x 2分 = 月10時間（40時間削減）
- **合計: 月185時間削減（月65時間に短縮）**

#### 主な関連機能と業務インパクト

| 機能名 | 何をする機能か | 機能がない場合の運用工数 | 機能があることによるインパクト |
| ------ | ---------------------- | ------------------------ | ------------------------------ |
| 見積依頼（RFQ）管理 | 仕入先への見積依頼を作成・送付 | 月300件×15分=月75時間 | 月300件×5分=月25時間（50時間削減） |
| 発注書管理 | RFQから発注書へ変換、送付、入庫連携 | 月300件×15分=月75時間 | 月300件×3分=月15時間（60時間削減） |
| 仕入先管理 | 仕入先情報・取引条件の一元管理 | 仕入先情報検索に月20時間 | 瞬時検索で月3時間（17時間削減） |
| 仕入先価格管理 | 仕入先別・商品別の価格を管理 | 都度価格確認に月30時間 | 自動適用で月2時間（28時間削減） |
| 購買依頼管理 | 社内からの購買依頼を管理 | 依頼管理に月15時間 | 一元管理で月3時間（12時間削減） |
| 商品管理（購買） | 購買商品マスタの管理 | 商品情報管理に月15時間 | 一元管理で月3時間（12時間削減） |
| 商品カテゴリ管理（購買） | 購買商品のカテゴリ管理 | カテゴリ管理に月5時間 | 階層管理で月1時間（4時間削減） |
| 商品属性管理（購買） | 購買商品の属性管理 | 属性管理に月5時間 | 体系的管理で月1時間（4時間削減） |
| パッケージング管理（購買） | 購買単位のパッケージ設定 | 梱包設定に月5時間 | 自動設定で月1時間（4時間削減） |

### 業務プロセス3: 在庫管理プロセス（入庫〜保管〜出庫〜棚卸）

#### プロセス概要

**業務フロー**

入庫検品 → 棚入れ → 保管 → ピッキング → 検品 → 梱包 → 出荷 / 棚卸 → 差異調整

**関係者**

倉庫担当者、物流担当者

**発生頻度**

月間1,000〜5,000件程度（入出庫合計）

#### 関連するドメイン課題

| ドメイン課題 | この業務プロセスでの具体的な影響 |
| ------------ | -------------------------------- |
| 在庫管理の不正確さ | 実在庫とシステム在庫の差異、欠品・過剰在庫の発生 |

#### 本業務をシステム化しない場合の想定リスク・コスト

**工数コスト**
- 入出庫記録: 月2000件 x 5分 = 月167時間
- 在庫照会: 月500回 x 10分 = 月83時間
- 棚卸作業: 月1回 x 80時間 = 月80時間
- **合計: 月330時間**

**その他リスク**
- 欠品による販売機会損失（月商の1〜3%程度）
- 過剰在庫による資金拘束
- 在庫差異の原因調査工数

#### 本業務をシステム化することの想定効果

**工数削減効果**
- 入出庫記録: バーコード・システム連携で月2000件 x 2分 = 月67時間（100時間削減）
- 在庫照会: リアルタイム参照で月500回 x 1分 = 月8時間（75時間削減）
- 棚卸作業: 循環棚卸・差異管理で月40時間（40時間削減）
- **合計: 月215時間削減（月115時間に短縮）**

#### 主な関連機能と業務インパクト

| 機能名 | 何をする機能か | 機能がない場合の運用工数 | 機能があることによるインパクト |
| ------ | ---------------------- | ------------------------ | ------------------------------ |
| 倉庫管理 | 倉庫情報・入出荷ステップの設定 | 倉庫設定管理に月5時間 | 一元管理で月1時間（4時間削減） |
| ロケーション管理 | 倉庫内の保管場所を階層管理 | 場所管理に月10時間 | 階層管理で月2時間（8時間削減） |
| 在庫移動管理 | 内部移動・入出庫を記録管理 | 月2000件×5分=月167時間 | 月2000件×2分=月67時間（100時間削減） |
| 在庫調整 | 棚卸差異・調整を記録 | 差異調整に月20時間 | システム記録で月5時間（15時間削減） |
| ルート管理 | 在庫の補充・移動ルールを設定 | 補充ルール管理に月5時間 | 自動化で月1時間（4時間削減） |
| ストレージカテゴリ管理 | 保管条件別のカテゴリ管理 | カテゴリ管理に月3時間 | 一元管理で月1時間（2時間削減） |
| パッケージタイプ管理 | 梱包タイプの管理 | タイプ管理に月3時間 | 一元管理で月1時間（2時間削減） |
| 商品カテゴリ管理（在庫） | 在庫管理用のカテゴリ | カテゴリ管理に月3時間 | 一元管理で月1時間（2時間削減） |

### 業務プロセス4: 会計・経理プロセス（請求〜入金・支払〜仕訳）

#### プロセス概要

**業務フロー**

請求書発行 → 入金確認 → 消込 / 仕入請求書受領 → 照合 → 支払処理 → 仕訳記帳

**関係者**

経理担当者、財務担当者

**発生頻度**

月間500〜2,000件程度（売掛・買掛合計）

#### 関連するドメイン課題

| ドメイン課題 | この業務プロセスでの具体的な影響 |
| ------------ | -------------------------------- |
| 業務データの分断 | 請求・入金・仕訳の情報が分断、照合に時間がかかる |

#### 本業務をシステム化しない場合の想定リスク・コスト

**工数コスト**
- 請求書作成: 月500件 x 10分 = 月83時間
- 入金消込: 月500件 x 5分 = 月42時間
- 仕入請求書照合: 月300件 x 10分 = 月50時間
- 支払処理: 月300件 x 5分 = 月25時間
- 仕訳入力: 月1000件 x 3分 = 月50時間
- **合計: 月250時間**

**その他リスク**
- 請求漏れ、入金漏れ
- 支払漏れ、二重支払
- 仕訳ミスによる決算遅延
- 税務調査対応リスク

#### 本業務をシステム化することの想定効果

**工数削減効果**
- 請求書作成: 受注連携で月500件 x 2分 = 月17時間（66時間削減）
- 入金消込: 自動消込で月500件 x 1分 = 月8時間（34時間削減）
- 請求書照合: 発注連携で月300件 x 3分 = 月15時間（35時間削減）
- 支払処理: 一括処理で月300件 x 1分 = 月5時間（20時間削減）
- 仕訳入力: 自動仕訳で月1000件 x 0.5分 = 月8時間（42時間削減）
- **合計: 月197時間削減（月53時間に短縮）**

#### 主な関連機能と業務インパクト

| 機能名 | 何をする機能か | 機能がない場合の運用工数 | 機能があることによるインパクト |
| ------ | ---------------------- | ------------------------ | ------------------------------ |
| 請求書管理 | 請求書の作成・発行・送付・状態管理 | 月500件×10分=月83時間 | 月500件×2分=月17時間（66時間削減） |
| 請求書管理（仕入） | 仕入先請求書の登録・照合・承認 | 月300件×10分=月50時間 | 月300件×3分=月15時間（35時間削減） |
| 返金管理 | クレジットノートの発行・管理 | 月20件×15分=月5時間 | 月20件×5分=月2時間（3時間削減） |
| 返金管理（仕入） | 仕入先への返品・返金管理 | 月10件×15分=月3時間 | 月10件×5分=月1時間（2時間削減） |
| 支払管理 | 支払登録・消込・一括処理 | 月300件×5分=月25時間 | 月300件×1分=月5時間（20時間削減） |
| 仕訳帳管理 | 仕訳帳の設定・管理 | 仕訳帳管理に月5時間 | 一元管理で月1時間（4時間削減） |
| 税管理 | 消費税・税率の設定・管理 | 税設定管理に月5時間 | 一元管理で月1時間（4時間削減） |
| 税グループ管理 | 税グループの設定 | グループ管理に月2時間 | 一元管理で月0.5時間（1.5時間削減） |
| 支払条件管理 | 支払条件の定義・管理 | 条件管理に月3時間 | 一元管理で月1時間（2時間削減） |
| 財政ポジション管理 | 取引先の税務ポジション管理 | ポジション管理に月3時間 | 一元管理で月1時間（2時間削減） |
| 銀行口座管理 | 会社・取引先の銀行口座管理 | 口座管理に月3時間 | 一元管理で月1時間（2時間削減） |
| インコターム管理 | 国際取引条件の管理 | 条件管理に月2時間 | 一元管理で月0.5時間（1.5時間削減） |
| 決済処理 | オンライン決済の処理 | 決済管理に月10時間 | 自動処理で月2時間（8時間削減） |
| 決済トランザクション管理 | 決済履歴の管理・追跡 | 履歴管理に月5時間 | 自動記録で月1時間（4時間削減） |
| ベンダー管理 | 仕入先（ベンダー）の管理 | 仕入先管理に月10時間 | 一元管理で月2時間（8時間削減） |
| 商品管理（請求） | 請求用商品マスタの管理 | 商品管理に月5時間 | 一元管理で月1時間（4時間削減） |

### 業務プロセス5: 人事管理プロセス（入社〜勤務〜退職）

#### プロセス概要

**業務フロー**

従業員登録 → 部門配属 → 勤務管理 → スキル・経歴管理 → 評価 → 異動・昇進 → 退職処理

**関係者**

人事担当者、各部門マネージャー

**発生頻度**

従業員数100名の場合：月間10〜50件程度（各種更新・申請）

#### 関連するドメイン課題

| ドメイン課題 | この業務プロセスでの具体的な影響 |
| ------------ | -------------------------------- |
| 人事情報管理の煩雑さ | 従業員情報が分散、スキル情報の活用困難 |

#### 本業務をシステム化しない場合の想定リスク・コスト

**工数コスト**
- 従業員情報管理: 100名 x 月15分 = 月25時間
- スキル・経歴管理: 100名 x 月10分 = 月17時間
- 部門・組織管理: 月10時間
- **合計: 月52時間**

**その他リスク**
- 人員配置の最適化困難
- スキルミスマッチによる生産性低下
- 法令遵守（労働基準法）のリスク

#### 本業務をシステム化することの想定効果

**工数削減効果**
- 従業員情報管理: 一元管理で100名 x 月5分 = 月8時間（17時間削減）
- スキル・経歴管理: 自己申告で100名 x 月3分 = 月5時間（12時間削減）
- 部門・組織管理: システム管理で月3時間（7時間削減）
- **合計: 月36時間削減（月16時間に短縮）**

#### 主な関連機能と業務インパクト

| 機能名 | 何をする機能か | 機能がない場合の運用工数 | 機能があることによるインパクト |
| ------ | ---------------------- | ------------------------ | ------------------------------ |
| 従業員管理 | 従業員情報の一元管理 | 月25時間 | 月8時間（17時間削減） |
| 部門管理 | 組織・部門の階層管理 | 月5時間 | 月1時間（4時間削減） |
| 職位管理 | 職位・ポジションの定義 | 月3時間 | 月1時間（2時間削減） |
| スキルタイプ管理 | スキルの種類・レベル定義 | 月3時間 | 月1時間（2時間削減） |
| 勤務カレンダー管理 | 勤務時間・休日の設定 | 月5時間 | 月1時間（4時間削減） |
| 従業員カテゴリ管理 | 従業員の分類管理 | 月2時間 | 月0.5時間（1.5時間削減） |
| 勤務地管理 | 勤務地の登録・管理 | 月2時間 | 月0.5時間（1.5時間削減） |
| 雇用形態管理 | 雇用形態の定義 | 月1時間 | 月0.5時間（0.5時間削減） |
| 退職理由管理 | 退職理由の分類・分析 | 月1時間 | 月0.5時間（0.5時間削減） |
| 活動プラン管理（人事） | 人事関連活動の計画 | 月2時間 | 月0.5時間（1.5時間削減） |
| 従業員スキルレポート | スキル状況のレポート出力 | 月5時間 | 月1時間（4時間削減） |

### 業務プロセス6: 採用プロセス（募集〜選考〜採用決定）

#### プロセス概要

**業務フロー**

求人作成 → 募集開始 → 応募受付 → 書類選考 → 面接（複数回） → 内定 → 入社手続き

**関係者**

採用担当者、面接官、人事担当者

**発生頻度**

年間10〜100名採用の場合：月間50〜500件程度（応募）

#### 関連するドメイン課題

| ドメイン課題 | この業務プロセスでの具体的な影響 |
| ------------ | -------------------------------- |
| 人事情報管理の煩雑さ | 応募者情報の管理が煩雑、選考状況の把握困難 |

#### 本業務をシステム化しない場合の想定リスク・コスト

**工数コスト**
- 応募者情報管理: 月100件 x 15分 = 月25時間
- 選考状況管理: 月100件 x 10分 = 月17時間
- 面接調整: 月50件 x 15分 = 月13時間
- **合計: 月55時間**

**その他リスク**
- 応募者対応の遅延による辞退
- 選考漏れ、重複対応
- 採用活動の分析・改善困難

#### 本業務をシステム化することの想定効果

**工数削減効果**
- 応募者情報管理: 一元管理で月100件 x 5分 = 月8時間（17時間削減）
- 選考状況管理: ステージ管理で月100件 x 3分 = 月5時間（12時間削減）
- 面接調整: カレンダー連携で月50件 x 5分 = 月4時間（9時間削減）
- **合計: 月38時間削減（月17時間に短縮）**

#### 主な関連機能と業務インパクト

| 機能名 | 何をする機能か | 機能がない場合の運用工数 | 機能があることによるインパクト |
| ------ | ---------------------- | ------------------------ | ------------------------------ |
| 応募者管理 | 応募者情報・選考状況の一元管理 | 月25時間 | 月8時間（17時間削減） |
| 求人管理 | 求人情報の作成・公開・管理 | 月10時間 | 月3時間（7時間削減） |
| 候補者管理 | 候補者プールの管理 | 月5時間 | 月1時間（4時間削減） |
| 採用ステージ管理 | 選考ステージの定義・管理 | 月2時間 | 月0.5時間（1.5時間削減） |
| 学歴管理 | 学歴情報の分類・管理 | 月1時間 | 月0.5時間（0.5時間削減） |
| 不採用理由管理 | 不採用理由の分類・分析 | 月2時間 | 月0.5時間（1.5時間削減） |
| 応募者カテゴリ管理 | 応募者の分類管理 | 月1時間 | 月0.5時間（0.5時間削減） |
| 雇用形態管理（採用） | 採用時の雇用形態定義 | 月1時間 | 月0.5時間（0.5時間削減） |
| スキルタイプ管理（採用） | 採用時のスキル評価基準 | 月1時間 | 月0.5時間（0.5時間削減） |
| UTMソース管理 | 応募経路（ソース）の管理 | 月2時間 | 月0.5時間（1.5時間削減） |
| UTMメディア管理 | 応募経路（メディア）の管理 | 月1時間 | 月0.5時間（0.5時間削減） |
| 活動タイプ管理（採用） | 採用活動の種類定義 | 月1時間 | 月0.5時間（0.5時間削減） |
| 活動プラン管理（採用） | 採用活動の計画管理 | 月2時間 | 月0.5時間（1.5時間削減） |
| 部門管理（採用） | 採用部門の管理 | 月1時間 | 月0.5時間（0.5時間削減） |

### 業務プロセス7: 休暇管理プロセス（申請〜承認〜取得）

#### プロセス概要

**業務フロー**

休暇申請 → 上長承認 → 人事確認 → 休暇取得 → 残高更新 / 休暇割当 → 残高管理

**関係者**

従業員（全員）、マネージャー、人事担当者

**発生頻度**

従業員100名の場合：月間50〜150件程度

#### 関連するドメイン課題

| ドメイン課題 | この業務プロセスでの具体的な影響 |
| ------------ | -------------------------------- |
| 人事情報管理の煩雑さ | 休暇残高管理が煩雑、承認フローが非効率 |

#### 本業務をシステム化しない場合の想定リスク・コスト

**工数コスト**
- 休暇申請処理: 月100件 x 10分 = 月17時間
- 残高管理: 100名 x 月5分 = 月8時間
- 割当管理: 月5時間
- **合計: 月30時間**

**その他リスク**
- 休暇残高の不正確さ
- 承認遅延による業務影響
- 法令遵守（年次有給休暇取得義務）のリスク

#### 本業務をシステム化することの想定効果

**工数削減効果**
- 休暇申請処理: オンライン申請で月100件 x 2分 = 月3時間（14時間削減）
- 残高管理: 自動計算で月1時間（7時間削減）
- 割当管理: 自動付与で月1時間（4時間削減）
- **合計: 月25時間削減（月5時間に短縮）**

#### 主な関連機能と業務インパクト

| 機能名 | 何をする機能か | 機能がない場合の運用工数 | 機能があることによるインパクト |
| ------ | ---------------------- | ------------------------ | ------------------------------ |
| 休暇申請管理 | 全従業員の休暇申請を一元管理 | 月17時間 | 月3時間（14時間削減） |
| 自分の休暇管理 | 従業員自身の休暇申請・確認 | 月5時間（問い合わせ対応） | 月0.5時間（4.5時間削減） |
| 休暇割当管理 | 休暇日数の割当・管理 | 月5時間 | 月1時間（4時間削減） |
| 自分の休暇割当管理 | 従業員自身の残高確認 | 月3時間（問い合わせ対応） | 月0.5時間（2.5時間削減） |
| 休暇タイプ管理 | 休暇種類の定義 | 月2時間 | 月0.5時間（1.5時間削減） |
| 休暇発生プラン管理 | 休暇の自動付与ルール設定 | 月3時間 | 月0.5時間（2.5時間削減） |
| 祝日管理 | 祝日の登録・管理 | 月1時間 | 月0.5時間（0.5時間削減） |
| 必須休暇日管理 | 一斉休暇日の設定 | 月1時間 | 月0.5時間（0.5時間削減） |
| 活動タイプ管理（休暇） | 休暇関連活動の種類定義 | 月0.5時間 | 月0.2時間（0.3時間削減） |

### 業務プロセス8: プロジェクト・工数管理プロセス

#### プロセス概要

**業務フロー**

プロジェクト作成 → タスク分解 → 担当者アサイン → 作業実施 → 工数入力 → 進捗管理 → 完了

**関係者**

プロジェクトマネージャー、プロジェクトメンバー

**発生頻度**

プロジェクト10件、メンバー50名の場合：月間1,000件程度（工数入力）

#### 関連するドメイン課題

| ドメイン課題 | この業務プロセスでの具体的な影響 |
| ------------ | -------------------------------- |
| プロジェクト工数管理の困難さ | 実績工数の把握困難、採算管理が不正確 |

#### 本業務をシステム化しない場合の想定リスク・コスト

**工数コスト**
- プロジェクト管理: 10件 x 月5時間 = 月50時間
- タスク管理: 100件 x 月10分 = 月17時間
- 工数集計: 月1000件 x 2分 = 月33時間
- **合計: 月100時間**

**その他リスク**
- プロジェクト採算の把握困難
- リソース配分の最適化困難
- 見積もり精度の向上困難

#### 本業務をシステム化することの想定効果

**工数削減効果**
- プロジェクト管理: ダッシュボードで10件 x 月2時間 = 月20時間（30時間削減）
- タスク管理: カンバンで100件 x 月3分 = 月5時間（12時間削減）
- 工数集計: 自動集計で月5時間（28時間削減）
- **合計: 月70時間削減（月30時間に短縮）**

#### 主な関連機能と業務インパクト

| 機能名 | 何をする機能か | 機能がない場合の運用工数 | 機能があることによるインパクト |
| ------ | ---------------------- | ------------------------ | ------------------------------ |
| プロジェクト管理 | プロジェクトの作成・進捗管理 | 月50時間 | 月20時間（30時間削減） |
| タスク管理 | タスクの作成・状態管理 | 月17時間 | 月5時間（12時間削減） |
| マイルストーン管理 | マイルストーンの設定・追跡 | 月5時間 | 月1時間（4時間削減） |
| タスクステージ管理 | タスク状態の定義 | 月2時間 | 月0.5時間（1.5時間削減） |
| サブタスク管理 | タスクの分割・階層管理 | 月5時間 | 月1時間（4時間削減） |
| タスク工数管理 | タスク別の工数入力・集計 | 月20時間 | 月3時間（17時間削減） |
| タイムシート管理 | 日別の工数入力 | 月33時間 | 月5時間（28時間削減） |

### 業務プロセス9: システム管理・共通機能

#### プロセス概要

**業務フロー**

システム設定 → ユーザー管理 → 権限設定 → マスタ管理 → 運用監視

**関係者**

システム管理者

**発生頻度**

月間10〜50件程度（設定変更・ユーザー管理）

#### 関連するドメイン課題

| ドメイン課題 | この業務プロセスでの具体的な影響 |
| ------------ | -------------------------------- |
| 業務データの分断 | 複数システムのユーザー管理が煩雑 |

#### 本業務をシステム化しない場合の想定リスク・コスト

**工数コスト**
- ユーザー管理: 月20件 x 15分 = 月5時間
- 権限管理: 月10件 x 20分 = 月3時間
- マスタ管理: 月10時間
- **合計: 月18時間**

**その他リスク**
- セキュリティリスク（権限管理漏れ）
- 設定不整合によるシステム障害

#### 本業務をシステム化することの想定効果

統合ERPとしてユーザー・権限を一元管理することで、複数システム管理の煩雑さを解消。

#### 主な関連機能と業務インパクト

| 機能名 | 何をする機能か | 機能がない場合の運用工数 | 機能があることによるインパクト |
| ------ | ---------------------- | ------------------------ | ------------------------------ |
| プラグイン管理 | システムプラグインの有効化・管理 | 設定ファイル直接編集に月3時間 | GUI操作で月0.5時間（2.5時間削減） |
| ユーザー管理 | システムユーザーの登録・管理 | 月5時間 | 月2時間（3時間削減） |
| ロール管理 | ユーザーロール・権限の定義 | 月3時間 | 月1時間（2時間削減） |
| 会社管理 | マルチカンパニーの会社設定 | 月2時間 | 月0.5時間（1.5時間削減） |
| チーム管理 | チームの作成・メンバー管理 | 月2時間 | 月0.5時間（1.5時間削減） |
| カスタムフィールド管理 | 各リソースへのカスタム項目追加 | 開発依頼で月5時間 | 設定画面で月1時間（4時間削減） |
| テーブルビュー管理 | 一覧画面のカスタマイズ | 開発依頼で月3時間 | 設定画面で月0.5時間（2.5時間削減） |

### 業務プロセス10: 商品・パートナーマスタ管理

#### プロセス概要

**業務フロー**

商品登録 → カテゴリ設定 → 価格設定 → 属性設定 / パートナー登録 → 住所設定 → 連絡先設定

**関係者**

商品管理者、営業担当者

**発生頻度**

月間50〜200件程度（新規登録・更新）

#### 関連するドメイン課題

| ドメイン課題 | この業務プロセスでの具体的な影響 |
| ------------ | -------------------------------- |
| 業務データの分断 | 商品・取引先情報が部門ごとに分散 |

#### 主な関連機能と業務インパクト

| 機能名 | 何をする機能か | 機能がない場合の運用工数 | 機能があることによるインパクト |
| ------ | ---------------------- | ------------------------ | ------------------------------ |
| 商品マスタ管理 | 商品情報の一元管理 | 月20時間 | 月5時間（15時間削減） |
| 商品カテゴリ管理 | 商品カテゴリの階層管理 | 月5時間 | 月1時間（4時間削減） |
| 商品属性管理 | 商品属性・バリエーション管理 | 月10時間 | 月2時間（8時間削減） |
| パッケージング管理 | 梱包・販売単位の管理 | 月5時間 | 月1時間（4時間削減） |
| パートナー管理 | 顧客・仕入先の統合管理 | 月15時間 | 月3時間（12時間削減） |
| 住所管理 | パートナーの複数住所管理 | 月5時間 | 月1時間（4時間削減） |
| 連絡先管理 | パートナーの連絡先管理 | 月3時間 | 月1時間（2時間削減） |
| パートナー関係管理 | パートナー間の関係管理 | 月2時間 | 月0.5時間（1.5時間削減） |
| 連絡先設定管理 | 連絡先の設定管理 | 月1時間 | 月0.5時間（0.5時間削減） |

### 業務プロセス11: Webサイト・ブログ管理（付加機能）

#### プロセス概要

**業務フロー**

記事作成 → カテゴリ・タグ設定 → 公開 / ページ作成 → SEO設定 → 公開

**関係者**

コンテンツ管理者、マーケティング担当者

**発生頻度**

月間10〜50件程度

#### 主な関連機能と業務インパクト

| 機能名 | 何をする機能か | 機能がない場合の運用工数 | 機能があることによるインパクト |
| ------ | ---------------------- | ------------------------ | ------------------------------ |
| ブログ記事管理 | ブログ記事の作成・公開 | 外部ツールで月10時間 | 統合管理で月5時間（5時間削減） |
| ブログカテゴリ管理 | 記事カテゴリの管理 | 月2時間 | 月0.5時間（1.5時間削減） |
| ブログタグ管理 | 記事タグの管理 | 月2時間 | 月0.5時間（1.5時間削減） |
| ページ管理 | Webサイトページの管理 | 外部ツールで月5時間 | 統合管理で月2時間（3時間削減） |
| ウェブサイトパートナー管理 | Webサイト経由の顧客管理 | 月3時間 | 月1時間（2時間削減） |

### 業務プロセス12: 共通コンポーネント・基盤機能

#### プロセス概要

各業務プロセスを横断的に支援する共通機能群。

#### 主な関連機能と業務インパクト

| 機能名 | 何をする機能か | 機能がない場合の運用工数 | 機能があることによるインパクト |
| ------ | ---------------------- | ------------------------ | ------------------------------ |
| サポート | 基盤機能・共通ライブラリ | （基盤なので比較不可） | システム全体の安定稼働を支援 |
| フルカレンダー | カレンダー表示機能 | 個別実装に月5時間 | 統合機能で月0時間（5時間削減） |
| アナリティクス | データ分析・可視化 | Excel集計に月20時間 | ダッシュボードで月2時間（18時間削減） |
| チャッター | コミュニケーション機能 | 別ツールで管理 | 統合管理で情報の一元化 |

## 3. 各機能想定意図サマリー

### システム管理・基盤機能（機能1〜11）

| 機能名 | 背景にある業務課題 | 業務負荷（推察） | 主な解決アプローチ | 手動運用を選ばなかった理由 |
| --- | --- | --- | --- | --- |
| プラグイン管理 | システム拡張・機能ON/OFFの管理が煩雑 | 低（随時） | プラグインの有効/無効をGUIで切替 | 設定ファイル直接編集は専門知識が必要で運用ミスリスクがあるため |
| ユーザー管理 | ユーザー追加・権限設定の手作業負担 | 中（月数件〜数十件） | ユーザーCRUD・招待機能 | 手動でのDB操作はセキュリティリスクがあるため |
| ロール管理 | 権限設定の一貫性維持が困難 | 中（随時） | ロール単位でのパーミッション管理 | 個別設定では漏れ・矛盾が発生するため |
| 会社管理 | マルチカンパニー環境での会社情報管理 | 低（随時） | 会社情報の一元管理 | 複数会社のデータ分離を確実に行うため |
| チーム管理 | チーム単位での業務管理が困難 | 低（随時） | チーム作成・メンバー管理 | 部門横断的なチーム編成を柔軟に行うため |
| カスタムフィールド管理 | 業種特有の項目追加にシステム改修が必要 | 中（随時） | ノーコードでのフィールド追加 | 開発依頼なしで業務に必要な項目を追加するため |
| テーブルビュー管理 | 一覧画面のカスタマイズにシステム改修が必要 | 低（随時） | 表示項目のカスタマイズ | ユーザーが必要な情報を自由に表示するため |
| アナリティクス | 経営データの可視化に手作業集計が必要 | 高（月次） | ダッシュボード・レポート機能 | Excel集計では工数がかかり、リアルタイム性がないため |
| チャッター | 業務データとコミュニケーションが分離 | 中（日次） | 各レコードにコメント・活動記録 | 別ツールでは業務コンテキストが失われるため |
| フルカレンダー | スケジュール表示の統合が困難 | 中（日次） | カレンダー形式での予定表示 | 複数機能の予定を一元的に確認するため |
| サポート | システム基盤の共通機能が必要 | （基盤） | 共通ライブラリ・ユーティリティ | システム全体の品質・保守性を確保するため |

### 販売管理機能（機能12〜24）

| 機能名 | 背景にある業務課題 | 業務負荷（推察） | 主な解決アプローチ | 手動運用を選ばなかった理由 |
| --- | --- | --- | --- | --- |
| 見積書管理 | 見積作成に時間がかかり、価格設定ミスが発生 | 高（月500件程度） | 商品・価格マスタ連携の見積自動生成 | 手作業では工数が大きく、ミスが多発するため |
| 受注管理 | 見積から受注への転記作業が発生 | 高（月500件程度） | 見積からの受注変換、出荷連携 | 転記ミス防止と後続工程への自動連携のため |
| 顧客管理 | 顧客情報が分散し、検索に時間がかかる | 高（日次） | 顧客情報の一元管理・検索 | 顧客対応のスピードと品質を向上するため |
| 商品管理（販売） | 販売商品情報の管理が煩雑 | 中（月数十件） | 商品マスタの一元管理 | 価格・在庫連携を正確に行うため |
| 請求対象管理 | 請求漏れが発生する | 中（月次） | 請求対象の自動抽出 | 請求漏れを防止し、確実に売上を回収するため |
| 販売チーム管理 | チーム別の売上管理が困難 | 低（随時） | チーム定義・目標管理 | 営業チーム単位の業績管理を行うため |
| 見積テンプレート管理 | 定型見積の作成に時間がかかる | 低（随時） | テンプレートの事前定義 | 見積作成の効率化とミス防止のため |
| 商品カテゴリ管理（販売） | 商品分類が統一されていない | 低（随時） | カテゴリの階層管理 | 商品検索と分析を効率化するため |
| 商品属性管理（販売） | 商品バリエーション管理が煩雑 | 中（随時） | 属性・バリエーションの体系的管理 | サイズ・色などの組み合わせを効率的に管理するため |
| パッケージング管理（販売） | 梱包・販売単位の設定が煩雑 | 低（随時） | パッケージング定義 | 販売単位と在庫単位の変換を自動化するため |
| タグ管理（販売） | 見積・受注の分類が困難 | 低（随時） | タグによる分類 | 検索・分析を効率化するため |
| 活動タイプ管理（販売） | 営業活動の種類が統一されていない | 低（随時） | 活動タイプの定義 | 営業活動の可視化と分析を可能にするため |
| 活動プラン管理（販売） | フォローアップの漏れが発生 | 低（随時） | 活動プランの事前定義 | 定型的な営業活動を確実に実行するため |

### 購買管理機能（機能25〜33）

| 機能名 | 背景にある業務課題 | 業務負荷（推察） | 主な解決アプローチ | 手動運用を選ばなかった理由 |
| --- | --- | --- | --- | --- |
| 発注書管理 | 発注書作成に時間がかかり、入庫管理が煩雑 | 高（月300件程度） | RFQからの発注変換、入庫連携 | 転記ミス防止と入庫管理の効率化のため |
| 見積依頼（RFQ）管理 | 仕入先への見積依頼管理が煩雑 | 高（月300件程度） | RFQの作成・送付・回答管理 | 見積比較と発注判断を効率化するため |
| 仕入先管理 | 仕入先情報が分散している | 中（随時） | 仕入先情報の一元管理 | 取引条件の参照と比較を容易にするため |
| 商品管理（購買） | 購買商品情報の管理が煩雑 | 中（月数十件） | 購買用商品マスタの管理 | 仕入価格・リードタイム管理を正確に行うため |
| 購買依頼管理 | 社内からの購買依頼が口頭やメールで散逸 | 中（月数十件） | 購買依頼の一元管理 | 依頼の漏れ防止と優先度管理のため |
| 商品カテゴリ管理（購買） | 購買商品の分類が統一されていない | 低（随時） | カテゴリの階層管理 | 発注分析と在庫管理を効率化するため |
| 仕入先価格管理 | 仕入先別の価格管理が煩雑 | 中（随時） | 仕入先・商品・数量別の価格設定 | 最適な仕入先選定と価格交渉を支援するため |
| 商品属性管理（購買） | 購買商品の属性管理が煩雑 | 低（随時） | 属性の体系的管理 | 商品仕様の管理を効率化するため |
| パッケージング管理（購買） | 入荷単位の設定が煩雑 | 低（随時） | パッケージング定義 | 入荷単位と在庫単位の変換を自動化するため |

### 在庫管理機能（機能34〜40、F041）

| 機能名 | 背景にある業務課題 | 業務負荷（推察） | 主な解決アプローチ | 手動運用を選ばなかった理由 |
| --- | --- | --- | --- | --- |
| 倉庫管理 | 倉庫情報・運用設定の管理が煩雑 | 低（随時） | 倉庫マスタの一元管理 | 複数倉庫運用の効率化のため |
| ロケーション管理 | 保管場所の把握が困難 | 中（随時） | ロケーションの階層管理 | ピッキング効率と在庫精度向上のため |
| 在庫移動管理 | 在庫移動の記録が遅延・漏れがある | 高（月2000件程度） | 移動オペレーションの記録 | リアルタイムな在庫把握のため |
| 在庫調整 | 棚卸差異の調整に時間がかかる | 中（月次） | 調整オペレーションの記録 | 差異原因の追跡と在庫精度向上のため |
| ルート管理 | 在庫補充ルールの設定が煩雑 | 低（随時） | ルール定義による自動化 | 補充作業の効率化と欠品防止のため |
| ストレージカテゴリ管理 | 保管条件別の管理が困難 | 低（随時） | カテゴリの定義 | 保管条件の適切な管理のため |
| パッケージタイプ管理 | 梱包タイプの管理が煩雑 | 低（随時） | タイプの定義 | 出荷作業の効率化のため |
| 商品カテゴリ管理（在庫） | 在庫管理用のカテゴリが必要 | 低（随時） | カテゴリの定義 | 在庫分析と管理の効率化のため |

### 会計管理機能（機能51〜58、F042〜F050）

| 機能名 | 背景にある業務課題 | 業務負荷（推察） | 主な解決アプローチ | 手動運用を選ばなかった理由 |
| --- | --- | --- | --- | --- |
| 顧客請求書管理 | 請求書作成と送付に時間がかかる | 高（月500件程度） | 受注からの自動生成、メール送信 | 請求漏れ防止と工数削減のため |
| 返金管理（仕入） | 返品・返金処理が煩雑 | 低（月数件） | クレジットノートの発行・管理 | 正確な債務管理のため |
| 支払管理 | 支払処理と消込に時間がかかる | 高（月300件程度） | 支払登録・自動消込 | 支払漏れ・重複支払防止のため |
| ベンダー管理 | 仕入先の財務情報管理が煩雑 | 中（随時） | 仕入先財務情報の一元管理 | 支払管理の効率化のため |
| 商品管理（請求） | 請求用商品情報の管理が必要 | 低（随時） | 請求用商品マスタの管理 | サービス商品の請求対応のため |
| インコターム管理 | 国際取引条件の管理が煩雑 | 低（随時） | インコタームの定義 | 国際取引の条件管理を効率化するため |
| 決済処理 | オンライン決済の処理が煩雑 | 中（随時） | 決済処理の自動化 | 決済処理のスピードと正確性向上のため |
| 決済トランザクション管理 | 決済履歴の追跡が困難 | 中（随時） | 履歴の自動記録 | 決済状況の追跡と分析のため |
| 請求書管理 | 請求書全般の管理が必要 | 高（月500件程度） | 請求書の一元管理 | 売上管理と債権管理の効率化のため |
| 返金管理 | 顧客への返金処理が煩雑 | 低（月数件） | クレジットノートの発行 | 正確な債権管理のため |
| 仕訳帳管理 | 仕訳帳の設定・管理が煩雑 | 低（随時） | 仕訳帳の定義 | 会計処理の効率化のため |
| 税グループ管理 | 税グループの設定が必要 | 低（随時） | グループの定義 | 税計算の効率化のため |
| 税管理 | 消費税率の管理が煩雑 | 低（随時） | 税設定の一元管理 | 税計算の正確性確保のため |
| 財政ポジション管理 | 取引先の税務ポジション管理が必要 | 低（随時） | ポジションの定義 | 税務処理の適切な適用のため |
| 銀行口座管理 | 銀行口座情報の管理が煩雑 | 低（随時） | 口座情報の一元管理 | 入出金処理の効率化のため |
| 支払条件管理 | 支払条件の設定が煩雑 | 低（随時） | 条件の定義 | 請求・支払処理の効率化のため |
| 請求書管理（仕入） | 仕入請求書の照合に時間がかかる | 高（月300件程度） | 発注連携・自動照合 | 照合作業の効率化と支払精度向上のため |

### 商品・パートナーマスタ管理機能（機能59〜67）

| 機能名 | 背景にある業務課題 | 業務負荷（推察） | 主な解決アプローチ | 手動運用を選ばなかった理由 |
| --- | --- | --- | --- | --- |
| 商品マスタ管理 | 商品情報が部門ごとに分散 | 高（月数十件） | 商品情報の一元管理 | 全社的な商品情報の統一のため |
| 商品カテゴリ管理 | 商品分類が統一されていない | 低（随時） | カテゴリの階層管理 | 商品検索と分析の効率化のため |
| 商品属性管理 | 商品属性の管理が煩雑 | 中（随時） | 属性・バリエーションの体系的管理 | 商品情報の完全性確保のため |
| 価格リスト管理 | 顧客別価格の管理が煩雑 | 中（随時） | 価格リストの定義 | 価格設定の一貫性確保のため |
| パッケージング管理 | 梱包単位の設定が煩雑 | 低（随時） | パッケージングの定義 | 販売・在庫単位の変換自動化のため |
| パートナー管理 | 顧客・仕入先情報が分散 | 高（月数十件） | パートナー情報の一元管理 | 顧客・仕入先情報の統一のため |
| 住所管理 | 住所情報の管理が煩雑 | 中（随時） | 複数住所の一元管理 | 配送先・請求先管理の効率化のため |
| 連絡先管理 | 連絡先情報が分散 | 中（随時） | 連絡先の一元管理 | コミュニケーションの効率化のため |
| パートナー関係管理 | パートナー間の関係把握が困難 | 低（随時） | 関係性の定義・管理 | グループ会社管理などの効率化のため |

### 人事管理機能（機能68〜78）

| 機能名 | 背景にある業務課題 | 業務負荷（推察） | 主な解決アプローチ | 手動運用を選ばなかった理由 |
| --- | --- | --- | --- | --- |
| 従業員管理 | 従業員情報が分散している | 高（随時） | 従業員情報の一元管理 | 人事情報の正確性と参照性向上のため |
| 部門管理 | 組織構造の把握・管理が困難 | 中（随時） | 部門の階層管理 | 組織変更への柔軟な対応のため |
| 職位管理 | 職位の定義が統一されていない | 低（随時） | 職位の定義・管理 | 人員計画と採用管理の効率化のため |
| スキルタイプ管理 | スキル評価基準が統一されていない | 低（随時） | スキルタイプの定義 | スキル管理の体系化のため |
| 勤務カレンダー管理 | 勤務パターンの管理が煩雑 | 中（随時） | カレンダーの定義 | 勤怠管理の効率化のため |
| 従業員カテゴリ管理 | 従業員の分類が困難 | 低（随時） | カテゴリの定義 | 従業員分析の効率化のため |
| 勤務地管理 | 勤務地情報の管理が煩雑 | 低（随時） | 勤務地の定義 | リモートワーク対応などのため |
| 雇用形態管理 | 雇用形態の定義が必要 | 低（随時） | 雇用形態の定義 | 人事管理の正確性確保のため |
| 退職理由管理 | 退職理由の分析が困難 | 低（随時） | 理由の分類 | 離職分析と対策立案のため |
| 活動プラン管理（人事） | 人事関連活動の漏れが発生 | 低（随時） | 活動プランの定義 | 入社・異動時の漏れ防止のため |
| 従業員スキルレポート | スキル状況の把握が困難 | 低（月次） | レポート自動生成 | 人材配置の最適化のため |

### 採用管理機能（機能79〜92）

| 機能名 | 背景にある業務課題 | 業務負荷（推察） | 主な解決アプローチ | 手動運用を選ばなかった理由 |
| --- | --- | --- | --- | --- |
| 応募者管理 | 応募者情報と選考状況の管理が煩雑 | 高（月100件程度） | 応募者の一元管理・ステージ管理 | 選考漏れ防止と進捗可視化のため |
| 求人管理 | 求人情報の管理・公開が煩雑 | 中（随時） | 求人情報の一元管理 | 採用活動の効率化のため |
| 候補者管理 | 候補者プールの管理が困難 | 中（随時） | 候補者情報の蓄積 | 将来の採用に向けた人材データベース化のため |
| 採用ステージ管理 | 選考ステージの定義が統一されていない | 低（随時） | ステージの定義 | 選考プロセスの標準化のため |
| 学歴管理 | 学歴情報の分類が必要 | 低（随時） | 学歴の分類定義 | 応募者評価の効率化のため |
| 不採用理由管理 | 不採用理由の分析が困難 | 低（随時） | 理由の分類 | 採用活動の改善のため |
| 応募者カテゴリ管理 | 応募者の分類が困難 | 低（随時） | カテゴリの定義 | 応募者分析の効率化のため |
| 雇用形態管理（採用） | 採用時の雇用形態定義が必要 | 低（随時） | 雇用形態の定義 | 求人・採用条件の明確化のため |
| スキルタイプ管理（採用） | 採用時のスキル評価基準が必要 | 低（随時） | スキルタイプの定義 | スキルマッチングの効率化のため |
| UTMソース管理 | 応募経路の分析が困難 | 低（随時） | ソースの定義 | 採用チャネル分析のため |
| UTMメディア管理 | 応募メディアの分析が困難 | 低（随時） | メディアの定義 | 採用広告効果分析のため |
| 活動タイプ管理（採用） | 採用活動の種類が統一されていない | 低（随時） | 活動タイプの定義 | 採用活動の可視化のため |
| 活動プラン管理（採用） | 採用活動の漏れが発生 | 低（随時） | 活動プランの定義 | 面接調整などの漏れ防止のため |
| 部門管理（採用） | 採用部門の管理が必要 | 低（随時） | 部門の定義 | 部門別採用管理のため |

### 休暇管理機能（機能93〜101）

| 機能名 | 背景にある業務課題 | 業務負荷（推察） | 主な解決アプローチ | 手動運用を選ばなかった理由 |
| --- | --- | --- | --- | --- |
| 休暇申請管理 | 休暇申請の処理に時間がかかる | 高（月100件程度） | オンライン申請・承認 | 承認遅延防止と工数削減のため |
| 自分の休暇管理 | 従業員が自分の休暇状況を把握困難 | 中（日次） | セルフサービスでの確認・申請 | 問い合わせ対応工数削減のため |
| 休暇割当管理 | 休暇日数の割当管理が煩雑 | 中（年次） | 割当の一元管理 | 残高管理の正確性確保のため |
| 自分の休暇割当管理 | 従業員が残高を把握困難 | 中（随時） | セルフサービスでの確認 | 問い合わせ対応工数削減のため |
| 休暇タイプ管理 | 休暇種類の定義が必要 | 低（随時） | タイプの定義 | 休暇管理の体系化のため |
| 休暇発生プラン管理 | 休暇の自動付与が煩雑 | 低（年次） | 発生プランの定義 | 付与漏れ防止と工数削減のため |
| 祝日管理 | 祝日の管理が必要 | 低（年次） | 祝日の登録 | カレンダー連携のため |
| 必須休暇日管理 | 一斉休暇日の管理が必要 | 低（年次） | 必須休暇日の定義 | 会社カレンダー管理のため |
| 活動タイプ管理（休暇） | 休暇関連活動の定義が必要 | 低（随時） | 活動タイプの定義 | 休暇関連コミュニケーションのため |

### プロジェクト・工数管理機能（機能102〜108）

| 機能名 | 背景にある業務課題 | 業務負荷（推察） | 主な解決アプローチ | 手動運用を選ばなかった理由 |
| --- | --- | --- | --- | --- |
| タイムシート管理 | 工数入力と集計に時間がかかる | 高（日次） | オンライン工数入力・自動集計 | 工数把握の正確性と効率化のため |
| プロジェクト管理 | プロジェクト状況の把握が困難 | 高（随時） | プロジェクトの一元管理 | 進捗可視化と採算管理のため |
| タスク管理 | タスクの状況把握が困難 | 高（日次） | タスクの一元管理・カンバン | 進捗可視化と担当者管理のため |
| マイルストーン管理 | マイルストーンの管理が煩雑 | 中（随時） | マイルストーンの定義・追跡 | 期日管理の効率化のため |
| タスクステージ管理 | タスク状態の定義が必要 | 低（随時） | ステージの定義 | ワークフロー管理の標準化のため |
| サブタスク管理 | タスクの分割管理が困難 | 中（随時） | サブタスクの階層管理 | 作業分解の効率化のため |
| タスク工数管理 | タスク別工数の把握が困難 | 高（日次） | タスク別工数の入力・集計 | タスク単位の採算管理のため |

### Webサイト・ブログ管理機能（機能109〜114）

| 機能名 | 背景にある業務課題 | 業務負荷（推察） | 主な解決アプローチ | 手動運用を選ばなかった理由 |
| --- | --- | --- | --- | --- |
| ブログ記事管理 | ブログ運用に外部ツールが必要 | 中（月数件） | 記事の作成・公開 | ERPとの情報統合のため |
| ブログカテゴリ管理 | カテゴリ管理が必要 | 低（随時） | カテゴリの定義 | 記事整理の効率化のため |
| ブログタグ管理 | タグ管理が必要 | 低（随時） | タグの定義 | 記事検索の効率化のため |
| ページ管理 | Webページ管理に外部ツールが必要 | 中（月数件） | ページの作成・公開 | ERPとの情報統合のため |
| ウェブサイトパートナー管理 | Web経由の顧客管理が煩雑 | 低（随時） | パートナーとの連携 | リード獲得の効率化のため |
| 連絡先設定管理 | 連絡先設定の管理が必要 | 低（随時） | 設定の管理 | 問い合わせ対応の効率化のため |

## 4. 技術設計判断サマリー

> 技術的な設計判断の詳細（アーキテクチャ、DB設計、キャッシュ戦略等）は **アーキテクチャ設計意図書** を参照してください。

本機能群に関連する主要な技術設計判断のサマリーを以下に示す。

| 設計論点 | 採用した方針 | 選択理由（概要） |
| --- | --- | --- |
| トランザクション境界 | ユースケース単位（ヘッダ+明細を同一トランザクション） | 業務処理の原子性を保証するため |
| バリデーション | 入力層（Filament Forms）＋ドメイン層（モデル）での2層バリデーション | 早期エラー検出と業務ルール保護の両立 |
| 共通処理 | トレイト（HasChatter, HasLogActivity等）による共通化 | コード再利用とメンテナンス性向上 |
| 状態管理 | Enum（State列挙型）による状態定義 | 状態遷移の明示化とタイプセーフティ確保 |
| 論理削除 | SoftDeletesトレイトによる論理削除 | データ復元可能性とトレーサビリティ確保 |
| 権限管理 | Filament Shield + Spatie Permission | ロールベースアクセス制御の標準実装 |
| UI基盤 | Filament v3（Laravel Admin Panel） | 開発効率とUI/UXの統一性 |

## 備考

### 本書の前提と限界

- 本書の工数・効果の数値は、機能設計書・業務要件一覧・コード分析に基づく**推測値**である
- 実際の効果は、企業の規模、業務量、システム導入前の運用状況により大きく異なる
- 定量的な効果検証には、導入前後での計測が必要である

### 根拠となった情報源

1. `docs/code-to-docs/機能設計書/` 配下の114件の機能設計書
2. `docs/code-to-docs/業務要件一覧/業務要件一覧.csv`（83件の業務要件）
3. システムコード内の命名・コメント・バリデーションルール

### 関連ドキュメント

- アーキテクチャ設計意図書: 技術的な設計判断の詳細
- 機能設計書: 各機能の詳細仕様
- 業務要件一覧: 業務要件の詳細
