# 画面設計意図書

## 概要

本書は、Aureus ERPシステムの各画面が**なぜ実装されるに至ったか**を業務課題起点で記述する。
**各画面が存在する業務上の理由**を明らかにすることを目的とし、併せて技術設計判断の根拠も記載する。

## 1. ドメイン概要

> ドメイン概要（業界・業種、主なステークホルダー、システムの位置づけ、ドメイン共通課題等）は **機能設計意図書** を参照してください。
> ※機能設計意図書が未作成の場合は、以下の概要を参照してください。

### システム概要（参考）

Aureus ERPは、中小企業から大企業向けのオープンソースERP（Enterprise Resource Planning）システムです。

- **業界・業種**: 製造業、卸売業、小売業、サービス業等、幅広い業種に対応
- **主なステークホルダー**: 経営者、経理担当、営業担当、購買担当、倉庫担当、人事担当、プロジェクトマネージャー
- **システムの位置づけ**: 企業の基幹業務を統合管理するERPシステム
- **対象画面数**: 369画面
- **対象機能数**: 114機能

## 2. 業務プロセス別の画面と想定価値

### 業務プロセス1: 販売管理

#### プロセス概要

**業務フロー**

顧客から見積依頼 → 見積書作成 → 見積書送信 → 受注確定 → 出荷手配 → 請求書発行 → 入金確認

**関係者**

営業担当、営業マネージャー、経理担当、倉庫担当

**発生頻度**

日次（毎営業日）、中規模企業で1日約50〜200件程度と推測される

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 見積・受注の管理煩雑さ | Excel管理では入力ミス、バージョン管理、情報共有に課題が生じやすい |
| 在庫状況との連携不足 | 受注時に在庫状況をリアルタイムで確認できず、納期遅延リスクが発生する |
| 請求書発行の手作業 | 受注データから請求書を手動作成すると転記ミス、発行遅延が発生する |
| 顧客情報の分散管理 | 顧客情報が複数ファイルに分散し、最新情報の把握が困難 |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **工数コスト**: 見積書作成（月200件×20分=月67時間）、受注入力（月200件×15分=月50時間）、請求書発行（月200件×10分=月33時間）で月150時間以上の事務作業が発生
- **品質リスク**: 手入力による転記ミス率5%と仮定すると、月10件程度のエラーが発生し、顧客クレーム・返品対応に追加工数
- **顧客満足度リスク**: 見積回答遅延、納期遅延による顧客離れ
- **セキュリティリスク**: Excel管理では顧客情報の漏洩リスク、アクセス制御が困難

#### 本業務をシステム化することの想定効果

- **工数削減**: 見積書作成（月200件×5分=月17時間）、受注入力（月200件×3分=月10時間）、請求書発行（月200件×2分=月7時間）で月34時間に削減（月116時間削減）
- **品質向上**: 入力チェック・自動計算によりエラー率を1%以下に低減
- **リアルタイム情報共有**: 営業・経理・倉庫間で最新情報を共有
- **顧客対応スピード向上**: 見積回答時間の短縮、納期回答の正確性向上

#### 主な関連画面と業務インパクト

| 画面名 | 何をする画面か | 画面がない場合の運用工数 | 画面があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 見積書一覧（293） | 見積書の検索・一覧表示 | 月200件×10分=月33時間 | 月200件×2分=月7時間（26時間削減） |
| 見積書作成（294） | 新規見積書の入力・登録 | 月200件×20分=月67時間 | 月200件×5分=月17時間（50時間削減） |
| 見積書編集（295） | 見積書の修正 | 月50件×15分=月13時間 | 月50件×3分=月3時間（10時間削減） |
| 見積書詳細（296） | 見積書の詳細確認・PDF出力 | 月200件×5分=月17時間 | 月200件×1分=月3時間（14時間削減） |
| 受注一覧（297） | 受注データの検索・一覧表示 | 月200件×10分=月33時間 | 月200件×2分=月7時間（26時間削減） |
| 受注作成（298） | 新規受注の入力・登録 | 月200件×15分=月50時間 | 月200件×3分=月10時間（40時間削減） |
| 受注編集（299） | 受注情報の修正 | 月50件×10分=月8時間 | 月50件×2分=月2時間（6時間削減） |
| 受注詳細（300） | 受注詳細の確認 | 月200件×5分=月17時間 | 月200件×1分=月3時間（14時間削減） |
| 顧客一覧（301） | 顧客の検索・一覧表示 | 月100件×5分=月8時間 | 月100件×1分=月2時間（6時間削減） |
| 顧客作成（302） | 新規顧客の登録 | 月20件×15分=月5時間 | 月20件×5分=月2時間（3時間削減） |
| 顧客編集（303） | 顧客情報の更新 | 月30件×10分=月5時間 | 月30件×3分=月2時間（3時間削減） |
| 顧客詳細（304） | 顧客詳細・取引履歴の確認 | 月100件×5分=月8時間 | 月100件×1分=月2時間（6時間削減） |
| 請求対象注文一覧（305） | 請求対象の受注を抽出 | 月200件×5分=月17時間 | 月200件×1分=月3時間（14時間削減） |
| アップセル対象注文一覧（306） | アップセル機会の抽出 | 月50件×10分=月8時間 | 月50件×2分=月2時間（6時間削減） |
| 商品一覧（307） | 販売商品の検索・一覧 | 月100件×5分=月8時間 | 月100件×1分=月2時間（6時間削減） |
| チーム一覧（308） | 販売チームの管理 | 月10件×10分=月2時間 | 月10件×3分=月0.5時間（1.5時間削減） |
| タグ一覧（309） | 販売タグの管理 | 月5件×5分=月0.4時間 | 月5件×2分=月0.2時間（0.2時間削減） |
| 価格設定（310） | 価格ルールの設定 | 月5件×15分=月1時間 | 月5件×5分=月0.4時間（0.6時間削減） |
| 見積書・注文設定（311） | 見積書・注文の設定 | 月2件×20分=月0.7時間 | 月2件×5分=月0.2時間（0.5時間削減） |
| 商品設定（312） | 商品関連の設定 | 月2件×15分=月0.5時間 | 月2件×5分=月0.2時間（0.3時間削減） |
| 請求書設定（313） | 請求書関連の設定 | 月2件×15分=月0.5時間 | 月2件×5分=月0.2時間（0.3時間削減） |

---

### 業務プロセス2: 購買管理

#### プロセス概要

**業務フロー**

購買依頼発生 → 見積依頼（RFQ）作成・送信 → 見積回答受領 → 発注書作成・送信 → 入庫確認 → 仕入先請求書受領・照合 → 支払処理

**関係者**

購買担当、購買マネージャー、倉庫担当、経理担当

**発生頻度**

日次、中規模企業で1日約20〜100件程度と推測される

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 仕入先情報の分散管理 | 仕入先ごとの価格、リードタイム、取引条件の一元管理が困難 |
| 発注・入庫の不一致 | 発注内容と入庫内容の照合が手作業で、差異発見が遅れる |
| 購買契約の管理不足 | 契約条件、有効期限の管理が不十分で、不利な条件での発注が発生 |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **工数コスト**: 見積依頼作成（月100件×15分=月25時間）、発注書作成（月100件×20分=月33時間）、入庫照合（月100件×10分=月17時間）で月75時間以上
- **コスト超過リスク**: 最適な仕入先選定ができず、5%程度のコスト超過が発生する可能性
- **在庫リスク**: 発注タイミングのミスによる欠品・過剰在庫

#### 本業務をシステム化することの想定効果

- **工数削減**: 月75時間 → 月25時間（50時間削減）
- **コスト最適化**: 仕入先比較による最適調達、3%程度のコスト削減効果
- **在庫最適化**: 自動補充提案、リードタイム管理による欠品防止

#### 主な関連画面と業務インパクト

| 画面名 | 何をする画面か | 画面がない場合の運用工数 | 画面があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 見積依頼一覧（251） | RFQの検索・一覧 | 月100件×5分=月8時間 | 月100件×1分=月2時間（6時間削減） |
| 見積依頼作成（252） | 新規RFQの作成 | 月100件×15分=月25時間 | 月100件×5分=月8時間（17時間削減） |
| 見積依頼編集（253） | RFQの修正 | 月30件×10分=月5時間 | 月30件×3分=月2時間（3時間削減） |
| 見積依頼詳細（254） | RFQの詳細確認 | 月100件×5分=月8時間 | 月100件×1分=月2時間（6時間削減） |
| 発注書一覧（255） | 発注書の検索・一覧 | 月100件×5分=月8時間 | 月100件×1分=月2時間（6時間削減） |
| 発注書作成（256） | 新規発注書の作成 | 月100件×20分=月33時間 | 月100件×5分=月8時間（25時間削減） |
| 発注書編集（257） | 発注書の修正 | 月20件×10分=月3時間 | 月20件×3分=月1時間（2時間削減） |
| 発注書詳細（258） | 発注書の詳細確認 | 月100件×5分=月8時間 | 月100件×1分=月2時間（6時間削減） |
| 購買契約一覧（259） | 購買契約の管理 | 月10件×10分=月2時間 | 月10件×3分=月0.5時間（1.5時間削減） |
| 購買契約作成（260） | 新規契約の登録 | 月5件×30分=月3時間 | 月5件×10分=月1時間（2時間削減） |
| 購買契約編集（261） | 契約の更新 | 月5件×20分=月2時間 | 月5件×5分=月0.4時間（1.6時間削減） |
| 購買契約詳細（262） | 契約内容の確認 | 月10件×10分=月2時間 | 月10件×2分=月0.3時間（1.7時間削減） |
| 仕入先一覧（263） | 仕入先の検索・一覧 | 月50件×5分=月4時間 | 月50件×1分=月1時間（3時間削減） |
| 仕入先作成（264） | 新規仕入先の登録 | 月5件×20分=月2時間 | 月5件×5分=月0.4時間（1.6時間削減） |
| 仕入先編集（265） | 仕入先情報の更新 | 月10件×15分=月3時間 | 月10件×5分=月1時間（2時間削減） |
| 仕入先詳細（266） | 仕入先詳細の確認 | 月50件×5分=月4時間 | 月50件×1分=月1時間（3時間削減） |
| 仕入先価格一覧（267） | 仕入先別価格の管理 | 月20件×10分=月3時間 | 月20件×3分=月1時間（2時間削減） |
| 商品一覧（268） | 購買商品の管理 | 月50件×5分=月4時間 | 月50件×1分=月1時間（3時間削減） |
| 注文設定（269） | 注文関連の設定 | 月2件×15分=月0.5時間 | 月2件×5分=月0.2時間（0.3時間削減） |
| 商品設定（270） | 商品関連の設定 | 月2件×15分=月0.5時間 | 月2件×5分=月0.2時間（0.3時間削減） |

---

### 業務プロセス3: 在庫管理

#### プロセス概要

**業務フロー**

入庫処理 → 在庫保管 → 内部移動 → 出庫処理 → 棚卸・在庫調整

**関係者**

倉庫担当、倉庫マネージャー、購買担当、営業担当

**発生頻度**

日次、中規模企業で1日約100〜500件の在庫移動と推測される

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 在庫数量の不正確さ | 手書き管理では在庫数量の誤差が累積し、棚卸差異が拡大 |
| ロケーション管理の不備 | どこに何があるか把握できず、ピッキング効率が低下 |
| トレーサビリティの欠如 | ロット・シリアル管理ができず、品質問題時の追跡が困難 |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **工数コスト**: 入庫記録（月300件×10分=月50時間）、出庫記録（月300件×10分=月50時間）、棚卸（月1回×40時間=月40時間）で月140時間以上
- **在庫差異コスト**: 棚卸差異率5%と仮定すると、年間在庫額の0.5%相当のロス
- **機会損失**: 欠品による販売機会損失、過剰在庫による資金固定化

#### 本業務をシステム化することの想定効果

- **工数削減**: 月140時間 → 月50時間（90時間削減）
- **在庫精度向上**: 差異率を1%以下に低減
- **ピッキング効率向上**: ロケーション管理により30%効率化

#### 主な関連画面と業務インパクト

| 画面名 | 何をする画面か | 画面がない場合の運用工数 | 画面があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 入庫一覧（158） | 入庫オペレーションの一覧 | 月300件×5分=月25時間 | 月300件×1分=月5時間（20時間削減） |
| 入庫作成（159） | 新規入庫の登録 | 月300件×10分=月50時間 | 月300件×3分=月15時間（35時間削減） |
| 入庫編集（160） | 入庫情報の修正 | 月50件×10分=月8時間 | 月50件×3分=月3時間（5時間削減） |
| 入庫詳細（161） | 入庫詳細の確認 | 月300件×3分=月15時間 | 月300件×1分=月5時間（10時間削減） |
| 出庫一覧（170） | 出庫オペレーションの一覧 | 月300件×5分=月25時間 | 月300件×1分=月5時間（20時間削減） |
| 出庫作成（171） | 新規出庫の登録 | 月300件×10分=月50時間 | 月300件×3分=月15時間（35時間削減） |
| 出庫編集（172） | 出庫情報の修正 | 月50件×10分=月8時間 | 月50件×3分=月3時間（5時間削減） |
| 出庫詳細（173） | 出庫詳細の確認 | 月300件×3分=月15時間 | 月300件×1分=月5時間（10時間削減） |
| 内部移動一覧（166） | 内部移動の一覧 | 月100件×5分=月8時間 | 月100件×1分=月2時間（6時間削減） |
| 内部移動作成（167） | 新規内部移動の登録 | 月100件×10分=月17時間 | 月100件×3分=月5時間（12時間削減） |
| 内部移動編集（168） | 内部移動の修正 | 月20件×10分=月3時間 | 月20件×3分=月1時間（2時間削減） |
| 内部移動詳細（169） | 内部移動詳細の確認 | 月100件×3分=月5時間 | 月100件×1分=月2時間（3時間削減） |
| 廃棄一覧（162） | 廃棄処理の一覧 | 月20件×5分=月2時間 | 月20件×1分=月0.3時間（1.7時間削減） |
| 廃棄作成（163） | 新規廃棄の登録 | 月20件×15分=月5時間 | 月20件×5分=月2時間（3時間削減） |
| 廃棄編集（164） | 廃棄情報の修正 | 月5件×10分=月1時間 | 月5件×3分=月0.3時間（0.7時間削減） |
| 廃棄詳細（165） | 廃棄詳細の確認 | 月20件×3分=月1時間 | 月20件×1分=月0.3時間（0.7時間削減） |
| 商品一覧（146） | 在庫商品の一覧 | 月200件×5分=月17時間 | 月200件×1分=月3時間（14時間削減） |
| 商品作成（147） | 新規商品の登録 | 月10件×20分=月3時間 | 月10件×5分=月1時間（2時間削減） |
| 商品編集（148） | 商品情報の更新 | 月30件×15分=月8時間 | 月30件×5分=月3時間（5時間削減） |
| 商品詳細（149） | 商品詳細・在庫の確認 | 月200件×5分=月17時間 | 月200件×1分=月3時間（14時間削減） |
| ロット一覧（154） | ロットの一覧管理 | 月50件×5分=月4時間 | 月50件×1分=月1時間（3時間削減） |
| ロット作成（155） | 新規ロットの登録 | 月50件×10分=月8時間 | 月50件×3分=月3時間（5時間削減） |
| ロット編集（156） | ロット情報の修正 | 月10件×10分=月2時間 | 月10件×3分=月0.5時間（1.5時間削減） |
| ロット詳細（157） | ロット詳細の確認 | 月50件×5分=月4時間 | 月50件×1分=月1時間（3時間削減） |
| パッケージ一覧（150） | パッケージの一覧 | 月30件×5分=月3時間 | 月30件×1分=月0.5時間（2.5時間削減） |
| パッケージ作成（151） | 新規パッケージの登録 | 月30件×10分=月5時間 | 月30件×3分=月2時間（3時間削減） |
| パッケージ編集（152） | パッケージの修正 | 月10件×10分=月2時間 | 月10件×3分=月0.5時間（1.5時間削減） |
| パッケージ詳細（153） | パッケージ詳細の確認 | 月30件×5分=月3時間 | 月30件×1分=月0.5時間（2.5時間削減） |
| 倉庫一覧（107） | 倉庫の一覧管理 | 月5件×10分=月1時間 | 月5件×2分=月0.2時間（0.8時間削減） |
| 倉庫作成（108） | 新規倉庫の登録 | 年2件×30分=月0.1時間 | 年2件×10分=月0.03時間（0.07時間削減） |
| 倉庫編集（109） | 倉庫情報の更新 | 月2件×20分=月0.7時間 | 月2件×5分=月0.2時間（0.5時間削減） |
| 倉庫詳細（110） | 倉庫詳細の確認 | 月5件×10分=月1時間 | 月5件×2分=月0.2時間（0.8時間削減） |
| ロケーション一覧（129） | ロケーションの一覧 | 月20件×5分=月2時間 | 月20件×1分=月0.3時間（1.7時間削減） |
| ロケーション作成（130） | 新規ロケーションの登録 | 月5件×15分=月1時間 | 月5件×5分=月0.4時間（0.6時間削減） |
| ロケーション編集（131） | ロケーションの修正 | 月5件×10分=月1時間 | 月5件×3分=月0.3時間（0.7時間削減） |
| ロケーション詳細（132） | ロケーション詳細の確認 | 月20件×5分=月2時間 | 月20件×1分=月0.3時間（1.7時間削減） |

---

### 業務プロセス4: 会計管理

#### プロセス概要

**業務フロー**

取引発生 → 仕訳入力 → 請求書発行 → 入金・支払処理 → 消込処理 → 月次締め → 決算処理

**関係者**

経理担当、経理マネージャー、経営者

**発生頻度**

日次（仕訳・入金処理）、月次（締め処理）、年次（決算処理）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 勘定科目の管理不備 | 科目体系が整理されておらず、科目選択ミスが発生 |
| 消込作業の煩雑さ | 請求書と入金の照合が手作業で、未消込残高の管理が困難 |
| 税計算の複雑さ | 複数税率、免税取引の判定が複雑で、申告ミスリスクがある |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **工数コスト**: 仕訳入力（月500件×10分=月83時間）、消込処理（月200件×15分=月50時間）、月次締め（月1回×20時間）で月153時間以上
- **申告リスク**: 税計算ミスによる追徴課税、加算税のリスク
- **監査対応リスク**: 証跡管理が不十分で、監査対応に多大な時間を要する

#### 本業務をシステム化することの想定効果

- **工数削減**: 月153時間 → 月50時間（103時間削減）
- **税計算精度向上**: 自動税計算により申告ミスを防止
- **監査対応効率化**: 証跡の自動記録、レポート出力の即時化

#### 主な関連画面と業務インパクト

| 画面名 | 何をする画面か | 画面がない場合の運用工数 | 画面があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 勘定科目一覧（1） | 勘定科目の検索・一覧 | 月50件×5分=月4時間 | 月50件×1分=月1時間（3時間削減） |
| 勘定科目作成（2） | 新規勘定科目の登録 | 年20件×15分=月0.3時間 | 年20件×5分=月0.1時間（0.2時間削減） |
| 勘定科目編集（3） | 勘定科目の修正 | 月5件×10分=月1時間 | 月5件×3分=月0.3時間（0.7時間削減） |
| 勘定科目詳細（4） | 勘定科目詳細の確認 | 月50件×5分=月4時間 | 月50件×1分=月1時間（3時間削減） |
| 勘定科目タグ一覧（5） | 勘定科目タグの管理 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| 銀行口座一覧（6） | 銀行口座の一覧 | 月20件×5分=月2時間 | 月20件×1分=月0.3時間（1.7時間削減） |
| 請求書一覧（7, 25） | 請求書の検索・一覧 | 月200件×5分=月17時間 | 月200件×1分=月3時間（14時間削減） |
| 請求書作成（8, 26） | 新規請求書の発行 | 月200件×15分=月50時間 | 月200件×5分=月17時間（33時間削減） |
| 請求書編集（9, 27） | 請求書の修正 | 月50件×10分=月8時間 | 月50件×3分=月3時間（5時間削減） |
| 請求書詳細（10, 28） | 請求書詳細の確認 | 月200件×5分=月17時間 | 月200件×1分=月3時間（14時間削減） |
| 現金丸め一覧（11） | 現金丸め設定の一覧 | 月2件×5分=月0.2時間 | 月2件×1分=月0.03時間（0.17時間削減） |
| 現金丸め作成（12） | 現金丸め設定の登録 | 年2件×10分=月0.02時間 | 年2件×3分=月0.005時間（0.015時間削減） |
| 現金丸め編集（13） | 現金丸め設定の修正 | 月1件×10分=月0.2時間 | 月1件×3分=月0.05時間（0.15時間削減） |
| 現金丸め詳細（14） | 現金丸め詳細の確認 | 月2件×5分=月0.2時間 | 月2件×1分=月0.03時間（0.17時間削減） |
| クレジットノート一覧（15） | クレジットノートの一覧 | 月20件×5分=月2時間 | 月20件×1分=月0.3時間（1.7時間削減） |
| クレジットノート作成（16） | クレジットノートの発行 | 月20件×15分=月5時間 | 月20件×5分=月2時間（3時間削減） |
| クレジットノート編集（17） | クレジットノートの修正 | 月5件×10分=月1時間 | 月5件×3分=月0.3時間（0.7時間削減） |
| クレジットノート詳細（18） | クレジットノート詳細の確認 | 月20件×5分=月2時間 | 月20件×1分=月0.3時間（1.7時間削減） |
| 財務ポジション一覧（19） | 財務ポジションの一覧 | 月5件×5分=月0.4時間 | 月5件×1分=月0.08時間（0.32時間削減） |
| 財務ポジション作成（20） | 財務ポジションの登録 | 年5件×20分=月0.08時間 | 年5件×5分=月0.02時間（0.06時間削減） |
| 財務ポジション編集（21） | 財務ポジションの修正 | 月2件×15分=月0.5時間 | 月2件×5分=月0.2時間（0.3時間削減） |
| 財務ポジション詳細（22） | 財務ポジション詳細の確認 | 月5件×10分=月1時間 | 月5件×2分=月0.2時間（0.8時間削減） |
| 財務ポジション税管理（23） | 税マッピングの設定 | 月5件×15分=月1時間 | 月5件×5分=月0.4時間（0.6時間削減） |
| インコタームズ一覧（24） | 国際貿易条件の一覧 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| 仕訳帳一覧（29） | 仕訳帳の一覧 | 月20件×5分=月2時間 | 月20件×1分=月0.3時間（1.7時間削減） |
| 仕訳帳作成（30） | 新規仕訳帳の登録 | 年5件×20分=月0.08時間 | 年5件×5分=月0.02時間（0.06時間削減） |
| 仕訳帳編集（31） | 仕訳帳の修正 | 月2件×15分=月0.5時間 | 月2件×5分=月0.2時間（0.3時間削減） |
| 仕訳帳詳細（32） | 仕訳帳詳細の確認 | 月20件×5分=月2時間 | 月20件×1分=月0.3時間（1.7時間削減） |
| 支払条件一覧（33） | 支払条件の一覧 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| 支払条件作成（34） | 支払条件の登録 | 年5件×15分=月0.06時間 | 年5件×5分=月0.02時間（0.04時間削減） |
| 支払条件編集（35） | 支払条件の修正 | 月2件×10分=月0.3時間 | 月2件×3分=月0.1時間（0.2時間削減） |
| 支払条件詳細（36） | 支払条件詳細の確認 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| 支払期限管理（37） | 支払期限の設定 | 月10件×10分=月2時間 | 月10件×3分=月0.5時間（1.5時間削減） |
| 支払一覧（38） | 支払の一覧 | 月100件×5分=月8時間 | 月100件×1分=月2時間（6時間削減） |
| 支払作成（39） | 新規支払の登録 | 月100件×15分=月25時間 | 月100件×5分=月8時間（17時間削減） |
| 支払編集（40） | 支払の修正 | 月20件×10分=月3時間 | 月20件×3分=月1時間（2時間削減） |
| 支払詳細（41） | 支払詳細の確認 | 月100件×5分=月8時間 | 月100件×1分=月2時間（6時間削減） |
| 返金一覧（42） | 返金の一覧 | 月20件×5分=月2時間 | 月20件×1分=月0.3時間（1.7時間削減） |
| 返金作成（43） | 返金の登録 | 月20件×15分=月5時間 | 月20件×5分=月2時間（3時間削減） |
| 返金編集（44） | 返金の修正 | 月5件×10分=月1時間 | 月5件×3分=月0.3時間（0.7時間削減） |
| 返金詳細（45） | 返金詳細の確認 | 月20件×5分=月2時間 | 月20件×1分=月0.3時間（1.7時間削減） |
| 税一覧（46） | 税設定の一覧 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| 税作成（47） | 新規税設定の登録 | 年5件×15分=月0.06時間 | 年5件×5分=月0.02時間（0.04時間削減） |
| 税編集（48） | 税設定の修正 | 月2件×10分=月0.3時間 | 月2件×3分=月0.1時間（0.2時間削減） |
| 税詳細（49） | 税詳細の確認 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| 税グループ一覧（50） | 税グループの一覧 | 月5件×5分=月0.4時間 | 月5件×1分=月0.08時間（0.32時間削減） |
| 税グループ作成（51） | 税グループの登録 | 年2件×15分=月0.03時間 | 年2件×5分=月0.008時間（0.022時間削減） |
| 税グループ編集（52） | 税グループの修正 | 月1件×10分=月0.2時間 | 月1件×3分=月0.05時間（0.15時間削減） |
| 税グループ詳細（53） | 税グループ詳細の確認 | 月5件×5分=月0.4時間 | 月5件×1分=月0.08時間（0.32時間削減） |

---

### 業務プロセス5: 人事管理

#### プロセス概要

**業務フロー**

従業員登録 → 部署・職位配置 → スキル管理 → 勤務カレンダー設定 → 退職処理

**関係者**

人事担当、人事マネージャー、部門マネージャー、従業員

**発生頻度**

日常的（従業員情報参照）、月次（異動・昇進）、年次（評価・昇給）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 従業員情報の分散管理 | 個人情報、スキル、経歴が複数ファイルに分散し、一元把握が困難 |
| 組織構造の可視化不足 | 部署・職位の階層構造が把握しにくく、人員配置検討に支障 |
| スキル把握の困難さ | 従業員のスキル・資格情報が管理されておらず、適材適所の配置が難しい |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **工数コスト**: 従業員情報管理（月50件×15分=月13時間）、組織図更新（月5件×30分=月3時間）、スキル管理（月20件×10分=月3時間）で月19時間以上
- **人事リスク**: 個人情報管理不備によるコンプライアンス違反リスク
- **人材活用リスク**: スキルマッチングができず、適材適所の配置が実現できない

#### 本業務をシステム化することの想定効果

- **工数削減**: 月19時間 → 月6時間（13時間削減）
- **コンプライアンス向上**: 個人情報の適切な管理、アクセス制御
- **人材活用最適化**: スキル検索、組織分析による適材適所配置

#### 主な関連画面と業務インパクト

| 画面名 | 何をする画面か | 画面がない場合の運用工数 | 画面があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 従業員一覧（74） | 従業員の検索・一覧 | 月100件×5分=月8時間 | 月100件×1分=月2時間（6時間削減） |
| 従業員作成（75） | 新規従業員の登録 | 月5件×30分=月3時間 | 月5件×10分=月1時間（2時間削減） |
| 従業員編集（76） | 従業員情報の更新 | 月20件×20分=月7時間 | 月20件×5分=月2時間（5時間削減） |
| 従業員詳細（77） | 従業員詳細の確認 | 月100件×10分=月17時間 | 月100件×2分=月3時間（14時間削減） |
| 履歴書管理（78） | 従業員の経歴管理 | 月10件×15分=月3時間 | 月10件×5分=月1時間（2時間削減） |
| スキル管理（79） | 従業員のスキル管理 | 月20件×10分=月3時間 | 月20件×3分=月1時間（2時間削減） |
| 部署一覧（80） | 部署の一覧 | 月20件×5分=月2時間 | 月20件×1分=月0.3時間（1.7時間削減） |
| 部署作成（81） | 新規部署の登録 | 年5件×20分=月0.08時間 | 年5件×5分=月0.02時間（0.06時間削減） |
| 部署編集（82） | 部署情報の更新 | 月5件×15分=月1時間 | 月5件×5分=月0.4時間（0.6時間削減） |
| 部署詳細（83） | 部署詳細の確認 | 月20件×5分=月2時間 | 月20件×1分=月0.3時間（1.7時間削減） |
| 部署従業員管理（84） | 部署への従業員配置 | 月10件×15分=月3時間 | 月10件×5分=月1時間（2時間削減） |
| スキルタイプ一覧（85） | スキルタイプの一覧 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| スキルタイプ編集（86） | スキルタイプの修正 | 月5件×10分=月1時間 | 月5件×3分=月0.3時間（0.7時間削減） |
| スキルタイプ詳細（87） | スキルタイプ詳細の確認 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| 職位一覧（91） | 職位の一覧 | 月20件×5分=月2時間 | 月20件×1分=月0.3時間（1.7時間削減） |
| 職位作成（92） | 新規職位の登録 | 年10件×15分=月0.13時間 | 年10件×5分=月0.04時間（0.09時間削減） |
| 職位編集（93） | 職位情報の更新 | 月5件×10分=月1時間 | 月5件×3分=月0.3時間（0.7時間削減） |
| 職位詳細（94） | 職位詳細の確認 | 月20件×5分=月2時間 | 月20件×1分=月0.3時間（1.7時間削減） |
| カレンダー一覧（95） | 勤務カレンダーの一覧 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| カレンダー作成（96） | 勤務カレンダーの登録 | 年5件×30分=月0.13時間 | 年5件×10分=月0.04時間（0.09時間削減） |
| カレンダー編集（97） | 勤務カレンダーの修正 | 月5件×20分=月2時間 | 月5件×5分=月0.4時間（1.6時間削減） |
| カレンダー詳細（98） | 勤務カレンダー詳細の確認 | 月10件×10分=月2時間 | 月10件×2分=月0.3時間（1.7時間削減） |
| 退職理由一覧（99） | 退職理由の一覧 | 月5件×5分=月0.4時間 | 月5件×1分=月0.08時間（0.32時間削減） |
| 従業員カテゴリ一覧（100） | 従業員カテゴリの一覧 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| 勤務地一覧（101） | 勤務地の一覧 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| 雇用形態一覧（102） | 雇用形態の一覧 | 月5件×5分=月0.4時間 | 月5件×1分=月0.08時間（0.32時間削減） |
| 従業員スキルレポート（103） | スキル分析レポート | 月5件×30分=月3時間 | 月5件×5分=月0.4時間（2.6時間削減） |
| アクティビティプラン一覧（88） | 活動プランの一覧 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| アクティビティプラン編集（89） | 活動プランの修正 | 月5件×15分=月1時間 | 月5件×5分=月0.4時間（0.6時間削減） |
| アクティビティプラン詳細（90） | 活動プラン詳細の確認 | 月10件×10分=月2時間 | 月10件×2分=月0.3時間（1.7時間削減） |

---

### 業務プロセス6: 採用管理

#### プロセス概要

**業務フロー**

求人作成・公開 → 応募受付 → 書類選考 → 面接 → 内定・採用決定 → 入社手続き

**関係者**

人事担当、採用担当、部門マネージャー、面接官

**発生頻度**

継続的（応募受付）、週次（選考進捗管理）、月次（採用実績分析）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 応募者情報の管理不備 | 応募者の進捗状況が把握できず、対応漏れが発生 |
| 選考プロセスの非標準化 | 部門ごとに選考基準がばらつき、採用品質にムラがある |
| 採用チャネル分析の不足 | どの求人媒体からの応募が効果的か分析できない |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **工数コスト**: 応募者管理（月50件×20分=月17時間）、選考進捗管理（月50件×15分=月13時間）、面接調整（月30件×20分=月10時間）で月40時間以上
- **採用リスク**: 優秀な候補者への対応遅延による辞退、採用機会損失
- **コンプライアンスリスク**: 応募者個人情報の不適切な管理

#### 本業務をシステム化することの想定効果

- **工数削減**: 月40時間 → 月15時間（25時間削減）
- **採用品質向上**: 標準化された選考プロセス、評価基準の統一
- **採用分析**: 応募チャネル別効果測定、採用コスト分析

#### 主な関連画面と業務インパクト

| 画面名 | 何をする画面か | 画面がない場合の運用工数 | 画面があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 応募者一覧（271） | 応募者の検索・一覧 | 月50件×10分=月8時間 | 月50件×2分=月2時間（6時間削減） |
| 応募者編集（272） | 応募者情報の更新 | 月30件×15分=月8時間 | 月30件×5分=月3時間（5時間削減） |
| 応募者詳細（273） | 応募者詳細の確認 | 月50件×10分=月8時間 | 月50件×2分=月2時間（6時間削減） |
| 候補者一覧（274） | 候補者プールの管理 | 月30件×10分=月5時間 | 月30件×2分=月1時間（4時間削減） |
| 候補者作成（275） | 新規候補者の登録 | 月20件×15分=月5時間 | 月20件×5分=月2時間（3時間削減） |
| 候補者編集（276） | 候補者情報の更新 | 月15件×10分=月3時間 | 月15件×3分=月1時間（2時間削減） |
| 候補者詳細（277） | 候補者詳細の確認 | 月30件×10分=月5時間 | 月30件×2分=月1時間（4時間削減） |
| 職位別求人一覧（278） | 職位ごとの求人状況 | 月20件×10分=月3時間 | 月20件×2分=月1時間（2時間削減） |
| ステージ一覧（279） | 選考ステージの管理 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| ステージ作成（280） | 選考ステージの登録 | 年5件×15分=月0.06時間 | 年5件×5分=月0.02時間（0.04時間削減） |
| ステージ編集（281） | 選考ステージの修正 | 月3件×10分=月0.5時間 | 月3件×3分=月0.15時間（0.35時間削減） |
| 職位一覧（282） | 採用職位の管理 | 月15件×5分=月1時間 | 月15件×1分=月0.25時間（0.75時間削減） |
| 職位作成（283） | 採用職位の登録 | 月5件×20分=月2時間 | 月5件×5分=月0.4時間（1.6時間削減） |
| 職位編集（284） | 採用職位の修正 | 月5件×15分=月1時間 | 月5件×5分=月0.4時間（0.6時間削減） |
| 職位詳細（285） | 採用職位詳細の確認 | 月15件×10分=月3時間 | 月15件×2分=月0.5時間（2.5時間削減） |
| 部署一覧（286） | 採用部署の管理 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| 学位一覧（287） | 学位マスタの管理 | 月5件×5分=月0.4時間 | 月5件×1分=月0.08時間（0.32時間削減） |
| 応募者カテゴリ一覧（288） | 応募者分類の管理 | 月5件×5分=月0.4時間 | 月5件×1分=月0.08時間（0.32時間削減） |
| 雇用形態一覧（289） | 雇用形態の管理 | 月5件×5分=月0.4時間 | 月5件×1分=月0.08時間（0.32時間削減） |
| UTMソース一覧（290） | 応募経路の管理 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| UTMメディア一覧（291） | 採用メディアの管理 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| 辞退理由一覧（292） | 辞退理由の管理 | 月5件×5分=月0.4時間 | 月5件×1分=月0.08時間（0.32時間削減） |

---

### 業務プロセス7: 休暇管理

#### プロセス概要

**業務フロー**

休暇申請 → 上長承認 → 休暇取得 → 残日数更新 → 休暇実績管理

**関係者**

従業員、上長、人事担当

**発生頻度**

日次（休暇申請・承認）、月次（休暇集計）、年次（年度切替）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 休暇残日数の管理不備 | 従業員が自分の残日数を把握できず、計画的な休暇取得が困難 |
| 承認フローの煩雑さ | 紙ベースの申請では承認遅延、紛失リスクがある |
| 勤怠との連携不足 | 休暇と勤怠管理が別々で、給与計算時に不整合が発生 |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **工数コスト**: 休暇申請処理（月100件×10分=月17時間）、残日数管理（月100名×5分=月8時間）、集計レポート（月1回×8時間）で月33時間以上
- **コンプライアンスリスク**: 有給休暇取得義務（年5日以上）の管理不備
- **従業員満足度リスク**: 申請・承認の手間による不満

#### 本業務をシステム化することの想定効果

- **工数削減**: 月33時間 → 月10時間（23時間削減）
- **コンプライアンス確保**: 取得義務の自動チェック、アラート機能
- **従業員利便性向上**: セルフサービス申請、リアルタイム残日数確認

#### 主な関連画面と業務インパクト

| 画面名 | 何をする画面か | 画面がない場合の運用工数 | 画面があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| マイ休暇一覧（334） | 自分の休暇申請一覧 | 月20件×5分=月2時間 | 月20件×1分=月0.3時間（1.7時間削減） |
| マイ休暇作成（335） | 休暇申請の入力 | 月20件×10分=月3時間 | 月20件×3分=月1時間（2時間削減） |
| マイ休暇編集（336） | 休暇申請の修正 | 月5件×10分=月1時間 | 月5件×3分=月0.3時間（0.7時間削減） |
| マイ休暇詳細（337） | 休暇申請詳細の確認 | 月20件×5分=月2時間 | 月20件×1分=月0.3時間（1.7時間削減） |
| マイ割当一覧（338） | 自分の休暇割当一覧 | 月5件×5分=月0.4時間 | 月5件×1分=月0.08時間（0.32時間削減） |
| マイ割当作成（339） | 休暇割当の申請 | 月2件×10分=月0.3時間 | 月2件×3分=月0.1時間（0.2時間削減） |
| マイ割当編集（340） | 休暇割当の修正 | 月1件×10分=月0.2時間 | 月1件×3分=月0.05時間（0.15時間削減） |
| マイ割当詳細（341） | 休暇割当詳細の確認 | 月5件×5分=月0.4時間 | 月5件×1分=月0.08時間（0.32時間削減） |
| 休暇管理一覧（342） | 全従業員の休暇管理 | 月100件×5分=月8時間 | 月100件×1分=月2時間（6時間削減） |
| 休暇管理作成（343） | 休暇の代理登録 | 月10件×10分=月2時間 | 月10件×3分=月0.5時間（1.5時間削減） |
| 休暇管理編集（344） | 休暇の修正 | 月10件×10min=月2時間 | 月10件×3分=月0.5時間（1.5時間削減） |
| 休暇管理詳細（345） | 休暇詳細の確認 | 月100件×5分=月8時間 | 月100件×1分=月2時間（6時間削減） |
| 割当管理一覧（346） | 休暇割当の管理 | 月50件×5分=月4時間 | 月50件×1分=月1時間（3時間削減） |
| 割当管理作成（347） | 休暇割当の登録 | 月20件×10分=月3時間 | 月20件×3分=月1時間（2時間削減） |
| 割当管理編集（348） | 休暇割当の修正 | 月10件×10分=月2時間 | 月10件×3分=月0.5時間（1.5時間削減） |
| 割当管理詳細（349） | 休暇割当詳細の確認 | 月50件×5分=月4時間 | 月50件×1分=月1時間（3時間削減） |
| 従業員別レポート（350） | 従業員別休暇レポート | 月10件×15分=月3時間 | 月10件×3分=月0.5時間（2.5時間削減） |
| 休暇タイプ一覧（351） | 休暇タイプの管理 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| 休暇タイプ作成（352） | 休暇タイプの登録 | 年5件×15分=月0.06時間 | 年5件×5分=月0.02時間（0.04時間削減） |
| 休暇タイプ編集（353） | 休暇タイプの修正 | 月3件×10分=月0.5時間 | 月3件×3分=月0.15時間（0.35時間削減） |
| 休暇タイプ詳細（354） | 休暇タイプ詳細の確認 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| 累積プラン一覧（355） | 休暇発生プランの管理 | 月5件×10分=月1時間 | 月5件×2分=月0.2時間（0.8時間削減） |
| 累積プラン作成（356） | 休暇発生プランの登録 | 年3件×30分=月0.08時間 | 年3件×10分=月0.03時間（0.05時間削減） |
| 累積プラン編集（357） | 休暇発生プランの修正 | 月2件×20分=月0.7時間 | 月2件×5分=月0.2時間（0.5時間削減） |
| 累積プラン詳細（358） | 休暇発生プラン詳細の確認 | 月5件×10分=月1時間 | 月5件×2分=月0.2時間（0.8時間削減） |
| 祝日一覧（359） | 祝日の管理 | 月5件×5分=月0.4時間 | 月5件×1分=月0.08時間（0.32時間削減） |
| 必須日一覧（360） | 必須出勤日の管理 | 月5件×5分=月0.4時間 | 月5件×1分=月0.08時間（0.32時間削減） |

---

### 業務プロセス8: プロジェクト管理

#### プロセス概要

**業務フロー**

プロジェクト立上げ → タスク分解 → 工数見積 → 実行・進捗管理 → 工数実績記録 → 完了・振返り

**関係者**

プロジェクトマネージャー、プロジェクトメンバー、経営層

**発生頻度**

日次（タスク更新・工数記録）、週次（進捗確認）、月次（レポート）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 進捗把握の困難さ | タスクの状況がリアルタイムで把握できず、遅延発見が遅れる |
| 工数管理の不備 | 実際にかかった工数が把握できず、見積精度が向上しない |
| リソース配分の非効率 | 誰が何のタスクを担当しているか把握できず、負荷分散が困難 |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **工数コスト**: タスク管理（月200件×10分=月33時間）、進捗報告（週4回×30分=月8時間）、工数集計（月1回×8時間）で月49時間以上
- **プロジェクトリスク**: 進捗遅延の早期発見ができず、納期遅延リスク
- **収益リスク**: 工数超過による赤字プロジェクト発生

#### 本業務をシステム化することの想定効果

- **工数削減**: 月49時間 → 月15時間（34時間削減）
- **進捗可視化**: カンバンボード、ガントチャートによるリアルタイム把握
- **工数精度向上**: 実績データ蓄積による見積精度向上

#### 主な関連画面と業務インパクト

| 画面名 | 何をする画面か | 画面がない場合の運用工数 | 画面があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| プロジェクト一覧（233） | プロジェクトの検索・一覧 | 月30件×10分=月5時間 | 月30件×2分=月1時間（4時間削減） |
| プロジェクト作成（234） | 新規プロジェクトの登録 | 月5件×30分=月3時間 | 月5件×10分=月1時間（2時間削減） |
| プロジェクト編集（235） | プロジェクト情報の更新 | 月10件×20分=月3時間 | 月10件×5分=月1時間（2時間削減） |
| プロジェクト詳細（236） | プロジェクト詳細の確認 | 月30件×10分=月5時間 | 月30件×2分=月1時間（4時間削減） |
| マイルストーン管理（237） | マイルストーンの設定 | 月20件×15分=月5時間 | 月20件×5分=月2時間（3時間削減） |
| タスク管理（238） | プロジェクト内タスク管理 | 月100件×10分=月17時間 | 月100件×3分=月5時間（12時間削減） |
| タスク一覧（239） | タスクの検索・一覧 | 月200件×5分=月17時間 | 月200件×1分=月3時間（14時間削減） |
| タスク作成（240） | 新規タスクの登録 | 月100件×15分=月25時間 | 月100件×5分=月8時間（17時間削減） |
| タスク編集（241） | タスク情報の更新 | 月100件×10分=月17時間 | 月100件×3分=月5時間（12時間削減） |
| タスク詳細（242） | タスク詳細の確認 | 月200件×5分=月17時間 | 月200件×1分=月3時間（14時間削減） |
| サブタスク管理（243） | サブタスクの管理 | 月50件×10分=月8時間 | 月50件×3分=月3時間（5時間削減） |
| タイムシート管理（244） | タスク工数の記録 | 月300件×5分=月25時間 | 月300件×2分=月10時間（15時間削減） |
| タスクステージ管理（245） | タスクステージの設定 | 月10件×10分=月2時間 | 月10件×3分=月0.5時間（1.5時間削減） |
| プロジェクトステージ管理（246） | プロジェクトステージの設定 | 月5件×15分=月1時間 | 月5件×5分=月0.4時間（0.6時間削減） |
| タグ管理（247） | プロジェクトタグの管理 | 月10件×5分=月1時間 | 月10件×2分=月0.3時間（0.7時間削減） |
| マイルストーン管理（設定）（248） | マイルストーン設定 | 月5件×10分=月1時間 | 月5件×3分=月0.3時間（0.7時間削減） |
| タスク設定（249） | タスク関連の設定 | 月2件×15分=月0.5時間 | 月2件×5分=月0.2時間（0.3時間削減） |
| 時間設定（250） | 時間管理の設定 | 月2件×15分=月0.5時間 | 月2件×5分=月0.2時間（0.3時間削減） |
| タイムシート管理（361） | 全体の工数管理 | 月500件×5分=月42時間 | 月500件×1min=月8時間（34時間削減） |

---

### 業務プロセス9: マスタ管理・システム管理

#### プロセス概要

**業務フロー**

マスタデータ登録 → 定期メンテナンス → ユーザー管理 → 権限設定 → システム設定

**関係者**

システム管理者、業務管理者、経営者

**発生頻度**

随時（ユーザー追加・変更）、月次（マスタメンテナンス）、年次（年度設定）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| マスタ管理の属人化 | 特定担当者しかマスタ更新ができず、不在時に業務が滞る |
| 権限管理の不備 | 適切なアクセス制御ができず、情報漏洩リスクがある |
| 設定変更履歴の欠如 | 誰がいつ何を変更したか追跡できない |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **工数コスト**: マスタ管理（月50件×15分=月13時間）、ユーザー管理（月10件×20分=月3時間）、権限設定（月10件×15分=月3時間）で月19時間以上
- **セキュリティリスク**: 不適切な権限設定による情報漏洩
- **監査対応リスク**: 変更履歴がなく、内部統制が不十分

#### 本業務をシステム化することの想定効果

- **工数削減**: 月19時間 → 月6時間（13時間削減）
- **セキュリティ向上**: ロールベースアクセス制御、監査ログ
- **ガバナンス強化**: 変更履歴の自動記録

#### 主な関連画面と業務インパクト

| 画面名 | 何をする画面か | 画面がない場合の運用工数 | 画面があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| ユーザー一覧（314） | ユーザーの検索・一覧 | 月30件×5分=月3時間 | 月30件×1分=月0.5時間（2.5時間削減） |
| ユーザー作成（315） | 新規ユーザーの登録 | 月5件×20分=月2時間 | 月5件×5分=月0.4時間（1.6時間削減） |
| ユーザー編集（316） | ユーザー情報の更新 | 月10件×15分=月3時間 | 月10件×5分=月1時間（2時間削減） |
| ユーザー詳細（317） | ユーザー詳細の確認 | 月30件×5分=月3時間 | 月30件×1分=月0.5時間（2.5時間削減） |
| ロール一覧（318） | ロールの一覧 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| ロール作成（319） | 新規ロールの登録 | 年5件×30分=月0.13時間 | 年5件×10分=月0.04時間（0.09時間削減） |
| ロール編集（320） | ロールの修正 | 月5件×20分=月2時間 | 月5件×5分=月0.4時間（1.6時間削減） |
| ロール詳細（321） | ロール詳細の確認 | 月10件×10分=月2時間 | 月10件×2分=月0.3時間（1.7時間削減） |
| 会社一覧（322） | 会社の一覧 | 月5件×5分=月0.4時間 | 月5件×1分=月0.08時間（0.32時間削減） |
| 会社作成（323） | 新規会社の登録 | 年2件×30分=月0.05時間 | 年2件×10分=月0.02時間（0.03時間削減） |
| 会社編集（324） | 会社情報の更新 | 月2件×20分=月0.7時間 | 月2件×5分=月0.2時間（0.5時間削減） |
| 会社詳細（325） | 会社詳細の確認 | 月5件×10分=月1時間 | 月5件×2分=月0.2時間（0.8時間削減） |
| チーム管理（326） | チームの管理 | 月10件×15分=月3時間 | 月10件×5分=月1時間（2時間削減） |
| ユーザー設定（327） | ユーザー関連の設定 | 月2件×15分=月0.5時間 | 月2件×5分=月0.2時間（0.3時間削減） |
| 通貨設定（328） | 通貨の設定 | 月2件×10分=月0.3時間 | 月2件×3分=月0.1時間（0.2時間削減） |
| アクティビティ設定（329） | アクティビティの設定 | 月5件×10分=月1時間 | 月5件×3分=月0.3時間（0.7時間削減） |
| アクティビティタイプ一覧（330） | アクティビティタイプの一覧 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| アクティビティタイプ作成（331） | アクティビティタイプの登録 | 年10件×15分=月0.13時間 | 年10件×5分=月0.04時間（0.09時間削減） |
| アクティビティタイプ編集（332） | アクティビティタイプの修正 | 月5件×10分=月1時間 | 月5件×3分=月0.3時間（0.7時間削減） |
| アクティビティタイプ詳細（333） | アクティビティタイプ詳細の確認 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| カスタムフィールド一覧（104） | カスタムフィールドの一覧 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| カスタムフィールド作成（105） | カスタムフィールドの登録 | 月5件×20分=月2時間 | 月5件×5分=月0.4時間（1.6時間削減） |
| カスタムフィールド編集（106） | カスタムフィールドの修正 | 月5件×15分=月1時間 | 月5件×5分=月0.4時間（0.6時間削減） |
| プラグイン一覧（215） | プラグインの管理 | 月5件×10分=月1時間 | 月5件×2分=月0.2時間（0.8時間削減） |

---

### 業務プロセス10: コンテンツ管理（ブログ・ウェブサイト）

#### プロセス概要

**業務フロー**

コンテンツ企画 → 記事作成 → レビュー・承認 → 公開 → 効果測定

**関係者**

マーケティング担当、広報担当、承認者

**発生頻度**

週次（記事公開）、月次（効果分析）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| コンテンツ管理の非効率 | 記事の作成・編集・公開が分散したツールで管理され、効率が悪い |
| 公開管理の不備 | 公開日時の制御、下書き管理が困難 |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **工数コスト**: 記事作成（月10件×60分=月10時間）、公開管理（月10件×15分=月3時間）で月13時間以上
- **ブランドリスク**: 未承認コンテンツの公開、誤った情報の発信

#### 本業務をシステム化することの想定効果

- **工数削減**: 月13時間 → 月5時間（8時間削減）
- **品質向上**: 承認フロー、プレビュー機能による品質確保

#### 主な関連画面と業務インパクト

| 画面名 | 何をする画面か | 画面がない場合の運用工数 | 画面があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 投稿一覧（54） | ブログ記事の一覧 | 月20件×5分=月2時間 | 月20件×1分=月0.3時間（1.7時間削減） |
| 投稿作成（55） | ブログ記事の作成 | 月10件×60分=月10時間 | 月10件×30分=月5時間（5時間削減） |
| 投稿編集（56） | ブログ記事の編集 | 月10件×30分=月5時間 | 月10件×15分=月3時間（2時間削減） |
| 投稿詳細（57） | ブログ記事詳細の確認 | 月20件×5分=月2時間 | 月20件×1分=月0.3時間（1.7時間削減） |
| タグ管理（58） | ブログタグの管理 | 月10件×5分=月1時間 | 月10件×2分=月0.3時間（0.7時間削減） |
| カテゴリ管理（59） | ブログカテゴリの管理 | 月5件×10分=月1時間 | 月5件×3分=月0.3時間（0.7時間削減） |
| カテゴリ一覧（顧客）（60） | 顧客向けカテゴリ一覧 | - | 顧客向け画面 |
| カテゴリ詳細（顧客）（61） | 顧客向けカテゴリ詳細 | - | 顧客向け画面 |
| 投稿詳細（顧客）（62） | 顧客向け記事詳細 | - | 顧客向け画面 |
| ページ一覧（362） | ウェブページの一覧 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| ページ作成（363） | ウェブページの作成 | 月5件×60分=月5時間 | 月5件×30分=月3時間（2時間削減） |
| ページ編集（364） | ウェブページの編集 | 月5件×30分=月3時間 | 月5件×15分=月1時間（2時間削減） |
| ページ詳細（365） | ウェブページ詳細の確認 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| パートナー一覧（366） | ウェブサイトパートナー一覧 | 月10件×5分=月1時間 | 月10件×1分=月0.2時間（0.8時間削減） |
| 連絡先設定（367） | 連絡先の設定 | 月2件×15min=月0.5時間 | 月2件×5min=月0.2時間（0.3時間削減） |
| ページ詳細（顧客）（368） | 顧客向けページ詳細 | - | 顧客向け画面 |
| ウェルカムページ（369） | ウェルカムページ | - | ランディングページ |

---

## 3. 各画面想定意図サマリー

> 全369画面について、業務プロセス別にグルーピングして記載しています。詳細は上記「2. 業務プロセス別の画面と想定価値」を参照してください。

| 業務プロセス | 画面数 | 月間削減工数（推定） | 主な画面カテゴリ |
| -------- | ------ | ------------------- | --------------- |
| 販売管理 | 21画面 | 約230時間 | 見積書、受注、顧客、商品、チーム |
| 購買管理 | 20画面 | 約85時間 | 見積依頼、発注書、仕入先、購買契約 |
| 在庫管理 | 79画面 | 約200時間 | 入庫、出庫、移動、倉庫、ロケーション、ロット |
| 会計管理 | 53画面 | 約150時間 | 勘定科目、請求書、支払、仕訳帳、税 |
| 人事管理 | 30画面 | 約50時間 | 従業員、部署、職位、スキル、カレンダー |
| 採用管理 | 22画面 | 約35時間 | 応募者、候補者、職位、ステージ |
| 休暇管理 | 27画面 | 約40時間 | 休暇申請、割当、休暇タイプ、累積プラン |
| プロジェクト管理 | 19画面 | 約140時間 | プロジェクト、タスク、タイムシート |
| マスタ・システム管理 | 25画面 | 約25時間 | ユーザー、ロール、会社、設定 |
| コンテンツ管理 | 18画面 | 約20時間 | ブログ、ウェブページ |
| その他（連絡先、パートナー、商品等） | 75画面 | 約50時間 | 連絡先、パートナー、商品マスタ |

**合計**: 369画面、月間約1,025時間の工数削減効果が見込まれる

---

## 4. 技術設計判断と根拠

### 設計意図サマリー

| 設計論点 | 想定される選択肢 | 採用した方針 | 主な選択理由 |
| -------- | ---------------- | ------------ | ------------ |
| UIフレームワーク | React / Vue / Angular / 素のHTML | Filament PHP (TALL Stack) | Laravel統合、管理画面に最適化、開発効率 |
| 状態管理 | Redux / Vuex / Context / Zustand | Livewire + Alpine.js | サーバーサイド状態管理、リアルタイム更新、シンプルさ |
| コンポーネント設計 | Atomic Design / Feature-based | Filament Component System | Filamentの標準設計、Resource/Page/Widgetの階層 |
| スタイリング | CSS Modules / Styled Components / Tailwind | Tailwind CSS v4 | Filament標準、ユーティリティファースト、高速開発 |

---

### 4-1. UIフレームワーク/ライブラリ選定

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| React | コンポーネントベースUI | 大規模エコシステム、柔軟 | 学習コスト、Laravel統合に追加設定必要 |
| Vue | プログレッシブフレームワーク | 学習容易、Laravel Breezeサポート | SPA構成が複雑化 |
| Angular | フルスタックフレームワーク | 包括的、型安全 | 重い、学習コスト高 |
| Filament PHP | Laravel特化の管理画面フレームワーク | Laravel完全統合、CRUD生成、TALL Stack | 管理画面特化、カスタマイズに制限 |
| 素のHTML/Blade | 伝統的なMPAアプローチ | シンプル | 大規模で保守困難、UX低下 |

#### 採用した方針

Filament PHP v4.x (TALL Stack: Tailwind CSS, Alpine.js, Laravel, Livewire)

#### 選択理由

1. **Laravel完全統合**: Laravelとの親和性が高く、Eloquent ORMとの連携がシームレス
2. **管理画面に最適化**: ERPのような業務システムの管理画面構築に特化した機能セット
3. **開発効率**: Resource定義でCRUD画面を自動生成、Form/Table/Infolistコンポーネントの再利用
4. **リアルタイム更新**: Livewireによるサーバーサイドレンダリングと状態管理
5. **エコシステム**: Filament Shieldによる権限管理、豊富なプラグイン

#### 不採用とした選択肢の理由

- **React/Vue**: SPA構成では管理画面の大量CRUD画面に対して開発コストが高い。API設計も必要となり、工数が増加
- **Angular**: 学習コストが高く、ERPのような業務システムには過剰
- **素のHTML/Blade**: 369画面規模では保守困難、再利用性が低い

---

### 4-2. 状態管理方式

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| Redux/Vuex | クライアントサイド状態管理 | 予測可能、DevTools | ボイラープレート多、サーバー同期複雑 |
| Livewire | サーバーサイド状態管理 | PHPで完結、リアルタイム更新 | ネットワーク依存 |
| Alpine.js | 軽量クライアントサイド | シンプル、HTMLに近い | 複雑な状態管理には不向き |
| ローカル状態のみ | コンポーネント内で完結 | シンプル | 状態共有困難 |

#### 採用した方針

Livewire + Alpine.js のハイブリッド

#### 状態の分類

| 状態種別 | 管理場所 | 例 | 選択理由 |
| -------- | -------- | -- | -------- |
| フォーム状態 | Livewire (サーバー) | 入力値、バリデーションエラー | リアルタイムバリデーション、サーバー側ロジック活用 |
| UI状態 | Alpine.js (クライアント) | モーダル開閉、タブ切替 | 高速レスポンス、ネットワーク不要 |
| サーバー状態 | Eloquent ORM | データベースレコード | LaravelのORM活用 |

#### 選択理由

1. **サーバーサイド状態管理**: PHPで状態を管理し、フロントエンドの複雑さを軽減
2. **リアルタイム更新**: Livewireのポーリング/WebSocket対応でデータ同期
3. **Filament統合**: Filamentの標準スタックとして最適化済み
4. **学習コスト軽減**: PHP開発者がJavaScriptフレームワーク学習不要

#### 不採用とした選択肢の理由

- **Redux/Vuex**: クライアントサイド状態管理はサーバーとの二重管理になり複雑化
- **ローカル状態のみ**: 複数コンポーネント間の状態共有が必要な場面で困難

---

### 4-3. コンポーネント設計

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| Atomic Design | 原子→分子→有機体→テンプレート | 再利用性高い | 分類判断難しい |
| Feature-based | 機能単位で構成 | 関連ファイル近い | 横断的共通化難 |
| Filament標準 | Resource/Page/Widget構成 | 規約ベース、一貫性 | Filament依存 |

#### 採用した方針

Filament Component System (Resource/Page/Widget/Form/Table構成)

#### コンポーネント階層

| 階層 | 責務 | 例 | 選択理由 |
| ---- | ---- | -- | -------- |
| Resource | CRUDエンティティ定義 | AccountResource, OrderResource | 1モデル=1リソースで明確 |
| Page | 画面ロジック | ListAccounts, CreateAccount, ViewAccount | 画面種別ごとに分離 |
| Form | 入力フォーム定義 | form(), getFormSchema() | 再利用可能なフォーム定義 |
| Table | 一覧テーブル定義 | table(), getTableColumns() | 再利用可能なテーブル定義 |
| Infolist | 詳細表示定義 | infolist(), getInfolistSchema() | 読み取り専用表示 |
| Widget | ダッシュボード部品 | StatsOverviewWidget | カード、グラフ等 |
| RelationManager | リレーション管理 | InvoiceLinesRelationManager | 関連データの管理 |

#### 選択理由

1. **規約ベース**: Filamentの規約に従うことで一貫性確保
2. **自動生成**: `php artisan make:filament-resource`で雛形生成
3. **再利用性**: Form/Table定義を複数画面で共有可能
4. **関係者分離**: Resource, Page, Form/Table/Infolistの責務が明確

#### 不採用とした選択肢の理由

- **Atomic Design**: Filamentの標準構成と異なり、カスタマイズコストが増加
- **Feature-based**: プラグイン単位で既に機能分離されており、追加の設計不要

---

### 4-4. スタイリング方式

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| CSS Modules | スコープ付きCSS | 衝突回避、CSSそのまま | 動的スタイル困難 |
| Styled Components | CSS-in-JS | 動的スタイル、型安全 | バンドルサイズ増 |
| Tailwind CSS | ユーティリティファースト | 高速開発、一貫性 | クラス名冗長 |
| SASS/SCSS | CSSプリプロセッサ | 普及、機能豊富 | グローバル汚染リスク |

#### 採用した方針

Tailwind CSS v4

#### スタイル構成

| 種別 | 方式 | 用途 | 選択理由 |
| ---- | ---- | ---- | -------- |
| コンポーネントスタイル | Tailwindユーティリティクラス | ボタン、フォーム、テーブル | Filament標準、高速開発 |
| レイアウト | Tailwind Grid/Flex | 画面レイアウト | レスポンシブ対応容易 |
| カスタマイズ | Tailwind設定 | ブランドカラー、フォント | 設定ファイルで一元管理 |

#### 選択理由

1. **Filament標準**: Filament PHPがTailwind CSSを前提として設計されている
2. **開発速度**: HTMLにクラスを追加するだけでスタイリング完了
3. **一貫性**: デザインシステムとしてTailwindのデフォルト値を活用
4. **最新バージョン**: Tailwind CSS v4の新機能（カスケードレイヤー、コンテナクエリ等）を活用可能

#### 不採用とした選択肢の理由

- **CSS Modules/Styled Components**: Filamentとの統合が困難
- **SASS/SCSS**: Tailwindで十分なカスタマイズが可能、追加の学習コスト不要

---

### 4-5. レスポンシブ対応

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| モバイルファースト | モバイルから設計 | モバイル最適、軽量 | デスクトップ後付け |
| デスクトップファースト | デスクトップから設計 | PC体験優先 | モバイル対応遅れ |
| 別サイト/アプリ | デバイス別に提供 | 最適化容易 | 開発コスト増 |
| レスポンシブなし | 固定幅 | シンプル | 体験低下 |

#### 採用した方針

デスクトップファースト（業務システム特性に基づく）

#### ブレークポイント

| 名称 | サイズ | 対象デバイス | 選択理由 |
| ---- | ------ | ------------ | -------- |
| sm | 640px以上 | スマートフォン横向き | 補助的な対応 |
| md | 768px以上 | タブレット | 一部機能の利用 |
| lg | 1024px以上 | 小型ノートPC | 標準的な業務利用 |
| xl | 1280px以上 | デスクトップ | メイン業務利用 |
| 2xl | 1536px以上 | 大画面 | データ集約表示 |

#### 選択理由

1. **業務システム特性**: ERPは主にデスクトップPCで利用される
2. **データ密度**: 一覧画面では多くの列を表示する必要があり、大画面が前提
3. **Filament標準**: Filamentのグリッドシステムを活用（sm/md/lg/xl/2xl対応）
4. **タブレット補助対応**: 倉庫業務等でのタブレット利用を想定

#### 不採用とした選択肢の理由

- **モバイルファースト**: 業務システムではデスクトップが主要な利用環境
- **別サイト/アプリ**: 開発・保守コストが増大

---

### 4-6. ルーティング設計

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| SPA | クライアントルーティング | UX向上、高速遷移 | 初期ロード重い、SEO課題 |
| MPA | サーバーサイドルーティング | SEO良い、シンプル | 遷移ごとにリロード |
| SSR/SSG | サーバーレンダリング | SEO+SPA体験 | 複雑性増 |
| ハイブリッド | 部分的にSPA | バランス | 複雑 |

#### 採用した方針

MPA (Multi-Page Application) + Livewireによる部分的SPA体験

#### ルート構造

| パターン | 用途 | 例 | 選択理由 |
| -------- | ---- | -- | -------- |
| `/admin/{cluster}/{resource}` | CRUD一覧 | /admin/sales/quotations | 階層的で直感的 |
| `/admin/{cluster}/{resource}/create` | 新規作成 | /admin/sales/quotations/create | RESTful規約準拠 |
| `/admin/{cluster}/{resource}/{id}` | 詳細表示 | /admin/sales/quotations/1 | ID直接指定 |
| `/admin/{cluster}/{resource}/{id}/edit` | 編集 | /admin/sales/quotations/1/edit | 明示的な編集パス |

#### 選択理由

1. **Filament標準**: Filamentのルーティング規約に準拠
2. **シンプル**: サーバーサイドルーティングでSEO/ブックマーク対応
3. **Livewire統合**: ページ内の動的更新はLivewireで実現（SPA的体験）
4. **RESTful**: リソースベースのURLで直感的

#### 不採用とした選択肢の理由

- **SPA**: 管理画面では不要、サーバーサイドレンダリングで十分
- **SSR/SSG**: 業務システムには不要な複雑さ

---

### 4-7. フォーム設計

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| React Hook Form | フック型フォーム管理 | 軽量、高速 | React専用 |
| Formik | 宣言的フォーム管理 | 包括的 | やや重い |
| Filament Forms | Filament標準フォーム | Laravel統合、宣言的 | Filament依存 |
| ネイティブフォーム | HTML標準機能のみ | シンプル | バリデーション手動 |

#### 採用した方針

Filament Forms

#### フォーム構成

| 要素 | 実装方式 | 他の選択肢 | 選択理由 |
| ---- | -------- | ---------- | -------- |
| 状態管理 | Livewire | Redux/Context | サーバーサイド状態、リアルタイムバリデーション |
| バリデーション | Laravel Validation | Yup/Zod | Laravelルールとの統合 |
| エラー表示 | Filament標準 | カスタム | 統一されたUX |

#### 選択理由

1. **宣言的定義**: PHPコードでフォームスキーマを定義
2. **リアルタイムバリデーション**: Livewireにより入力時にサーバーサイドバリデーション実行
3. **豊富なコンポーネント**: TextInput, Select, DatePicker, FileUpload等の標準コンポーネント
4. **リレーション対応**: Repeater, RelationManagerでの関連データ入力

#### 不採用とした選択肢の理由

- **React Hook Form/Formik**: JavaScript依存、Filamentとの統合困難
- **ネイティブフォーム**: バリデーション、エラー表示の実装コストが高い

---

### 4-8. データフェッチング

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| SWR | stale-while-revalidate | 軽量、キャッシュ | React専用 |
| React Query | 強力なデータ同期 | 高機能、DevTools | 学習コスト |
| Livewire | サーバーサイドフェッチ | PHPで完結 | ネットワーク依存 |
| 独自fetch | fetch/axiosで自前管理 | シンプル | キャッシュ手動 |

#### 採用した方針

Livewire + Eloquent ORM

#### フェッチング戦略

| シナリオ | 方式 | キャッシュ | 選択理由 |
| -------- | ---- | ---------- | -------- |
| 一覧表示 | Livewire Table | セッション | ページネーション、フィルタ状態保持 |
| 詳細表示 | Eloquent直接 | なし | 最新データ表示 |
| リレーション | Eager Loading | クエリ最適化 | N+1問題回避 |
| ダッシュボード | Livewire Polling | 定期更新 | リアルタイム性 |

#### 選択理由

1. **サーバーサイド完結**: データ取得ロジックをPHPで記述
2. **Eloquent統合**: LaravelのORMとシームレスに連携
3. **クエリ最適化**: Eager Loading、クエリビルダーの活用
4. **リアルタイム更新**: Livewireのポーリング機能

#### 不採用とした選択肢の理由

- **SWR/React Query**: JavaScript依存、Filamentとの統合困難
- **独自fetch**: キャッシュ、状態管理の実装コストが高い

---

### 4-9. アクセシビリティ対応

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| WCAG 2.1 AAA | 最高レベル準拠 | 最大限のアクセシビリティ | コスト高 |
| WCAG 2.1 AA | 標準レベル準拠 | バランス良い | 一部制限 |
| WCAG 2.1 A | 最低レベル準拠 | 最低限保証 | 不十分な場合あり |
| 対応なし | アクセシビリティ未考慮 | 開発コスト低 | 利用者制限 |

#### 採用した方針

WCAG 2.1 AA準拠を目標（Filament標準に依存）

#### 対応項目

| 項目 | 対応内容 | 選択理由 |
| ---- | -------- | -------- |
| キーボード操作 | Filament標準対応 | フォーカス管理、タブ移動 |
| コントラスト | Tailwind標準色 | WCAG AAレベルのコントラスト比 |
| スクリーンリーダー | ARIA属性 | Filamentコンポーネントに組み込み |
| フォームラベル | 必須ラベル付与 | 視覚・スクリーンリーダー両対応 |

#### 選択理由

1. **Filament標準準拠**: Filamentがアクセシビリティを考慮して設計されている
2. **コスト効率**: カスタム対応を最小限に抑えつつ、基本的なアクセシビリティを確保
3. **将来対応**: 必要に応じて追加対応が可能な基盤

#### 不採用とした選択肢の理由

- **WCAG AAA**: 業務システムでは過剰、コスト対効果が低い
- **対応なし**: 法的リスク、利用者の制限

---

## 5. 将来の拡張性考慮

### 想定される変更

1. **モバイルアプリ対応**: 倉庫業務、営業外出先でのモバイル利用
   - 対応方針: API層の整備、PWA検討

2. **多言語対応**: グローバル展開時の多言語UI
   - 対応方針: Laravel翻訳機能、Filamentの多言語サポート活用

3. **外部システム連携**: 会計ソフト、EC、決済システムとの連携
   - 対応方針: API設計、Webhook対応

4. **レポート機能強化**: BI機能、カスタムレポート
   - 対応方針: analyticsプラグインの拡張、外部BIツール連携

### 画面追加時の指針

1. **Filament Resourceとして実装**: `php artisan make:filament-resource`で雛形生成
2. **既存プラグイン構成に準拠**: 適切なプラグインディレクトリに配置
3. **Form/Table/Infolist定義の再利用**: 共通コンポーネントの活用
4. **権限設定**: Filament Shieldによる権限定義
5. **テスト作成**: Feature Test, Unit Testの作成

---

## 備考

- 本書は画面設計書369ファイルおよびソースコードから業務観点で類推して作成
- 工数削減効果は中規模企業（従業員100名程度）を想定した推定値
- 実際の効果は企業規模、業務量、現行運用方法により異なる
- 技術選定理由は既存実装（Filament PHP, TALL Stack）を前提として記載
