# 通知設計意図書

## 概要

本書は、AureusERPシステムの各通知が**なぜ実装されるに至ったか**を業務課題起点で記述する。
**各通知が存在する業務上の理由**を明らかにすることを目的とし、併せて技術設計判断の根拠も記載する。

## 1. ドメイン概要

> ドメイン概要（業界・業種、主なステークホルダー、システムの位置づけ、ドメイン共通課題等）は **[機能設計意図書](./機能設計意図書.md)** を参照してください。

**注**: 機能設計意図書が未生成のため、以下にAureusERPの概要を記載する。

AureusERPは、Laravel + Filamentベースの統合業務システム（ERP）であり、以下のドメインをカバーする：
- 販売管理（見積、受注、請求）
- 購買管理（見積依頼、発注、仕入）
- 在庫管理（入庫、出庫、移動、追跡）
- 会計管理（請求書、支払、仕訳）
- 人事管理（従業員、部門）
- 採用管理（求人、応募者、選考）
- 休暇管理（申請、承認、割当）
- 勤怠管理（タイムシート）
- プロジェクト管理（タスク、工数）
- 顧客ポータル（Webサイト）
- システム管理（プラグイン、ユーザー）

## 2. 業務プロセス別の通知と想定価値

### 業務プロセス1: ユーザー管理・認証プロセス

#### プロセス概要

**業務フロー**

新規ユーザー登録 → アカウント作成 → メール認証 → システム利用開始

**関係者**

システム管理者、新規ユーザー、顧客ポータル利用者

**発生頻度**

週次（新規ユーザー追加：週5〜10件程度と推測）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 新規ユーザーへの認証情報伝達の手間 | 管理者がパスワードを手動で伝達する必要があり、セキュリティリスクと工数が発生 |
| 不正アカウント作成のリスク | メールアドレスの所有確認がなければ、架空アドレスでの登録が可能 |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **工数コスト**: 管理者が1件あたり10〜15分かけて新規ユーザーに認証情報を電話・対面で伝達（週10件×15分=週2.5時間）
- **セキュリティリスク**: 初期パスワードの漏洩リスク、パスワードのメモ書き紛失リスク
- **人的リスク**: 認証情報の伝達漏れ、新規ユーザーがシステムにアクセスできない事態
- **顧客満足度リスク**: 顧客ポータルのユーザーが登録後すぐにアカウントを利用できない

#### 本業務をシステム化することの想定効果

- **工数削減**: 週2.5時間 → ほぼ0時間（自動化により管理者工数削減）
- **セキュリティ向上**: 署名付きURL＋有効期限により、安全なアカウント作成フローを実現
- **即時性向上**: ユーザーが登録後即座にメールを受信し、待ち時間なくアカウント作成可能

#### 主な関連通知と業務インパクト

| 通知名 | 何をする通知か | 通知がない場合の運用工数 | 通知があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 1-ユーザー招待メール | 管理者が新規ユーザーを招待し、アカウント作成リンクを送信 | 週10件×15分=週2.5時間 | 自動送信で0（週2.5時間削減） |
| 11-メール認証通知 | 顧客ポータル登録時にメールアドレスの所有確認 | 週5件×10分=週50分 | 自動送信で0（週50分削減） |

---

### 業務プロセス2: 購買発注プロセス

#### プロセス概要

**業務フロー**

見積依頼作成 → 仕入先へRFQ送信 → 見積回答受領 → 発注確定 → 発注書送信 → 入庫

**関係者**

購買担当者、仕入先（ベンダー）、倉庫担当者

**発生頻度**

日次（月間200〜500件程度と推測）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 仕入先への見積依頼・発注連絡の手間 | FAX・郵送では発注リードタイムが長期化、電話では記録が残らない |
| 発注書の送付漏れ | 口頭発注では後日トラブル発生時に証跡がない |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **工数コスト**: 月300件×10分（FAX準備・送信）=月50時間
- **リードタイム**: FAX・郵送では発注から仕入先確認まで1〜2日のタイムラグ
- **トラブルリスク**: 発注内容の認識齟齬、数量・単価の誤り、送付漏れ
- **監査リスク**: 発注書の送付履歴が残らず、内部統制上の問題

#### 本業務をシステム化することの想定効果

- **工数削減**: 月50時間 → 月5時間（システム操作のみ）で約45時間削減
- **リードタイム短縮**: 即時送信により発注当日に仕入先が確認可能
- **証跡管理**: PDF添付・Chatter履歴により完全な送信履歴を保持

#### 主な関連通知と業務インパクト

| 通知名 | 何をする通知か | 通知がない場合の運用工数 | 通知があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 2-購買発注メール | 仕入先へRFQ・発注書をPDF添付で送信 | 月300件×10分=月50時間 | 自動送信で月5時間（45時間削減） |

---

### 業務プロセス3: 販売見積・受注プロセス

#### プロセス概要

**業務フロー**

見積作成 → 顧客へ見積送信 → 見積回答受領 → 受注確定/キャンセル → 請求書発行 → 入金

**関係者**

営業担当者、顧客、経理担当者

**発生頻度**

日次（月間300〜800件程度と推測）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 顧客への見積提示の遅延 | 見積回答が遅れると商談機会の損失 |
| キャンセル通知の漏れ | キャンセル理由を伝えないと顧客との信頼関係に悪影響 |
| 請求書送付の遅延 | 入金サイクルが遅延し、キャッシュフローに影響 |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **工数コスト**: 月500件×8分（見積書作成・送付）=月67時間
- **機会損失**: 見積提示の遅延による失注リスク
- **入金遅延**: 請求書送付が遅れると入金も遅延

#### 本業務をシステム化することの想定効果

- **工数削減**: 月67時間 → 月10時間（約57時間削減）
- **スピード向上**: 商談中に即座に見積送信可能、受注確度向上
- **入金サイクル短縮**: 請求書即時送付により入金サイクル改善

#### 主な関連通知と業務インパクト

| 通知名 | 何をする通知か | 通知がない場合の運用工数 | 通知があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 3-販売見積メール | 顧客へ見積書・注文書をPDF添付で送信 | 月500件×8分=月67時間 | 自動送信で月10時間（57時間削減） |
| 4-販売見積キャンセルメール | 顧客へ見積キャンセルを通知 | 月50件×5分=月4時間 | 自動送信で0（4時間削減） |
| 5-請求書送信メール | 顧客へ請求書をPDF添付で送信 | 月300件×8分=月40時間 | 自動送信で月5時間（35時間削減） |

---

### 業務プロセス4: チームコラボレーションプロセス

#### プロセス概要

**業務フロー**

レコード作成/更新 → 関係者にフォロワー追加 → メッセージ投稿 → フォロワーへ通知 → 対応・コメント

**関係者**

全業務担当者（営業、購買、経理、人事等）

**発生頻度**

随時（月間1,000件以上と推測）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 関係者への情報共有漏れ | 重要な更新を関係者が見落とし、対応遅延 |
| メール・チャットでの情報分散 | 案件に関する情報が複数ツールに分散し、検索・追跡が困難 |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **工数コスト**: 月1,000件×3分（関係者への個別連絡）=月50時間
- **対応遅延リスク**: 連絡漏れによる対応遅延、顧客満足度低下
- **情報分散リスク**: 案件情報がメール・チャット・口頭で分散し、後日追跡不能

#### 本業務をシステム化することの想定効果

- **工数削減**: 月50時間 → ほぼ0時間（自動通知）
- **情報集約**: 案件に関するコミュニケーションがレコードに紐づいて一元管理
- **対応速度向上**: 即時通知により関係者が迅速に対応可能

#### 主な関連通知と業務インパクト

| 通知名 | 何をする通知か | 通知がない場合の運用工数 | 通知があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 6-フォロワー追加メール | レコードにフォロワー追加時に追加されたユーザーへ通知 | 月300件×3分=月15時間 | 自動送信で0（15時間削減） |
| 7-メッセージ通知メール | メッセージ投稿時に全フォロワーへ通知 | 月1,000件×3分=月50時間 | 自動送信で0（50時間削減） |

---

### 業務プロセス5: 採用プロセス

#### プロセス概要

**業務フロー**

求人作成 → 応募受付 → 応募確認通知 → 選考（面接） → 採用/不採用決定 → 結果通知

**関係者**

人事担当者、面接官、応募者

**発生頻度**

月次（月間50〜200件応募と推測）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 応募者への連絡漏れ | 応募受付確認がないと応募者が不安、企業イメージ低下 |
| 面接官へのアサイン通知漏れ | 面接官が面接予定を把握できず、準備不足やダブルブッキング |
| 不採用通知の遅延 | 応募者を長期間待たせることで企業ブランドに悪影響 |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **工数コスト**: 月100件×10分（応募確認連絡）=月17時間
- **ブランドリスク**: 連絡遅延・漏れによる企業イメージ低下
- **面接準備不足リスク**: 面接官が応募者情報を事前に確認できない

#### 本業務をシステム化することの想定効果

- **工数削減**: 月17時間 → ほぼ0時間（自動通知）
- **応募者体験向上**: 応募直後に確認メールを受信し安心感
- **面接品質向上**: 面接官が事前に応募者情報を確認可能

#### 主な関連通知と業務インパクト

| 通知名 | 何をする通知か | 通知がない場合の運用工数 | 通知があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 8-応募確認メール | 応募者へ応募受付確認を自動送信 | 月100件×10分=月17時間 | 自動送信で0（17時間削減） |
| 9-応募者不採用メール | 応募者へ不採用結果を通知 | 月50件×15分=月12.5時間 | 自動送信で0（12.5時間削減） |
| 10-面接官アサインメール | 面接官へ面接担当のアサインを通知 | 月80件×5分=月7時間 | 自動送信で0（7時間削減） |

---

### 業務プロセス6: 休暇管理プロセス

#### プロセス概要

**業務フロー**

休暇割当設定 → 従業員が休暇申請 → 上長承認/却下 → 残高更新 → カレンダー反映

**関係者**

従業員、上長（承認者）、人事担当者

**発生頻度**

日次（月間100〜300件申請と推測）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 申請状況の確認漏れ | 重複申請や残高不足に気づかず承認してしまう |
| 承認遅延 | 承認者が申請に気づかず、従業員の予定が立てられない |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **工数コスト**: 紙ベース申請では月200件×15分（申請書作成・提出・承認）=月50時間
- **残高管理リスク**: Excel管理では残高計算ミス、重複申請の見落とし
- **法令遵守リスク**: 有給取得状況の把握不足による労基法違反リスク

#### 本業務をシステム化することの想定効果

- **工数削減**: 月50時間 → 月10時間（システム操作のみ）で約40時間削減
- **残高自動計算**: 重複チェック・残高チェックを自動実行
- **即時フィードバック**: 申請時に即座に警告・エラー表示

#### 主な関連通知と業務インパクト

| 通知名 | 何をする通知か | 通知がない場合の運用工数 | 通知があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 15-休暇申請関連通知 | 休暇申請のCRUD結果をアプリ内通知で表示 | - | 操作結果を即座に確認可能 |
| 16-休暇割当関連通知 | 休暇割当の承認・却下結果をアプリ内通知で表示 | - | 承認ワークフローの進捗を即座に確認可能 |

---

### 業務プロセス7: 勤怠管理プロセス

#### プロセス概要

**業務フロー**

タイムシート入力 → プロジェクト・タスク紐づけ → 工数集計 → 承認

**関係者**

従業員、プロジェクトマネージャー、経理担当者

**発生頻度**

日次（従業員数×営業日で月間数千件と推測）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 工数入力漏れ | 月末に一括入力すると記憶が曖昧で不正確 |
| プロジェクト別工数把握困難 | 紙・Excelでは集計に時間がかかる |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **工数コスト**: 月末集計に月10時間以上
- **データ品質リスク**: 後日入力による不正確な工数データ
- **原価管理リスク**: プロジェクト別原価が把握できず、採算管理が困難

#### 本業務をシステム化することの想定効果

- **リアルタイム入力**: 日次で工数入力する習慣づけ
- **自動集計**: プロジェクト・タスク別工数を自動集計
- **即時フィードバック**: 入力結果を即座に確認可能

#### 主な関連通知と業務インパクト

| 通知名 | 何をする通知か | 通知がない場合の運用工数 | 通知があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 17-勤怠記録通知 | タイムシートのCRUD結果をアプリ内通知で表示 | - | 操作結果を即座に確認可能 |

---

### 業務プロセス8: 在庫管理プロセス

#### プロセス概要

**業務フロー**

入庫オペレーション作成 → 移動明細入力 → Todo（準備） → Validate（検証・確定） → 在庫反映

**関係者**

倉庫担当者、購買担当者、品質管理担当者

**発生頻度**

日次（月間500〜2,000件オペレーションと推測）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| ロット・シリアル番号の管理漏れ | 追跡商品のトレーサビリティが確保できない |
| 在庫数量の不整合 | 入力ミスによる理論在庫と実在庫の乖離 |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **工数コスト**: 紙ベースでは月1,000件×15分=月250時間
- **棚卸リスク**: 理論在庫と実在庫の乖離、棚卸差異の発生
- **品質リスク**: ロット追跡ができず、品質問題発生時の原因追跡が困難

#### 本業務をシステム化することの想定効果

- **バリデーション機能**: ロット・シリアル番号の必須チェック、数量チェック
- **即時警告**: 問題があれば操作時に即座に警告表示
- **トレーサビリティ確保**: 全オペレーションの履歴を保持

#### 主な関連通知と業務インパクト

| 通知名 | 何をする通知か | 通知がない場合の運用工数 | 通知があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 20-在庫操作通知 | 在庫オペレーションのTodo/Validate結果・警告をアプリ内通知で表示 | - | 問題を即座に把握し、入力ミスを防止 |

---

### 業務プロセス9: 商品管理プロセス

#### プロセス概要

**業務フロー**

商品マスタ登録 → 属性設定 → バリアント自動生成 → 価格設定 → 販売・購買で使用

**関係者**

商品管理担当者、営業担当者、購買担当者

**発生頻度**

週次（月間50〜200件商品登録と推測）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| バリアント商品の登録漏れ | サイズ・色の組み合わせを手動登録すると漏れが発生 |
| 属性設定の不整合 | 属性の組み合わせが不正確だとバリアント生成に失敗 |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **工数コスト**: 手動でバリアント登録すると1商品あたり30分以上（10属性値×10属性値=100バリアント）
- **登録漏れリスク**: 手動登録では一部バリアントの登録漏れが発生
- **価格設定リスク**: バリアント別価格の設定漏れ

#### 本業務をシステム化することの想定効果

- **自動生成**: 属性の組み合わせからバリアントを自動生成
- **即時フィードバック**: 生成成功・失敗を即座に通知

#### 主な関連通知と業務インパクト

| 通知名 | 何をする通知か | 通知がない場合の運用工数 | 通知があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 19-商品バリアント生成通知 | バリアント生成の成功・失敗をアプリ内通知で表示 | - | 生成結果を即座に確認し、問題があれば属性設定を見直し可能 |

---

### 業務プロセス10: システム管理プロセス

#### プロセス概要

**業務フロー**

プラグイン一覧確認 → インストール/アンインストール → 機能有効化/無効化 → 動作確認

**関係者**

システム管理者

**発生頻度**

月次（月間5〜20件操作と推測）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| プラグイン操作の結果把握 | インストール・アンインストールが成功したか確認が必要 |
| 依存関係の把握 | プラグイン間の依存関係を把握しないと、アンインストール時に問題発生 |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **システム障害リスク**: プラグイン操作の失敗を見落とし、システムが不安定な状態に
- **依存関係問題リスク**: 依存プラグインを先にアンインストールせず、システムエラー発生

#### 本業務をシステム化することの想定効果

- **即時フィードバック**: 操作成功・失敗を即座に通知
- **エラー詳細表示**: 失敗時にはエラーメッセージを表示し、原因特定を支援

#### 主な関連通知と業務インパクト

| 通知名 | 何をする通知か | 通知がない場合の運用工数 | 通知があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 18-プラグイン操作通知 | プラグインのインストール・アンインストール・同期結果をアプリ内通知で表示 | - | 操作結果を即座に確認し、問題発生時に迅速対応可能 |

---

### 業務プロセス11: 汎用操作フィードバック

#### プロセス概要

**業務フロー**

レコードのCRUD操作 → 操作結果通知 → 次の操作へ

**関係者**

全システム利用者

**発生頻度**

随時（1ユーザーあたり日数十〜数百件操作）

#### 関連する業務課題

| 業務課題 | この業務プロセスでの具体的な影響 |
| -------- | -------------------------------- |
| 操作結果の確認不足 | 保存したつもりが失敗していた、削除したつもりができていなかった等 |
| エラー原因の把握困難 | エラー発生時に原因がわからず、対処に時間がかかる |

#### 本業務をシステム化しない場合の想定リスク・コスト

- **操作ミスリスク**: 操作結果が不明確だと、二重入力や保存漏れが発生
- **対応遅延リスク**: エラー原因がわからず、問い合わせ対応に時間がかかる

#### 本業務をシステム化することの想定効果

- **即時フィードバック**: 操作成功・失敗・警告を即座に通知
- **エラー詳細表示**: 失敗時にはエラーメッセージを表示し、対処方法を案内

#### 主な関連通知と業務インパクト

| 通知名 | 何をする通知か | 通知がない場合の運用工数 | 通知があることによるインパクト |
| -------- | ---------------- | -------------------------- | -------------------------------- |
| 12-操作成功通知 | CRUD操作の成功をアプリ内通知で表示 | - | 操作完了を即座に確認可能 |
| 13-操作失敗通知 | CRUD操作の失敗をアプリ内通知で表示 | - | エラー原因を即座に把握し、対処可能 |
| 14-警告通知 | 入力データの問題・注意事項をアプリ内通知で表示 | - | 問題を事前に把握し、入力ミスを防止 |

---

## 3. 各通知想定意図サマリー

| 通知名 | 背景にある業務課題 | 業務負荷（推察） | 主な解決アプローチ | 手動連絡を選ばなかった理由 | 画面表示で代用を選ばなかった理由 |
| -------- | ------------------ | ---------------- | ------------------ | -------------------------- | ---------------------------------- |
| 1-ユーザー招待メール | 新規ユーザーへの認証情報伝達の手間 | 高（週2.5時間） | 署名付きURLで招待メール自動送信 | 件数が多く、セキュリティリスクもあるため | 新規ユーザーはシステムにログインできないため |
| 2-購買発注メール | 仕入先への発注連絡の手間・リードタイム | 高（月45時間削減） | PDF添付で発注書を即時送信 | 月300件の発注を手動連絡するのは非現実的 | 仕入先がシステムにアクセスしないため |
| 3-販売見積メール | 顧客への見積提示の遅延 | 高（月57時間削減） | PDF添付で見積書を即時送信 | 月500件の見積を手動送付するのは非現実的 | 顧客がシステムにアクセスしないため |
| 4-販売見積キャンセルメール | キャンセル通知の漏れによる信頼低下 | 中（月4時間削減） | キャンセル理由を含むメール自動送信 | キャンセル連絡を漏らすと顧客関係に悪影響 | 顧客がシステムにアクセスしないため |
| 5-請求書送信メール | 請求書送付の遅延による入金遅延 | 高（月35時間削減） | PDF添付で請求書を即時送信 | 月300件の請求書を手動送付するのは非現実的 | 顧客がシステムにアクセスしないため |
| 6-フォロワー追加メール | 関係者への情報共有漏れ | 中（月15時間削減） | フォロワー追加時に自動通知 | 関係者への個別連絡は漏れやすい | 関係者が常にシステムを見ていないため |
| 7-メッセージ通知メール | 関係者への情報共有漏れ | 高（月50時間削減） | メッセージ投稿時に全フォロワーへ自動通知 | 全フォロワーへの個別連絡は非現実的 | 関係者が常にシステムを見ていないため |
| 8-応募確認メール | 応募者への連絡漏れによる企業イメージ低下 | 中（月17時間削減） | 応募受付時に確認メール自動送信 | 応募者への連絡漏れは企業ブランドに悪影響 | 応募者がシステムにアクセスしないため |
| 9-応募者不採用メール | 不採用通知の遅延による企業イメージ低下 | 中（月12.5時間削減） | 不採用決定時に通知メール自動送信 | 不採用連絡を漏らすと長期間応募者を待たせる | 応募者がシステムにアクセスしないため |
| 10-面接官アサインメール | 面接官への通知漏れによる準備不足 | 低（月7時間削減） | 面接官アサイン時に自動通知 | 面接官への連絡漏れは面接品質に悪影響 | 面接官が常にシステムを見ていないため |
| 11-メール認証通知 | 不正アカウント作成のリスク | 低（週50分削減） | 登録時に認証メール自動送信 | セキュリティ上、メール所有確認は必須 | 未登録ユーザーはシステムにログインできないため |
| 12-操作成功通知 | 操作結果の確認不足 | - | CRUD操作成功時にアプリ内通知 | - | アプリ内通知で十分（操作者がシステムを見ている） |
| 13-操作失敗通知 | エラー原因の把握困難 | - | 操作失敗時にエラー詳細をアプリ内通知 | - | アプリ内通知で十分（操作者がシステムを見ている） |
| 14-警告通知 | 入力データの問題把握困難 | - | バリデーション警告をアプリ内通知 | - | アプリ内通知で十分（操作者がシステムを見ている） |
| 15-休暇申請関連通知 | 申請状況の確認漏れ | - | 休暇申請CRUD結果をアプリ内通知 | - | アプリ内通知で十分（操作者がシステムを見ている） |
| 16-休暇割当関連通知 | 承認遅延 | - | 休暇割当承認・却下結果をアプリ内通知 | - | アプリ内通知で十分（操作者がシステムを見ている） |
| 17-勤怠記録通知 | 工数入力漏れ | - | タイムシートCRUD結果をアプリ内通知 | - | アプリ内通知で十分（操作者がシステムを見ている） |
| 18-プラグイン操作通知 | プラグイン操作の結果把握 | - | インストール・アンインストール結果をアプリ内通知 | - | アプリ内通知で十分（操作者がシステムを見ている） |
| 19-商品バリアント生成通知 | バリアント生成結果の把握困難 | - | バリアント生成成功・失敗をアプリ内通知 | - | アプリ内通知で十分（操作者がシステムを見ている） |
| 20-在庫操作通知 | 在庫操作の問題把握困難 | - | 在庫操作のTodo/Validate結果・警告をアプリ内通知 | - | アプリ内通知で十分（操作者がシステムを見ている） |

---

## 4. 技術設計判断と根拠

### 設計意図サマリー

| 設計論点 | 想定される選択肢 | 採用した方針 | 主な選択理由 |
| -------- | ---------------- | ------------ | ------------ |
| チャネル選択 | メール / SMS / Push / Slack | メール + アプリ内通知 | 外部連絡はメール、内部フィードバックはアプリ内通知で使い分け |
| 送信タイミング | 同期 / 非同期 / 遅延 | 非同期（キュー）/ 同期（アプリ内） | メールは非同期でレスポンス高速化、アプリ内は同期で即時表示 |
| リトライ戦略 | 即時 / 指数バックオフ / なし | Laravelキューのデフォルト | Laravel標準機能を活用し、実装コストを抑制 |
| 配信制御 | スロットリングあり / なし | なし（一部レート制限あり） | 通常の業務量であればスロットリング不要と判断 |

---

### 4-1. 通知チャネル選択

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| メール | 電子メール配信 | 普及、記録性 | 即時性低い、到達率課題 |
| SMS | ショートメッセージ | 高到達率、即時性 | コスト高、文字数制限 |
| Push通知 | モバイル/Webプッシュ | 即時性、低コスト | 許可必要、端末依存 |
| Slack/Teams | ビジネスチャット連携 | 業務ツール統合 | ツール依存 |
| アプリ内通知 | アプリ内で通知表示 | 確実に表示 | アプリ起動必要 |
| Webhook | 外部サービス連携 | 柔軟 | 受信側実装必要 |

#### 採用した方針

**メール + アプリ内通知の二本立て**

#### チャネル用途

| チャネル | 用途 | 優先度 | 選択理由 |
| -------- | ---- | ------ | -------- |
| メール（非同期） | 外部関係者（仕入先、顧客、応募者）への通知、社内ユーザーへの重要通知 | 高 | 受信者がシステムにアクセスしない/できない場合に必要 |
| アプリ内通知（同期） | 操作者への即時フィードバック | 高 | 操作中のユーザーに即座に結果を伝達 |

#### 選択理由

1. **外部関係者はシステムにアクセスしない**: 仕入先・顧客・応募者はAureusERPにログインしないため、メールでの通知が必須
2. **社内ユーザーへの重要通知もメール**: フォロワー追加・メッセージ投稿など、受信者が常にシステムを見ていない場合はメールが有効
3. **操作結果は即時表示が有効**: CRUD操作の成功・失敗・警告は、操作中のユーザーに即座に伝達する必要があり、アプリ内通知が適切

#### 不採用とした選択肢の理由

- **SMS**: コストが高く、ERPの通知用途では費用対効果が低い
- **Push通知**: モバイルアプリがないため現時点では不要
- **Slack/Teams**: 導入企業のツール依存になるため、汎用的なメールを優先

---

### 4-2. テンプレート管理

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| コード内埋め込み | ソースコードにテンプレート | シンプル | 変更にデプロイ必要 |
| DB管理 | DBにテンプレート保存 | 動的変更可能 | 管理画面必要 |
| ファイル管理 | テンプレートファイル | 見やすい、VCS管理 | デプロイ必要 |
| 外部サービス | SendGrid等のテンプレート | 編集容易、プレビュー | ベンダー依存 |

#### 採用した方針

**Bladeテンプレートによるファイル管理**

#### テンプレート構成

| 種別 | 管理場所 | 変更頻度 | 選択理由 |
| ---- | -------- | -------- | -------- |
| メールテンプレート | `plugins/*/resources/views/mails/` | 低 | VCS管理でき、開発者が容易に変更可能 |
| アプリ内通知メッセージ | 言語ファイル（`lang/{locale}/`） | 低 | 多言語対応と一元管理 |

#### 選択理由

1. **VCS管理**: テンプレートをGitで管理でき、変更履歴を追跡可能
2. **Laravel/Filament標準**: フレームワークの標準機能を活用し、学習コストを抑制
3. **多言語対応**: 言語ファイルによるi18n対応が容易

#### 不採用とした選択肢の理由

- **DB管理**: 現時点ではテンプレート変更頻度が低く、管理画面開発の工数に見合わない
- **外部サービス**: ベンダーロックインを避けるため、Laravelネイティブを優先

---

### 4-3. 送信タイミング設計

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| 同期送信 | リクエスト内で送信 | シンプル | レスポンス遅延 |
| 非同期送信 | キュー経由で送信 | レスポンス高速 | 実装複雑 |
| 遅延送信 | 指定時刻に送信 | タイミング制御 | スケジューリング必要 |
| バッチ送信 | まとめて送信 | 効率的 | 即時性なし |

#### 採用した方針

**メール: 非同期（Queueable）、アプリ内通知: 同期（即時表示）**

#### 送信パターン

| 通知種別 | タイミング | 他の選択肢 | 選択理由 |
| -------- | ---------- | ---------- | -------- |
| 外部向けメール | 非同期（キュー経由） | 同期 | レスポンス高速化、メール送信失敗時のリトライ対応 |
| アプリ内通知 | 同期（即時） | 非同期 | 操作結果を即座にフィードバックする必要がある |

#### 選択理由

1. **ユーザー体験**: メール送信に数秒かかることがあるため、非同期にすることで画面操作がブロックされない
2. **信頼性**: キュー経由にすることで、一時的なSMTPエラー時にもリトライが可能
3. **即時性**: アプリ内通知は操作直後に表示する必要があるため、同期が適切

#### 不採用とした選択肢の理由

- **同期送信（メール）**: SMTP接続でレスポンスが遅延するリスクがある
- **バッチ送信**: 発注書・請求書などは即時送信が業務要件

---

### 4-4. リトライ戦略

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| 即時リトライ | 失敗後すぐに再試行 | 早い回復 | 連続失敗リスク |
| 指数バックオフ | 間隔を徐々に延長 | サービス保護 | 遅延増加 |
| 固定間隔リトライ | 一定間隔で再試行 | 予測可能 | 最適でない場合あり |
| リトライなし | 失敗時は記録のみ | シンプル | 到達率低下 |

#### 採用した方針

**Laravelキューのデフォルト設定に依存**

#### リトライ設定

| チャネル | 最大回数 | 間隔 | バックオフ | 選択理由 |
| -------- | -------- | ---- | ---------- | -------- |
| メール（キュー経由） | Laravelデフォルト | Laravelデフォルト | あり | フレームワーク標準機能を活用 |
| アプリ内通知 | なし | - | - | 同期送信のためリトライ不要 |

#### 選択理由

1. **Laravel標準機能活用**: 独自実装を避け、保守性を確保
2. **設定変更の柔軟性**: 環境設定でリトライ回数・間隔を調整可能

#### 不採用とした選択肢の理由

- **リトライなし**: 一時的なSMTPエラーで通知が届かないリスクを許容できない

---

### 4-5. 配信制御・スロットリング

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| スロットリングなし | 制限なく送信 | シンプル | 外部サービス制限抵触リスク |
| レート制限 | 単位時間あたりの上限 | サービス保護 | 遅延発生 |
| バースト制御 | 短期間の集中を抑制 | 安定性 | 実装複雑 |
| 優先度制御 | 重要通知を優先 | 重要通知確保 | 優先度判断必要 |

#### 採用した方針

**基本的にスロットリングなし（一部レート制限あり）**

#### 制御設定

| 対象 | 制限 | 他の選択肢 | 選択理由 |
| ---- | ---- | ---------- | -------- |
| 業務メール | なし | レート制限 | 通常の業務量であれば問題なしと判断 |
| メール認証 | 1分あたり2回 | なし | 不正な大量登録を防止 |

#### 選択理由

1. **業務量の想定**: 月間数百件の通知であれば、SMTPサービスの制限に抵触しない
2. **セキュリティ**: 顧客ポータル登録はスパム対策としてレート制限を適用

#### 不採用とした選択肢の理由

- **全面的なレート制限**: 業務メールの遅延を引き起こすリスクがある

---

### 4-6. 通知設定（ユーザー制御）

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| 全通知必須 | ユーザー設定なし | シンプル | UX低下リスク |
| オプトアウト | デフォルト有効、無効化可 | 到達率高い | 法規制注意 |
| オプトイン | 明示的に有効化 | コンプライアンス | 到達率低い |
| 細かいカスタマイズ | 通知種別ごとに設定 | 柔軟 | 設定複雑 |

#### 採用した方針

**業務通知は必須、一部通知はオプトアウト可能（フォロワー通知の「通知する」オプション）**

#### 設定項目

| 項目 | 選択肢 | デフォルト | 選択理由 |
| ---- | ------ | ---------- | -------- |
| 業務メール（発注書、請求書等） | 必須 | - | 業務遂行上必要な通知のため無効化不可 |
| フォロワー追加通知 | 通知する/しない | 通知しない（オプトイン） | 不要な通知を減らすためオプトイン |
| アプリ内通知 | 必須 | - | 操作フィードバックのため無効化不可 |

#### 選択理由

1. **業務必須通知**: 発注書・請求書・応募確認などは業務遂行上必須であり、無効化を許容しない
2. **フレキシビリティ**: フォロワー通知はオプトインにすることで、不要なメールを削減

#### 不採用とした選択肢の理由

- **全面オプトアウト**: 重要な業務通知が届かなくなるリスクがある

---

### 4-7. 多言語・地域化対応

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| 単一言語 | 1言語のみ | シンプル | グローバル対応不可 |
| 言語別テンプレート | 言語ごとにテンプレート | きめ細かい | 管理コスト増 |
| 翻訳サービス連携 | 動的翻訳 | 柔軟 | 品質・コスト |
| ユーザー言語設定 | ユーザー設定に従う | ユーザーフレンドリー | 設定管理必要 |

#### 採用した方針

**Laravel言語ファイルによる多言語対応**

#### 対応言語

| 言語 | 対応状況 | テンプレート管理 | 選択理由 |
| ---- | -------- | ---------------- | -------- |
| 英語 | 対応済み | `lang/en/` | デフォルト言語 |
| 日本語 | 対応可能（言語ファイル追加） | `lang/ja/` | 言語ファイル追加で対応可能 |

#### 選択理由

1. **Laravel標準機能**: `__()` ヘルパーによるi18n対応が標準
2. **拡張性**: 言語ファイルを追加することで新言語に対応可能

#### 不採用とした選択肢の理由

- **翻訳サービス連携**: 品質とコストの観点から、静的な言語ファイルを優先

---

### 4-8. 監視・配信状況追跡

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| ログのみ | 送信ログを記録 | シンプル | 開封追跡不可 |
| 開封追跡 | 開封イベント記録 | 効果測定可能 | プライバシー課題 |
| クリック追跡 | リンククリック追跡 | コンバージョン測定 | URL書き換え必要 |
| 外部サービス分析 | SendGrid等の分析機能 | 詳細分析 | ベンダー依存 |

#### 採用した方針

**ログ記録 + Chatter機能による履歴保存**

#### 追跡項目

| 項目 | 追跡方法 | 保持期間 | 選択理由 |
| ---- | -------- | -------- | -------- |
| 送信ログ | Laravelログ | 設定依存 | 送信成否の確認 |
| メッセージ履歴 | chatter_messagesテーブル | 永続 | 業務記録として保持 |
| 添付ファイル履歴 | chatter_attachmentsテーブル | 永続 | 送信した帳票の履歴 |

#### 選択理由

1. **業務記録**: 発注書・請求書などの送信履歴は監査上重要
2. **トラブル対応**: 「送信したはずなのに届いていない」という問い合わせに対応可能

#### 不採用とした選択肢の理由

- **開封追跡**: プライバシー懸念があり、ERPの用途では必須ではない

---

### 4-9. エラーハンドリング

#### 想定される選択肢

| 選択肢 | 概要 | メリット | デメリット |
| ------ | ---- | -------- | ---------- |
| 黙殺 | エラーを無視 | シンプル | 問題発見遅れ |
| ログ記録のみ | エラーログ出力 | 追跡可能 | 能動的対応なし |
| アラート通知 | 運用者に通知 | 即座に対応 | アラート疲れ |
| 代替チャネル | 別手段で再送 | 到達率確保 | 実装複雑 |

#### 採用した方針

**ログ記録 + ユーザーへのエラー通知（アプリ内）**

#### エラー処理

| エラー種別 | 処理 | 通知 | 選択理由 |
| ---------- | ---- | ---- | -------- |
| メール送信失敗 | ログ記録 + キューリトライ | なし（バックグラウンド） | リトライで復旧を試みる |
| 設定エラー（メールアドレスなし） | スキップ + ログ記録 | アプリ内通知（失敗リスト表示） | ユーザーに問題を認識させる |
| アプリ内通知失敗 | ログ記録 | なし | JavaScriptエラーのためサーバーサイドでは検知困難 |

#### 選択理由

1. **ユーザーフィードバック**: メールアドレスなしなどの問題はユーザーに通知し、対処を促す
2. **運用負荷軽減**: 全エラーをアラートにすると運用者の負荷が高いため、重大なもののみログ監視

#### 不採用とした選択肢の理由

- **代替チャネル**: 現時点ではメール以外の外部通知チャネルがないため不要

---

## 5. 将来の拡張性考慮

### 想定される変更

1. **SMS通知の追加**: 緊急性の高い通知（在庫切れアラート等）にSMSを追加する場合、通知チャネルを抽象化した設計が有効
2. **Slack/Teams連携**: 社内コミュニケーションツールとの連携ニーズが高まった場合、Webhook経由での通知を追加
3. **プッシュ通知**: モバイルアプリ開発時には、FCM/APNsによるプッシュ通知を追加
4. **開封追跡**: マーケティング用途が発生した場合、SendGrid等のサービスと連携

### 通知追加時の指針

1. **通知種別の分類**: 外部向け（メール必須）か内部フィードバック（アプリ内で十分）かを判断
2. **非同期/同期の判断**: ユーザーの待ち時間に影響するかどうかで判断
3. **テンプレートの配置**: 各プラグインの `resources/views/mails/` に配置
4. **言語ファイルの更新**: 多言語対応が必要な場合は言語ファイルに翻訳を追加
5. **Chatter連携**: 履歴として残すべき通知はChatter機能と連携

---

## 備考

- 本書は通知設計書（全20件）を基に、業務課題起点で設計意図を類推したものである
- 工数推計は一般的なERP利用企業を想定した概算であり、実際の値は企業規模・業務量により異なる
- 技術設計判断はLaravel + Filamentの標準機能を最大限活用する方針で整理している
- 将来的にメール以外のチャネル（SMS、Push、Slack等）を追加する場合は、本書を更新することを推奨
