---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 37
  claims_with_evidence: 34
  claims_without_evidence: 3
confidence_derived: 0.92
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：34 / 37、根拠なし：3
- 優先レビュー（高）
  1. **認証方式の詳細**：spark.ui.filtersやACLの具体的な挙動はコード上のコメント以上の文書化が必要
  2. **レスポンスJSONサンプルの正確性**：JSONサンプルはデータモデルクラスから推測して構築しており、実行時の出力と差異がある可能性
  3. **REST Submission APIリクエストボディの必須フィールド**：SubmitRestProtocolMessageの検証ロジックの完全な把握が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/scala/org/apache/spark/status/api/v1/ApiRootResource.scala`
- E-02: `core/src/main/scala/org/apache/spark/status/api/v1/OneApplicationResource.scala`
- E-03: `core/src/main/scala/org/apache/spark/status/api/v1/StagesResource.scala`
- E-04: `core/src/main/scala/org/apache/spark/status/api/v1/ApplicationListResource.scala`
- E-05: `core/src/main/scala/org/apache/spark/status/api/v1/PrometheusResource.scala`
- E-06: `core/src/main/scala/org/apache/spark/status/api/v1/api.scala`
- E-07: `core/src/main/scala/org/apache/spark/deploy/rest/RestSubmissionServer.scala`
- E-08: `core/src/main/scala/org/apache/spark/deploy/rest/RestSubmissionClient.scala`
- E-09: `core/src/main/scala/org/apache/spark/deploy/rest/StandaloneRestServer.scala`
- E-10: `sql/core/src/main/scala/org/apache/spark/status/api/v1/sql/SqlResource.scala`
- E-11: `sql/core/src/main/scala/org/apache/spark/status/api/v1/sql/ApiSqlRootResource.scala`
- E-12: `sql/core/src/main/scala/org/apache/spark/status/api/v1/sql/api.scala`
- E-13: `streaming/src/main/scala/org/apache/spark/status/api/v1/streaming/ApiStreamingRootResource.scala`
- E-14: `streaming/src/main/scala/org/apache/spark/status/api/v1/streaming/ApiStreamingApp.scala`
- E-15: `streaming/src/main/scala/org/apache/spark/status/api/v1/streaming/api.scala`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Status APIのベースURLは /api/v1 である | E-01（contextPath="/api", @Path("/v1")） | ○ |
| C-02 | REST Submission APIのベースURLは /v1/submissions である | E-07（baseContext定義）, E-08（PROTOCOL_VERSION="v1"） | ○ |
| C-03 | Prometheusメトリクスのパスは /metrics/executors/prometheus である | E-05（contextPath="/metrics", @Path("/executors"), @Path("prometheus")） | ○ |
| C-04 | 認証はSpark UIセキュリティ設定に依存する | E-01（BaseAppResource.withUI内のsecurityManager.checkUIViewPermissions） | ○ |
| C-05 | 認証の具体的な仕組み（ACL設定の詳細） | **根拠不足** | △ |
| C-06 | Status APIの共通エラーコード（400,403,404,503） | E-01（BadParameterException, ForbiddenException, NotFoundException, ServiceUnavailable定義） | ○ |
| C-07 | REST Submission APIのエラーコード（200,400,468,500） | E-07（Scaladoc, SC_UNKNOWN_PROTOCOL_VERSION=468） | ○ |
| C-08 | GET /api/v1/version はVersionInfoを返す | E-01（version()メソッド, @GET @Path("version")） | ○ |
| C-09 | GET /api/v1/applications はアプリケーション一覧を返す | E-01（applicationList()）, E-04（appList()メソッド, クエリパラメータ定義） | ○ |
| C-10 | ApplicationListResourceのクエリパラメータ（status, minDate, maxDate, minEndDate, maxEndDate, limit） | E-04（@QueryParam定義） | ○ |
| C-11 | GET /api/v1/applications/{appId} はApplicationInfoを返す | E-02（getApp()メソッド） | ○ |
| C-12 | GET /api/v1/applications/{appId}/{attemptId} はApplicationAttemptInfoを返す | E-02（getAttempt()メソッド） | ○ |
| C-13 | GET .../jobs はジョブ一覧を返す（statusパラメータ付き） | E-02（jobsList()メソッド, @QueryParam("status")） | ○ |
| C-14 | GET .../jobs/{jobId} はJobDataを返す | E-02（oneJob()メソッド） | ○ |
| C-15 | GET .../stages はステージ一覧を返す（複数クエリパラメータ付き） | E-03（stageList()メソッド, @QueryParam定義） | ○ |
| C-16 | ステージ一覧のクエリパラメータ（status, details, withSummaries, quantiles, taskStatus） | E-03（@QueryParam, @DefaultValue定義） | ○ |
| C-17 | GET .../stages/{stageId} は指定ステージ情報を返す | E-03（stageData()メソッド） | ○ |
| C-18 | GET .../stages/{stageId}/{stageAttemptId} はステージ試行情報を返す | E-03（oneAttemptData()メソッド） | ○ |
| C-19 | GET .../stages/{stageId}/{stageAttemptId}/taskSummary はTaskMetricDistributionsを返す | E-03（taskSummary()メソッド） | ○ |
| C-20 | GET .../stages/{stageId}/{stageAttemptId}/taskList はタスク一覧を返す（offset, length, sortBy, status） | E-03（taskList()メソッド, @QueryParam定義） | ○ |
| C-21 | GET .../stages/{stageId}/{stageAttemptId}/taskTable はHashMap形式を返す（DataTables用） | E-03（taskTable()メソッド） | ○ |
| C-22 | GET .../executors はアクティブExecutor一覧を返す | E-02（executorList()メソッド, store.executorList(true)） | ○ |
| C-23 | GET .../allexecutors は全Executor一覧を返す | E-02（allExecutorList()メソッド, store.executorList(false)） | ○ |
| C-24 | GET .../executors/{executorId}/threads はスレッドダンプを返す | E-02（threadDump()メソッド） | ○ |
| C-25 | GET .../threads はタスクスレッドダンプを返す（taskId, executorIdパラメータ） | E-02（getTaskThreadDump()メソッド） | ○ |
| C-26 | GET .../storage/rdd はRDD一覧を返す | E-02（rddList()メソッド） | ○ |
| C-27 | GET .../storage/rdd/{rddId} は指定RDD情報を返す | E-02（rddData()メソッド） | ○ |
| C-28 | GET .../environment はApplicationEnvironmentInfoを返す（機密情報はredact） | E-02（environmentInfo()メソッド, Utils.redact呼び出し） | ○ |
| C-29 | GET .../logs はZIPファイルとしてイベントログを返す | E-02（getEventLogs()メソッド, @Produces(APPLICATION_OCTET_STREAM)） | ○ |
| C-30 | GET .../sql はSQL実行一覧を返す（details, planDescription, offset, length） | E-10（sqlList()メソッド, @QueryParam定義）, E-11（ルーティング定義） | ○ |
| C-31 | GET .../sql/{executionId} は指定SQL実行情報を返す | E-10（sql()メソッド） | ○ |
| C-32 | ストリーミングAPIのエンドポイント一覧（statistics, receivers, batches, operations） | E-13（各メソッドの@Path定義）, E-14（ルーティング定義） | ○ |
| C-33 | Prometheusエンドポイントは@Experimentalである | E-05（@Experimental アノテーション） | ○ |
| C-34 | REST Submission API: POST /create でアプリケーションを投入できる | E-07（SubmitRequestServlet.doPost）, E-08（createSubmission, constructSubmitRequest） | ○ |
| C-35 | REST Submission API: POST /kill/{id}, POST /killall, GET /status/{id}, POST /clear, GET /readyz | E-07（各Servletクラス定義, contextToServlet Map） | ○ |
| C-36 | レスポンスJSONサンプルの各フィールド構成 | E-06（api.scalaのデータクラス定義）, E-12, E-15 | △ |
| C-37 | REST Submission APIのリクエストボディの必須フィールド（action, clientSparkVersion, appResource, mainClass） | E-08（constructSubmitRequest）, E-09（buildDriverDescription内のOption(...).getOrElse throw） | △ |

## 4) 不足情報（Unknown / Missing）
- 認証・認可の詳細仕様（spark.acls.enable, spark.ui.view.acls等の具体的な設定と挙動）
  - 候補：Sparkの公式ドキュメント / SecurityManager.scala / SparkConf内のACL関連設定
- REST Submission APIのリクエスト・レスポンスのJSON完全仕様（SubmitRestProtocolMessageのシリアライズ/デシリアライズ仕様）
  - 候補：SubmitRestProtocolMessage.scala / 各Responseクラスの定義 / テストコードのゴールデンファイル
- レスポンスJSONの実際の出力形式の検証
  - 候補：HistoryServerSuiteのゴールデンファイル / 実際のSparkインスタンスからの出力

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - エンドポイントの一覧、HTTPメソッド、パスパラメータ、クエリパラメータはコードから直接読み取れるため信頼性が高い
- 1: 中リスク - レスポンスJSONサンプルはデータモデルクラスのフィールド定義から推測構築しているが、Jackson設定やカスタムシリアライザにより実際の出力と差異が生じる可能性がある（ExecutorMetricsJsonSerializer等）
- 1: 中リスク - REST Submission APIのリクエストボディのバリデーションルールは、SubmitRestProtocolMessageのvalidate()メソッドの詳細解析が必要
- 0: 低リスク - Prometheus出力形式はPrometheusResource.scalaのString組み立て処理から直接読み取れる

## 6) レビュアーチェックリスト（最小）
- [ ] Status APIの全エンドポイントパスがソースコードのJAX-RSアノテーションと一致しているか確認
- [ ] REST Submission APIの各エンドポイントのHTTPメソッド（GET/POST）がServletクラスのdoGet/doPostオーバーライドと一致しているか確認
- [ ] レスポンスJSONサンプルの各フィールドがapi.scalaのデータクラス定義と一致しているか確認
- [ ] 認証方式の記述がプロジェクトのセキュリティポリシーと整合しているか確認
- [ ] attemptIdを含むパスパターンが全エンドポイントで正しく記載されているか確認
- [ ] HistoryServerSuiteのゴールデンファイルとJSONサンプルを比較し、形式の正確性を検証
