# Apache Spark

## 概要

Apache Spark は、大規模データ処理のための統合分析エンジンです。Scala、Java、Python、R（非推奨）向けの高水準APIを提供し、データ分析のための汎用計算グラフをサポートする最適化エンジンを備えています。SQL処理、DataFrames、機械学習、グラフ処理、ストリーム処理など、多様なデータ処理ワークロードを単一のプラットフォーム上で統合的に実行できます。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| Spark SQL / DataFrames | SQLクエリおよびDataFrame APIを用いた構造化データ処理。Hive連携やJDBCアクセスも対応 |
| pandas API on Spark | pandasワークロードをSpark上で分散実行するためのAPI互換レイヤー |
| MLlib | 分散機械学習ライブラリ。分類、回帰、クラスタリング、協調フィルタリング、特徴量エンジニアリング等を提供 |
| GraphX | グラフ構造データの並列処理ライブラリ。グラフアルゴリズムやグラフ計算をサポート |
| Structured Streaming | DataFrames/Datasets APIに基づくスケーラブルで耐障害性のあるストリーム処理エンジン |
| Spark Connect | クライアント・サーバ型アーキテクチャによるリモートSparkアクセス（JDBCクライアント含む） |
| Spark Pipelines | 宣言的パイプライン定義によるデータ処理フロー |
| コネクタ | Kafka、Avro、Protobuf、Kinesis等の外部データソースとの接続 |
| リソース管理 | YARN、Kubernetes上でのクラスタリソース管理 |
| Hadoop Cloud連携 | AWS S3、Google Cloud Storage等のクラウドストレージとの統合 |

## 技術スタック

### コア

- 言語: Scala 2.13、Java 17以上、Python 3.9以上
- ビルドツール: Apache Maven 3.9.x / sbt
- フレームワーク: Apache Spark 4.2.0-SNAPSHOT
- 分散ストレージ連携: Apache Hadoop 3.4.2

### 主要ライブラリ

- Apache Parquet 1.17.0（列指向ストレージ形式）
- Apache ORC 2.2.2（列指向ストレージ形式）
- Apache Kafka 3.9.1（メッセージングおよびストリーミング）
- Apache Avro 1.12.1（データシリアライゼーション）
- Protocol Buffers 4.33.5（データシリアライゼーション）
- Apache Hive 2.3.10（メタストア/SQL連携）
- Apache ZooKeeper 3.9.4（分散コーディネーション）
- Jackson 2.21.0（JSON処理）
- Jetty 12.1.5（HTTPサーバ/Web UI）
- SLF4J 2.0.17 / Log4j 2.25.3（ロギング）
- Dropwizard Metrics 4.2.37（メトリクス収集）
- Ruff / Black 23.12.1（Python Linter/Formatter）
- Scalastyle / Scalafmt（Scala Linter/Formatter）

## ディレクトリ構成

```
spark-master/
├── bin/                          # 実行スクリプト（spark-shell, pyspark, spark-submit等）
├── sbin/                         # クラスタ管理スクリプト（master/worker起動・停止）
├── build/                        # ビルド関連スクリプト（mvn, sbt）
├── conf/                         # 設定ファイルテンプレート
├── core/                         # Sparkコアエンジン（RDD, スケジューラ, ストレージ等）
├── sql/
│   ├── api/                      # SQL公開API
│   ├── catalyst/                 # クエリ最適化エンジン（Catalyst）
│   ├── core/                     # Spark SQL実行エンジン
│   ├── hive/                     # Hive統合
│   ├── hive-thriftserver/        # Hive Thriftサーバ
│   ├── pipelines/                # 宣言的パイプライン
│   └── connect/                  # Spark Connectサーバ/クライアント
│       ├── server/
│       ├── common/
│       ├── shims/
│       └── client/
│           ├── jvm/
│           └── jdbc/
├── mllib/                        # 分散機械学習ライブラリ
├── mllib-local/                  # ローカル機械学習ライブラリ
├── graphx/                       # グラフ処理ライブラリ
├── streaming/                    # Spark Streaming（DStream）
├── connector/                    # 外部データソースコネクタ
│   ├── kafka-0-10/               # Kafkaコネクタ（DStream用）
│   ├── kafka-0-10-sql/           # Kafkaコネクタ（Structured Streaming用）
│   ├── kafka-0-10-assembly/      # Kafkaアセンブリ
│   ├── kafka-0-10-token-provider/# Kafka認証トークンプロバイダ
│   ├── avro/                     # Avroデータソース
│   ├── protobuf/                 # Protobufデータソース
│   ├── kinesis-asl/              # Amazon Kinesisコネクタ
│   ├── kinesis-asl-assembly/     # Kinesisアセンブリ
│   ├── profiler/                 # JVMプロファイラ
│   └── spark-ganglia-lgpl/       # Gangliaメトリクス
├── python/                       # PySpark（Python API）
│   └── pyspark/                  # PySparkパッケージ
├── R/                            # SparkR（R API、非推奨）
├── common/                       # 共通モジュール
│   ├── network-common/           # ネットワーク通信基盤
│   ├── network-shuffle/          # シャッフルサービス
│   ├── unsafe/                   # Unsafeメモリ操作
│   ├── sketch/                   # データスケッチ
│   ├── kvstore/                  # Key-Valueストア
│   ├── utils/                    # 共通ユーティリティ（Scala）
│   ├── utils-java/               # 共通ユーティリティ（Java）
│   ├── variant/                  # Variantデータ型
│   └── tags/                     # テストタグ
├── resource-managers/            # リソースマネージャ統合
│   ├── kubernetes/               # Kubernetes上でのSpark実行
│   └── yarn/                     # Hadoop YARN上でのSpark実行
├── hadoop-cloud/                 # クラウドストレージ連携
├── examples/                     # サンプルプログラム
├── assembly/                     # ディストリビューションアセンブリ
├── launcher/                     # アプリケーションランチャー
├── repl/                         # 対話型シェル（REPL）
├── tools/                        # 開発補助ツール
├── dev/                          # 開発支援スクリプト（テスト、リント等）
├── docs/                         # ドキュメントソース
├── data/                         # テスト/サンプルデータ
├── project/                      # sbtビルド設定
├── licenses/                     # サードパーティライセンス
├── licenses-binary/              # バイナリ配布用ライセンス
├── ui-test/                      # Web UIテスト
├── binder/                       # Binder設定
├── pom.xml                       # Mavenプロジェクト定義（ルート）
├── pyproject.toml                # Python開発ツール設定
├── scalastyle-config.xml         # Scalastyle設定
├── LICENSE                       # Apache License 2.0
├── NOTICE                        # ライセンス通知
└── CONTRIBUTING.md               # コントリビューションガイド
```

## セットアップ

### 必要条件

- Java 17以上（最小バージョン: 17.0.11）
- Apache Maven 3.9.x（ソースからビルドする場合）
- Python 3.9以上（PySparkを利用する場合）

### ビルド手順

Apache Mavenを使用してビルドします。

```bash
./build/mvn -DskipTests clean package
```

事前ビルド済みのパッケージをダウンロードした場合は、ビルドは不要です。

詳細なビルド手順については、公式ドキュメント ["Building Spark"](https://spark.apache.org/docs/latest/building-spark.html) を参照してください。

### Hadoopバージョンの指定

SparkはHadoopコアライブラリを使用してHDFSや他のHadoop対応ストレージシステムと通信するため、クラスタが使用するHadoopバージョンと同じバージョンでビルドする必要があります。詳細は ["Specifying the Hadoop Version and Enabling YARN"](https://spark.apache.org/docs/latest/building-spark.html#specifying-the-hadoop-version-and-enabling-yarn) を参照してください。

### 設定

`conf/` ディレクトリ内のテンプレートファイルを基に設定をカスタマイズします。

- `spark-defaults.conf.template` -- Sparkデフォルト設定
- `spark-env.sh.template` -- 環境変数設定
- `log4j2.properties.template` -- ログ設定
- `metrics.properties.template` -- メトリクス設定
- `fairscheduler.xml.template` -- フェアスケジューラ設定
- `workers.template` -- ワーカーノード一覧

詳細は [Configuration Guide](https://spark.apache.org/docs/latest/configuration.html) を参照してください。

## 開発

### 対話型シェル

Scalaシェル:

```bash
./bin/spark-shell
```

Pythonシェル:

```bash
./bin/pyspark
```

SQLシェル:

```bash
./bin/spark-sql
```

### サンプルプログラムの実行

```bash
./bin/run-example SparkPi
```

クラスタ上で実行する場合:

```bash
MASTER=spark://host:7077 ./bin/run-example SparkPi
```

### テスト

```bash
./dev/run-tests
```

個別モジュールや個別テストの実行方法については、[Developer Tools](https://spark.apache.org/developer-tools.html#individual-tests) を参照してください。

Kubernetes統合テストについては、`resource-managers/kubernetes/integration-tests/README.md` を参照してください。

### リンター / フォーマッター

- **Python**: Ruff（リンター）、Black 23.12.1（フォーマッター）
  ```bash
  ./dev/lint-python
  ./dev/reformat-python
  ```

- **Scala**: Scalastyle（リンター）、Scalafmt（フォーマッター）
  ```bash
  ./dev/lint-scala
  ./dev/scalafmt
  ```

- **Java**: Checkstyle
  ```bash
  ./dev/lint-java
  ```

- **R**: lintr
  ```bash
  ./dev/lint-r
  ```

- **JavaScript**: ESLint
  ```bash
  ./dev/lint-js
  ```

### クラスタ管理スクリプト

- `sbin/start-master.sh` / `sbin/stop-master.sh` -- マスターノードの起動/停止
- `sbin/start-worker.sh` / `sbin/stop-worker.sh` -- ワーカーノードの起動/停止
- `sbin/start-all.sh` / `sbin/stop-all.sh` -- 全ノードの一括起動/停止
- `sbin/start-history-server.sh` / `sbin/stop-history-server.sh` -- ヒストリサーバの起動/停止
- `sbin/start-connect-server.sh` / `sbin/stop-connect-server.sh` -- Connectサーバの起動/停止
- `sbin/start-thriftserver.sh` / `sbin/stop-thriftserver.sh` -- Thriftサーバの起動/停止
