# アーキテクチャ設計書

## 概要

本ドキュメントは、Apache Spark 4.2.0-SNAPSHOT のアプリケーションアーキテクチャを記述する設計書である。Apache Spark は大規模データ処理のための統合分析エンジンであり、バッチ処理、ストリーミング処理、SQL、機械学習、グラフ処理を統一的なAPIで提供する分散コンピューティングフレームワークである。Scala 2.13 / Java 17 を主要言語とし、Python (PySpark) および R のバインディングも提供する。本書ではモジュール構成、レイヤー構造、データフロー、横断的関心事について詳述する。

## システム全体構成

### アーキテクチャ概要図

[アーキテクチャ構成図](./アーキテクチャ構成図.md) を参照。

### システム境界と外部連携

| 外部システム | 連携方式 | 用途 |
| --- | --- | --- |
| Apache Hadoop HDFS | Hadoop FileSystem API | 分散ファイルシステムへのデータ読み書き |
| Apache Hive Metastore | Thrift RPC (HiveMetastoreClient) | テーブルメタデータ管理、SQL互換カタログ |
| Apache Kafka | Kafka Consumer/Producer API | ストリーミングデータの入出力 |
| Apache ZooKeeper | ZooKeeper Client | Standalone Master のリーダー選出、高可用性 |
| Kubernetes API Server | Kubernetes Client API | Executor Pod のスケジューリング・管理 |
| YARN ResourceManager | YARN Client Protocol | YARN クラスタ上でのリソース管理 |
| JDBC/ODBC データソース | JDBC Driver | 外部RDBMSへのデータアクセス |
| Amazon S3 / GCS | AWS SDK v2 / GCS Connector | クラウドオブジェクトストレージへのアクセス |
| Amazon Kinesis | Kinesis Client Library | ストリーミングデータソース |
| Apache Derby | JDBC (組み込みDB) | ローカルHive Metastore のデフォルトバックエンド |
| Apache Parquet | parquet-mr ライブラリ | 列指向ファイルフォーマットの読み書き |
| Apache ORC | orc-core ライブラリ | 列指向ファイルフォーマットの読み書き |
| Apache Avro | avro ライブラリ | 行指向シリアライゼーションフォーマットの読み書き |
| Protocol Buffers | protobuf-java | 構造化データのシリアライゼーション |

## レイヤー構成

### アーキテクチャスタイル

Apache Spark は**マスター・ワーカー型の分散アーキテクチャ**を採用しており、アプリケーション内部は**レイヤードアーキテクチャ**で構成される。クラスタマネージャーとの連携部分では**プラグインアーキテクチャ**を採用し、Standalone / YARN / Kubernetes / Mesos など複数のリソースマネージャーに対応する。SQL エンジン部分は**Catalyst オプティマイザ**を中心とした**パイプラインアーキテクチャ**（解析 -> 最適化 -> コード生成 -> 実行）を採用している。

### レイヤー定義

| レイヤー | 責務 | 主なコンポーネント |
| --- | --- | --- |
| API Layer | ユーザー向けプログラミングインタフェースの提供 | `SparkContext`, `SparkSession`, `Dataset`, `DataFrame`, `RDD`, PySpark, SparkR |
| SQL / DataFrame Layer | SQL 解析・最適化・実行計画の生成 | Catalyst Parser, Analyzer, Optimizer, SparkPlanner, QueryExecution |
| Scheduling Layer | ジョブ・ステージ・タスクのスケジューリング | `DAGScheduler`, `TaskSchedulerImpl`, `SchedulerBackend`, `LiveListenerBus` |
| Execution Layer | タスクの実行とデータ処理 | `Executor`, `TaskRunner`, Tungsten メモリ管理, コード生成 (Whole-Stage CodeGen) |
| Shuffle Layer | ステージ間のデータ交換 | `ShuffleManager`, `SortShuffleManager`, `BlockStoreShuffleReader`, `ShuffleBlockFetcherIterator` |
| Storage Layer | データブロックの管理と永続化 | `BlockManager`, `BlockManagerMaster`, `DiskStore`, `MemoryStore`, `DiskBlockManager` |
| Network Layer | ノード間通信 | `RpcEnv` (Netty), `NettyBlockTransferService`, `ExternalBlockStoreClient` |
| Resource Management Layer | クラスタリソースの管理 | `StandaloneSchedulerBackend`, `YarnAllocator`, `KubernetesClusterSchedulerBackend` |

### レイヤー間の依存関係ルール

- **API Layer** は SQL / DataFrame Layer および Scheduling Layer に依存する。直接 Storage Layer や Network Layer を参照しない。
- **SQL / DataFrame Layer** は Catalyst（catalyst モジュール）で論理プラン操作を行い、sql/core で物理プラン生成・実行を行う。Scheduling Layer を通じてジョブを投入する。
- **Scheduling Layer** は Execution Layer（Executor）へタスクを配布し、Storage Layer を通じて中間データを管理する。
- **Execution Layer** は Storage Layer のBlockManagerを通じてデータを読み書きし、Shuffle Layer を通じてステージ間データ交換を行う。
- **Network Layer** は全レイヤーから利用されるが、直接参照は RPC エンドポイント経由に限定される。
- **Resource Management Layer** は Scheduling Layer と連携し、Executor の起動・停止を管理する。上位レイヤーからは抽象化されている。

## モジュール構成

### ドメイン分割

| ドメイン | 責務 | 関連モジュール |
| --- | --- | --- |
| Core Engine | RDD 計算モデル、タスクスケジューリング、分散実行基盤 | `core` |
| SQL Engine | SQL 解析、DataFrame/Dataset API、Catalyst オプティマイザ | `sql/api`, `sql/catalyst`, `sql/core` |
| Hive Integration | Hive Metastore 連携、HiveQL 互換 | `sql/hive`, `sql/hive-thriftserver` |
| Spark Connect | クライアント・サーバー型 Spark セッション | `sql/connect/server`, `sql/connect/client/jvm`, `sql/connect/client/jdbc`, `sql/connect/common`, `sql/connect/shims` |
| Structured Streaming | マイクロバッチ・継続ストリーミング処理 | `sql/core` 内 `streaming` パッケージ |
| DStream Streaming | レガシーストリーミング処理 (DStream ベース) | `streaming` |
| Machine Learning | ML パイプライン、分類・回帰・クラスタリング等 | `mllib`, `mllib-local` |
| Graph Processing | グラフ並列計算 (Pregel, PageRank 等) | `graphx` |
| Connector | 外部データソースとの統合 | `connector/kafka-0-10`, `connector/kafka-0-10-sql`, `connector/avro`, `connector/protobuf`, `connector/kinesis-asl` |
| Common Libraries | 共通ユーティリティ群 | `common/sketch`, `common/kvstore`, `common/network-common`, `common/network-shuffle`, `common/unsafe`, `common/utils`, `common/variant`, `common/tags` |
| Resource Managers | クラスタマネージャー統合 | `resource-managers/yarn`, `resource-managers/kubernetes` |
| SQL Pipelines | 宣言的 ETL パイプライン | `sql/pipelines` |
| Tools | 開発者向けユーティリティ | `tools` |
| Launcher | Spark アプリケーション起動 | `launcher` |
| REPL | 対話的シェル | `repl` |

### パッケージ構造

```
spark-master/
├── core/                               # Spark Core エンジン
│   └── src/main/scala/org/apache/spark/
│       ├── SparkContext.scala           # ユーザーエントリポイント
│       ├── SparkEnv.scala              # ランタイム環境管理
│       ├── api/                        # Java/Python/R API バインディング
│       ├── broadcast/                  # ブロードキャスト変数
│       ├── deploy/                     # デプロイ・クラスタ管理
│       │   ├── master/                 # Standalone Master
│       │   ├── worker/                 # Standalone Worker
│       │   ├── history/               # History Server
│       │   └── rest/                  # REST API
│       ├── executor/                   # Executor 実行環境
│       ├── io/                         # 圧縮・I/O
│       ├── memory/                     # メモリ管理 (Unified Memory Manager)
│       ├── metrics/                    # メトリクス収集
│       ├── network/                    # ネットワーク転送
│       ├── rdd/                        # RDD 実装群
│       ├── rpc/                        # RPC フレームワーク (Netty ベース)
│       ├── scheduler/                  # スケジューラ
│       │   ├── DAGScheduler.scala      # ステージ分割・DAG 管理
│       │   ├── TaskSchedulerImpl.scala # タスク割り当て
│       │   ├── cluster/               # クラスタスケジューラバックエンド
│       │   ├── local/                 # ローカルモードスケジューラ
│       │   └── dynalloc/             # 動的リソース割り当て
│       ├── security/                   # セキュリティ
│       ├── serializer/                 # シリアライゼーション
│       ├── shuffle/                    # シャッフルエンジン
│       │   └── sort/                  # Sort-based シャッフル
│       ├── storage/                    # ブロックストレージ
│       │   └── memory/               # メモリストア
│       ├── ui/                         # Web UI
│       └── util/                       # ユーティリティ
├── sql/
│   ├── api/                            # SQL/DataFrame 公開API
│   ├── catalyst/                       # Catalyst クエリオプティマイザ
│   │   └── src/main/scala/.../catalyst/
│   │       ├── analysis/              # 論理プラン解析
│   │       ├── expressions/           # 式定義
│   │       ├── optimizer/             # 論理プラン最適化
│   │       ├── parser/                # SQL パーサー (ANTLR ベース)
│   │       ├── plans/                 # 論理・物理プラン定義
│   │       └── rules/                 # 変換ルール基盤
│   ├── core/                           # SQL 実行エンジン
│   │   └── src/main/scala/.../sql/
│   │       ├── execution/             # 物理プラン実行
│   │       ├── sources/               # データソース API
│   │       ├── streaming/             # Structured Streaming
│   │       ├── jdbc/                  # JDBC データソース
│   │       └── catalyst/             # Core 固有の Catalyst 拡張
│   ├── hive/                           # Hive 統合
│   ├── hive-thriftserver/             # Thrift Server (JDBC/ODBC)
│   ├── connect/                        # Spark Connect
│   │   ├── server/                    # gRPC サーバー
│   │   ├── client/jvm/               # JVM クライアント
│   │   ├── client/jdbc/              # JDBC クライアント
│   │   ├── common/                    # 共通プロトコル定義
│   │   └── shims/                    # バージョン互換シム
│   └── pipelines/                     # 宣言的 ETL パイプライン
├── streaming/                          # Spark Streaming (DStream)
├── mllib/                              # Machine Learning
├── mllib-local/                        # ローカル ML ライブラリ
├── graphx/                             # グラフ処理
├── common/                             # 共通ライブラリ
│   ├── network-common/                # ネットワーク基盤
│   ├── network-shuffle/               # シャッフルネットワーク
│   ├── unsafe/                        # Unsafe メモリ操作
│   ├── kvstore/                       # KV ストア (UI 用)
│   ├── sketch/                        # 確率的データ構造
│   ├── utils/                         # 共通ユーティリティ (Scala)
│   ├── utils-java/                    # 共通ユーティリティ (Java)
│   ├── variant/                       # Variant データ型
│   └── tags/                          # テスト用タグ
├── connector/                          # 外部コネクタ
│   ├── kafka-0-10/                    # Kafka DStream コネクタ
│   ├── kafka-0-10-sql/               # Kafka Structured Streaming コネクタ
│   ├── avro/                          # Avro フォーマット
│   ├── protobuf/                      # Protobuf フォーマット
│   ├── kinesis-asl/                   # Amazon Kinesis コネクタ
│   └── profiler/                      # JVM プロファイラ
├── resource-managers/                  # クラスタマネージャー統合
│   ├── kubernetes/                    # Kubernetes 統合
│   └── yarn/                          # YARN 統合
├── launcher/                           # アプリケーションランチャー
├── repl/                               # REPL (spark-shell)
├── tools/                              # 開発ツール
├── examples/                           # サンプルアプリケーション
├── python/                             # PySpark
│   └── pyspark/
│       ├── sql/                       # PySpark SQL
│       ├── ml/                        # PySpark ML
│       ├── streaming/                # PySpark Streaming
│       └── pandas/                   # Pandas API on Spark
├── R/                                  # SparkR
└── assembly/                           # ビルドアセンブリ
```

### コンポーネント依存関係

主要モジュール間の依存関係は以下の通りである。

- `sql/core` -> `sql/catalyst` -> `sql/api` -> `common/utils`
- `sql/core` -> `core` -> `common/network-common` -> `common/unsafe`
- `sql/hive` -> `sql/core`, `sql/catalyst`
- `sql/connect/server` -> `sql/core`, `sql/catalyst`
- `streaming` -> `core`
- `mllib` -> `core`, `sql/core`, `sql/catalyst`
- `graphx` -> `core`
- `connector/*` -> `sql/core` (SQL コネクタ) または `streaming` (DStream コネクタ)
- `resource-managers/yarn` -> `core`
- `resource-managers/kubernetes` -> `core`
- `core` -> `common/network-common`, `common/network-shuffle`, `common/unsafe`, `common/kvstore`, `common/sketch`
- `launcher` -> (独立、JVM プロセス起動のみ)

## ミドルウェア構成

### データベース

| 種類 | ミドルウェア | バージョン | 用途 |
| --- | --- | --- | --- |
| RDB (組み込み) | Apache Derby | 10.16.1.1 | ローカルモードの Hive Metastore バックエンド |
| KV Store | LevelDB / RocksDB (common/kvstore) | - | Spark UI / History Server のイベントデータ永続化 |

### キャッシュ

| ミドルウェア | バージョン | 用途 | TTL |
| --- | --- | --- | --- |
| Spark BlockManager (in-memory) | 内蔵 | RDD/DataFrame のメモリキャッシュ | ユーザー指定 (MEMORY_ONLY, MEMORY_AND_DISK 等) |
| Guava Cache | Google Guava 同梱 | 内部メタデータキャッシュ (MapOutputTracker 等) | 設定依存 |

### メッセージキュー

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Apache Kafka | 3.9.1 (クライアント) | Structured Streaming / DStream のデータソース・シンク |
| Amazon Kinesis | KCL 2.7.2 | ストリーミングデータソース |

### 検索エンジン

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| 該当なし | - | Spark 本体には検索エンジン連携は含まれない |

### その他ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Apache Hadoop | 3.4.2 | 分散ファイルシステム、YARN リソース管理 |
| Apache Hive | 2.3.10 | メタストア連携、HiveQL 互換 |
| Apache ZooKeeper | 3.9.4 | Standalone Master のリーダー選出 |
| Apache Curator | 5.9.0 | ZooKeeper クライアントフレームワーク |
| Apache Parquet | 1.17.0 | 列指向ファイルフォーマット |
| Apache ORC | 2.2.2 | 列指向ファイルフォーマット |
| Apache Avro | 1.12.1 | 行指向シリアライゼーションフォーマット |
| Protocol Buffers | 4.33.5 | シリアライゼーション (内部通信・データフォーマット) |
| Eclipse Jetty | 12.1.5 | Spark Web UI / REST API の HTTP サーバー |
| Netty (RPC) | 内蔵 (common/network-common) | ノード間 RPC 通信、ブロック転送 |
| Kryo | 4.0.3 | 高速シリアライゼーション (オプション) |
| Twitter Chill | 0.10.0 | Kryo シリアライゼーション拡張 |
| Dropwizard Metrics | 4.2.37 | メトリクス収集・レポーティング |
| SLF4J / Log4j2 | SLF4J 2.0.17 / Log4j 2.25.3 | ロギング基盤 |
| Apache Ivy | 2.5.3 | 依存関係の動的解決 (spark-submit --packages) |

## データフロー

### リクエスト処理の流れ

Spark ジョブの実行は以下のフローで処理される。

1. **ジョブ投入**: ユーザーが `SparkContext.runJob()` または `DataFrame.collect()` 等のアクションを呼び出す
2. **DAG 構築**: `DAGScheduler` が RDD のリネージ (依存関係グラフ) を解析し、シャッフル境界でステージに分割する
3. **ステージ分割**: `ResultStage` (最終ステージ) と `ShuffleMapStage` (中間ステージ) を生成する
4. **タスク生成**: 各ステージのパーティション数に応じて `Task` オブジェクト (`ShuffleMapTask` / `ResultTask`) を生成する
5. **タスク配布**: `TaskSchedulerImpl` が `SchedulerBackend` を通じて利用可能な Executor にタスクを送信する（データローカリティを考慮）
6. **タスク実行**: 各 Executor 上の `TaskRunner` がタスクを実行し、RDD の `compute()` メソッドを呼び出す
7. **シャッフル**: `ShuffleMapTask` は出力を `ShuffleWriter` でローカルディスクに書き出し、次ステージが `ShuffleReader` で読み取る
8. **結果返却**: `ResultTask` の結果が Driver に返却され、ユーザーアクションの結果となる

### SQL クエリの処理フロー

Spark SQL のクエリは以下のパイプラインで処理される。

1. **パース**: SQL 文字列を ANTLR ベースの `SparkSqlParser` が未解決論理プラン (`Unresolved LogicalPlan`) に変換する
2. **解析 (Analysis)**: `Analyzer` がカタログを参照してテーブル名・カラム名を解決し、型を付与する (`Resolved LogicalPlan`)
3. **論理最適化**: `Optimizer` が述語プッシュダウン、定数畳み込み、結合順序最適化等の論理最適化ルールを適用する
4. **物理プラン生成**: `SparkPlanner` がコストモデルに基づき物理実行プラン (`SparkPlan`) を選択する
5. **コード生成**: Whole-Stage CodeGen により、複数の物理オペレータを単一の Java メソッドにコンパイルする
6. **実行**: 生成されたプランが `SparkContext.runJob()` を通じて分散実行される

### 非同期処理の流れ

1. **イベントバス**: `LiveListenerBus` が非同期イベントキューを管理し、`SparkListener` にイベントを配信する
2. **動的リソース割り当て**: `ExecutorAllocationManager` が負荷に応じて Executor を動的に追加・削除する
3. **Structured Streaming**: マイクロバッチごとに `IncrementalExecution` が実行され、チェックポイントで進捗を永続化する
4. **ブロードキャスト**: `TorrentBroadcast` がピアツーピア方式で変数を全 Executor に配信する

### データ永続化の流れ

1. **RDD キャッシュ**: `BlockManager` がパーティションデータをメモリ (on-heap / off-heap) またはディスクに保存する。ストレージレベル (`StorageLevel`) で制御する
2. **シャッフルデータ**: `SortShuffleWriter` がソート済みデータファイルとインデックスファイルをローカルディスクに書き出す
3. **チェックポイント**: RDD / Streaming のチェックポイントデータを信頼性のあるストレージ (HDFS 等) に書き出す
4. **イベントログ**: `EventLoggingListener` がイベントログを JSON 形式でファイルシステム (HDFS 等) に書き出す

## 横断的関心事

### 認証・認可

| 方式 | 実装箇所 | 対象 |
| --- | --- | --- |
| 共有シークレット認証 | `SecurityManager`, `SocketAuthHelper` | Executor-Driver 間 RPC 通信 |
| Hadoop 認証 (Kerberos) | `SparkHadoopUtil`, `HadoopDelegationTokenProvider` | HDFS / YARN / Hive 等の Hadoop サービスへのアクセス |
| ACL (Access Control List) | `SecurityManager` (spark.acls.enable) | Web UI / REST API へのアクセス制御 |
| SSL/TLS 暗号化 | `SSLOptions` | ノード間通信の暗号化 |
| Web UI 認証フィルタ | `HttpSecurityFilter`, `JWSFilter` | Web UI へのアクセス制御 |

### ロギング・監査

| 種類 | 実装方式 | 保存先 |
| --- | --- | --- |
| アプリケーションログ | SLF4J + Log4j2 (`Logging` トレイト) | ローカルファイルシステム (log4j2 設定に依存) |
| イベントログ | `EventLoggingListener` (JSON 形式) | HDFS / S3 / ローカル (spark.eventLog.dir) |
| メトリクス | Dropwizard Metrics (`MetricsSystem`) | Console / CSV / JMX / Graphite / Ganglia / Servlet |
| ドライバーログ | `DriverLogger` | 分散ストレージ (spark.driver.log.persistToDfs.enabled) |

### エラーハンドリング

| エラー種別 | ハンドリング方式 | レスポンス |
| --- | --- | --- |
| タスク失敗 | `TaskSchedulerImpl` によるリトライ (spark.task.maxFailures, デフォルト4回) | 同一タスクの再実行、失敗 Executor の除外 |
| ステージ失敗 | `DAGScheduler` によるステージ再投入 (spark.stage.maxConsecutiveAttempts) | シャッフルデータの再計算 |
| Executor 喪失 | `SchedulerBackend` がExecutor喪失を検知、タスクを別 Executor に再配置 | HealthTracker による問題ノード除外 |
| Fetch 失敗 | `FetchFailedException` により `DAGScheduler` がシャッフル再実行を判断 | 前ステージの再計算 |
| OOM | `UnifiedMemoryManager` がメモリ確保を調整、Tungsten が off-heap を活用 | メモリ不足時はディスクスピル |
| シリアライゼーション失敗 | `SerializationDebugger` が失敗原因を診断 | `TaskNotSerializableException` の詳細メッセージ |
| アプリケーションエラー | ユーザーコード例外をタスク結果として Driver に返却 | `SparkException` でラップして報告 |

### トランザクション管理

| 範囲 | 管理方式 | 分離レベル |
| --- | --- | --- |
| 出力コミット | `OutputCommitCoordinator` によるタスク出力の投機実行調整 | 単一タスク出力の原子性保証 |
| ファイル書き込み | Hadoop `OutputCommitter` (v1/v2) によるジョブ・タスクコミット | ジョブ単位のアトミックコミット |
| Structured Streaming チェックポイント | WAL (Write-Ahead Log) + Idempotent Sink | Exactly-once セマンティクス |
| Delta Lake (外部) | ACID トランザクション (外部ライブラリ) | Serializable 分離レベル |

## 設計原則・コーディング規約

### 適用している設計原則

| 原則 | 適用箇所 | 実装例 |
| --- | --- | --- |
| Lazy Evaluation | RDD / DataFrame の変換操作 | `map`, `filter` 等の変換はアクション呼び出しまで実行されない |
| Immutability | RDD, Dataset | RDD は不変。変換は常に新しい RDD を生成する |
| プラグインアーキテクチャ | リソースマネージャー、データソース | `ExternalClusterManager` SPI、DataSource V2 API |
| 依存性逆転 | スケジューラバックエンド | `SchedulerBackend` trait を通じた抽象化。具象実装は Standalone / YARN / K8s |
| ストラテジーパターン | シリアライザ選択、シャッフル実装 | `Serializer` (Java / Kryo)、`ShuffleManager` の差し替え可能な実装 |
| オブザーバーパターン | イベントリスナー | `SparkListener` + `LiveListenerBus` によるイベント通知 |
| テンプレートメソッドパターン | RDD の compute | `RDD.compute()` を各サブクラス (`MapPartitionsRDD`, `ShuffledRDD` 等) がオーバーライド |
| ファクトリパターン | ブロードキャスト生成 | `BroadcastFactory` -> `TorrentBroadcastFactory` |
| ルールベース変換 | Catalyst オプティマイザ | `Rule[LogicalPlan]` を継承した最適化ルールをバッチ適用 |

### コーディング規約

- **言語**: Scala 2.13 を主要言語とし、一部コンポーネント (common/unsafe, common/network-common) は Java で実装する。Python バインディング (PySpark) は Py4J 経由で JVM と通信する
- **ビルド**: Maven (pom.xml) を公式ビルドツールとし、SBT もサポートする
- **テスト**: ScalaTest を主要テストフレームワークとし、Maven Surefire / Scalatest Maven Plugin で実行する
- **ログ**: `Logging` トレイトを利用した構造化ログ。`LogKeys` による型安全なログキー管理
- **アノテーション**: `@DeveloperApi`, `@Experimental` による API 安定性の明示
- **エラーメッセージ**: `SparkCoreErrors` / エラークラスによる一元管理された型安全なエラーメッセージ
- **コードスタイル**: Scalastyle (`scalastyle-config.xml`) による自動チェック

## 備考

- 本プロジェクトは Apache Spark 4.2.0-SNAPSHOT であり、開発中のバージョンである
- Spark Connect (sql/connect) は Spark 3.4 以降で導入されたクライアント・サーバー分離アーキテクチャであり、gRPC ベースの通信を使用する
- sql/pipelines モジュールは宣言的 ETL パイプラインのサポートを提供する新しいモジュールである
- DStream ベースの Spark Streaming は maintenance モードであり、新規開発には Structured Streaming が推奨されている
- Tungsten プロジェクトによるオフヒープメモリ管理とコード生成は、SQL 実行エンジンの性能最適化の中核である
- Whole-Stage Code Generation により、複数の物理演算子を単一の最適化された Java メソッドにコンパイルし、仮想関数呼び出しオーバーヘッドを排除している
