---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 30
  claims_without_evidence: 5
confidence_derived: 0.86
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：30 / 35、根拠なし：5
- 優先レビュー（高）
  1. **YARN モードの詳細構成**：YARN 固有の設定ファイルがプロジェクト内に限定的であり、Hadoop クラスタ依存のため詳細が不足
  2. **バックアップ設計の保持期間**：具体的な保持期間の設定値がコードから確認できない
  3. **Standalone Master HA 構成の詳細**：ZooKeeper 連携の具体的設定がプロジェクト内のコードから直接確認できない
  4. **具体的なリソーススペック推奨値**：デフォルト値は確認できるが、本番環境での推奨値はコードベースには含まれない
  5. **History Server の詳細設定**：ポート番号以外の詳細設定はテンプレート内のコメントから推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `resource-managers/kubernetes/docker/src/main/dockerfiles/spark/Dockerfile`
- E-02: `resource-managers/kubernetes/docker/src/main/dockerfiles/spark/bindings/python/Dockerfile`
- E-03: `resource-managers/kubernetes/docker/src/main/dockerfiles/spark/bindings/R/Dockerfile`
- E-04: `resource-managers/kubernetes/integration-tests/dev/spark-rbac.yaml`
- E-05: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/Constants.scala`
- E-06: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/Config.scala`
- E-07: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/features/BasicDriverFeatureStep.scala`
- E-08: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/features/BasicExecutorFeatureStep.scala`
- E-09: `conf/spark-defaults.conf.template`
- E-10: `conf/spark-env.sh.template`
- E-11: `conf/workers.template`
- E-12: `conf/metrics.properties.template`
- E-13: `conf/log4j2.properties.template`
- E-14: `dev/infra/Dockerfile`
- E-15: `pom.xml`
- E-16: `sbin/` ディレクトリ内のデーモン管理スクリプト群
- E-17: `resource-managers/kubernetes/integration-tests/src/test/resources/driver-template.yml`
- E-18: `resource-managers/kubernetes/integration-tests/src/test/resources/executor-template.yml`
- E-19: `connector/` ディレクトリ（kafka-0-10, kinesis-asl 等）
- E-20: `hadoop-cloud/pom.xml`
- E-21: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/scheduler/cluster/k8s/` 内のスケジューラ関連クラス群
- E-22: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/features/` 内の各 FeatureStep クラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Spark は Standalone/YARN/Kubernetes の3つのクラスタマネージャをサポート | E-10, E-16, E-21 | ○ |
| C-02 | Driver-Executor アーキテクチャ（Master-Worker 型） | E-05, E-06, E-07, E-08 | ○ |
| C-03 | Standalone Master のデフォルトポートは 7077 | E-10 | ○ |
| C-04 | K8s Driver のデフォルトポートは 7078 | E-05 (DEFAULT_DRIVER_PORT = 7078) | ○ |
| C-05 | K8s Block Manager のデフォルトポートは 7079 | E-05 (DEFAULT_BLOCKMANAGER_PORT = 7079) | ○ |
| C-06 | Spark Connect Server のデフォルトポートは 15002 | E-05 (DEFAULT_SPARK_CONNECT_SERVER_PORT = 15002) | ○ |
| C-07 | Docker ベースイメージは azul/zulu-openjdk:21 | E-01 (ARG java_image_tag=21) | ○ |
| C-08 | コンテナの実行ユーザー UID は 185 | E-01, E-02, E-03 (ARG spark_uid=185) | ○ |
| C-09 | ENTRYPOINT は /opt/entrypoint.sh | E-01, E-02, E-03 | ○ |
| C-10 | SPARK_HOME=/opt/spark | E-01 (ENV SPARK_HOME=/opt/spark) | ○ |
| C-11 | K8s Namespace のデフォルトは "default" | E-06 (createWithDefault("default")) | ○ |
| C-12 | RBAC で spark Namespace に spark-sa ServiceAccount を定義 | E-04 | ○ |
| C-13 | ClusterRole spark-role は pods リソースへの全操作権限 | E-04 | ○ |
| C-14 | イメージプルポリシーのデフォルトは IfNotPresent | E-06 (createWithDefault("IfNotPresent")) | ○ |
| C-15 | Driver Service の IP Family Policy はデフォルト SingleStack | E-06 (createWithDefault("SingleStack")) | ○ |
| C-16 | PVC アクセスモードはデフォルト ReadWriteOncePod | E-06 (KUBERNETES_USE_LEGACY_PVC_ACCESS_MODE デフォルト false) | ○ |
| C-17 | PVC 所有権はデフォルトで Driver が保持 | E-06 (KUBERNETES_DRIVER_OWN_PVC デフォルト true) | ○ |
| C-18 | PVC 再利用はデフォルトで有効 | E-06 (KUBERNETES_DRIVER_REUSE_PVC デフォルト true) | ○ |
| C-19 | Executor ロールポリシーのデフォルトは OUTLIER | E-06 (createWithDefault(ExecutorRollPolicy.OUTLIER)) | ○ |
| C-20 | Submission タイムアウトのデフォルトは 10000ms | E-06 (createWithDefault(10000)) | ○ |
| C-21 | ConfigMap 最大サイズは 1048576 bytes | E-06 (createWithDefault(1048576)) | ○ |
| C-22 | メトリクスシンクとして Console/CSV/JMX/Graphite/StatsD/Ganglia/Prometheus をサポート | E-12 | ○ |
| C-23 | PrometheusServlet のパスは /metrics/prometheus | E-12 | ○ |
| C-24 | MetricsServlet のデフォルトパスは /metrics/json | E-12 | ○ |
| C-25 | CI 環境の Docker イメージは ubuntu:jammy ベースで openjdk-17 を使用 | E-14 | ○ |
| C-26 | Python 3.9-3.13 および PyPy 3.10 をサポート | E-14 | ○ |
| C-27 | Kafka および Kinesis コネクタが存在 | E-19 | ○ |
| C-28 | hadoop-cloud モジュールでクラウドストレージ連携をサポート | E-20 | ○ |
| C-29 | Volcano スケジューラとの統合 | E-21 (StatefulSetPodsAllocator, DeploymentPodsAllocator 等) | ○ |
| C-30 | Secret Volume のマウントパスは /mnt/secrets/spark-kubernetes-credentials | E-05 (DRIVER_CREDENTIALS_SECRETS_BASE_DIR) | ○ |
| C-31 | Standalone Master HA は ZooKeeper を使用 | **根拠なし**（プロジェクト内のコードからは直接確認できず、Apache Spark ドキュメントに基づく） | △ |
| C-32 | YARN モードの詳細構成（ResourceManager HA 等） | **根拠なし**（YARN_CONF_DIR の参照は E-10 に存在するが、詳細設定は Hadoop 側に依存） | △ |
| C-33 | バックアップ設計の保持期間 | **根拠なし**（spark.history.fs.cleaner.maxAge の参照はあるが、具体値はコードベースから確認不可） | △ |
| C-34 | History Server のデフォルトポートは 18080 | **根拠なし**（一般的な Apache Spark ドキュメントに基づくが、本プロジェクトコード内での直接的な定義は未確認） | △ |
| C-35 | Decommission スクリプトのデフォルトは /opt/decom.sh | E-06 (createWithDefault("/opt/decom.sh")) | ○ |

## 4) 不足情報（Unknown / Missing）
- **YARN モード固有設定**: プロジェクト内には resource-managers/yarn/ が存在するが、YARN 固有のインフラ設定ファイル（yarn-site.xml 等）はプロジェクトに含まれず Hadoop クラスタ側に依存するため詳細を記載できない
  - 候補：Hadoop 公式ドキュメント / yarn-site.xml / capacity-scheduler.xml
- **Standalone Master HA 設定**: ZooKeeper 連携の具体的な設定がプロジェクトコードからは直接確認できない
  - 候補：Apache Spark 公式ドキュメント / ZooKeeper 設定ファイル
- **バックアップ保持期間**: イベントログクリーナーの具体的なデフォルト値やバックアップポリシーがコードベースから直接確認できない
  - 候補：spark-defaults.conf の実運用設定 / Apache Spark 公式ドキュメント
- **History Server ポート番号**: 18080 は広く知られたデフォルト値だが、本プロジェクトのコード内での直接的な定義箇所が未確認
  - 候補：core モジュール内の HistoryServer 実装コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- Kubernetes モードの設計情報（Config.scala、Constants.scala、Dockerfile から直接抽出した値）
- 0: 低リスク -- メトリクスシステムの設計（metrics.properties.template から直接抽出）
- 1: 中リスク -- YARN モードの詳細構成（Hadoop 側の設定に依存するため、実環境との整合性確認が必要）
- 1: 中リスク -- バックアップ設計（具体的な保持期間やバックアップ頻度は実運用環境に依存）
- 0: 低リスク -- コンテナイメージ設計（Dockerfile から直接抽出した情報）
- 1: 中リスク -- Standalone Master HA 構成（ZooKeeper 連携の詳細は外部ドキュメントに依存）

## 6) レビュアーチェックリスト（最小）
- [ ] Kubernetes 関連の設定値（ポート番号、デフォルト値）が Config.scala / Constants.scala と一致しているか
- [ ] Dockerfile のベースイメージバージョン（azul/zulu-openjdk:21）が最新のプロジェクトコードと一致しているか
- [ ] RBAC 設定（spark-rbac.yaml）の記載内容が実際のマニフェストと一致しているか
- [ ] メトリクスシンクの一覧が metrics.properties.template に記載された全シンクを網羅しているか
- [ ] YARN モードの記載事項が実際の Hadoop クラスタ環境と整合しているか
- [ ] バックアップ設計の保持期間が実運用ポリシーと一致しているか
- [ ] Standalone モードのデーモン管理スクリプト（sbin/）の記載が実際のスクリプトと一致しているか
- [ ] 外部サービス連携の一覧が connector/ ディレクトリの全コネクタを網羅しているか
